/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import javax.xml.namespace.QName;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.util.QxName;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.builtIns.FNUtil;
import oracle.xquery.XQException;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.RenameUP;
import oracle.xquery.exec.UpdateExpr;
import oracle.xquery.exec.Visitor;
import oracle.xquery.exec.XQueryUtils;
import org.w3c.dom.Attr;

public class RenameExpr
extends UpdateExpr {
    public RenameExpr(Expr expr, Expr expr2) {
        super(expr, expr2);
    }

    public XMLNode toXML() {
        XMLElement xMLElement = (XMLElement)RenameExpr.getDoc().createElement("RenameExpr");
        this.toXMLKids((XMLNode)xMLElement);
        return xMLElement;
    }

    public void acceptVisitor(Visitor visitor) {
        visitor.visitRenameExpr(this);
    }

    protected void evaluateUpdate(QueryState queryState) {
        QxName qxName = this.evaluateSourceExpr(queryState);
        XMLNode xMLNode = this.eval(queryState, qxName);
        RenameUP renameUP = new RenameUP(xMLNode, qxName);
        queryState.addUpdatePrimitive(renameUP);
    }

    protected void evaluateUpdateAtOnce(QueryState queryState) {
        QxName qxName = this.evaluateSourceExpr(queryState);
        XMLNode xMLNode = this.eval(queryState, qxName);
        XMLNode xMLNode2 = RenameUP.eval(queryState, xMLNode, qxName, true);
        if (queryState.isDebugFlagSet(1)) {
            this.printAffectedNodes(xMLNode2, null);
        }
    }

    private XMLNode eval(QueryState queryState, QxName qxName) {
        OXMLSequence oXMLSequence = this.kids[0].Evaluate(queryState);
        boolean bl = this.kids[0].unknownStaticType();
        if (!oXMLSequence.next()) {
            throw new XQException(queryState.getMesg().getMessage0("XUDY0027"));
        }
        OXMLItem oXMLItem = oXMLSequence.getItem();
        if (oXMLSequence.next() || bl && !FNUtil.isNode((OXMLItem)oXMLItem)) {
            throw new XQException(queryState.getMesg().getMessage0("XUTY0012"));
        }
        XMLNode xMLNode = oXMLItem.getNode();
        switch (xMLNode.getNodeType()) {
            case 1: {
                if (!XQueryUtils.namespaceConflict(xMLNode, (QName)qxName)) break;
                throw new XQException(queryState.getMesg().getMessage0("XUDY0023"));
            }
            case 2: {
                if (!XQueryUtils.namespaceConflict((XMLNode)((Attr)xMLNode).getOwnerElement(), (QName)qxName)) break;
                throw new XQException(queryState.getMesg().getMessage0("XUDY0023"));
            }
            case 7: {
                if (qxName.getPrefix() == null) break;
                throw new XQException(queryState.getMesg().getMessage0("XUDY0025"));
            }
            default: {
                throw new XQException(queryState.getMesg().getMessage0("XUTY0012"));
            }
        }
        return xMLNode;
    }

    private QxName evaluateSourceExpr(QueryState queryState) {
        OXMLItem oXMLItem;
        OXMLSequence oXMLSequence = this.kids[1].Evaluate(queryState);
        boolean bl = this.kids[1].needAtomization();
        OXMLSequence oXMLSequence2 = bl ? oXMLSequence.atomize() : oXMLSequence;
        try {
            oXMLItem = XQueryUtils.getSingleItem(oXMLSequence2);
        }
        catch (XQException xQException) {
            throw xQException;
        }
        catch (Exception exception) {
            throw new XQException(queryState.getMesg().getMessage0("XPTY0004"), exception);
        }
        QName qName = null;
        switch (oXMLItem.getPrimitiveType()) {
            case 0: 
            case 1: {
                try {
                    oXMLItem = XQueryUtils.convert(oXMLItem, OXMLSequenceType.TQNAME, queryState);
                }
                catch (XQException xQException) {
                    throw new XQException(queryState.getMesg().getMessage0("XQDY0074"), xQException);
                }
                qName = oXMLItem.getQName();
                break;
            }
            case 18: {
                qName = oXMLItem.getQName();
                break;
            }
            default: {
                throw new XQException(queryState.getMesg().getMessage0("XPTY0004"));
            }
        }
        if (bl) {
            queryState.returnSequence(oXMLSequence2);
        }
        return new QxName(qName.getNamespaceURI(), qName.getLocalPart(), qName.getPrefix(), XQueryUtils.getQNameString(qName));
    }
}

