/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.functions.builtIns.FNUtil;
import oracle.xquery.XQException;
import oracle.xquery.XQMesg;
import oracle.xquery.exec.ExprResultIterator;
import oracle.xquery.exec.PathAttrAxisIterator;
import oracle.xquery.exec.PathChildAxisIterator;
import oracle.xquery.exec.PathDescendantAxisIterator;
import oracle.xquery.exec.PathSelfAxisIterator;
import oracle.xquery.exec.PathStep;
import oracle.xquery.exec.PredicateSet;
import oracle.xquery.exec.QueryState;

abstract class PathAxisIterator
implements ExprResultIterator {
    protected ExprResultIterator previousStepIterator;
    protected XMLNode currNode;
    protected QueryState qryState;
    protected PathStep step;
    protected int pos;

    protected PathAxisIterator(PathStep pathStep, ExprResultIterator exprResultIterator, QueryState queryState) {
        this.step = pathStep;
        this.previousStepIterator = exprResultIterator;
        this.qryState = queryState;
        this.currNode = null;
        PredicateSet predicateSet = pathStep.predicateSet;
        this.pos = predicateSet != null ? predicateSet.getPositionTestExact() : 0;
    }

    static PathAxisIterator getInstance(PathStep pathStep, ExprResultIterator exprResultIterator, QueryState queryState) {
        int n = pathStep.getAxis();
        switch (n) {
            case 3: {
                return new PathChildAxisIterator(pathStep, exprResultIterator, queryState);
            }
            case 2: {
                return new PathAttrAxisIterator(pathStep, exprResultIterator, queryState);
            }
            case 11: {
                return new PathSelfAxisIterator(pathStep, exprResultIterator, queryState);
            }
            case 4: {
                return new PathDescendantAxisIterator(pathStep, exprResultIterator, queryState, false);
            }
            case 5: {
                return new PathDescendantAxisIterator(pathStep, exprResultIterator, queryState, true);
            }
        }
        return null;
    }

    public void Restart() {
        this.previousStepIterator.Restart();
    }

    public void Close() {
        this.previousStepIterator.Close();
    }

    XMLNode getNode(OXMLItem oXMLItem) {
        if (FNUtil.isNode((OXMLItem)oXMLItem)) {
            return oXMLItem.getNode();
        }
        throw new XQException(XQMesg.getInstance().getMessage0("XPTY0019"));
    }
}

