/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xquery.XQException;
import oracle.xquery.exec.ConstantExpr;
import oracle.xquery.exec.ConvertXML;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.Utils;
import oracle.xquery.exec.Visitor;
import oracle.xquery.parser.XQXGen;

public class OrderComparison
extends Expr {
    private int type;

    public XMLNode toXML() {
        XMLElement xMLElement = (XMLElement)OrderComparison.getDoc().createElement("OrderComp");
        xMLElement.setAttribute("type", OrderComparisonTypes.toString(this.type));
        this.toXMLKids((XMLNode)xMLElement);
        return xMLElement;
    }

    public void getStrRep(StringBuffer stringBuffer) {
        this.toKidsStrRep(stringBuffer, OrderComparisonTypes.toString(this.type));
    }

    public void toSql(XQXGen xQXGen) {
        int n = this.kids[0].getDatatype();
        int n2 = this.kids[1].getDatatype();
        xQXGen.startElement("function", XQXGen.createAttrs("name", OrderComparisonTypes.toString(this.type), "infix", "true"));
        if (n == 90 && n2 == 90) {
            xQXGen.startElement("function", XQXGen.createAttrs("name", "XMLRelop"));
            this.toSqlDefault(xQXGen);
            xQXGen.endElement("function");
            ConstantExpr.toSql(xQXGen, 0);
        } else {
            this.kids[0].toSqlScalar(xQXGen);
            this.kids[1].toSqlScalar(xQXGen);
        }
        xQXGen.endElement("function");
    }

    public void toSql_LATER(XQXGen xQXGen) {
        xQXGen.startElement("function", XQXGen.createAttrs("name", OrderComparisonTypes.toString(this.type), "infix", "true"));
        this.toSqlDefault(xQXGen);
        xQXGen.endElement("function");
    }

    public int getDatatype() {
        return 2;
    }

    public ConvertXML fromXML(XMLElement xMLElement) {
        this.type = OrderComparisonTypes.fromString(xMLElement.getAttribute("type"));
        this.fromXMLKids(xMLElement);
        return this;
    }

    public OrderComparison(int n, Expr expr, Expr expr2) {
        super(expr, expr2);
        this.type = n;
    }

    public OrderComparison() {
    }

    public OXMLSequence Evaluate(QueryState queryState) {
        boolean bl = false;
        OXMLSequence oXMLSequence = this.kids[0].Evaluate(queryState);
        if (!oXMLSequence.next()) {
            return queryState.createSequence();
        }
        OXMLSequence oXMLSequence2 = this.kids[1].Evaluate(queryState);
        if (!oXMLSequence2.next()) {
            return queryState.createSequence();
        }
        OXMLItem oXMLItem = oXMLSequence.getItem();
        OXMLItem oXMLItem2 = oXMLSequence2.getItem();
        if (this.kids[0].unknownStaticType()) {
            if (oXMLSequence.next()) {
                throw new XQException(queryState.getMesg().getMessage0("XPTY0004"));
            }
            if (oXMLItem.getPrimitiveType() != 90) {
                throw new XQException(queryState.getMesg().getMessage0("XPTY0004"));
            }
        }
        if (this.kids[1].unknownStaticType()) {
            if (oXMLSequence2.next()) {
                throw new XQException(queryState.getMesg().getMessage0("XPTY0004"));
            }
            if (oXMLItem2.getPrimitiveType() != 90) {
                throw new XQException(queryState.getMesg().getMessage0("XPTY0004"));
            }
        }
        int n = -1;
        switch (this.type) {
            case 1: 
            case 3: {
                n = 222;
                break;
            }
            case 2: 
            case 4: {
                n = 223;
                break;
            }
            case 5: {
                n = 208;
            }
        }
        OXMLItem oXMLItem3 = queryState.createItem();
        oXMLItem.compareNodes(oXMLItem2, n, oXMLItem3);
        OXMLSequence oXMLSequence3 = queryState.createSequence(oXMLItem3);
        oXMLSequence3.setKnownType(OXMLSequenceType.TBOOLEAN);
        return oXMLSequence3;
    }

    public void acceptVisitor(Visitor visitor) {
        visitor.visitNodeComp(this);
    }

    public static class OrderComparisonTypes {
        public static final int LTLT = 1;
        public static final int GTGT = 2;
        public static final int PRECEDES = 3;
        public static final int FOLLOWS = 4;
        public static final int IS = 5;
        public static final int ISNOT = 6;
        static final String[] strings = new String[]{"<<", ">>", "precedes", "follows", "is", "isnot"};

        public static final String toString(int n) {
            return strings[n - 1];
        }

        public static final int fromString(String string) {
            return Utils.indexOf(strings, string) + 1;
        }
    }
}

