/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import java.util.List;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.FSType;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xquery.XQException;
import oracle.xquery.exec.ConvertXML;
import oracle.xquery.exec.ConvertXMLUtils;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.LetExpr;
import oracle.xquery.exec.NodeSourceIterator;
import oracle.xquery.exec.NodeSourceVisitor;
import oracle.xquery.exec.OptimizeContext;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.StaticTypingVisitor;
import oracle.xquery.exec.VarExpr;
import oracle.xquery.exec.XQueryUtils;
import oracle.xquery.parser.XQXGen;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class NodeSource
implements ConvertXML {
    NodeSource[] kids;
    NodeSource parent;
    Expr filter;
    VarExpr[] letExprs;
    Object iterState;
    VarExpr outVar;

    static final XMLDocument getDoc() {
        return Expr.getDoc();
    }

    private void setup(NodeSource[] nodeSourceArray, VarExpr varExpr) {
        this.outVar = varExpr;
        this.setKids(nodeSourceArray);
    }

    protected void setKids(NodeSource[] nodeSourceArray) {
        this.kids = nodeSourceArray;
        if (this.kids != null) {
            for (int i = 0; i < this.kids.length; ++i) {
                this.kids[i].parent = this;
            }
        }
    }

    public void toSql(XQXGen xQXGen) {
        throw new XQException("toSql not implemented");
    }

    public void toSqlDefault(XQXGen xQXGen) {
        if (this.kids == null) {
            return;
        }
        for (int i = 0; i < this.kids.length; ++i) {
            this.kids[i].toSql(xQXGen);
        }
    }

    public final void toSqlFilter(XQXGen xQXGen) {
        if (this.filter == null) {
            return;
        }
        xQXGen.startElement("where");
        this.filter.toSql(xQXGen);
        xQXGen.endElement("where");
    }

    public abstract XMLNode toXML();

    public final void toXMLDefault(XMLElement xMLElement) {
        ConvertXMLUtils.toXMLKids(NodeSource.getDoc(), (XMLNode)xMLElement, this.kids);
        if (this.filter != null) {
            xMLElement.appendChild((Node)ConvertXMLUtils.toXMLAndTag(NodeSource.getDoc(), this.filter, "FILTER"));
        }
        if (this.letExprs != null) {
            XMLElement xMLElement2 = (XMLElement)NodeSource.getDoc().createElement("LET_EXPRESSIONS");
            for (int i = 0; i < this.letExprs.length; ++i) {
                xMLElement2.appendChild((Node)this.letExprs[i].var.DefinitionToXML());
            }
            xMLElement.appendChild((Node)xMLElement2);
        }
    }

    public final void toXMLOutput(XMLElement xMLElement) {
        if (this.outVar == null) {
            return;
        }
        XMLElement xMLElement2 = (XMLElement)NodeSource.getDoc().createElement("OUT_VAR");
        xMLElement2.appendChild((Node)this.outVar.var.DefinitionToXML());
        xMLElement.appendChild((Node)xMLElement2);
    }

    public ConvertXML DefinitionFromXML(XMLElement xMLElement) {
        return this.fromXML(xMLElement);
    }

    public ConvertXML fromXML(XMLElement xMLElement) {
        XMLElement xMLElement2;
        ConvertXML[] convertXMLArray = ConvertXMLUtils.fromXMLKids(this, xMLElement);
        if (convertXMLArray != null && convertXMLArray.length > 0) {
            xMLElement2 = new NodeSource[convertXMLArray.length];
            for (int i = 0; i < convertXMLArray.length; ++i) {
                xMLElement2[i] = (NodeSource)convertXMLArray[i];
            }
            this.setup((NodeSource[])xMLElement2, null);
        }
        this.filter = (Expr)ConvertXMLUtils.fromXMLUntag(xMLElement, "FILTER");
        NodeList nodeList = xMLElement.getChildrenByTagName("OUT_VAR");
        if (nodeList != null && nodeList.getLength() > 0) {
            xMLElement2 = (XMLElement)nodeList.item(0);
            xMLElement2 = (XMLElement)xMLElement2.getFirstChild();
            this.outVar = (VarExpr)ConvertXMLUtils.createFromXML(xMLElement2, true);
        }
        return this;
    }

    public static NodeSource[] createArray(NodeSource nodeSource) {
        NodeSource[] nodeSourceArray = new NodeSource[]{nodeSource};
        return nodeSourceArray;
    }

    public static NodeSource[] createArray(NodeSource nodeSource, NodeSource nodeSource2) {
        NodeSource[] nodeSourceArray = new NodeSource[]{nodeSource, nodeSource2};
        return nodeSourceArray;
    }

    public static NodeSource[] createArray(NodeSource nodeSource, NodeSource nodeSource2, NodeSource nodeSource3) {
        NodeSource[] nodeSourceArray = new NodeSource[]{nodeSource, nodeSource2, nodeSource3};
        return nodeSourceArray;
    }

    public boolean Trace() {
        return false;
    }

    NodeSource() {
        this.setup(null, null);
    }

    NodeSource(VarExpr varExpr) {
        this.setup(null, varExpr);
    }

    NodeSource(NodeSource[] nodeSourceArray, VarExpr varExpr) {
        this.setup(nodeSourceArray, varExpr);
    }

    NodeSource(NodeSource nodeSource, VarExpr varExpr) {
        NodeSource[] nodeSourceArray = new NodeSource[]{nodeSource};
        this.setup(nodeSourceArray, varExpr);
    }

    NodeSource(NodeSource nodeSource, NodeSource nodeSource2, VarExpr varExpr) {
        NodeSource[] nodeSourceArray = new NodeSource[]{nodeSource, nodeSource2};
        this.setup(nodeSourceArray, varExpr);
    }

    public final void setFilter(Expr expr) {
        this.filter = expr;
    }

    public Expr getFilter() {
        return this.filter;
    }

    public final void setLetExprs(VarExpr[] varExprArray) {
        this.letExprs = varExprArray;
    }

    public VarExpr[] getLetExprs() {
        return this.letExprs;
    }

    public final VarExpr getOutVariable() {
        return this.outVar;
    }

    public final void setOutVarExpr(VarExpr varExpr) {
        this.outVar = varExpr;
    }

    public final boolean EvaluateFilter(QueryState queryState) {
        this.EvaluateLets(queryState);
        if (this.filter == null) {
            return true;
        }
        OXMLSequence oXMLSequence = this.filter.Evaluate(queryState);
        boolean bl = XQueryUtils.effectiveBoolValue(oXMLSequence);
        return bl;
    }

    public final void EvaluateLets(QueryState queryState) {
        if (this.letExprs == null) {
            return;
        }
        for (int i = 0; i < this.letExprs.length; ++i) {
            ((LetExpr)this.letExprs[i].var).setLetValue(queryState, true);
        }
    }

    public NodeSource optimize(OptimizeContext optimizeContext) {
        this.optimizeKids(optimizeContext);
        this.optimizeLets(optimizeContext);
        this.optimizeFilter(optimizeContext);
        this.optimizeOutput(optimizeContext);
        return this;
    }

    public void optimizeKids(OptimizeContext optimizeContext) {
        if (this.kids != null) {
            for (int i = 0; i < this.kids.length; ++i) {
                this.kids[i] = this.kids[i].optimize(optimizeContext);
            }
        }
    }

    public void optimizeFilter(OptimizeContext optimizeContext) {
        if (this.filter != null) {
            this.filter = this.filter.optimize(optimizeContext);
        }
    }

    public void optimizeOutput(OptimizeContext optimizeContext) {
        if (this.outVar != null) {
            this.outVar = (VarExpr)this.outVar.optimize(optimizeContext);
        }
    }

    public void optimizeLets(OptimizeContext optimizeContext) {
        if (this.letExprs != null) {
            for (int i = 0; i < this.letExprs.length; ++i) {
                this.letExprs[i] = (VarExpr)this.letExprs[i].optimize(optimizeContext);
            }
        }
    }

    public NodeSource normalize() {
        this.normalizeKids();
        this.normalizeLets();
        this.normalizeFilter();
        this.normalizeOutput();
        return this;
    }

    public void normalizeKids() {
        if (this.kids != null) {
            for (int i = 0; i < this.kids.length; ++i) {
                this.kids[i] = this.kids[i].normalize();
            }
        }
    }

    public void normalizeFilter() {
        if (this.filter != null) {
            this.filter = this.filter.normalize();
        }
    }

    public void normalizeOutput() {
        if (this.outVar != null) {
            this.outVar = (VarExpr)this.outVar.normalize();
        }
    }

    public void normalizeLets() {
        if (this.letExprs != null) {
            for (int i = 0; i < this.letExprs.length; ++i) {
                this.letExprs[i] = (VarExpr)this.letExprs[i].normalize();
            }
        }
    }

    public void getDependencies(List list) {
        if (this.kids != null) {
            for (int i = 0; i < this.kids.length; ++i) {
                this.kids[i].getDependencies(list);
            }
        }
    }

    public abstract NodeSourceIterator getNSIterator(QueryState var1);

    FSType staticTypeChecking(StaticTypingVisitor staticTypingVisitor) {
        return null;
    }

    abstract void acceptVisitor(NodeSourceVisitor var1);
}

