/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.ide.Context;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.palette.PaletteArb;

public class PalettePagePanel
extends JPanel {
    private final JLabel _pageNameLbl = new JLabel();
    private final JLabel _containsLbl = new JLabel();
    private final JTextField _pageNameFld = new JTextField();
    private final JWrappedLabel _headerLbl = new JWrappedLabel(PaletteArb.getString(56));
    private final GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JComboBox _containsFld = new JComboBox();

    public PalettePagePanel(String type, Context context, Vector list) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.populateModel(list);
        this.setCurrentType(type);
    }

    public PalettePagePanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this._headerLbl.setVerticalShrinking(false);
        ResourceUtils.resLabel((JLabel)this._pageNameLbl, (Component)this._pageNameFld, (String)PaletteArb.getString(54));
        ResourceUtils.resLabel((JLabel)this._containsLbl, (Component)this._containsFld, (String)PaletteArb.getString(51));
        this.setLayout(this.gridBagLayout1);
        this.setLayout(this.gridBagLayout1);
        Insets insets = new Insets(0, 0, 8, 0);
        Insets rightInsets = new Insets(0, 8, 8, 0);
        this.add((Component)this._headerLbl, new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)this._pageNameLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._pageNameFld, new GridBagConstraints(2, 1, 2, 1, 1.0, 0.0, 17, 2, rightInsets, 0, 0));
        insets.bottom = 0;
        rightInsets.bottom = 0;
        this.add((Component)this._containsLbl, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._containsFld, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 17, 2, rightInsets, 0, 0));
        HelpSystem hs = HelpSystem.getHelpSystem();
        if (hs != null) {
            hs.registerTopic((JComponent)this, "f1_idednewpalettepage_html");
        }
        this._containsLbl.setVisible(true);
        this._containsFld.setVisible(true);
    }

    public String getPageName() {
        return this._pageNameFld.getText();
    }

    public final JTextField getPageNameFld() {
        return this._pageNameFld;
    }

    public final void populateModel(Vector list) {
        String[] pageTypes = new String[list.size() - 1];
        for (int i = 0; i < list.size(); ++i) {
            if (i <= 0) continue;
            pageTypes[i - 1] = ((String)list.get(i)).toLowerCase();
        }
        this._containsFld.setModel(new DefaultComboBoxModel<String>(pageTypes));
    }

    public String getPageType() {
        String pageType;
        Object obj = this._containsFld.getSelectedItem();
        String string = pageType = obj != null ? obj.toString() : null;
        if (pageType == null) {
            pageType = "";
        }
        return pageType;
    }

    public final void setCurrentType(String type) {
        int count = this._containsFld.getItemCount();
        for (int i = 0; i < count; ++i) {
            if (!this._containsFld.getItemAt(i).toString().equals(type)) continue;
            this._containsFld.setSelectedIndex(i);
            break;
        }
    }
}

