/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.awt.Dimension;
import java.awt.dnd.DropTargetListener;
import javax.naming.Context;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableListener;
import oracle.ide.docking.DockingParam;
import oracle.ide.docking.Site;
import oracle.ide.docking.TitleChangeListener;
import oracle.ide.layout.Layout;
import oracle.ide.layout.ViewId;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.MultiManager;
import oracle.ideimpl.palette.PaletteArb;
import oracle.ideimpl.palette.PaletteWindowImpl;
import oracle.javatools.jndi.Names;

public class PaletteDockableFactory
implements DockableFactory {
    static DockableProxy DOCKABLE_PROXY;
    public static final String WEB_EDITING_LAYOUT_BASE_NAME = "Web Editing";

    public PaletteDockableFactory() {
        DockStation.getDockStation().registerDockableFactory("ComponentPalette", (DockableFactory)this);
    }

    public void install() {
        MultiManager mgr = (MultiManager)Names.lookup((Context)Names.newInitialContext(), (String)"ide/inspector-manager");
        ViewId viewId = mgr.getDefaultViewId();
        DockStation ds = DockStation.getDockStation();
        Dockable inspectorDockable = ds.findDockable(viewId);
        DockingParam p = new DockingParam();
        if (inspectorDockable != null) {
            p.setPosition(inspectorDockable, 2, 1);
        } else {
            p.setPosition(1);
        }
        Dockable palette = this.getDockable(null);
        ds.dock(palette, p);
    }

    public Dockable getDockable(ViewId viewId) {
        if (DOCKABLE_PROXY == null) {
            DOCKABLE_PROXY = new DockableProxy();
        }
        return DOCKABLE_PROXY;
    }

    private static class DockableProxy
    implements Dockable,
    DockableListener {
        private PaletteWindowImpl _paletteWindow;
        private PropertyAccess _properties;
        private Site _site = new Site();
        private String _title;

        DockableProxy() {
            DockStation.getDockStation().addDockableListener((DockableListener)this, (Dockable)this);
        }

        public String getTitleName() {
            if (this._title == null) {
                this._title = PaletteArb.getString(27);
            }
            return this._title;
        }

        public String getTabName() {
            return PaletteArb.getString(28);
        }

        public Icon getTabIcon() {
            return PaletteArb.getIcon(30);
        }

        public String getUniqueName() {
            return "ComponentPalette";
        }

        public int getType() {
            return 0;
        }

        public Site getSite() {
            return this._site;
        }

        public void setSite(Site site) {
            this._site = site;
        }

        public JComponent getHostedComponent() {
            if (this._paletteWindow == null) {
                this._paletteWindow = PaletteWindowImpl.getInstance();
                this._paletteWindow.loadLayout(this._properties);
                this._properties = null;
                this._paletteWindow.checkIfPopulated();
            }
            return this._paletteWindow.getHostedComponent();
        }

        public void addTitleChangeListener(TitleChangeListener l) {
            if (this._paletteWindow != null) {
                this._paletteWindow.addTitleChangeListener(l);
            }
        }

        public void removeTitleChangeListener(TitleChangeListener l) {
            if (this._paletteWindow != null) {
                this._paletteWindow.removeTitleChangeListener(l);
            }
        }

        public void saveLayout(PropertyAccess p) {
            if (this._paletteWindow != null) {
                this._paletteWindow.saveLayout(p);
            }
        }

        public void loadLayout(PropertyAccess p) {
            if (this._paletteWindow != null) {
                this._paletteWindow.loadLayout(p);
            }
        }

        public void dockableHidden(DockableEvent e) {
            if (this._paletteWindow != null) {
                this._paletteWindow.dockableHidden(e);
            }
        }

        public void dockableShown(DockableEvent e) {
            if (this._paletteWindow != null) {
                this._paletteWindow.dockableShown(e);
            }
        }

        public DropTargetListener getTabDropListener() {
            return null;
        }

        public String getMenuTitle() {
            return this.getTabName();
        }

        public int getDefaultVisibility(Layout layout) {
            return 0;
        }

        public boolean isAutoExpandable() {
            return false;
        }

        public void setAutoExpandable(boolean autoExpandable) {
        }

        public boolean isAutoExpandableEnabled() {
            return false;
        }

        public void setAutoExpandableEnabled(boolean autoExpandableEnabled) {
        }

        public void beforeAutoExpanding() {
        }

        public void afterAutoExpanding() {
        }

        public void afterRestoringFromAutoExpansion(int orientation, Dimension autoExpandedWindowSize, boolean userResized) {
        }

        public Dimension getAutoExpansionPreferredSize(int orientation) {
            return null;
        }

        public Dimension getAutoExpansionSize(int orientation, JPanel dockedTitledPanel) {
            return null;
        }
    }
}

