/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.PackageEntry;
import oracle.jdeveloper.java.locator.URLClassLocator;

public class DirURLClassLocator
extends URLClassLocator {
    private Map _packageMap = new HashMap(512);
    private boolean _built = false;

    protected DirURLClassLocator(URL dirURL, int classType) {
        super(dirURL, classType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildIndex() {
        if (!this._built) {
            DirURLClassLocator dirURLClassLocator = this;
            synchronized (dirURLClassLocator) {
                if (!this._built) {
                    try {
                        this.buildIndexImpl(false);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this._built = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildIndexInterruptibly() throws InterruptedException {
        if (!this._built) {
            DirURLClassLocator dirURLClassLocator = this;
            synchronized (dirURLClassLocator) {
                if (!this._built) {
                    this.buildIndexImpl(true);
                    this._built = true;
                }
            }
        }
    }

    @Override
    protected void getPackages(String packagePrefix, Collection<String> out) {
        PackageEntry entry = this.findPackage(packagePrefix);
        if (entry != null) {
            out.addAll(entry.getSubpackageNamesAsList());
        }
    }

    @Override
    protected void getClassesInPackage(String packagePrefix, Collection<String> out) {
        PackageEntry entry = this.findPackage(packagePrefix);
        if (entry != null) {
            if (this.isSourceTypeLocator()) {
                out.addAll(entry.getClassesAsList());
            } else {
                for (String className : entry.getClasses()) {
                    if (className.indexOf(36) != -1) continue;
                    out.add(className);
                }
            }
        }
    }

    @Override
    protected void getAllClasses(Collection<String> out, ClassNameFilter filter) {
        try {
            this.getClassesRecursively("", out, filter, false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    protected void getAllClassesInterruptibly(Collection<String> out, ClassNameFilter filter) throws InterruptedException {
        this.getClassesRecursively("", out, filter, true);
    }

    private void getClassesRecursively(String packagePrefix, Collection<String> out, ClassNameFilter filter, boolean checkInterrupt) throws InterruptedException {
        PackageEntry entry;
        if (checkInterrupt) {
            DirURLClassLocator.checkInterrupt();
        }
        if ((entry = this.findPackage(packagePrefix)) != null) {
            String[] classList = entry.getClasses();
            int classCount = classList.length;
            for (int i = 0; i < classCount; ++i) {
                String className;
                if (checkInterrupt) {
                    DirURLClassLocator.checkInterrupt();
                }
                if ((className = classList[i]).indexOf(36) != -1) continue;
                boolean acceptName = true;
                if (filter != null) {
                    acceptName = filter.acceptClassName(className, packagePrefix);
                }
                if (!acceptName) continue;
                String fqName = DirURLClassLocator.buildFQName(packagePrefix, className);
                out.add(fqName);
            }
            if (checkInterrupt) {
                DirURLClassLocator.checkInterrupt();
            }
            for (String subName : entry.getSubpackageNames()) {
                String fullSubName = DirURLClassLocator.buildFQName(packagePrefix, subName);
                this.getClassesRecursively(fullSubName, out, filter, checkInterrupt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void getAllPackages(Collection<String> out, PackageNameFilter filter) {
        this.buildIndex();
        Map map = this._packageMap;
        synchronized (map) {
            for (String packagePrefix : this._packageMap.keySet()) {
                if (packagePrefix == null || packagePrefix.length() <= 0) continue;
                boolean acceptName = true;
                if (filter != null) {
                    acceptName = filter.acceptPackageName(packagePrefix);
                }
                if (!acceptName) continue;
                out.add(packagePrefix);
            }
        }
    }

    @Override
    public URL getURL(String fqClassName) {
        for (String suffix : this.isSourceTypeLocator() ? SOURCE_SUFFIXES : CLASS_SUFFIXES) {
            String entryPath = fqClassName.replace('.', '/') + suffix;
            URL rootURL = this.getRootURL();
            URL fileURL = URLFactory.newURL((URL)rootURL, (String)entryPath);
            if (!URLFileSystem.exists((URL)fileURL)) continue;
            return fileURL;
        }
        return null;
    }

    @Override
    public URL getResourceURL(String resourceName) {
        URL rootURL;
        URL fileURL;
        if (this.isClassTypeLocator() && URLFileSystem.exists((URL)(fileURL = URLFactory.newURL((URL)(rootURL = this.getRootURL()), (String)resourceName)))) {
            return fileURL;
        }
        return null;
    }

    private void buildIndexImpl(boolean checkInterrupt) throws InterruptedException {
        this.buildPackage("", checkInterrupt);
    }

    private void buildPackage(String packagePrefix, boolean checkInterrupt) throws InterruptedException {
        if (checkInterrupt) {
            DirURLClassLocator.checkInterrupt();
        }
        Thread.yield();
        PackageEntry entry = this.findPackage(packagePrefix);
        if (entry != null) {
            String[] subs = entry.getSubpackageNames();
            int numSubs = subs.length;
            for (int i = 0; i < numSubs; ++i) {
                String subName = packagePrefix.length() > 0 ? packagePrefix + "." + subs[i] : subs[i];
                this.buildPackage(subName, checkInterrupt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageEntry findPackage(String packageName) {
        int numInfos;
        URL dirURL;
        PackageEntry foundEntry = null;
        Map map = this._packageMap;
        synchronized (map) {
            foundEntry = (PackageEntry)this._packageMap.get(packageName);
        }
        URL rootURL = this.getRootURL();
        if (foundEntry != null) {
            dirURL = foundEntry._packageURL;
        } else if (packageName.length() == 0) {
            dirURL = rootURL;
        } else {
            String dirName = packageName.replace('.', '/');
            dirURL = URLFactory.newDirURL((URL)rootURL, (String)dirName);
        }
        long lastModified = URLFileSystem.lastModified((URL)dirURL);
        if (foundEntry != null && lastModified == foundEntry._lastModified) {
            return foundEntry;
        }
        URLFileSystem.FileInfo[] infos = URLFileSystem.ls((URL)dirURL);
        int n = numInfos = infos == null ? 0 : infos.length;
        if (numInfos == 0) {
            return null;
        }
        ArrayList<String> classList = new ArrayList<String>(numInfos);
        ArrayList<String> subList = new ArrayList<String>(numInfos);
        for (int i = 0; i < numInfos; ++i) {
            URLFileSystem.FileInfo info = infos[i];
            URL childURL = info.getURL();
            boolean isDirectory = info.isDirectory();
            String filename = URLFileSystem.getFileName((URL)childURL);
            if (isDirectory) {
                if (filename.indexOf(46) != -1 || filename.indexOf(45) != -1 || filename.equals("CVS")) continue;
                subList.add(filename);
                continue;
            }
            if (!this.isMatchingFileType(filename)) continue;
            int lastDot = filename.lastIndexOf(46);
            classList.add(filename.substring(0, lastDot));
        }
        foundEntry = new PackageEntry(dirURL, classList, subList, lastModified);
        Map map2 = this._packageMap;
        synchronized (map2) {
            this._packageMap.put(packageName, foundEntry);
        }
        return foundEntry;
    }
}

