/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.HashSet;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemEvent;
import oracle.ide.net.URLFileSystemListener;
import oracle.ide.net.URLPath;
import oracle.javatools.util.WeakCache;
import oracle.jdeveloper.java.JavaModelFactory;
import oracle.jdeveloper.java.locator.ArrayClassLocator;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.CachedDirURLClassLocator;
import oracle.jdeveloper.java.locator.DirURLClassLocator;
import oracle.jdeveloper.java.locator.JarURLClassLocator;
import oracle.jdeveloper.java.locator.PathClassLocator;
import oracle.jdeveloper.java.locator.URLClassLocator;

public class ClassLocatorFactory {
    private static final WeakCache _sourceLocatorCache = new WeakCache();
    private static final WeakCache _classLocatorCache = new WeakCache();
    private static final boolean USE_VFS_FOR_LOCATOR;
    private static final URLFileSystemListener _fileSystemListener;
    private static final ReferenceQueue<URLClassLocator> _queue;
    private static final HashSet<LocatorReference> refs;

    public static ClassLocatorFactory getInstance() {
        return JavaModelFactory.getInstance().getLocatorFactory();
    }

    private static BaseClassLocator createURLClassLocator(URL rootURL, int fileType) {
        boolean vfsEnabled;
        URLClassLocator locator;
        String suffix;
        boolean isJar = JarUtil.isJarURL((URL)rootURL);
        if (!isJar && (".jar".equals(suffix = URLFileSystem.getSuffix((URL)rootURL)) || ".zip".equals(suffix))) {
            isJar = true;
            rootURL = URLFactory.newJarURL((URL)rootURL, null);
        }
        if (isJar) {
            return new JarURLClassLocator(rootURL, fileType);
        }
        rootURL = ClassLocatorFactory.sanitizeDirectoryURL(rootURL);
        if (USE_VFS_FOR_LOCATOR) {
            URLFileSystem.addURLFileSystemListener((URL)rootURL, (URLFileSystemListener)_fileSystemListener);
        }
        URLClassLocator uRLClassLocator = locator = (vfsEnabled = CachedDirURLClassLocator.supportsCache(rootURL)) ? new CachedDirURLClassLocator(rootURL, fileType) : new DirURLClassLocator(rootURL, fileType);
        if (USE_VFS_FOR_LOCATOR) {
            refs.add(new LocatorReference(locator, _queue));
            ClassLocatorFactory.processQueue();
        }
        return locator;
    }

    private static URL sanitizeDirectoryURL(URL url) {
        String path = url.getPath();
        if (path != null && path.length() > 0 && path.charAt(path.length() - 1) != '/') {
            return URLFactory.replacePathPart((URL)url, (String)(path + "/"));
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseClassLocator getSourceLocator(URL rootURL) {
        if (rootURL != null) {
            WeakCache weakCache = _sourceLocatorCache;
            synchronized (weakCache) {
                BaseClassLocator locator = (BaseClassLocator)_sourceLocatorCache.get((Object)rootURL);
                if (locator == null) {
                    locator = ClassLocatorFactory.createURLClassLocator(rootURL, 2);
                    _sourceLocatorCache.put((Object)rootURL, (Object)locator);
                }
                return locator;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseClassLocator getClassLocator(URL rootURL) {
        if (rootURL != null) {
            WeakCache weakCache = _classLocatorCache;
            synchronized (weakCache) {
                BaseClassLocator locator = (BaseClassLocator)_classLocatorCache.get((Object)rootURL);
                if (locator == null) {
                    locator = ClassLocatorFactory.createURLClassLocator(rootURL, 1);
                    _classLocatorCache.put((Object)rootURL, (Object)locator);
                }
                return locator;
            }
        }
        return null;
    }

    public BaseClassLocator getSourceLocator(URLPath urlPath) {
        try {
            return this.createArrayClassLocator(urlPath, 2, false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public BaseClassLocator getSourceLocatorInterruptibly(URLPath urlPath) throws InterruptedException {
        return this.createArrayClassLocator(urlPath, 2, true);
    }

    public BaseClassLocator getClassLocator(URLPath urlPath) {
        URLPath expandedURLPath = new URLPath(urlPath);
        expandedURLPath.expandToIncludeManifestClassPaths();
        try {
            return this.createArrayClassLocator(expandedURLPath, 1, false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public BaseClassLocator getClassLocatorInterruptibly(URLPath urlPath) throws InterruptedException {
        URLPath expandedURLPath = new URLPath(urlPath);
        expandedURLPath.expandToIncludeManifestClassPathsInterruptibly();
        return this.createArrayClassLocator(expandedURLPath, 1, true);
    }

    private BaseClassLocator createArrayClassLocator(URLPath urlPath, int fileType, boolean checkInterrupt) throws InterruptedException {
        if (urlPath != null) {
            int urlCount;
            URL[] urls = urlPath.getEntries();
            int n = urlCount = urls != null ? urls.length : 0;
            if (urlCount == 0) {
                return BaseClassLocator.EMPTY_LOCATOR;
            }
            BaseClassLocator[] locators = new BaseClassLocator[urlCount];
            for (int i = 0; i < urlCount; ++i) {
                if (checkInterrupt) {
                    ClassLocatorFactory.checkInterrupt();
                }
                URL url = urls[i];
                BaseClassLocator locator = fileType == 2 ? this.getSourceLocator(url) : this.getClassLocator(url);
                locators[i] = BaseClassLocator.ensureValid(locator);
            }
            return new ArrayClassLocator(locators);
        }
        return null;
    }

    public BaseClassLocator getPathLocator(URLPath sourcePath, URLPath classPath) {
        if (sourcePath != null || classPath != null) {
            return PathClassLocator.getInstance(sourcePath, classPath);
        }
        return null;
    }

    public BaseClassLocator getPathLocatorInterruptibly(URLPath sourcePath, URLPath classPath) throws InterruptedException {
        if (sourcePath != null || classPath != null) {
            return PathClassLocator.getInstanceInterruptibly(sourcePath, classPath);
        }
        return null;
    }

    private static void processQueue() {
        Reference<URLClassLocator> ref = _queue.poll();
        while (ref != null) {
            LocatorReference locatorRef = (LocatorReference)ref;
            URLFileSystem.removeURLFileSystemListener((URL)locatorRef.getURL(), (URLFileSystemListener)_fileSystemListener);
            refs.remove(locatorRef);
            ref = _queue.poll();
        }
    }

    private static void checkInterrupt() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    static {
        String property = System.getProperty("use.vfs.for.locator");
        USE_VFS_FOR_LOCATOR = property == null || !"false".equalsIgnoreCase(property);
        _fileSystemListener = new URLFileSystemListener(){

            public void notifyEvent(URLFileSystemEvent event) {
            }
        };
        _queue = new ReferenceQueue();
        refs = new HashSet();
    }

    private static final class LocatorReference
    extends WeakReference<URLClassLocator> {
        private URL url;

        public LocatorReference(URLClassLocator locator, ReferenceQueue<URLClassLocator> q) {
            super(locator, q);
            this.url = locator.getRootURL();
        }

        public URL getURL() {
            return this.url;
        }
    }
}

