/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.externaltools.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.button.ButtonBar;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controls.WaitCursor;
import oracle.ide.externaltools.ExternalTool;
import oracle.ide.externaltools.ExternalToolManager;
import oracle.ide.externaltools.ExternalToolScanner;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.externaltools.ExternalToolList;
import oracle.ideimpl.externaltools.ExternalToolsArb;
import oracle.ideimpl.externaltools.Util;
import oracle.ideimpl.externaltools.ui.ExternalToolsWizard;
import oracle.javatools.controls.SimpleListModel;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public final class ToolListPanel
extends JPanel {
    private GridBagLayout gbl = new GridBagLayout();
    private JLabel cmdLabel = new JLabel();
    private JScrollPane cmdScrollPane = new JScrollPane();
    private JList cmdList = new JList();
    private JButton btnMoveUp = new JButton();
    private JButton btnMoveDown = new JButton();
    private JButton btnRemoveCommand = new JButton();
    private JButton btnAddCommand = new JButton();
    private JButton btnEditCommand = new JButton();
    private JButton btnFindTools = new JButton();
    private ButtonBar bbAddRemove = new ButtonBar();
    private ButtonBar bbMoveUpDown = new ButtonBar();
    private transient ExternalToolManager m_manager;
    private transient ExternalToolList _listCopy;
    private boolean m_dialogChanges = false;
    public static final String COMMIT_PENDING_PROPERTY = "commitPending";

    public ToolListPanel() {
        this.jbInit();
        if (HelpSystem.getHelpSystem() != null) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_idedexternaltools_html");
        }
        this.cmdList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                try {
                    ToolListPanel.this.commandListSelectionChanged();
                }
                catch (RuntimeException re) {
                    ExceptionDialog.showExceptionDialog((Component)ToolListPanel.this, (Throwable)re);
                }
            }
        });
        this.cmdList.setCellRenderer(new ListRenderer());
        this.cmdList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                try {
                    if (me.getClickCount() == 2 && me.getButton() == 1 && ToolListPanel.this.cmdList.getSelectedValue() != null) {
                        ToolListPanel.this.doEditCommand();
                    }
                }
                catch (RuntimeException re) {
                    ExceptionDialog.showExceptionDialog((Component)ToolListPanel.this, (Throwable)re);
                }
            }
        });
        this.cmdList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke) {
                try {
                    if (ke.getKeyCode() == 127 && ToolListPanel.this.cmdList.getSelectedValue() != null) {
                        ToolListPanel.this.doRemoveCommand();
                    }
                }
                catch (RuntimeException re) {
                    ExceptionDialog.showExceptionDialog((Component)ToolListPanel.this, (Throwable)re);
                }
            }
        });
    }

    private void fireCommitPending() {
        if (!this.m_dialogChanges) {
            this.m_dialogChanges = true;
            super.firePropertyChange(COMMIT_PENDING_PROPERTY, false, true);
        }
    }

    public boolean isCommitPending() {
        return this.m_dialogChanges;
    }

    public void runDialog(Component parent, final Runnable commitRunnable) {
        this.btnFindTools.setVisible(false);
        for (ExternalToolScanner thisScanner : this.m_manager.getScanners()) {
            if (!thisScanner.canScan()) continue;
            this.btnFindTools.setVisible(true);
            break;
        }
        final JEWTDialog jd = JEWTDialog.createDialog((Component)parent, (String)ExternalToolsArb.getString(52), (int)7);
        jd.setResizable(true);
        jd.setOKButtonEnabled(this.isCommitPending());
        jd.setContent((Component)this);
        jd.pack();
        Dimension prefSize = jd.getPreferredSize();
        jd.setPreferredSize(new Dimension(Math.max(500, prefSize.width), Math.max(350, prefSize.height)));
        PropertyChangeListener pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                jd.setOKButtonEnabled(ToolListPanel.this.isCommitPending());
            }
        };
        this.addPropertyChangeListener(COMMIT_PENDING_PROPERTY, pcl);
        VetoableChangeListener vcl = null;
        if (commitRunnable != null) {
            vcl = new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
                    if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)pce)) {
                        try {
                            commitRunnable.run();
                        }
                        catch (RuntimeException re) {
                            ExceptionDialog.showExceptionDialog((Component)ToolListPanel.this, (Throwable)re);
                            throw new PropertyVetoException("", pce);
                        }
                    }
                }
            };
            jd.addVetoableChangeListener(vcl);
        }
        jd.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                ToolListPanel.this.autoCheckToolScanners();
                jd.removeWindowListener((WindowListener)this);
            }
        });
        jd.runDialog();
        this.removePropertyChangeListener(COMMIT_PENDING_PROPERTY, pcl);
        if (vcl != null) {
            jd.removeVetoableChangeListener(vcl);
        }
        jd.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoCheckToolScanners() {
        List validScanners = this.getValidAutoScanners();
        if (!validScanners.isEmpty()) {
            boolean doScan = MessageDialog.confirm((Component)this, (Object)ExternalToolsArb.getString(111), (String)ExternalToolsArb.getString(110), null);
            try {
                if (doScan) {
                    this.scanForTools(validScanners);
                }
            }
            finally {
                this.disableAutoScan(validScanners);
            }
        }
    }

    private void scanForTools(final List scanners) {
        final WaitCursor wc = new WaitCursor((Component)this);
        wc.show();
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                final ArrayList<ExternalTool> tools = new ArrayList<ExternalTool>();
                try {
                    for (ExternalToolScanner scanner : scanners) {
                        ExternalTool[] scannerTools = scanner.findTools(ToolListPanel.this._listCopy.tools());
                        for (int j = 0; j < scannerTools.length; ++j) {
                            tools.add(scannerTools[j]);
                        }
                    }
                }
                catch (RuntimeException re) {
                    try {
                        ExceptionDialog.showExceptionDialog((Component)ToolListPanel.this, (Throwable)re);
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                wc.hide();
                                wc.dispose();
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                if (tools.size() == 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.information((Component)ToolListPanel.this, (Object)ExternalToolsArb.getString(114), (String)ExternalToolsArb.getString(115), null);
                        }
                    });
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ToolListPanel.this.runDefaultToolsDialog(Collections.unmodifiableList(tools));
                        }
                    });
                }
            }
        };
        Thread t = new Thread(r, "External Tool Scanner");
        t.start();
    }

    private void runDefaultToolsDialog(List tools) {
        this.getListModel().addAll(tools);
        this.fireCommitPending();
        this.cmdList.requestFocus();
        if (tools.size() > 0) {
            this.cmdList.setSelectionInterval(this.cmdList.getModel().getSize() - tools.size(), this.cmdList.getModel().getSize() - 1);
        }
    }

    private List getValidAutoScanners() {
        ArrayList<ExternalToolScanner> scanners = new ArrayList<ExternalToolScanner>();
        for (ExternalToolScanner scanner : this.m_manager.getScanners()) {
            if (scanner.getId() == null) {
                Logger.getLogger(ToolListPanel.class.getName()).log(Level.SEVERE, "ExternalToolScanner " + scanner + " is illegally returning null from getId()", new IllegalStateException());
                continue;
            }
            if (!this.isAutoScanEnabled(scanner) || !scanner.canScan()) continue;
            scanners.add(scanner);
        }
        return Collections.unmodifiableList(scanners);
    }

    private boolean isAutoScanEnabled(ExternalToolScanner scanner) {
        return Ide.getDTCache().getBoolean(this.getKey(scanner), true);
    }

    private void disableAutoScan(List scanners) {
        for (ExternalToolScanner scanner : scanners) {
            Ide.getDTCache().putBoolean(this.getKey(scanner), Boolean.FALSE);
        }
    }

    private String getKey(ExternalToolScanner scanner) {
        StringBuffer b = new StringBuffer(31 + scanner.getId().length());
        b.append("externaltools.scanners.");
        b.append(scanner.getId());
        b.append(".enabled");
        return b.toString();
    }

    public void setToolManager(ExternalToolManager mgr) {
        this.m_manager = mgr;
        ExternalToolList tools = ExternalToolList.getInstance((PropertyStorage)Preferences.getPreferences());
        this._listCopy = (ExternalToolList)((Object)tools.copyTo(null));
        this.cmdList.setModel(new ListModel(this._listCopy));
        if (this._listCopy.tools().size() > 0) {
            this.cmdList.setSelectedIndex(0);
        }
        this.commandListSelectionChanged();
    }

    public ExternalToolList getTools() {
        return this._listCopy;
    }

    private void jbInit() {
        Icon upIcon = OracleIcons.getIcon((String)"up.png");
        Icon downIcon = OracleIcons.getIcon((String)"down.png");
        this.bbAddRemove.setOrientation(0);
        this.bbAddRemove.setAlignment(4);
        this.bbMoveUpDown.setOrientation(1);
        this.bbMoveUpDown.setAlignment(0);
        ButtonListener bl = new ButtonListener();
        this.setLayout(this.gbl);
        ResourceUtils.resLabel((JLabel)this.cmdLabel, (Component)this.cmdList, (String)ExternalToolsArb.getString(46));
        this.cmdScrollPane.setPreferredSize(new Dimension(0, 0));
        this.btnMoveUp.setIcon(upIcon);
        this.btnMoveUp.setMargin(new Insets(1, 1, 1, 1));
        this.btnMoveUp.addActionListener(bl);
        this.btnMoveUp.setToolTipText(ExternalToolsArb.getString(47));
        this.btnMoveDown.setIcon(downIcon);
        this.btnMoveDown.setMargin(new Insets(1, 1, 1, 1));
        this.btnMoveDown.addActionListener(bl);
        this.btnMoveDown.setToolTipText(ExternalToolsArb.getString(48));
        ResourceUtils.resButton((AbstractButton)this.btnRemoveCommand, (String)ExternalToolsArb.getString(49));
        this.btnRemoveCommand.addActionListener(bl);
        ResourceUtils.resButton((AbstractButton)this.btnAddCommand, (String)ExternalToolsArb.getString(50));
        this.btnAddCommand.addActionListener(bl);
        ResourceUtils.resButton((AbstractButton)this.btnEditCommand, (String)ExternalToolsArb.getString(51));
        this.btnEditCommand.addActionListener(bl);
        ResourceUtils.resButton((AbstractButton)this.btnFindTools, (String)ExternalToolsArb.getString(116));
        this.btnFindTools.addActionListener(bl);
        this.bbAddRemove.add((Component)this.btnFindTools);
        this.bbAddRemove.add((Component)this.btnAddCommand);
        this.bbAddRemove.add((Component)this.btnEditCommand);
        this.bbAddRemove.add((Component)this.btnRemoveCommand);
        this.bbMoveUpDown.add((Component)this.btnMoveUp);
        this.bbMoveUpDown.add((Component)this.btnMoveDown);
        this.cmdList.setModel(new SimpleListModel());
        this.cmdList.setSelectionMode(2);
        this.add((Component)this.cmdLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.cmdScrollPane.getViewport().add((Component)this.cmdList, null);
        this.add((Component)this.cmdScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.bbMoveUpDown, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.bbAddRemove, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0));
    }

    private void commandListSelectionChanged() {
        if (this.cmdList.getSelectedIndices().length > 1) {
            this.btnRemoveCommand.setEnabled(true);
            this.btnEditCommand.setEnabled(false);
            this.btnMoveUp.setEnabled(false);
            this.btnMoveDown.setEnabled(false);
        } else {
            int sel = this.cmdList.getSelectedIndex();
            this.btnMoveUp.setEnabled(sel > 0);
            this.btnMoveDown.setEnabled(sel != -1 && sel < this.cmdList.getModel().getSize() - 1);
            if (sel == -1) {
                this.btnRemoveCommand.setEnabled(false);
                this.btnEditCommand.setEnabled(false);
            } else {
                this.btnRemoveCommand.setEnabled(true);
                this.btnEditCommand.setEnabled(true);
            }
        }
    }

    private ListModel getListModel() {
        return (ListModel)this.cmdList.getModel();
    }

    private void doAddCommand() {
        ExternalTool tool = new ExternalToolsWizard().runCreateWizard(this._listCopy.tools(), this.m_manager, this, null);
        if (tool != null) {
            this.getListModel().add(tool);
            this.cmdList.setSelectedIndex(this.getListModel().getSize() - 1);
            this.cmdList.ensureIndexIsVisible(this.getListModel().getSize() - 1);
        }
        this.fireCommitPending();
    }

    private void doEditCommand() {
        ExternalTool tool = (ExternalTool)this.cmdList.getSelectedValue();
        if (tool != null) {
            new ExternalToolsWizard().runEditWizard(this._listCopy.tools(), this.m_manager, this, tool);
            this.getListModel().refreshTool(this.cmdList.getSelectedIndex());
            this.fireCommitPending();
        }
    }

    private void doRemoveCommand() {
        this.removeSelectedItems(this.cmdList);
        if (this.cmdList.getModel().getSize() == 0) {
            this.commandListSelectionChanged();
        }
        this.fireCommitPending();
    }

    void removeSelectedItems(JList list) {
        boolean singleSelection;
        int[] selectedIndices = list.getSelectedIndices();
        this.getListModel().removeItems(selectedIndices);
        boolean bl = singleSelection = selectedIndices.length == 1;
        if (singleSelection) {
            int selectIndex = selectedIndices[0];
            if (selectIndex < list.getModel().getSize()) {
                list.setSelectedIndex(selectIndex);
            } else if (list.getModel().getSize() > 0) {
                list.setSelectedIndex(list.getModel().getSize() - 1);
            }
        } else {
            list.getSelectionModel().clearSelection();
        }
    }

    void moveSelectionUp(JList list) {
        int sel = list.getSelectedIndex();
        this.getListModel().moveUp(this._listCopy.tools().get(sel));
        list.setSelectedIndex(sel - 1);
    }

    void moveSelectionDown(JList list) {
        int sel = list.getSelectedIndex();
        this.getListModel().moveDown(this._listCopy.tools().get(sel));
        list.setSelectedIndex(sel + 1);
    }

    private void doMoveToolUp() {
        this.moveSelectionUp(this.cmdList);
        this.fireCommitPending();
    }

    private void doMoveToolDown() {
        this.moveSelectionDown(this.cmdList);
        this.fireCommitPending();
    }

    private void doFindTools() {
        this.scanForTools(this.m_manager.getScanners());
    }

    private static class ListModel
    extends AbstractListModel {
        private final ExternalToolList _tools;

        ListModel(ExternalToolList tools) {
            this._tools = tools;
        }

        public void removeItems(int[] indices) {
            int newSize;
            int oldSize = this.getSize();
            List<ExternalTool> tools = this._tools.tools();
            for (int i = 0; i < indices.length; ++i) {
                this._tools.remove(tools.get(indices[i]));
            }
            int start = newSize = this.getSize();
            int end = oldSize - 1;
            this.fireIntervalRemoved(start, end);
            this.fireContentsChanged(this, 0, newSize);
        }

        public void remove(int index) {
            ExternalTool tool = this._tools.tools().get(index);
            this._tools.remove(tool);
            this.fireIntervalRemoved(this, index, index);
        }

        public void fireIntervalRemoved(int start, int end) {
            super.fireIntervalRemoved(this, start, end);
        }

        public void fireIntervalAdded(int start, int end) {
            super.fireIntervalAdded(this, start, end);
        }

        public void addAll(List tools) {
            int size = this.getSize();
            for (ExternalTool tool : tools) {
                this._tools.add(tool);
            }
            this.fireIntervalAdded(size, size + tools.size() - 1);
        }

        public void add(int index, ExternalTool tool) {
            this._tools.add(index, tool);
            this.fireIntervalAdded(this, index, index);
        }

        public void add(ExternalTool tool) {
            this._tools.add(tool);
            int size = this._tools.tools().size();
            this.fireIntervalAdded(this, size - 1, size - 1);
        }

        public void refreshTool(int index) {
            this.fireContentsChanged(this, index, index);
        }

        public void moveUp(ExternalTool tool) {
            this._tools.moveUp(tool);
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }

        public void moveDown(ExternalTool tool) {
            this._tools.moveDown(tool);
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }

        @Override
        public int getSize() {
            return this._tools.tools().size();
        }

        @Override
        public Object getElementAt(int index) {
            return this._tools.tools().get(index);
        }
    }

    private static class ListRenderer
    extends DefaultListCellRenderer {
        private ListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
            if (value instanceof ExternalTool) {
                ExternalTool tool = (ExternalTool)value;
                this.setIcon(Util.getToolIcon(tool, Context.newIdeContext()));
            }
            return c;
        }
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JButton button = (JButton)e.getSource();
                if (ToolListPanel.this.btnAddCommand == button) {
                    ToolListPanel.this.doAddCommand();
                } else if (ToolListPanel.this.btnRemoveCommand == button) {
                    ToolListPanel.this.doRemoveCommand();
                } else if (ToolListPanel.this.btnMoveUp == button) {
                    ToolListPanel.this.doMoveToolUp();
                } else if (ToolListPanel.this.btnMoveDown == button) {
                    ToolListPanel.this.doMoveToolDown();
                } else if (ToolListPanel.this.btnEditCommand == button) {
                    ToolListPanel.this.doEditCommand();
                } else if (ToolListPanel.this.btnFindTools == button) {
                    ToolListPanel.this.doFindTools();
                }
                if (button.isEnabled()) {
                    button.requestFocus();
                }
            }
            catch (RuntimeException re) {
                ExceptionDialog.showExceptionDialog((Component)ToolListPanel.this, (Throwable)re);
            }
        }
    }
}

