/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.externaltools.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.externaltools.ExternalToolType;
import oracle.ide.externaltools.macro.MacroExpander;
import oracle.ide.externaltools.macro.MacroPicker;
import oracle.ide.externaltools.macro.MacroRegistry;
import oracle.ide.externaltools.macro.Parameter;
import oracle.ide.externaltools.macro.ParameterizedMacro;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Displayable;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.externaltools.ExternalToolsArb;
import oracle.javatools.controls.SimpleListModel;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public final class MacroPickerImpl
extends JPanel
implements MacroPicker {
    private static final String COMPLETE = "complete";
    private GridBagLayout layout = new GridBagLayout();
    private JLabel lblHint = new JLabel();
    private JLabel lblMacro = new JLabel();
    private JScrollPane spMacro = new JScrollPane();
    private JLabel lblDescription = new JLabel();
    private JScrollPane spDescription = new JScrollPane();
    private JLabel lblSample = new JLabel();
    private JScrollPane spSample = new JScrollPane();
    private JList lstMacro = new JList();
    private JTextArea taDescription = new JTextArea();
    private JTextArea taSample = new JTextArea();
    private JPanel panParameters = new JPanel();
    private SearchField searchField = new SearchField();
    private SimpleListModel<MacroExpander> _allModel;
    private transient DocumentListener paramDocListener = new DocumentListener(){

        private void update() {
            MacroPickerImpl.this.fireCompleteChanged();
            MacroPickerImpl.this.updateSample();
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            this.update();
        }
    };

    public MacroPickerImpl() {
        this.jbInit();
        this.addListSelectionListener(new DetailUpdateListener());
    }

    private void updateSample() {
        MacroExpander me = this.getSelectedMacro();
        String sample = me == null ? "" : me.getSampleExpansion(Ide.getMainWindow().getLastActiveView().getContext());
        this.taSample.setText(sample);
        this.taSample.setCaretPosition(0);
    }

    private void updateDetails() {
        MacroExpander me = this.getSelectedMacroImpl();
        String description = me == null ? "" : me.getLongLabel();
        this.taDescription.setText(description);
        this.taDescription.setCaretPosition(0);
        this.lstMacro.requestFocus();
        if (me instanceof ParameterizedMacro) {
            this.disposeParameterPanel();
            ParameterizedMacro paramMacro = (ParameterizedMacro)me;
            for (Parameter parameter : paramMacro.getSupportedParameters()) {
                ParameterPanel panel = new ParameterPanel(parameter);
                this.panParameters.add(panel);
            }
            this.panParameters.setVisible(true);
            this.packParentDialog();
        } else if (this.panParameters.isVisible()) {
            this.panParameters.setVisible(false);
            this.packParentDialog();
        }
        this.updateSample();
        this.fireCompleteChanged();
    }

    private void disposeParameterPanel() {
        for (int i = 0; i < this.panParameters.getComponentCount(); ++i) {
            ParameterPanel parameterPanel = (ParameterPanel)this.panParameters.getComponent(i);
            parameterPanel.dispose();
        }
        this.panParameters.removeAll();
    }

    private void fireCompleteChanged() {
        boolean complete = this.isComplete();
        this.firePropertyChange(COMPLETE, !complete, complete);
    }

    private void packParentDialog() {
        this.validate();
        Dialog parent = this.getDialogParent(this);
        if (parent != null) {
            parent.pack();
        }
    }

    public boolean isComplete() {
        return this.getSelectedMacroImpl() != null && this.areAllParametersSet();
    }

    private boolean areAllParametersSet() {
        if (!this.panParameters.isVisible()) {
            return true;
        }
        for (int i = 0; i < this.panParameters.getComponentCount(); ++i) {
            ParameterPanel p = (ParameterPanel)this.panParameters.getComponent(i);
            if (p.hasValue()) continue;
            return false;
        }
        return true;
    }

    private Dialog getDialogParent(Component c) {
        if (c == null || c instanceof Dialog) {
            return (Dialog)c;
        }
        return this.getDialogParent(c.getParent());
    }

    @Override
    public void addListSelectionListener(ListSelectionListener lsl) {
        this.lstMacro.addListSelectionListener(lsl);
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener lsl) {
        this.lstMacro.removeListSelectionListener(lsl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MacroExpander runDialog(Component parent) {
        final JEWTDialog jd = JEWTDialog.createDialog((Component)parent, (String)ExternalToolsArb.getString(45), (int)7);
        jd.setResizable(true);
        jd.setContent((Component)this);
        jd.setOKButtonEnabled(this.isComplete());
        jd.setInitialFocus((Component)this.lstMacro);
        PropertyChangeListener pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                if (MacroPickerImpl.COMPLETE.equals(pce.getPropertyName())) {
                    jd.setOKButtonEnabled(((Boolean)pce.getNewValue()).booleanValue());
                }
            }
        };
        this.addPropertyChangeListener(pcl);
        if (HelpSystem.getHelpSystem() != null) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_idedexternaltoolsmacros_html");
        }
        this.attachDoubleClickListener(jd, this.lstMacro);
        try {
            if (jd.runDialog()) {
                MacroExpander macroExpander = this.getSelectedMacro();
                return macroExpander;
            }
            MacroExpander macroExpander = null;
            return macroExpander;
        }
        finally {
            this.removePropertyChangeListener(pcl);
            jd.dispose();
            this.disposeParameterPanel();
            this.detachDoubleClickListener(this.lstMacro);
        }
    }

    private void attachDoubleClickListener(final JEWTDialog dialog, final JList list) {
        MouseAdapter ml = new MouseAdapter(){

            private boolean isPointInsideACell(Point p) {
                int row = list.locationToIndex(p);
                if (row == -1) {
                    return false;
                }
                Rectangle bounds = list.getCellBounds(row, row);
                return bounds.contains(p);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2 && this.isPointInsideACell(e.getPoint())) {
                    dialog.closeDialog(false);
                }
            }
        };
        list.addMouseListener(ml);
        list.putClientProperty(MouseListener.class, ml);
    }

    private void detachDoubleClickListener(JList list) {
        MouseListener ml = (MouseListener)list.getClientProperty(MouseListener.class);
        if (ml != null) {
            list.removeMouseListener(ml);
        }
    }

    public void populate(MacroRegistry registry, ExternalToolType type, boolean onlyDirectories) {
        ArrayList<MacroExpander> alMacros = new ArrayList<MacroExpander>();
        for (MacroExpander expander : registry.getMacros()) {
            if (type != null && !expander.isAvailableForType(type)) continue;
            if (onlyDirectories && expander.isDirectoryMacro()) {
                alMacros.add(expander);
                continue;
            }
            if (onlyDirectories) continue;
            alMacros.add(expander);
        }
        Comparator c = new Comparator(){
            Collator _collator = Collator.getInstance();

            public int compare(Object thisObject, Object thatObject) {
                if (thisObject instanceof MacroExpander && thatObject instanceof MacroExpander) {
                    String thisString = ((MacroExpander)thisObject).getShortLabel();
                    String thatString = ((MacroExpander)thatObject).getShortLabel();
                    return this._collator.compare(thisString, thatString);
                }
                return 0;
            }
        };
        Collections.sort(alMacros, c);
        this._allModel = new SimpleListModel(alMacros);
        this.lstMacro.setModel(this._allModel);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public MacroExpander getSelectedMacro() {
        MacroExpander macro = this.getSelectedMacroImpl();
        if (macro instanceof ParameterizedMacro) {
            ParameterizedMacro pm = (ParameterizedMacro)macro;
            for (int i = 0; i < this.panParameters.getComponentCount(); ++i) {
                ParameterPanel parameterPanel = (ParameterPanel)this.panParameters.getComponent(i);
                Parameter p = parameterPanel._parameter;
                pm.setValue(p, parameterPanel.getValue());
            }
        }
        return macro;
    }

    private MacroExpander getSelectedMacroImpl() {
        return (MacroExpander)this.lstMacro.getSelectedValue();
    }

    private void jbInit() {
        this.setLayout(this.layout);
        ResourceUtils.resLabel((JLabel)this.lblMacro, (Component)this.lstMacro, (String)ExternalToolsArb.getString(42));
        ResourceUtils.resLabel((JLabel)this.lblDescription, (Component)this.taDescription, (String)ExternalToolsArb.getString(43));
        ResourceUtils.resLabel((JLabel)this.lblSample, (Component)this.taSample, (String)ExternalToolsArb.getString(44));
        this.lblHint.setText(ExternalToolsArb.getString(41));
        this.taDescription.setEditable(false);
        this.taDescription.setRows(3);
        this.taDescription.setOpaque(false);
        this.taDescription.setFont(this.lblHint.getFont());
        this.taDescription.setWrapStyleWord(true);
        this.taDescription.setLineWrap(true);
        this.taSample.setEditable(false);
        this.taSample.setRows(3);
        this.taSample.setOpaque(false);
        this.taSample.setLineWrap(true);
        this.lstMacro.setSelectionMode(0);
        this.lstMacro.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof Displayable) {
                    super.setText(((Displayable)value).getShortLabel());
                }
                return c;
            }
        });
        this.add((Component)this.lblHint, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.add((Component)this.lblMacro, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.searchField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 20, 5, 0), 0, 0));
        this.spMacro.getViewport().add((Component)this.lstMacro, null);
        this.add((Component)this.spMacro, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.panParameters, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.lblDescription, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.spDescription.getViewport().add((Component)this.taDescription, null);
        this.add((Component)this.spDescription, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.lblSample, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.spSample.getViewport().add((Component)this.taSample, null);
        this.add((Component)this.spSample, new GridBagConstraints(0, 7, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panParameters.setLayout(new BoxLayout(this.panParameters, 1));
        this.panParameters.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent se) {
                MacroPickerImpl.this.filterList(se.getSearchText().toLowerCase());
            }

            public void searchCategoryChanged(SearchEvent se) {
            }
        });
    }

    private void filterList(String searchText) {
        if (searchText.length() == 0) {
            this.lstMacro.setModel(this._allModel);
        } else {
            SimpleListModel filteredModel = new SimpleListModel();
            for (MacroExpander expander : this._allModel) {
                if (!expander.getShortLabel().toLowerCase().contains(searchText)) continue;
                filteredModel.addElement((Object)expander);
            }
            this.lstMacro.setModel(filteredModel);
        }
    }

    private class ParameterPanel
    extends JPanel {
        private final Parameter _parameter;
        private final JLabel _label = new JLabel();
        private final JTextField _field = new JTextField();

        private ParameterPanel(Parameter parameter) {
            this._parameter = parameter;
            String text = this._parameter.getLabel();
            if (!text.endsWith(":")) {
                text = text + ':';
            }
            int mnemonicCode = StringUtils.getMnemonicKeyCode((String)text);
            int mnemonicIndex = StringUtils.getMnemonicIndex((String)text);
            text = StringUtils.stripMnemonic((String)text);
            this._label.setText(text);
            if (mnemonicCode >= 0) {
                this._label.setDisplayedMnemonic(mnemonicCode);
                this._label.setDisplayedMnemonicIndex(mnemonicIndex);
            }
            this._label.setLabelFor(this._field);
            this.setLayout(new BorderLayout(0, 5));
            this.add((Component)this._label, "North");
            this.add((Component)this._field, "Center");
            this._field.getDocument().addDocumentListener(MacroPickerImpl.this.paramDocListener);
        }

        public boolean hasValue() {
            return this._field.getText().trim().length() > 0;
        }

        public String getValue() {
            return this._field.getText();
        }

        public void dispose() {
            this._field.getDocument().removeDocumentListener(MacroPickerImpl.this.paramDocListener);
        }
    }

    private class DetailUpdateListener
    implements ListSelectionListener {
        private DetailUpdateListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent lse) {
            try {
                MacroPickerImpl.this.updateDetails();
            }
            catch (RuntimeException re) {
                ExceptionDialog.showExceptionDialog((Component)MacroPickerImpl.this, (Throwable)re);
            }
        }
    }
}

