/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.externaltools.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.ide.Ide;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.externaltools.Availability;
import oracle.ide.externaltools.ExternalTool;
import oracle.ide.externaltools.ExternalToolBaseProperties;
import oracle.ide.externaltools.ExternalToolOptionsEnvironment;
import oracle.ide.externaltools.ExternalToolOptionsPage;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.externaltools.ExternalToolsArb;
import oracle.javatools.controls.SimpleListModel;
import oracle.javatools.dialogs.ExceptionDialog;

public class AvailabilityPanel
extends JPanel
implements ExternalToolOptionsPage {
    private GridBagLayout gblEnablementPanel = new GridBagLayout();
    private JLabel labHint = new JLabel();
    private JLabel labTitle = new JLabel();
    private JRadioButton rbAlways = new JRadioButton();
    private JRadioButton rbActiveNode = new JRadioButton();
    private JRadioButton rbSpecificType = new JRadioButton();
    private Shuttle typeShuttle = new Shuttle();
    private JLabel labFrom = new JLabel();
    private JList typeFromList = new JList();
    private JLabel labTo = new JLabel();
    private JList typeToList = new JList();
    private boolean _typesHidden = false;

    public AvailabilityPanel() {
        this.jbInit();
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.rbAlways);
        bg.add(this.rbActiveNode);
        bg.add(this.rbSpecificType);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AvailabilityPanel.this.updateControlEnablement();
                }
                catch (RuntimeException re) {
                    ExceptionDialog.showExceptionDialog((Component)AvailabilityPanel.this, (Throwable)re);
                }
            }
        };
        this.rbAlways.addActionListener(al);
        this.rbActiveNode.addActionListener(al);
        this.rbSpecificType.addActionListener(al);
    }

    @Override
    public String getHelpTopicID() {
        return "f1_idedexternaltools5_html";
    }

    @Override
    public Component getInitialFocus() {
        return this.rbAlways;
    }

    private void updateControlEnablement() {
        this.typeShuttle.setEnabled(this.rbSpecificType.isSelected());
        this.typeToList.setEnabled(this.rbSpecificType.isSelected());
        this.typeFromList.setEnabled(this.rbSpecificType.isSelected());
    }

    private void jbInit() {
        this.setLayout(this.gblEnablementPanel);
        this.labHint.setText("<html>" + ExternalToolsArb.getString(97) + "</html>");
        ResourceUtils.resLabel((JLabel)this.labTitle, (Component)this.rbAlways, (String)ExternalToolsArb.getString(98));
        ResourceUtils.resButton((AbstractButton)this.rbAlways, (String)ExternalToolsArb.getString(99));
        ResourceUtils.resButton((AbstractButton)this.rbActiveNode, (String)ExternalToolsArb.getString(100));
        ResourceUtils.resButton((AbstractButton)this.rbSpecificType, (String)ExternalToolsArb.getString(101));
        ResourceUtils.resLabel((JLabel)this.labFrom, (Component)this.typeFromList, (String)ExternalToolsArb.getString(102));
        ResourceUtils.resLabel((JLabel)this.labTo, (Component)this.typeToList, (String)ExternalToolsArb.getString(103));
        this.add((Component)this.labHint, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.add((Component)this.labTitle, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.rbAlways, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 0, 0), 0, 0));
        this.add((Component)this.rbActiveNode, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 24, 0, 0), 0, 0));
        this.add((Component)this.rbSpecificType, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 24, 0, 0), 0, 0));
        this.add((Component)this.typeShuttle, new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 29, 0, 0), 0, 0));
    }

    private void populateAvailableTypes() {
        DocumentExtensions de = (DocumentExtensions)Ide.getSettings().getData("document-extensions-options");
        if (de == null || de.getDocuments().isEmpty()) {
            if (this._typesHidden) {
                return;
            }
            this._typesHidden = true;
            this.rbSpecificType.setVisible(false);
            this.typeShuttle.setVisible(false);
            this.add((Component)new JPanel(), new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            return;
        }
        Collection c = de.getDocuments();
        ArrayList copy = new ArrayList(c);
        Comparator comparator = new Comparator(){
            final Collator collator = Collator.getInstance();

            public int compare(Object o1, Object o2) {
                DocumentExtensions.DocRecord dr1 = (DocumentExtensions.DocRecord)o1;
                DocumentExtensions.DocRecord dr2 = (DocumentExtensions.DocRecord)o2;
                String label1 = dr1.getLabel();
                String label2 = dr2.getLabel();
                if (label1 == null) {
                    label1 = dr1.getDocClassName();
                }
                if (label2 == null) {
                    label2 = dr2.getDocClassName();
                }
                return this.collator.compare(label1, label2);
            }
        };
        Collections.sort(copy, comparator);
        SimpleListModel model = new SimpleListModel();
        model.asList().addAll(copy);
        this.typeFromList.setModel(model);
        this.typeToList.setModel(new SimpleListModel());
    }

    @Override
    public void setEnvironment(ExternalToolOptionsEnvironment env) {
        this.typeFromList.setCellRenderer(new TypeListCellRenderer());
        this.typeToList.setCellRenderer(new TypeListCellRenderer());
        this.typeShuttle.setFromPicker((ItemPicker)new ListPicker(this.typeFromList));
        this.typeShuttle.setToPicker((ItemPicker)new ListPicker(this.typeToList));
        this.typeShuttle.add((Component)this.labFrom, (Object)"FromHeader");
        this.typeShuttle.add((Component)this.labTo, (Object)"ToHeader");
    }

    @Override
    public JComponent getGUI() {
        return this;
    }

    @Override
    public String getPageName() {
        return ExternalToolsArb.getString(96);
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public boolean validateOptions() {
        return true;
    }

    @Override
    public void saveOptions(ExternalTool tool, boolean isCreateMode) {
        ExternalToolBaseProperties props = ExternalToolBaseProperties.getInstance(tool);
        Availability availability = null;
        if (this.rbActiveNode.isSelected()) {
            availability = Availability.ANY_SELECTION;
        } else if (this.rbAlways.isSelected()) {
            availability = Availability.ALWAYS;
        } else if (this.rbSpecificType.isSelected()) {
            availability = Availability.SELECTED_TYPES;
        }
        props.setAvailability(availability);
        ArrayList<String> l = new ArrayList<String>();
        DefaultListModel model = (DefaultListModel)this.typeToList.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            l.add(((DocumentExtensions.DocRecord)model.getElementAt(i)).getDocClassName());
        }
        props.setAvailableTypes(l);
    }

    @Override
    public void loadOptions(ExternalTool tool, boolean isCreateMode) {
        this.populateAvailableTypes();
        ExternalToolBaseProperties props = ExternalToolBaseProperties.getInstance(tool);
        List<String> l = props.getAvailableTypes();
        if (l != null) {
            DefaultListModel fromModel = (DefaultListModel)this.typeFromList.getModel();
            DefaultListModel toModel = (DefaultListModel)this.typeToList.getModel();
            block5: for (String typeClass : l) {
                for (int j = 0; j < fromModel.getSize(); ++j) {
                    DocumentExtensions.DocRecord rec = (DocumentExtensions.DocRecord)fromModel.getElementAt(j);
                    if (!rec.getDocClassName().equals(typeClass)) continue;
                    fromModel.removeElement(rec);
                    toModel.addElement(rec);
                    continue block5;
                }
            }
        }
        switch (props.getAvailability()) {
            case ALWAYS: {
                this.rbAlways.setSelected(true);
                break;
            }
            case SELECTED_TYPES: {
                this.rbSpecificType.setSelected(true);
                break;
            }
            case ANY_SELECTION: {
                this.rbActiveNode.setSelected(true);
            }
        }
        this.updateControlEnablement();
    }

    private static class TypeListCellRenderer
    extends DefaultListCellRenderer {
        private TypeListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof DocumentExtensions.DocRecord) {
                DocumentExtensions.DocRecord record = (DocumentExtensions.DocRecord)value;
                Icon icon = record.getIcon();
                this.setIcon(icon);
                this.setText(record.getLabel() != null ? record.getLabel() : record.getDocClassName());
            }
            this.setEnabled(list.isEnabled());
            return this;
        }
    }
}

