/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.externaltools;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import javax.ide.util.Version;
import oracle.ide.migration.Migrator;
import oracle.ide.util.Assert;
import oracle.ideimpl.externaltools.ExternalToolsArb;
import oracle.ideimpl.externaltools.ToolPersistence;

public class ToolMigrator
implements Migrator {
    static final int EXTERNAL_TOOL_DEFINITIONS = 0;
    private static final int[] CATEGORIES = new int[]{0};
    private boolean m_isSelected = true;

    public int[] getMigrationCategories() {
        return (int[])CATEGORIES.clone();
    }

    public String getDescription(int category) {
        switch (category) {
            case 0: {
                return ExternalToolsArb.getString(40);
            }
        }
        Assert.fail((String)("Unrecognized category: " + category));
        return null;
    }

    public boolean canMigrate(int category, File sourceDir) {
        File f;
        if (category == 0 && (f = this.findToolsXml(sourceDir)) != null && f.canRead()) {
            try {
                int revision = ToolPersistence.getDefinitionRevision(f);
                return revision != -1;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public void setSelected(int category, boolean isSelected) {
        if (category == 0) {
            this.m_isSelected = isSelected;
        }
    }

    public boolean isSelected(int category) {
        return category == 0 && this.m_isSelected;
    }

    public String[] migrate(File sourceDir, File destDir) {
        String[] result = new String[]{};
        if (this.m_isSelected) {
            File source = this.findToolsXml(sourceDir);
            if (source == null) {
                return result;
            }
            File dest = this.toolsXmlIn(destDir);
            try {
                ToolPersistence.convertDefinitions(source, dest, -1);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return new String[]{ioe.getMessage()};
            }
        }
        return result;
    }

    private File findToolsXml(File sourceDir) {
        if (!sourceDir.isDirectory()) {
            return null;
        }
        File toolsXml = this.toolsXmlIn(sourceDir);
        if (toolsXml.exists()) {
            return toolsXml;
        }
        String[] extensionDirs = this.sortByExtensionVersion(sourceDir, "oracle.jdeveloper");
        for (int i = extensionDirs.length - 1; i >= 0; --i) {
            toolsXml = this.toolsXmlIn(new File(sourceDir, extensionDirs[i]));
            if (!toolsXml.exists()) continue;
            return toolsXml;
        }
        return null;
    }

    private String[] sortByExtensionVersion(File sourceDir, String id) {
        final String prefix = id + ".";
        String[] names = sourceDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name != null && name.startsWith(prefix) && name.length() > prefix.length();
            }
        });
        Arrays.sort(names, new SystemDirVersionComparator("oracle.jdeveloper."));
        return names;
    }

    private File toolsXmlIn(File dir) {
        return new File(dir, "tools.xml");
    }

    private static class SystemDirVersionComparator
    implements Comparator<String> {
        private final int _baseNameSize;

        SystemDirVersionComparator(String baseName) {
            this._baseNameSize = baseName.length();
        }

        @Override
        public int compare(String o1, String o2) {
            try {
                Version v1 = new Version(o1.substring(this._baseNameSize));
                Version v2 = new Version(o2.substring(this._baseNameSize));
                return v1.compareTo(v2);
            }
            catch (NumberFormatException nfe) {
                return -1;
            }
        }
    }
}

