/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.externaltools;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.externaltools.Availability;
import oracle.ide.externaltools.ExternalToolBaseProperties;
import oracle.ide.externaltools.ExternalToolManager;
import oracle.ide.externaltools.ExternalToolType;
import oracle.ide.externaltools.ToolRunException;
import oracle.javatools.data.HashStructure;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Copyable;

public abstract class ExternalTool
implements Copyable {
    public static final int INTEG_TOOLS_MENU_ITEM = 1;
    public static final int INTEG_CODE_EDITOR_CONTEXT_MENU_ITEM = 2;
    public static final int INTEG_NAVIGATOR_CONTEXT_MENU_ITEM = 4;
    public static final int INTEG_MAIN_WINDOW_TOOLBAR_BUTTON = 8;
    public static final int INTEG_NAVIGATOR_TOOLBAR_BUTTON = 16;
    public static final int AVAIL_ALWAYS = 0;
    public static final int AVAIL_SELECTION = 1;
    public static final int AVAIL_REGEXP = 2;
    public static final int AVAIL_TYPES = 3;
    private HashStructure _properties = HashStructure.newInstance();

    public final void setData(HashStructure hs) {
        if (hs == null) {
            throw new NullPointerException("hs is null");
        }
        this._properties = hs;
    }

    public final HashStructure getData() {
        return this._properties;
    }

    private ExternalToolBaseProperties properties() {
        return ExternalToolBaseProperties.getInstance(this.getData());
    }

    public void setScannerTag(String tag) {
        this.properties().setScannerTag(tag);
    }

    public String getScannerTag() {
        return this.properties().getScannerTag();
    }

    public boolean getReloadBuffers() {
        return this.properties().getReloadBuffers();
    }

    public void setReloadBuffers(boolean reload) {
        this.properties().setReloadBuffers(reload);
    }

    public Icon getIconWhenRequired() {
        return OracleIcons.getIcon((String)"file.png");
    }

    public boolean hasIntegration(int integrationType) {
        return ExternalToolBaseProperties.hasIntegration(this.properties().getIntegrationMask(), integrationType);
    }

    public String toString() {
        return this.properties().getCaption();
    }

    public int hashCode() {
        return 4132 + this.getData().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExternalTool)) {
            return false;
        }
        ExternalTool other = (ExternalTool)o;
        return other.getData().equals((Object)this.getData());
    }

    public void setAvailableTypes(List<String> types) {
        this.properties().setAvailableTypes(types);
    }

    public List<String> getAvailableTypes() {
        return new ArrayList<String>(this.properties().getAvailableTypes());
    }

    public URL getIconURL() {
        return this.properties().getIconURL();
    }

    public void setIconURL(URL u) {
        this.properties().setIconURL(u);
    }

    public String getCaption() {
        return this.properties().getCaption();
    }

    public void setCaption(String caption) {
        this.properties().setCaption(caption);
    }

    public String getToolTipText() {
        return this.properties().getToolTipText();
    }

    public void setToolTipText(String toolTipText) {
        this.properties().setToolTipText(toolTipText);
    }

    public int getIntegrationMask() {
        return this.properties().getIntegrationMask();
    }

    public void setIntegrationMask(int integrationMask) {
        this.properties().setIntegrationMask(integrationMask);
    }

    public int getAvailability() {
        return this.properties().getAvailability().oldConstant();
    }

    public void setAvailability(int availability) {
        this.properties().setAvailability(Availability.fromOldConstant(availability));
    }

    public String getAvailabilityExpression() {
        return "";
    }

    public void setAvailabilityExpression(String expression) {
    }

    protected void copyToImpl(ExternalTool copy) {
    }

    public Object copyTo(Object target) {
        return null;
    }

    public abstract void run(ExternalToolManager var1, Context var2) throws ToolRunException;

    public abstract <T extends ExternalToolType> Class<T> getType();
}

