/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.schemabrowser.view;

import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.schemabrowser.SBAddin;
import oracle.dbtools.raptor.schemabrowser.model.SBListModel;
import oracle.dbtools.raptor.schemabrowser.model.Task;
import oracle.dbtools.raptor.schemabrowser.view.PanelState;
import oracle.dbtools.raptor.schemabrowser.view.SBGui;
import oracle.ide.model.Displayable;

public class TaskHandler<T extends Displayable>
extends RaptorTaskAdapter {
    private SBGui m_gui;
    private SBListModel<T> m_model;
    private Task<T> m_task;

    public TaskHandler(SBGui sBGui, SBListModel<T> sBListModel, Task<T> task) {
        this.m_gui = sBGui;
        this.m_model = sBListModel;
        this.m_task = task;
    }

    private final void enableComponent() {
        this.m_gui.setPanelState(PanelState.OPEN);
    }

    protected void preProcess(RaptorTaskEvent raptorTaskEvent, SBListModel<T> sBListModel) {
    }

    protected void postProcess(RaptorTaskEvent raptorTaskEvent, SBListModel<T> sBListModel) {
    }

    public final void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
        this.enableComponent();
    }

    public final void taskFailed(RaptorTaskEvent raptorTaskEvent) {
        this.enableComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void taskFinished(final RaptorTaskEvent raptorTaskEvent) {
        try {
            final List list = (List)this.m_task.getResult();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    TaskHandler.this.preProcess(raptorTaskEvent, TaskHandler.this.m_model);
                    TaskHandler.this.m_model.addElements(list);
                    TaskHandler.this.postProcess(raptorTaskEvent, TaskHandler.this.m_model);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
            SBAddin.LOGGER.severe(executionException.getLocalizedMessage());
        }
        finally {
            this.enableComponent();
        }
    }
}

