/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.schemabrowser.view;

import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.controls.sqldialog.IObjectActionListener;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.BaseNavigatorController;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorController;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorManager;
import oracle.dbtools.raptor.navigator.NavActionListener;
import oracle.dbtools.raptor.schemabrowser.SchemaBrowserResources;
import oracle.dbtools.raptor.schemabrowser.model.SBSchema;
import oracle.dbtools.raptor.schemabrowser.model.SBType;
import oracle.dbtools.raptor.schemabrowser.view.PanelState;
import oracle.dbtools.raptor.schemabrowser.view.SBGui;
import oracle.dbtools.raptor.schemabrowser.view.SBWindow;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.objectpriv.PermissionRegistry;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.view.View;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

final class SBViewController
extends BaseNavigatorController
implements IObjectActionListener {
    private static final Controller NULL_CONTROLLER = new Controller(){

        public boolean handleEvent(IdeAction ideAction, Context context) {
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            return false;
        }
    };
    private static final String FILTER_DUMMY_CMD = "SchemaBrowser.FILTER_DUMMY";
    public static final int FILTER_DUMMY_ID = Ide.findOrCreateCmdID((String)"SchemaBrowser.FILTER_DUMMY");
    private static final String SCHEMA_FILTER_DUMMY_CMD = "SchemaBrowser.SCHEMA_FILTER_DUMMY";
    public static final int SCHEMA_FILTER_DUMMY_ID = Ide.findOrCreateCmdID((String)"SchemaBrowser.SCHEMA_FILTER_DUMMY");
    private static final String SCHEMA_FILTER_CMD = "SchemaBrowser.SCHEMA_FILTER";
    public static final int SCHEMA_FILTER_ID = Ide.findOrCreateCmdID((String)"SchemaBrowser.SCHEMA_FILTER");
    private static final String CLEAR_SCHEMA_FILTER_CMD = "SchemaBrowser.CLEAR_SCHEMA_FILTER";
    public static final int CLEAR_SCHEMA_FILTER_ID = Ide.findOrCreateCmdID((String)"SchemaBrowser.CLEAR_SCHEMA_FILTER");
    private static final String EDIT_BODY_CMD = "SchemaBrowser.EDIT_BODY";
    public static final int EDIT_BODY_ID = Ide.findOrCreateCmdID((String)"SchemaBrowser.EDIT_BODY");
    private static final String REOPEN_CMD = "SchemaBrowser.REOPEN_BROWSER";
    public static final int REOPEN_ID = Ide.findOrCreateCmdID((String)"SchemaBrowser.REOPEN_BROWSER");
    private SBWindow m_view;

    SBViewController(SBWindow sBWindow) {
        super(NULL_CONTROLLER);
        this.m_view = sBWindow;
        ObjectActionController.addListener((IObjectActionListener)this);
    }

    public boolean handleEvent(final IdeAction ideAction, Context context) {
        boolean bl = false;
        SBWindow sBWindow = (SBWindow)context.getView();
        SBGui sBGui = sBWindow.getViewComponent();
        PanelState panelState = sBGui.getPanelState();
        boolean bl2 = panelState == PanelState.OPEN;
        int n = ideAction.getCommandId();
        if (n == BaseNavigatorController.FILTER_CMD_ID) {
            if (bl2) {
                boolean bl3 = false;
                SBType sBType = sBGui.getSelectedType();
                bl3 = sBType.promptForFilter();
                if (bl3) {
                    View.updateToolbarActions((Toolbar)sBWindow.getToolbar());
                    IdeAction ideAction2 = IdeAction.find((int)51);
                    if (ideAction2 != null) {
                        this.handleEvent(ideAction2, context);
                    }
                }
            }
            bl = true;
        } else if (n == DatabaseNavigatorController.CLEAR_FILTER_CMD_ID) {
            if (bl2) {
                SBType sBType = sBGui.getSelectedType();
                sBType.clearFilter();
                View.updateToolbarActions((Toolbar)sBWindow.getToolbar());
                IdeAction ideAction3 = IdeAction.find((int)51);
                if (ideAction3 != null) {
                    this.handleEvent(ideAction3, context);
                }
            }
        } else if (n == SCHEMA_FILTER_ID) {
            if (bl2) {
                sBGui.promptForSchemaFilter();
            }
            bl = true;
        } else if (n == CLEAR_SCHEMA_FILTER_ID) {
            if (bl2) {
                sBGui.clearSchemaFilter();
            }
            bl = true;
        } else if (n == REOPEN_ID) {
            final String string = sBWindow.getConnectionName();
            ideAction.setEnabled(false);
            DatabaseQueryTask<Void> databaseQueryTask = new DatabaseQueryTask<Void>("Reopen", IRaptorTaskRunMode.MODAL, false, true){

                public String getConnectionName() {
                    return string;
                }

                public String getQuery() {
                    return null;
                }

                protected Void doWork() throws TaskException {
                    try {
                        Connections.getInstance().getConnection(string, true);
                    }
                    catch (DBException dBException) {
                        throw new TaskException((Throwable)dBException);
                    }
                    return null;
                }
            };
            databaseQueryTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                    ideAction.setEnabled(true);
                }

                public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                    ideAction.setEnabled(true);
                }

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    ideAction.setEnabled(true);
                }
            });
            RaptorTaskManager.getInstance().addTask((RaptorTask)databaseQueryTask);
            bl = true;
        }
        return bl || super.handleEvent(ideAction, context);
    }

    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = false;
        SBWindow sBWindow = (SBWindow)context.getView();
        SBGui sBGui = sBWindow.getViewComponent();
        PanelState panelState = sBGui.getPanelState();
        boolean bl2 = panelState == PanelState.OPEN;
        int n = ideAction.getCommandId();
        if (n == BaseNavigatorController.NEW_OJBECT_CMD_ID) {
            DBObject dBObject;
            boolean bl3 = false;
            if (bl2 && (dBObject = SBViewController.getObjectForType(sBGui.getSelectedType())) != null && PermissionRegistry.canCreate((DBObject)dBObject)) {
                DBEditorFactory dBEditorFactory;
                Database database;
                String string = dBObject.getObjectType();
                String string2 = dBObject.getConnectionName();
                if (!"SYNONYM".equals(string) && (database = BaseNavigatorController.getDatabase((String)string2)) != null && (dBEditorFactory = DBEditorFactoryRegistry.getCreateFactory((DBObjectProvider)database, (String)string)) != null && dBEditorFactory.canCreateDBObject(null, (DBObjectProvider)database, string)) {
                    SBViewController.updateAction((IdeAction)ideAction, (DBObject)dBObject, (Database)database, (String)string, (DBEditorFactory)dBEditorFactory);
                    ideAction.putValueDirectly("ObjectAction.CONN_NAME", (Object)string2);
                    bl3 = true;
                }
            }
            ideAction.putValueDirectly("SmallIcon", (Object)OracleIcons.getIcon((String)"add.png"));
            ideAction.setEnabled(bl3);
            bl = true;
        } else if (n == 51) {
            ideAction.setEnabled(bl2);
            bl = true;
        } else if (n == FILTER_DUMMY_ID) {
            boolean bl4 = false;
            String string = SchemaBrowserResources.getString("FILTER_DUMMY_LABEL");
            if (bl2) {
                SBType sBType = sBGui.getSelectedType();
                DBObject dBObject = SBViewController.getObjectForType(sBType);
                if (dBObject != null && (dBObject.isOracle() || dBObject.isTimesTen())) {
                    bl4 = sBType.canHaveFilter();
                }
                string = SchemaBrowserResources.format("FILTER_LABEL_TEMPLATE", sBType.getShortLabel());
            }
            SBViewController.updateAction(ideAction, bl4, string);
            bl = true;
        } else if (n == SCHEMA_FILTER_DUMMY_ID) {
            boolean bl5 = false;
            if (bl2) {
                String string = sBGui.getConnectionName();
                Connections connections = Connections.getInstance();
                bl5 = connections.isOracle(string) || connections.isTimesTen(string);
            }
            ideAction.setEnabled(bl5);
            bl = true;
        } else if (n == BaseNavigatorController.FILTER_CMD_ID) {
            if (bl2) {
                SBType sBType = sBGui.getSelectedType();
                DBObject dBObject = SBViewController.getObjectForType(sBType);
                SBViewController.updateFilterAction(ideAction, dBObject, sBType);
            } else {
                SBViewController.updateAction(ideAction, false, "Filter");
            }
            bl = true;
        } else if (n == DatabaseNavigatorController.CLEAR_FILTER_CMD_ID) {
            if (bl2) {
                SBType sBType = sBGui.getSelectedType();
                SBViewController.updateClearFilterAction(ideAction, sBType);
            } else {
                SBViewController.updateAction(ideAction, false, "Clear");
            }
            bl = true;
        } else if (n == SCHEMA_FILTER_ID) {
            boolean bl6 = false;
            if (bl2) {
                SBSchema sBSchema = sBGui.getSelectedSchema();
                bl6 = sBSchema.canHaveFilter();
            }
            ideAction.setEnabled(bl6);
            bl = true;
        } else if (n == CLEAR_SCHEMA_FILTER_ID) {
            boolean bl7 = false;
            if (bl2) {
                SBSchema sBSchema = sBGui.getSelectedSchema();
                bl7 = sBSchema.isFiltered();
            }
            ideAction.setEnabled(bl7);
            bl = true;
        }
        return bl || super.update(ideAction, context);
    }

    static void updateClearFilterAction(IdeAction ideAction, SBType sBType) {
        boolean bl = sBType.isFiltered();
        String string = SchemaBrowserResources.format("CLEAR_FILTER_TEMPLATE", sBType.getShortLabel());
        SBViewController.updateAction(ideAction, bl, string);
    }

    static void updateFilterAction(IdeAction ideAction, DBObject dBObject, SBType sBType) {
        boolean bl = false;
        if (dBObject != null && (dBObject.isOracle() || dBObject.isTimesTen())) {
            bl = sBType.canHaveFilter();
        }
        String string = SchemaBrowserResources.format("FILTER_LABEL_TEMPLATE", sBType.getShortLabel());
        SBViewController.updateAction(ideAction, bl, string);
    }

    static void updateAction(IdeAction ideAction, boolean bl, String string) {
        ideAction.setEnabled(bl);
        ideAction.putValueDirectly("Name", (Object)StringUtils.stripMnemonic((String)string));
        ideAction.putValueDirectly("MnemonicKey", (Object)StringUtils.getMnemonicKeyCode((String)string));
    }

    protected BaseNavigatorController.ProviderAdapter getProviderListener(Database database, Context context) {
        return new BaseNavigatorController.ProviderAdapter(database, context){

            protected void schemaObjectsAddedImpl(SchemaObject[] schemaObjectArray) {
                Context context = this.getContext();
                URL uRL = null;
                DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
                DBObject dBObject2 = new DBObject(dBObject.getURL());
                uRL = dBObject.getURL();
                NavigatorManager navigatorManager = DatabaseNavigatorManager.getInstance();
                NavigatorWindow navigatorWindow = navigatorManager.getNavigatorWindow();
                TreeExplorer treeExplorer = navigatorWindow.getTreeExplorer();
                DefaultTreeModel defaultTreeModel = treeExplorer.getTreeModel();
                TNode tNode = this.findTNode(defaultTreeModel, dBObject.getURL());
                if (tNode != null) {
                    dBObject2.setNode((Node)tNode.getData());
                    NavActionListener navActionListener = new NavActionListener(DatabaseNavigatorManager.getInstance());
                    navActionListener.reload(dBObject.getConnectionName(), new MenuActionWrapper().getObjectAction(), null, null, dBObject2);
                }
            }

            private TNode findTNode(DefaultTreeModel defaultTreeModel, URL uRL) {
                if (defaultTreeModel != null) {
                    return this.findTTree(defaultTreeModel, defaultTreeModel.getRoot(), uRL);
                }
                return null;
            }

            private TNode findTTree(DefaultTreeModel defaultTreeModel, Object object, URL uRL) {
                if (defaultTreeModel != null && object != null && uRL != null) {
                    Element element = null;
                    Object object2 = null;
                    URL uRL2 = null;
                    TNode tNode = null;
                    if (object instanceof TNode) {
                        tNode = (TNode)object;
                        element = tNode.getData();
                        object2 = element.getData();
                    }
                    if (element instanceof Locatable) {
                        uRL2 = ((Locatable)element).getURL();
                    }
                    if (uRL2 != null && uRL.equals(uRL2)) {
                        return tNode;
                    }
                    for (int i = 0; i < defaultTreeModel.getChildCount(object); ++i) {
                        Object object3 = defaultTreeModel.getChild(object, i);
                        tNode = this.findTTree(defaultTreeModel, object3, uRL);
                        if (tNode == null) continue;
                        return tNode;
                    }
                }
                return null;
            }
        };
    }

    public void refreshNode(Context context) {
    }

    public void refreshParent(Context context) {
        View view = context.getView();
        if (view instanceof SBWindow) {
            SBGui sBGui = ((SBWindow)view).getViewComponent();
            sBGui.refresh();
        }
    }

    public void notify(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
    }

    public void reload(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
        SBGui sBGui;
        String string2 = dBObject.getObjectType();
        if (string2 != null && string2.endsWith("_FOLDER") && (sBGui = this.checkGui(string)) != null) {
            sBGui.refresh(dBObject.getSchemaName(), dBObject.getObjectFolderType());
        }
    }

    public void reloadParent(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
        SBGui sBGui = this.checkGui(string);
        if (sBGui != null) {
            sBGui.refresh(dBObject.getSchemaName(), dBObject.getObjectType());
        }
    }

    public void removedFromParent(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
        this.reloadParent(string, objectAction, map, list, dBObject);
    }

    private SBGui checkGui(String string) {
        SBGui sBGui = this.m_view.getViewComponent();
        if (sBGui != null && ModelUtil.areDifferent((Object)string, (Object)sBGui.getConnectionName())) {
            sBGui = null;
        }
        return sBGui;
    }

    private static DBObject getObjectForType(SBType sBType) {
        return sBType != null ? new DBObject(sBType.getURL()) : null;
    }

    private static class MenuActionWrapper
    extends AbstractMenuAction {
        public MenuActionWrapper() {
            ObjectAction objectAction = new ObjectAction();
            objectAction.setReloadParent(false);
            objectAction.setReload(true);
            this.setObjectAction(objectAction);
        }

        public void launch() {
        }
    }
}

