/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.schemabrowser.model;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.model.DBCatalogInstance;
import oracle.dbtools.raptor.navigator.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.model.DBSchemasInstance;
import oracle.dbtools.raptor.schemabrowser.model.SBSchema;
import oracle.dbtools.raptor.schemabrowser.model.SBSearchCategory;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.model.Displayable;
import oracle.javatools.db.DBException;
import oracle.javatools.util.ModelUtil;

public class SBModel {
    private static final String NONTREE_UI_KEY = "NONTREE_UI";
    private static final String SB_PROTOCOL = "sqldev.sb";
    private static final String PROTOCOL_KEY = "PROTOCOL";
    private String m_connName;
    private String m_catalogName;
    private ObjectFactory m_factory;
    private DBSchemasInstance m_schemas;
    private SBSchema m_defaultSchema;
    private SortedMap<String, SBSchema> m_schemaModel = new TreeMap<String, SBSchema>();
    private boolean m_schemasLoaded = false;
    private String m_filterValue;
    private SBSearchCategory m_filterType;

    public SBModel(String string, String string2) throws TaskException {
        this.init(string, string2);
    }

    void init(String string, String string2) throws TaskException {
        try {
            this.m_connName = string;
            this.m_catalogName = string2;
            Connection connection = Connections.getInstance().getConnection(string);
            this.m_factory = ObjectFactory.getFactory((String)string, (Connection)connection);
            if (this.m_factory.isSupportsCatalog()) {
                DBCatalogInstance dBCatalogInstance = this.m_factory.createCatalogInstance(this.m_catalogName);
                this.m_schemas = SBModel.createSchemasInstance(this.m_factory, dBCatalogInstance);
            } else {
                this.m_schemas = SBModel.createSchemasInstance(this.m_factory, null);
                if (!this.m_factory.isShowAllSchemasAtTopLevel()) {
                    String string3 = this.m_factory.getSchema();
                    DBSchemaInstance dBSchemaInstance = this.m_factory.createSchemaInstance(string3);
                    SBSchema sBSchema = this.createSchema(dBSchemaInstance);
                    this.m_schemaModel.put(sBSchema.getSchemaName(), sBSchema);
                    this.m_defaultSchema = sBSchema;
                }
            }
        }
        catch (DBException dBException) {
            throw new TaskException((Throwable)dBException);
        }
    }

    private static DBSchemasInstance createSchemasInstance(ObjectFactory objectFactory, DBCatalogInstance dBCatalogInstance) {
        DBSchemasInstance dBSchemasInstance = objectFactory.getSchemasInstance(dBCatalogInstance);
        dBSchemasInstance.setProperty(PROTOCOL_KEY, (Object)SB_PROTOCOL);
        return dBSchemasInstance;
    }

    private SBSchema createSchema(DBSchemaInstance dBSchemaInstance) {
        if (dBSchemaInstance.getProperty("ConnectionName") == null) {
            dBSchemaInstance.setProperty("ConnectionName", (Object)this.m_connName);
        }
        dBSchemaInstance.setProperty(PROTOCOL_KEY, (Object)SB_PROTOCOL);
        dBSchemaInstance.setProperty(NONTREE_UI_KEY, (Object)true);
        return new SBSchema(dBSchemaInstance);
    }

    public String getConnectionName() {
        return this.m_connName;
    }

    public String getCatalog() {
        return this.m_catalogName;
    }

    public Collection<SBSchema> getSchemas() throws TaskException {
        if (!this.m_schemasLoaded) {
            ArrayList<SBSchema> arrayList = new ArrayList<SBSchema>();
            try {
                for (DBChildInstance object : this.m_schemas.listChildren()) {
                    SBSchema sBSchema = this.createSchema((DBSchemaInstance)object);
                    if (!ModelUtil.areDifferent((Object)this.m_defaultSchema, (Object)sBSchema)) continue;
                    arrayList.add(sBSchema);
                }
            }
            catch (SQLException sQLException) {
                throw new TaskException((Throwable)sQLException);
            }
            catch (AbortException abortException) {
                arrayList.clear();
            }
            for (SBSchema sBSchema : arrayList) {
                this.m_schemaModel.put(sBSchema.getSchemaName(), sBSchema);
            }
            if (this.m_defaultSchema == null && this.m_schemaModel.size() > 0) {
                String string = this.m_schemaModel.firstKey();
                this.m_defaultSchema = (SBSchema)this.m_schemaModel.get(string);
            }
        }
        return new FilteredCollection<SBSchema>(this.m_schemaModel.values());
    }

    public SBSchema getDefaultSchema() {
        return this.m_defaultSchema;
    }

    public SBSchema getSchema(String string) {
        SBSchema sBSchema = (SBSchema)this.m_schemaModel.get(string);
        if (sBSchema == null && "PUBLIC".equals(string)) {
            sBSchema = this.m_defaultSchema;
        }
        return sBSchema;
    }

    public void setSchemaFilterType(SBSearchCategory sBSearchCategory) {
        this.m_filterType = sBSearchCategory;
    }

    public SBSearchCategory getSchemaFilterType() {
        return this.m_filterType;
    }

    public boolean isSchemaListFiltered() {
        return this.m_filterType != null && ModelUtil.hasLength((String)this.m_filterValue);
    }

    public void setSchemaFilterValue(String string) {
        this.m_filterValue = string;
    }

    public String getSchemaFilterValue() {
        return this.m_filterValue;
    }

    private class FilteredCollection<T extends Displayable>
    extends AbstractCollection<T> {
        List<T> m_data = new ArrayList<T>();

        FilteredCollection(Collection<T> collection) {
            if (SBModel.this.m_filterType != null && SBModel.this.m_filterValue != null) {
                for (Displayable displayable : collection) {
                    if (!SBModel.this.m_filterType.match(SBModel.this.m_filterValue, displayable)) continue;
                    this.m_data.add(displayable);
                }
            } else {
                this.m_data.addAll(collection);
            }
        }

        @Override
        public Iterator<T> iterator() {
            return this.m_data.iterator();
        }

        @Override
        public int size() {
            return this.m_data.size();
        }
    }
}

