/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.viewBuilder;

import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.tableComponent.TableComponent;
import oracle.bali.dbUI.viewBuilder.TableViewBuilderComponent;
import oracle.bali.dbUI.viewBuilder.ViewBuilderComponent;
import oracle.bali.dbUI.viewBuilder.ViewBuilderLinkPort;

public class ColumnLinkPort
implements ViewBuilderLinkPort {
    private TableViewBuilderComponent _component;
    private PropertyChangeSupport _support;
    private int _x;
    private int _y;
    private int _width;
    private int _height;
    private TableComponent _tableComponent;
    private Column _column;
    private PropertyChangeListener _listener;

    public ColumnLinkPort(TableViewBuilderComponent component, TableComponent table, Column column) {
        if (component == null || table == null || column == null) {
            throw new IllegalArgumentException();
        }
        this._listener = new Updater();
        this._tableComponent = table;
        this._tableComponent.addPropertyChangeListener(this._listener);
        this._component = component;
        this._component.addPropertyChangeListener(this._listener);
        this._column = column;
    }

    public ViewBuilderComponent getViewBuilderComponent() {
        return this._component;
    }

    public Column getColumn() {
        return this._column;
    }

    public TableComponent getTableComponent() {
        return this._tableComponent;
    }

    public void setHighlighted(boolean highlighted) {
        this.getTableComponent().setColumnHighlighted(this.getColumn(), highlighted);
    }

    public Rectangle getBounds() {
        if (this._width == 0 || this._height == 0) {
            this._calculateBounds();
        }
        return new Rectangle(this._x, this._y, this._width, this._height);
    }

    public void setBounds(int x, int y, int width, int height) {
        if (this._x != x || this._y != y || this._width != width || this._height != height) {
            Rectangle oldBounds = new Rectangle(this._x, this._y, this._width, this._height);
            this._x = x;
            this._y = y;
            this._width = width;
            this._height = height;
            Rectangle newBounds = new Rectangle(this._x, this._y, this._width, this._height);
            this.firePropertyChange("bounds", oldBounds, newBounds);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this._support == null) {
            this._support = new PropertyChangeSupport(this);
        }
        this._support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this._support != null) {
            this._support.removePropertyChangeListener(l);
        }
    }

    public void cleanup() {
        this._tableComponent.removePropertyChangeListener(this._listener);
        this._component.removePropertyChangeListener(this._listener);
        this._listener = null;
        this._component = null;
        this._tableComponent = null;
        this._column = null;
    }

    public void invalidate() {
        this._calculateBounds();
    }

    public TableViewBuilderComponent getTableViewBuilderComponent() {
        return this._component;
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this._support != null) {
            this._support.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    private void _calculateBounds() {
        int height;
        Rectangle bounds = this.getViewBuilderComponent().getComponentBounds();
        int y = 0;
        if (this.getTableComponent().isShowing()) {
            y = this.getTableComponent().getColumnLocation(this.getColumn()) + this.getTableViewBuilderComponent().getTableComponentLocation().y;
        }
        if (y + (height = this.getTableComponent().getSpreadTable().getDefaultRowHeight()) > bounds.height) {
            y = bounds.height - height;
        }
        this.setBounds(0, y, bounds.width, height);
    }

    private class Updater
    implements PropertyChangeListener {
        private Updater() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if ("columnLocation".equals(name)) {
                ColumnLinkPort.this._calculateBounds();
            } else if ("bounds".equals(name)) {
                ColumnLinkPort.this._calculateBounds();
            }
        }
    }
}

