/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.schemaViewer;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.Database;
import oracle.bali.dbUI.db.DynamicColumn;
import oracle.bali.dbUI.db.DynamicTable;
import oracle.bali.dbUI.db.Schema;
import oracle.bali.dbUI.db.Table;
import oracle.bali.dbUI.db.event.DynamicTableEvent;
import oracle.bali.dbUI.db.event.DynamicTableListener;
import oracle.bali.dbUI.laf.DBUILookAndFeel;
import oracle.bali.dbUI.schemaViewer.SchemaViewerEvent;
import oracle.bali.dbUI.schemaViewer.SchemaViewerListener;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeButtonDecoration;
import oracle.bali.ewt.dTree.DTreeDecoration;
import oracle.bali.ewt.dTree.DTreeDeferredChild;
import oracle.bali.ewt.dTree.DTreeDeferredParent;
import oracle.bali.ewt.dTree.DTreeDeferringParent;
import oracle.bali.ewt.dTree.DTreeDeferringRoot;
import oracle.bali.ewt.dTree.DTreeDragSource;
import oracle.bali.ewt.dTree.DTreeDragSupport;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeItemFactory;
import oracle.bali.ewt.dTree.DTreeLineDecoration;
import oracle.bali.ewt.dTree.DTreeRootItem;
import oracle.bali.ewt.dTree.DTreeStackingDecoration;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.share.datatransfer.ObjectTransferable;
import oracle.bali.share.event.ListenerManager;

public class SchemaViewer
extends LWComponent
implements Accessible {
    private static final String _KEY_DATABASE = "SCHEMAVIEWER.DATABASE";
    private static final String _KEY_SCHEMA = "SCHEMAVIEWER.SCHEMA";
    private static final String _KEY_TABLE = "SCHEMAVIEWER.TABLE";
    private static final String _KEY_COLUMN = "SCHEMAVIEWER.COLUMN";
    private static final String _ACCESS_BUNDLE = "oracle.bali.dbUI.resource.AccessibleBundle";
    private DTree _tree = new DTree();
    private JScrollPane _scrollBox;
    private Database _database;
    private ListenerManager _listeners;
    private DTreeDragSupport _dragSupport;

    public SchemaViewer() {
        this(null);
    }

    public SchemaViewer(Database database) {
        DTreeButtonDecoration buttons = new DTreeButtonDecoration();
        DTreeLineDecoration lines = new DTreeLineDecoration();
        DTreeStackingDecoration stack = new DTreeStackingDecoration((DTreeDecoration)lines, (DTreeDecoration)buttons);
        this._tree.setDecoration((DTreeDecoration)stack);
        this._dragSupport = new DTreeDragSupport(this._tree);
        JScrollPane treeBox = new JScrollPane((Component)this._tree);
        this.setLayout(new BorderLayout());
        this.add("Center", treeBox);
        this._scrollBox = treeBox;
        this.setDatabase(database);
    }

    public void enableJDKDnD() {
        this._dragSupport.enableJDKDnD();
    }

    public void setDatabase(Database database) {
        this._database = database;
        Object[] name = new String[]{"Schemas"};
        ArrayOneDModel ds = new ArrayOneDModel(name);
        DTreeItemFactory factory = new DTreeItemFactory(){

            public DTreeItem createItem(DTreeDeferringParent parent, int index) {
                return new SchemaRoot(SchemaViewer.this.getDatabase());
            }
        };
        DTreeDeferringRoot root = new DTreeDeferringRoot(null, null, (OneDModel)ds, factory);
        this._tree.setRoot((DTreeRootItem)root);
    }

    public Database getDatabase() {
        return this._database;
    }

    public void addSchemaViewerListener(SchemaViewerListener l) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)l);
    }

    public void removeSchemaViewerListener(SchemaViewerListener l) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)l);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._scrollBox.setEnabled(enabled);
        this._tree.setEnabled(enabled);
    }

    public Locale getLocale() {
        if (this.isDisplayable()) {
            return super.getLocale();
        }
        return Locale.getDefault();
    }

    protected void fireTableActivateEvent(Table table) {
        int id = 2000;
        SchemaViewerEvent e = new SchemaViewerEvent(this, id, table);
        this.processEvent(e);
    }

    protected void fireColumnActivateEvent(Column column) {
        int id = 2001;
        SchemaViewerEvent e = new SchemaViewerEvent(this, id, column);
        this.processEvent(e);
    }

    protected Icon getIcon(Schema schema) {
        return null;
    }

    protected Icon getIcon(Table table) {
        return null;
    }

    protected Icon getIcon(Column column) {
        return null;
    }

    protected void processEventImpl(AWTEvent e) {
        if (e instanceof SchemaViewerEvent) {
            this.processSchemaViewerEvent((SchemaViewerEvent)e);
        } else {
            super.processEventImpl(e);
        }
    }

    protected void processSchemaViewerEvent(SchemaViewerEvent e) {
        if (this._listeners == null) {
            return;
        }
        Enumeration enumer = this._listeners.getListeners();
        if (enumer == null) {
            return;
        }
        int id = e.getID();
        switch (id) {
            case 2001: {
                while (enumer.hasMoreElements()) {
                    ((SchemaViewerListener)enumer.nextElement()).columnActivated(e);
                }
                break;
            }
            case 2000: {
                while (enumer.hasMoreElements()) {
                    ((SchemaViewerListener)enumer.nextElement()).tableActivated(e);
                }
                break;
            }
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSchemaViewer();
        }
        return this.accessibleContext;
    }

    private class ColumnItem
    extends DTreeDeferredChild
    implements DTreeDragSource,
    PropertyChangeListener {
        private Transferable _transfer;
        private Column _column;
        private Icon _icon;

        public ColumnItem(Column column) {
            this._column = column;
            if (this._column instanceof DynamicColumn) {
                ((DynamicColumn)column).addPropertyChangeListener(this);
            }
            this._icon = SchemaViewer.this.getIcon(this._column);
        }

        public String getAccessibleType() {
            ResourceBundle b = ResourceBundle.getBundle(SchemaViewer._ACCESS_BUNDLE, SchemaViewer.this.getLocale());
            return b.getString(SchemaViewer._KEY_COLUMN);
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if ("name".equals(name)) {
                SchemaViewer.this.repaint();
            } else if ("dataType".equals(name)) {
                this._icon = SchemaViewer.this.getIcon(this._column);
                SchemaViewer.this.repaint();
            }
        }

        public Icon getIcon() {
            return this._icon;
        }

        public String getLabel() {
            return this._column.getDisplayName(SchemaViewer.this.getLocale());
        }

        public DTreeDragSource getDragSource() {
            return this;
        }

        public int getSourceActions(DTreeItem item) {
            return 2;
        }

        public Transferable getTransferable(DTreeItem item) {
            if (this._transfer == null) {
                this._transfer = ObjectTransferable.createTransferable((Object)this._column);
            }
            return this._transfer;
        }

        public void dragDropEnd(DTreeItem item, int dropAction) {
        }

        public void activate() {
            super.activate();
            SchemaViewer.this.fireColumnActivateEvent(this._column);
        }

        protected void mousePressed(MouseEvent e) {
            if (e.getClickCount() == 2) {
                SchemaViewer.this.fireColumnActivateEvent(this._column);
            } else {
                super.mousePressed(e);
            }
        }

        protected void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                SchemaViewer.this.fireColumnActivateEvent(this._column);
            } else {
                super.keyPressed(e);
            }
        }
    }

    private class TableItem
    extends BaseParent
    implements DTreeDragSource,
    DTreeItemFactory,
    PropertyChangeListener,
    DynamicTableListener {
        private Transferable _transfer;
        private Table _table;
        private Icon _icon;

        public TableItem(Table table) {
            super(null);
            this._table = table;
            this._icon = SchemaViewer.this.getIcon(this._table);
            if (this._table instanceof DynamicTable) {
                DynamicTable d = (DynamicTable)this._table;
                d.addPropertyChangeListener(this);
                d.addTableListener(this);
            }
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if ("name".equals(name) || "displayName".equals(name)) {
                SchemaViewer.this.repaint();
            }
        }

        public String getAccessibleType() {
            ResourceBundle b = ResourceBundle.getBundle(SchemaViewer._ACCESS_BUNDLE, SchemaViewer.this.getLocale());
            return b.getString(SchemaViewer._KEY_TABLE);
        }

        public void columnAdded(DynamicTableEvent e) {
            System.out.println("todo: SchemaViewer.update table " + e.getTable().getName() + " and add column " + e.getColumn().getName());
        }

        public void columnRemoved(DynamicTableEvent e) {
            System.out.println("todo: SchemaViewer.update table " + e.getTable().getName() + " and remove column " + e.getColumn().getName());
        }

        public void primaryKeyAdded(DynamicTableEvent e) {
        }

        public void primaryKeyRemoved(DynamicTableEvent e) {
        }

        public void foreignKeyAdded(DynamicTableEvent e) {
        }

        public void foreignKeyRemoved(DynamicTableEvent e) {
        }

        public void uniqueKeyAdded(DynamicTableEvent e) {
        }

        public void uniqueKeyRemoved(DynamicTableEvent e) {
        }

        public Icon getIcon() {
            return this._icon;
        }

        public Object getChildData(int index) {
            return this._table.getColumnDisplayName(index, SchemaViewer.this.getLocale());
        }

        protected void initChilderen() {
            this._table.getColumnCount();
        }

        public int getChildCount() {
            return this._table.getColumnCount();
        }

        public DTreeItemFactory getItemFactory() {
            return this;
        }

        public DTreeItem createItem(DTreeDeferringParent parent, int index) {
            return new ColumnItem(this._table.getColumn(index));
        }

        public String getLabel() {
            return this._table.getDisplayName(SchemaViewer.this.getLocale());
        }

        public DTreeDragSource getDragSource() {
            return this;
        }

        public int getSourceActions(DTreeItem item) {
            return 2;
        }

        public Transferable getTransferable(DTreeItem item) {
            if (this._transfer == null) {
                this._transfer = ObjectTransferable.createTransferable((Object)this._table);
            }
            return this._transfer;
        }

        public void dragDropEnd(DTreeItem item, int dropAction) {
        }

        protected void mousePressed(MouseEvent e) {
            if (e.getClickCount() == 2) {
                e.consume();
                SchemaViewer.this.fireTableActivateEvent(this._table);
            } else {
                super.mousePressed(e);
            }
        }

        protected void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                e.consume();
                SchemaViewer.this.fireTableActivateEvent(this._table);
            } else {
                super.keyPressed(e);
            }
        }

        public void activate() {
            super.activate();
            SchemaViewer.this.fireTableActivateEvent(this._table);
        }
    }

    private class SchemaItem
    extends BaseParent
    implements DTreeItemFactory {
        private Icon _icon;
        private Schema _schema;

        public SchemaItem(Schema schema) {
            super(null);
            this._icon = SchemaViewer.this.getIcon(schema);
            this._schema = schema;
        }

        public Object getChildData(int index) {
            return this._schema.getTableDisplayName(index, SchemaViewer.this.getLocale());
        }

        public String getAccessibleType() {
            ResourceBundle b = ResourceBundle.getBundle(SchemaViewer._ACCESS_BUNDLE, SchemaViewer.this.getLocale());
            return b.getString(SchemaViewer._KEY_SCHEMA);
        }

        protected void initChilderen() {
            this._schema.getTableCount();
        }

        public int getChildCount() {
            return this._schema.getTableCount();
        }

        public DTreeItemFactory getItemFactory() {
            return this;
        }

        public DTreeItem createItem(DTreeDeferringParent parent, int index) {
            return new TableItem(this._schema.getTable(index));
        }

        public Icon getIcon() {
            return this._icon;
        }

        public String getLabel() {
            return this._schema.getDisplayName(SchemaViewer.this.getLocale());
        }
    }

    private class SchemaRoot
    extends BaseParent
    implements DTreeItemFactory {
        private Database _database;

        public SchemaRoot(Database database) {
            super(null);
            this._database = database;
        }

        public String getAccessibleType() {
            ResourceBundle b = ResourceBundle.getBundle(SchemaViewer._ACCESS_BUNDLE, SchemaViewer.this.getLocale());
            return b.getString(SchemaViewer._KEY_DATABASE);
        }

        public DTreeItemFactory getItemFactory() {
            return this;
        }

        public Object getChildData(int index) {
            return this._database == null ? null : this._database.getSchemaDisplayName(index, SchemaViewer.this.getLocale());
        }

        protected void initChilderen() {
            if (this._database != null) {
                this._database.getSchemaCount();
            }
        }

        protected int getChildCount() {
            return this._database == null ? 0 : this._database.getSchemaCount();
        }

        public DTreeItem createItem(DTreeDeferringParent parent, int index) {
            return new SchemaItem(this._database.getSchema(index));
        }

        public Icon getIcon() {
            return null;
        }

        public String getLabel() {
            return this._database == null ? null : this._database.getDisplayName(SchemaViewer.this.getLocale());
        }
    }

    private abstract class BaseParent
    extends DTreeDeferredParent {
        private boolean _childerenInited;

        public BaseParent(OneDModel model) {
            super(model);
        }

        public boolean isExpandable() {
            if (!this._childerenInited) {
                return true;
            }
            return super.isExpandable();
        }

        public int getItemCount() {
            if (!this._childerenInited) {
                DBUILookAndFeel.getLookAndFeel().setCursor((Component)((Object)SchemaViewer.this), true);
                this.initChilderen();
                DBUILookAndFeel.getLookAndFeel().setCursor((Component)((Object)SchemaViewer.this), false);
                this._childerenInited = true;
            }
            return this.getChildCount();
        }

        protected void initChilderen() {
        }

        protected abstract int getChildCount();
    }

    private class AccessibleSchemaViewer
    extends JComponent.AccessibleJComponent {
        public AccessibleSchemaViewer() {
            super((JComponent)((Object)SchemaViewer.this));
            SchemaViewer.this._tree.getAccessibleContext().setAccessibleParent(SchemaViewer.this);
        }

        public int getAccessibleChildrenCount() {
            return 1;
        }

        public Accessible getAccessibleChild(int i) {
            if (i < 0 || i >= this.getAccessibleChildrenCount()) {
                return null;
            }
            return SchemaViewer.this._tree;
        }
    }
}

