/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph;

import oracle.bali.dbUI.graph.Data;
import oracle.bali.dbUI.graph.Node;
import oracle.bali.dbUI.graph.NodeDataSource;
import oracle.bali.dbUI.graph.Port;

final class ChildNodeDataSource
extends Data {
    private Node _node;
    private int _portCount;
    private int[] _indicies;
    private boolean _expanded = true;
    private NodeDataSource _parent;
    private Data[] _children;
    private Data[] _sortedChildren;

    public ChildNodeDataSource(NodeDataSource parent, Node node, int depth) {
        super(node, parent.getLocale(), depth);
        this._parent = parent;
        this.setNode(node);
    }

    public void dispose() {
        super.dispose();
        if (this._node == null) {
            return;
        }
        this._node = null;
        this._indicies = null;
        this._parent = null;
        this._children = null;
        this._sortedChildren = null;
    }

    public Node getNode() {
        return this._node;
    }

    public Port getPort(int i) {
        if (this._indicies != null) {
            i = this._indicies[i];
        }
        return this.getNode().getPort(i);
    }

    public void setNode(Node node) {
        this._node = node;
        this._portCount = NodeDataSource.getPortCount(node);
        this._calculateIndicies();
    }

    public void setSortedChildren(Data[] children) {
        if (this.isExpanded()) {
            this._sortedChildren = children;
        } else {
            this._children = children;
        }
    }

    public Data[] getSortedChildren() {
        return this._sortedChildren;
    }

    public boolean isExpanded() {
        return this._expanded;
    }

    public void setExpanded(boolean expanded, Data[] children) {
        this._expanded = expanded;
        this._children = children;
    }

    public Data[] getChildren() {
        return this._children;
    }

    public boolean hasChildren() {
        return this.getPortCount() > 0;
    }

    public int getPortCount() {
        return this._portCount;
    }

    public void updatePortCount(int count) {
        this._portCount += count;
    }

    private void _calculateIndicies() {
        this._indicies = this._parent.__calculateSortedIndicies(this.getNode());
    }
}

