/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintBuilder;

import java.awt.image.RGBImageFilter;

class TruncateFilter
extends RGBImageFilter {
    private int _width;
    private int _height;
    private int _quarter;
    private int _half;
    private int _threeQuarter;

    public TruncateFilter(int width, int height) {
        this.canFilterIndexColorModel = false;
        this._width = width;
        this._height = height;
        this._quarter = this._height / 4;
        this._half = this._quarter * 2;
        this._threeQuarter = this._half + this._quarter;
    }

    public int filterRGB(int x, int y, int rgb) {
        int alpha = rgb & 0xFF000000;
        rgb &= 0xFFFFFF;
        if (y > this._threeQuarter) {
            y = this._height - y;
        } else if (y > this._half) {
            y -= this._half;
        } else if (y > this._quarter) {
            y = this._half - y;
        }
        int left = this._width - x - 1;
        double right = y / 2;
        if ((double)left < right) {
            alpha = 0;
        } else if ((double)(left - 1) < right) {
            alpha = -16777216;
            rgb = 0;
        }
        return alpha | rgb;
    }
}

