/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintBuilder;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import oracle.bali.dbUI.constraintBuilder.CBCompArray;
import oracle.bali.dbUI.constraintBuilder.ConstraintBuilderComp;
import oracle.bali.dbUI.constraintBuilder.ParentComponent;
import oracle.bali.dbUI.constraintComponent.ConstraintComponent;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.dbUI.dnd.DBUIDataFlavors;
import oracle.bali.ewt.LWComponent;

class PCJDKDropSupport
implements DropTargetListener {
    private ParentComponent _parent;

    public PCJDKDropSupport(ParentComponent parent) {
        this._parent = parent;
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        if (this._acceptDrag(dtde)) {
            Point p = dtde.getLocation();
            Component comp = dtde.getDropTargetContext().getComponent();
            Point offset = this._getOffset(comp);
            this._parent.calculateFeedback(offset.x + p.x, offset.y + p.y);
        } else {
            dtde.rejectDrag();
        }
    }

    public void dragOver(DropTargetDragEvent dtde) {
        if (this._acceptDrag(dtde)) {
            Point p = dtde.getLocation();
            Component comp = dtde.getDropTargetContext().getComponent();
            Point offset = this._getOffset(comp);
            this._parent.calculateFeedback(offset.x + p.x, offset.y + p.y);
        } else {
            this._parent.calculateFeedback(-1, -1);
            dtde.rejectDrag();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dtde) {
        this._parent.calculateFeedback(-1, -1);
    }

    public void drop(DropTargetDropEvent dtde) {
        this._parent.calculateFeedback(-1, -1);
        DropTargetContext context = dtde.getDropTargetContext();
        if (!this._acceptDrop(dtde)) {
            context.dropComplete(false);
            return;
        }
        dtde.acceptDrop(2);
        Transferable transfer = dtde.getTransferable();
        Point p = dtde.getLocation();
        Component comp = dtde.getDropTargetContext().getComponent();
        Point offset = this._getOffset(comp);
        int index = this._parent.getInsertIndex(offset.y + p.y);
        Object data = null;
        if (transfer.isDataFlavorSupported(DBUIDataFlavors.DATA_DESCRIPTOR_FLAVOR)) {
            DataDescriptor dd;
            try {
                data = transfer.getTransferData(DBUIDataFlavors.DATA_DESCRIPTOR_FLAVOR);
            }
            catch (IOException ioe) {
                data = null;
            }
            catch (UnsupportedFlavorException ufe) {
                data = null;
            }
            if (data instanceof DataDescriptor && (dd = (DataDescriptor)data) != null) {
                context.dropComplete(true);
                ConstraintComponent cc = this._parent.getConstraintBuilder().createConstraintComponent(dd);
                this._parent.getConstraintBuilder().dropConstraintComponent(cc, this._parent, index);
            }
        }
        if (data == null && transfer.isDataFlavorSupported(DBUIDataFlavors.CONSTRAINT_COMPONENT_FLAVOR)) {
            try {
                data = transfer.getTransferData(DBUIDataFlavors.CONSTRAINT_COMPONENT_FLAVOR);
            }
            catch (IOException ioe) {
                data = null;
            }
            catch (UnsupportedFlavorException ufe) {
                data = null;
            }
            if (data instanceof ConstraintComponent) {
                ConstraintComponent cc = (ConstraintComponent)data;
                if (cc != null) {
                    this._parent.getConstraintBuilder().dropConstraintComponent(cc, this._parent, index);
                }
                context.dropComplete(cc != null);
                return;
            }
        }
        if (data == null && transfer.isDataFlavorSupported(CBCompArray.CB_COMP_ARRAY_FLAVOR)) {
            ConstraintBuilderComp[] array;
            try {
                data = transfer.getTransferData(CBCompArray.CB_COMP_ARRAY_FLAVOR);
            }
            catch (IOException ioe) {
                data = null;
            }
            catch (UnsupportedFlavorException ufe) {
                data = null;
            }
            if (data instanceof CBCompArray && (array = ((CBCompArray)data).getData()) != null) {
                for (int i = 0; i < array.length; ++i) {
                    if (array[i] != this._parent) continue;
                    context.dropComplete(true);
                    return;
                }
                this._parent.getConstraintBuilder().dropConstraintBuilderComp(array, this._parent, index);
                context.dropComplete(true);
                return;
            }
        }
        context.dropComplete(false);
    }

    void __addDropTarget(LWComponent comp) {
        if (comp.getDropTarget() != null) {
            return;
        }
        DropTarget dummy = new DropTarget((Component)comp, this);
        int count = comp.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component child = comp.getComponent(i);
            if (!(child instanceof LWComponent)) continue;
            this.__addDropTarget((LWComponent)child);
        }
    }

    void __removeDropTarget(LWComponent comp) {
        DropTarget drop = comp.getDropTarget();
        boolean found = true;
        try {
            drop.removeDropTargetListener(this);
        }
        catch (Exception e) {
            found = false;
        }
        if (found) {
            comp.setDropTarget(null);
        }
        int count = comp.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component child = comp.getComponent(i);
            if (!(child instanceof LWComponent)) continue;
            this.__removeDropTarget((LWComponent)child);
        }
    }

    private Point _getOffset(Component comp) {
        int x = 0;
        int y = 0;
        for (Component parent = comp; parent != this._parent; parent = parent.getParent()) {
            Point p = parent.getLocation();
            x += p.x;
            y += p.y;
        }
        return new Point(x, y);
    }

    private boolean _acceptDrag(DropTargetDragEvent dtde) {
        DropTargetContext context = dtde.getDropTargetContext();
        DropTarget target = context.getDropTarget();
        return this._parent.__acceptDrag(target.getComponent(), target.getDefaultActions(), target.isActive(), dtde.getLocation(), dtde.getDropAction(), dtde.getSourceActions(), dtde.getTransferable());
    }

    private boolean _acceptDrop(DropTargetDropEvent dtde) {
        DropTargetContext context = dtde.getDropTargetContext();
        DropTarget target = context.getDropTarget();
        return this._parent.__acceptDrop(target.getComponent(), target.getDefaultActions(), target.isActive(), dtde.getLocation(), dtde.getDropAction(), dtde.getSourceActions(), dtde.getTransferable());
    }
}

