/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintBuilder;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import oracle.bali.dbUI.constraintBuilder.CBCompArray;
import oracle.bali.dbUI.constraintBuilder.ConstraintBuilder;
import oracle.bali.dbUI.constraintBuilder.ConstraintBuilderComp;
import oracle.bali.dbUI.constraintBuilder.DragComponent;
import oracle.bali.dbUI.constraintBuilder.ParentComponent;
import oracle.bali.dbUI.constraintComponent.ConstraintComponent;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.dbUI.dnd.DBUIDataFlavors;
import oracle.bali.ewt.LWComponent;
import oracle.bali.share.datatransfer.TransferUtils;

class DCJDKDragDropSupport
implements DragSourceListener,
DropTargetListener {
    private DragComponent _dragComp;
    private boolean _dropping;
    private boolean _replacing;
    private boolean _isDragging;

    public DCJDKDragDropSupport(DragComponent comp, Component child) {
        this._dragComp = comp;
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer((Component)((Object)comp), 2, new StartDrag(false));
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(child, 2, new StartDrag(true));
        this._addDropTarget(comp);
    }

    public void dragEnter(DragSourceDragEvent dsde) {
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    public void dragExit(DragSourceEvent dsde) {
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
        this._isDragging = false;
        this._dragComp.getConstraintBuilder().setDragging(this._dragComp, false);
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        if (this._acceptDrag(dtde)) {
            this.__setReplacing(true);
        } else {
            dtde.rejectDrag();
        }
    }

    public void dragOver(DropTargetDragEvent dtde) {
        if (!this._acceptDrag(dtde)) {
            dtde.rejectDrag();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dtde) {
        this.__setReplacing(false);
    }

    public void drop(DropTargetDropEvent dtde) {
        this.__setReplacing(false);
        DropTargetContext context = dtde.getDropTargetContext();
        if (!this._acceptDrop(dtde)) {
            context.dropComplete(false);
            return;
        }
        dtde.acceptDrop(2);
        Transferable transfer = dtde.getTransferable();
        Object data = null;
        if (transfer.isDataFlavorSupported(DBUIDataFlavors.DATA_DESCRIPTOR_FLAVOR)) {
            DataDescriptor dd;
            try {
                data = transfer.getTransferData(DBUIDataFlavors.DATA_DESCRIPTOR_FLAVOR);
            }
            catch (IOException ioe) {
                data = null;
            }
            catch (UnsupportedFlavorException ufe) {
                data = null;
            }
            if (data instanceof DataDescriptor && (dd = (DataDescriptor)data) != null) {
                context.dropComplete(true);
                ConstraintComponent cc = this._dragComp.getConstraintBuilder().createConstraintComponent(dd);
                this._dragComp.getConstraintBuilder().replaceConstraintBuilderComp(cc, (ConstraintBuilderComp)this._dragComp);
            }
        }
        if (data == null && transfer.isDataFlavorSupported(DBUIDataFlavors.CONSTRAINT_COMPONENT_FLAVOR)) {
            ConstraintComponent cc;
            try {
                data = transfer.getTransferData(DBUIDataFlavors.CONSTRAINT_COMPONENT_FLAVOR);
            }
            catch (IOException ioe) {
                data = null;
            }
            catch (UnsupportedFlavorException ufe) {
                data = null;
            }
            if (data instanceof ConstraintComponent && (cc = (ConstraintComponent)data) != null) {
                context.dropComplete(true);
                this._dragComp.getConstraintBuilder().replaceConstraintBuilderComp(cc, (ConstraintBuilderComp)this._dragComp);
            }
        }
        if (data == null && transfer.isDataFlavorSupported(CBCompArray.CB_COMP_ARRAY_FLAVOR)) {
            ConstraintBuilderComp[] array;
            try {
                data = transfer.getTransferData(CBCompArray.CB_COMP_ARRAY_FLAVOR);
            }
            catch (IOException ioe) {
                data = null;
            }
            catch (UnsupportedFlavorException ufe) {
                data = null;
            }
            if (data instanceof CBCompArray && (array = ((CBCompArray)data).getData()) != null) {
                for (int i = 0; i < array.length; ++i) {
                    if (array[i] != this._dragComp) continue;
                    context.dropComplete(true);
                    return;
                }
                this._dragComp.getConstraintBuilder().replaceConstraintBuilderComp(array, (ConstraintBuilderComp)this._dragComp);
                context.dropComplete(true);
            }
        }
    }

    void __setDropping(boolean dropping) {
        if (this._dropping != dropping) {
            this._dropping = dropping;
            Color c = this._dropping ? this._dragComp.getConstraintBuilder().DROP_FEEDBACK_COLOR : this._dragComp.getUIDefaults().getColor("control");
            this._dragComp.getChild().setBackground(c);
            this._dragComp.repaint();
        }
    }

    boolean __isDropping() {
        return this._dropping;
    }

    void __setReplacing(boolean replacing) {
        if (this._replacing != replacing) {
            this._replacing = replacing;
            Color c = this._replacing ? this._dragComp.getConstraintBuilder().DROP_REPLACE_FEEDBACK_COLOR : this._dragComp.getUIDefaults().getColor("control");
            this._dragComp.getChild().setBackground(c);
            this._dragComp.repaint();
        }
    }

    boolean __isReplacing() {
        return this._replacing;
    }

    boolean __isDragging() {
        return this._isDragging;
    }

    private void _addDropTarget(LWComponent comp) {
        if (comp.getDropTarget() != null) {
            return;
        }
        DropTarget dummy = new DropTarget((Component)comp, this);
        int count = comp.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component child = comp.getComponent(i);
            if (!(child instanceof LWComponent)) continue;
            this._addDropTarget((LWComponent)child);
        }
    }

    private void _removeDropTarget(LWComponent comp) {
        if (comp instanceof LWComponent) {
            DropTarget target = comp.getDropTarget();
            if (target != null) {
                target.setComponent(null);
                target.removeDropTargetListener(this);
            }
            comp.setDropTarget(null);
            int count = comp.getComponentCount();
            for (int i = 0; i < count; ++i) {
                this._removeDropTarget((LWComponent)comp.getComponent(i));
            }
        }
    }

    private boolean _acceptDrag(DropTargetDragEvent dtde) {
        if (!this._dragComp.isEnabled()) {
            return false;
        }
        for (ParentComponent parent = this._dragComp.getParentComponent(); parent != null; parent = parent.getParentComponent()) {
            if (!parent.isDragging()) continue;
            return false;
        }
        DataFlavor[] flavors = dtde.getCurrentDataFlavors();
        if (flavors == null) {
            return false;
        }
        for (int i = 0; i < flavors.length; ++i) {
            if (TransferUtils.supportsDataFlavor((DataFlavor)flavors[i], (DataFlavor)DBUIDataFlavors.DATA_DESCRIPTOR_FLAVOR)) {
                return true;
            }
            if (TransferUtils.supportsDataFlavor((DataFlavor)flavors[i], (DataFlavor)DBUIDataFlavors.CONSTRAINT_COMPONENT_FLAVOR)) {
                return true;
            }
            if (!CBCompArray.CB_COMP_ARRAY_FLAVOR.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }

    private boolean _acceptDrop(DropTargetDropEvent e) {
        if (!this._dragComp.isEnabled()) {
            return false;
        }
        for (ParentComponent parent = this._dragComp.getParentComponent(); parent != null; parent = parent.getParentComponent()) {
            if (!parent.isDragging()) continue;
            return false;
        }
        return true;
    }

    private ConstraintBuilderComp _getCBComponent() {
        if (this._dragComp.getConstraintComponent() != null) {
            return this._dragComp;
        }
        return this._dragComp.getWrappedParentComponent();
    }

    private void _tryDrag(DragGestureEvent e, boolean isChild) {
        ConstraintBuilderComp dragComp = this._getCBComponent();
        ConstraintBuilder builder = this._dragComp.getConstraintBuilder();
        if (builder.canDrag(dragComp) && !this._isDragging) {
            if (!dragComp.isSelected()) {
                builder.setSelection(dragComp);
                builder.paintImmediateInterior();
            }
            Point offset = e.getDragOrigin();
            offset.x = 5;
            offset.y = -offset.y;
            if (dragComp instanceof ParentComponent) {
                offset.y -= this._dragComp.getLocation().y;
                if (isChild) {
                    offset.y -= this._dragComp.getChild().getLocation().y;
                }
            }
            this._isDragging = true;
            e.startDrag(DragSource.DefaultMoveDrop, builder.getDragImage(), offset, builder.getDragTransferable(), this);
            builder.setDragging(this._dragComp, this._isDragging);
        }
    }

    private class StartDrag
    implements DragGestureListener {
        private boolean _isChild;

        public StartDrag(boolean child) {
            this._isChild = child;
        }

        public void dragGestureRecognized(DragGestureEvent e) {
            DCJDKDragDropSupport.this._tryDrag(e, this._isChild);
        }
    }
}

