/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.xml.bind;

import java.lang.reflect.Method;
import oracle.javatools.xml.bind.ChoiceType;
import oracle.javatools.xml.bind.CreateImpl;
import oracle.javatools.xml.bind.ElementFilter;
import oracle.javatools.xml.bind.ElementListItemImpl;
import oracle.javatools.xml.bind.GetImpl;
import oracle.javatools.xml.bind.GetListImpl;
import oracle.javatools.xml.bind.GetMixedListImpl;
import oracle.javatools.xml.bind.GetOrCreateImpl;
import oracle.javatools.xml.bind.GetPcdataImpl;
import oracle.javatools.xml.bind.ObjectImpl;
import oracle.javatools.xml.bind.Pcdata;
import oracle.javatools.xml.bind.SetImpl;
import oracle.javatools.xml.bind.SetPcdataImpl;
import oracle.javatools.xml.bind.TypeImpl;
import oracle.javatools.xml.bind.UtilImpl;
import oracle.javatools.xml.bind.XMLBindingInfo;

public abstract class XMLBinding {
    protected abstract Class getRootInterface();

    protected Class getUtilClass() {
        return null;
    }

    protected XMLBinding getChainedBinding() {
        return null;
    }

    protected abstract XMLBindingInfo getBindingInfo(Class var1, String var2, Object[] var3);

    protected abstract int elem2intImpl(Class var1, String var2, String var3);

    protected void throwUnrecognizedElem(Class parentIntf, String nsURI, String localName) {
        throw new IllegalArgumentException("Unrecognized parent-elem combination: " + parentIntf + " - " + localName + " in URI '" + nsURI + "'");
    }

    protected static XMLBindingInfo getterPcdata() {
        return new GetPcdataImpl();
    }

    protected static XMLBindingInfo getterElem(String localName) {
        return new GetImpl(0, localName);
    }

    protected static XMLBindingInfo getterElemNS(String nsURI, String localName) {
        return new GetImpl(0, nsURI, localName);
    }

    protected static XMLBindingInfo getterAttr(String localName) {
        return new GetImpl(1, localName);
    }

    protected static XMLBindingInfo getterAttrNS(String nsURI, String localName) {
        return new GetImpl(1, nsURI, localName);
    }

    protected static XMLBindingInfo setterPcdata() {
        return new SetPcdataImpl();
    }

    protected static XMLBindingInfo setterElem(String localName) {
        return new SetImpl(0, localName);
    }

    protected static XMLBindingInfo setterElemNS(String nsURI, String defaultPrefix, String localName) {
        return new SetImpl(0, nsURI, defaultPrefix, localName);
    }

    protected static XMLBindingInfo setterAttr(String localName) {
        return new SetImpl(1, localName);
    }

    protected static XMLBindingInfo setterAttrNS(String nsURI, String defaultPrefix, String localName) {
        return new SetImpl(1, nsURI, defaultPrefix, localName);
    }

    protected static XMLBindingInfo listElems(String localName, Class type) {
        return new GetListImpl(null, null, localName, type, null);
    }

    protected static XMLBindingInfo listElemsNS(String nsURI, String defaultPrefix, String localName, Class type) {
        return new GetListImpl(nsURI, defaultPrefix, localName, type, null);
    }

    protected static XMLBindingInfo listElems(String localName, Class type, ElementFilter filter) {
        return new GetListImpl(null, null, localName, type, filter);
    }

    protected static XMLBindingInfo listElemsNS(String nsURI, String defaultPrefix, String localName, Class type, ElementFilter filter) {
        return new GetListImpl(nsURI, defaultPrefix, localName, type, filter);
    }

    protected static XMLBindingInfo listElems(XMLBindingInfo[] listItemBindings) {
        return new GetMixedListImpl(listItemBindings);
    }

    protected static XMLBindingInfo listItem(String localName, Class type, int id) {
        return new ElementListItemImpl(null, localName, type, id);
    }

    protected static XMLBindingInfo listItemNS(String nsURI, String localName, Class type, int id) {
        return new ElementListItemImpl(nsURI, localName, type, id);
    }

    protected static XMLBindingInfo createElem(String localName) {
        return new CreateImpl(localName);
    }

    protected static XMLBindingInfo createElemNS(String nsURI, String defaultPrefix, String localName) {
        return new CreateImpl(nsURI, defaultPrefix, localName);
    }

    protected static XMLBindingInfo getOrCreateElem(String localName) {
        return new GetOrCreateImpl(localName);
    }

    protected static XMLBindingInfo getOrCreateElemNS(String nsURI, String defaultPrefix, String localName) {
        return new GetOrCreateImpl(nsURI, defaultPrefix, localName);
    }

    protected static XMLBindingInfo utilMethod(Class utilClass) {
        return new UtilImpl(utilClass);
    }

    final XMLBindingInfo getBindingInfo(Method method, Object[] args) {
        XMLBinding binding;
        Class<?> parentIntf = method.getDeclaringClass();
        String methodName = method.getName();
        XMLBindingInfo info = null;
        for (binding = this; binding != null && (info = binding.getBindingInfo(parentIntf, methodName, args)) == null; binding = binding.getChainedBinding()) {
        }
        if (info != null) {
            return info.isBindingValid(method) ? info : this.tryReturnUtilMethod(binding);
        }
        if (parentIntf == Pcdata.class) {
            if (methodName == "getPcdata") {
                return new GetPcdataImpl();
            }
            if (methodName == "setPcdata") {
                return new SetPcdataImpl();
            }
        } else {
            if (parentIntf == ChoiceType.class && methodName == "type") {
                return new TypeImpl();
            }
            if (parentIntf == Object.class) {
                return new ObjectImpl();
            }
        }
        return null;
    }

    private XMLBindingInfo tryReturnUtilMethod(XMLBinding binding) {
        Class utilClass;
        if (binding == null) {
            binding = this;
        }
        return (utilClass = binding.getUtilClass()) != null ? XMLBinding.utilMethod(utilClass) : null;
    }

    final boolean insertBetween(Class parentIntf, String nsURI1, String localName1, String nsURI2, String localName2, String nsURIToInsert, String localNameToInsert) {
        int index1 = this.elem2int(parentIntf, nsURI1, localName1, true);
        int index2 = this.elem2int(parentIntf, nsURI2, localName2, false);
        int index = this.elem2int(parentIntf, nsURIToInsert, localNameToInsert, false);
        return index >= index1 && index < index2;
    }

    final int elem2int(Class parentIntf, String nsURI, String localName, boolean isChild1) {
        if (localName == null) {
            return isChild1 ? 0 : Integer.MAX_VALUE;
        }
        int index = 0;
        for (XMLBinding binding = this; binding != null && (index = binding.elem2intImpl(parentIntf, nsURI, localName)) <= 0; binding = binding.getChainedBinding()) {
        }
        if (index <= 0) {
            System.err.println("**** XMLBinding.elem2intImpl(..) returned non-positive index for interface '" + parentIntf + "' and XML element '" + localName + "' in URI '" + nsURI + "'.");
        }
        return index;
    }
}

