/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.xml.bind;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.javatools.xml.bind.BindingContext;
import oracle.javatools.xml.bind.NodeListImpl;
import oracle.javatools.xml.bind.XMLBindingInfo;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

class GetImpl
extends XMLBindingInfo {
    private final int _xmlType;
    private transient BindingContext _bc;

    GetImpl(int elemOrAttr, String localName) {
        this(elemOrAttr, null, null, localName, null);
    }

    GetImpl(int elemOrAttr, String uri, String localName) {
        this(elemOrAttr, uri, null, localName, null);
    }

    GetImpl(int elemOrAttr, String uri, String defaultPrefix, String localName, Class propertyType) {
        super(uri, defaultPrefix, localName, propertyType);
        this._xmlType = elemOrAttr;
    }

    @Override
    boolean isBindingValid(Method method) {
        return method.getParameterTypes().length == 0;
    }

    @Override
    Object invoke(BindingContext bc, Object proxy, Method method, Object[] args) throws InvocationTargetException {
        this._bc = bc;
        return this.callGetter(method);
    }

    private Object callGetter(Method method) {
        Class<?> propertyType = method.getReturnType();
        if (propertyType == String.class) {
            return this.callGetter_String();
        }
        if (propertyType == Boolean.class) {
            return this.callGetter_Boolean();
        }
        if (propertyType == Integer.class) {
            return this.callGetter_Integer();
        }
        return this.callGetterForUniqueElem(propertyType);
    }

    private String callGetter_String() {
        switch (this._xmlType) {
            case 0: {
                Text text = BindingContext.findFirstTextNodeInChildElement(this._bc._contextElem, this, false);
                return text != null ? text.getNodeValue() : null;
            }
            case 1: {
                Attr attr = this._bc._contextElem.getAttributeNodeNS(this._nsURI, this._localName);
                return attr != null ? attr.getValue() : null;
            }
        }
        throw new IllegalStateException("Invalid XML type in XMLBindingInfo: " + this._xmlType);
    }

    private Boolean callGetter_Boolean() {
        String str = this.callGetter_String();
        return str != null ? Boolean.valueOf(str.trim()) : null;
    }

    private Integer callGetter_Integer() {
        String str = this.callGetter_String();
        return str != null ? Integer.valueOf(str.trim()) : null;
    }

    private Object callGetterForUniqueElem(Class propertyType) {
        NodeListImpl nodeList = BindingContext.getChildrenByQName(this._bc._contextElem, this._nsURI, this._localName);
        if (nodeList.getLength() > 0) {
            Element childElem = (Element)nodeList.item(0);
            return this._bc.createProxy(childElem, propertyType, this.getType());
        }
        return null;
    }
}

