/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.print;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.text.Segment;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.FontHelper;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.DocumentRenderer;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.StyledFragment;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.editor.print.PageInfo;
import oracle.javatools.editor.print.PrintOptions;

public class EditorPageable
implements Pageable,
Printable {
    private BasicDocument document;
    private Component randomComponent;
    private String fileName;
    private PageFormat pageFormat;
    private Segment segment;
    private PrintOptions printOptions;
    private FontHelper fontHelper;
    private String wrapSymbol;
    private int numPages;
    private int linesPerPage;
    private int gutterWidth;
    private int wrapSymbolWidth;
    private int headerHeight;
    private char[] digitArray;
    private FontMetrics fontMetrics;
    private int fontHeight;
    private int fontAscent;
    private int tabSize;
    private int bufferLines;
    private int printedLines;
    private PageInfo[] pageArray;
    private static final int GUTTER_SPACING = 20;
    private static final int WRAP_SYMBOL_SPACING = 10;
    private static final int HEADER_SPACING = 20;
    private static final boolean DEBUG = false;

    public EditorPageable(String fileName, BasicDocument document, PrintOptions printOptions, PageFormat pageFormat) {
        this.document = document;
        this.fileName = fileName;
        this.setPrintOptions(printOptions);
        this.setPageFormat(pageFormat);
        this.numPages = -1;
        this.linesPerPage = -1;
        this.segment = new Segment();
    }

    public void setPrintOptions(PrintOptions printOptions) {
        this.printOptions = (PrintOptions)((Object)printOptions.clone());
        this.invalidate();
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaginate() {
        boolean doWrapping;
        int visibleHeight;
        this.randomComponent = new JPanel();
        this.fontHelper = new FontHelper(this.printOptions.getFontFamily(), this.printOptions.getFontSize());
        Font baseFont = this.fontHelper.getBaseFont();
        this.fontMetrics = this.fontHelper.getFontMetrics(baseFont, this.randomComponent);
        this.fontHeight = this.fontMetrics.getHeight();
        this.fontAscent = this.fontMetrics.getAscent();
        int visibleWidth = (int)this.pageFormat.getImageableWidth();
        int printHeight = visibleHeight = (int)this.pageFormat.getImageableHeight();
        int printWidth = visibleWidth;
        if (this.printOptions.getPrintFileHeader() || this.printOptions.getPrintPageNumbers()) {
            this.headerHeight = this.fontHeight;
            printHeight -= this.headerHeight + 20;
        } else {
            this.headerHeight = 0;
        }
        LineMap lineMap = this.document.getLineMap();
        this.bufferLines = lineMap.getLineCount();
        if (this.printOptions.getPrintLineNumbers() != 0) {
            int digitWidth = EditorPageable.digitWidth(this.fontMetrics);
            int numDigits = EditorPageable.numDigits(this.bufferLines);
            this.digitArray = new char[numDigits + 1];
            this.gutterWidth = digitWidth * numDigits;
            printWidth -= this.gutterWidth + 20;
        } else {
            this.gutterWidth = 0;
        }
        boolean bl = doWrapping = this.printOptions.getWrapBehavior() != 0;
        if (doWrapping) {
            this.wrapSymbol = this.printOptions.getWrapSymbol().trim();
            int n = this.wrapSymbolWidth = this.wrapSymbol.length() > 0 ? this.fontMetrics.stringWidth(this.wrapSymbol) : 0;
            if (this.wrapSymbolWidth > 0) {
                printWidth -= this.wrapSymbolWidth + 10;
            }
        } else {
            this.wrapSymbolWidth = 0;
            this.wrapSymbol = "";
        }
        int linesPerPage = printHeight / this.fontHeight;
        EditorProperties properties = EditorProperties.getProperties();
        this.tabSize = properties.getIntegerProperty("tab-size");
        if (!doWrapping) {
            this.printedLines = this.bufferLines;
            this.numPages = this.bufferLines / linesPerPage;
            if (linesPerPage * this.numPages < this.bufferLines) {
                ++this.numPages;
            }
            this.pageArray = new PageInfo[this.numPages];
            for (int i = 0; i < this.numPages; ++i) {
                PageInfo info;
                this.pageArray[i] = info = new PageInfo(linesPerPage);
                int currentLine = i * linesPerPage;
                int index = 0;
                info.firstLine = currentLine + 1;
                while (currentLine < this.bufferLines && index < linesPerPage) {
                    info.wrappedArray[index] = false;
                    info.startOffsetArray[index] = lineMap.getLineStartOffset(currentLine);
                    info.endOffsetArray[index] = lineMap.getLineEndOffset(currentLine);
                    info.lineNumberArray[index++] = ++currentLine;
                }
                info.printedLines = index;
            }
        } else {
            StyleRegistry styleRegistry = properties.getStyleRegistry();
            DocumentRenderer renderer = this.document.getDocumentRenderer();
            ArrayList<PageInfo> pageList = new ArrayList<PageInfo>();
            StyledFragmentsList fragmentsList = null;
            TextBuffer textBuffer = this.document.getTextBuffer();
            int bufferLength = this.document.getLength();
            int lastLine = 0;
            int lastEndOffset = 0;
            int totalPrintedLines = 0;
            boolean useFontStyle = this.printOptions.getPrintFontStyles();
            FontMetrics styleMetrics = this.fontMetrics;
            do {
                int fragmentIndex;
                PageInfo info = new PageInfo(linesPerPage);
                if (lastEndOffset == bufferLength) {
                    info.firstLine = 1;
                    info.lineNumberArray[0] = 1;
                    info.startOffsetArray[0] = 0;
                    info.endOffsetArray[0] = 0;
                    info.wrappedArray[0] = false;
                    info.printedLines = 0;
                    pageList.add(info);
                    break;
                }
                StyledFragment fragment = null;
                BaseStyle fragmentStyle = null;
                int numFragments = 0;
                if (useFontStyle) {
                    int renderEnd = Math.min(this.bufferLines - 1, lastLine + linesPerPage - 1);
                    this.document.readLock();
                    try {
                        fragmentsList = renderer.renderLines(lastLine, renderEnd);
                    }
                    finally {
                        this.document.readUnlock();
                    }
                    if (fragmentsList == null) {
                        throw new IllegalStateException("empty fragments list");
                    }
                    numFragments = fragmentsList.size();
                    for (fragmentIndex = 0; fragmentIndex < numFragments; ++fragmentIndex) {
                        fragment = fragmentsList.get(fragmentIndex);
                        if (fragment.endOffset > lastEndOffset) break;
                    }
                    fragmentStyle = this.lookupStyle(styleRegistry, fragment.styleName);
                    int fontStyle = fragmentStyle.getFontStyle();
                    Font font = this.fontHelper.getFont(fontStyle);
                    styleMetrics = this.fontHelper.getFontMetrics(font, this.randomComponent);
                }
                info.printedLines = linesPerPage;
                info.firstLine = lastLine + 1;
                for (int i = 0; i < linesPerPage; ++i) {
                    char c;
                    int lazyLineEnd;
                    info.wrappedArray[i] = false;
                    info.startOffsetArray[i] = lastEndOffset;
                    int lineStart = lineMap.getLineStartOffset(lastLine);
                    int lineEnd = lineMap.getLineEndOffset(lastLine);
                    info.lineNumberArray[i] = lastEndOffset == lineStart ? lastLine + 1 : -1;
                    for (lazyLineEnd = lineEnd; lazyLineEnd > lineStart && ((c = textBuffer.getChar(lazyLineEnd - 1)) == ' ' || c == '\t' || c == '\n' || c == '\r'); --lazyLineEnd) {
                    }
                    int xPos = 0;
                    int currentOffset = lastEndOffset;
                    boolean lineFinished = false;
                    block14: while (currentOffset < bufferLength) {
                        if (currentOffset >= lazyLineEnd) {
                            currentOffset = lineEnd;
                            lineFinished = true;
                            break;
                        }
                        if (useFontStyle && fragment.endOffset <= currentOffset) {
                            fragment = fragmentsList.get(++fragmentIndex);
                            fragmentStyle = this.lookupStyle(styleRegistry, fragment.styleName);
                            int fontStyle = fragmentStyle.getFontStyle();
                            Font font = this.fontHelper.getFont(fontStyle);
                            styleMetrics = this.fontHelper.getFontMetrics(font, this.randomComponent);
                        }
                        char c2 = textBuffer.getChar(currentOffset);
                        switch (c2) {
                            case '\n': {
                                lineFinished = true;
                                break block14;
                            }
                            case '\t': {
                                ++currentOffset;
                                if ((xPos = EditorPageable.getNextTabStop(this.fontMetrics, this.tabSize, xPos)) < printWidth) continue block14;
                                break block14;
                            }
                            case ' ': {
                                ++currentOffset;
                                if ((xPos += styleMetrics.charWidth(' ')) < printWidth) continue block14;
                                break block14;
                            }
                            default: {
                                if ((xPos += styleMetrics.charWidth(c2)) > printWidth) break block14;
                                ++currentOffset;
                                continue block14;
                            }
                        }
                    }
                    info.endOffsetArray[i] = lastEndOffset = ++currentOffset;
                    if (lineFinished) {
                        ++lastLine;
                    } else {
                        info.wrappedArray[i] = true;
                    }
                    if (lastEndOffset != bufferLength) continue;
                    info.wrappedArray[i] = false;
                    info.printedLines = i + 1;
                    break;
                }
                if (useFontStyle) {
                    renderer.recycleFragmentsList(fragmentsList);
                }
                totalPrintedLines += info.printedLines;
                pageList.add(info);
            } while (lastEndOffset != bufferLength);
            this.printedLines = totalPrintedLines;
            this.numPages = pageList.size();
            this.pageArray = pageList.toArray(new PageInfo[this.numPages]);
        }
    }

    private BaseStyle lookupStyle(StyleRegistry styleRegistry, String styleName) {
        BaseStyle style = styleRegistry.lookupStyle(styleName);
        if (style == null) {
            throw new IllegalStateException("style not found: " + styleName);
        }
        return style;
    }

    protected void invalidate() {
        this.numPages = -1;
    }

    protected void repaginateIfNeeded() {
        if (this.numPages == -1) {
            this.repaginate();
        }
    }

    protected boolean isPageIndexValid(int pageIndex) {
        return pageIndex >= 0 && pageIndex < this.numPages;
    }

    protected void verifyPageIndexValid(int pageIndex) throws IndexOutOfBoundsException {
        if (!this.isPageIndexValid(pageIndex)) {
            throw new IndexOutOfBoundsException("bad index: " + pageIndex);
        }
    }

    @Override
    public int getNumberOfPages() {
        this.repaginateIfNeeded();
        return this.numPages;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        this.repaginateIfNeeded();
        this.verifyPageIndexValid(pageIndex);
        return this.pageFormat;
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        this.repaginateIfNeeded();
        this.verifyPageIndexValid(pageIndex);
        return this;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (!this.isPageIndexValid(pageIndex)) {
            return 1;
        }
        this.printHeader(graphics, pageFormat, pageIndex);
        this.printLineNumbers(graphics, pageFormat, pageIndex);
        this.printWrappedSymbols(graphics, pageFormat, pageIndex);
        this.printText(graphics, pageFormat, pageIndex);
        return 0;
    }

    protected void printHeader(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (this.headerHeight > 0) {
            int visibleStartX = (int)pageFormat.getImageableX();
            int visibleStartY = (int)pageFormat.getImageableY();
            int visibleWidth = (int)pageFormat.getImageableWidth();
            Font font = this.fontHelper.getBaseFont();
            graphics.setFont(font);
            graphics.setColor(Color.black);
            if (this.printOptions.getPrintFileHeader()) {
                int slashIndex = this.fileName.lastIndexOf(47);
                int colonIndex = this.fileName.lastIndexOf(58);
                int backslashIndex = this.fileName.lastIndexOf(92);
                int start = Math.max(Math.max(slashIndex, colonIndex), backslashIndex);
                String fileNameOnly = this.fileName.substring(start + 1);
                graphics.drawString(fileNameOnly, visibleStartX, visibleStartY + this.fontAscent);
            }
            if (this.printOptions.getPrintPageNumbers()) {
                int pageNumber = pageIndex + 1;
                String pageNumberText = pageNumber + "/" + this.numPages;
                int pageNumberWidth = this.fontMetrics.stringWidth(pageNumberText);
                graphics.drawString(pageNumberText, visibleStartX + visibleWidth - pageNumberWidth, visibleStartY + this.fontAscent);
            }
        }
    }

    protected void printLineNumbers(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (this.gutterWidth > 0) {
            int visibleStartX = (int)pageFormat.getImageableX();
            int visibleStartY = (int)pageFormat.getImageableY();
            Font font = this.fontHelper.getBaseFont();
            graphics.setFont(font);
            graphics.setColor(Color.black);
            int yPos = visibleStartY + this.fontAscent;
            if (this.headerHeight > 0) {
                yPos += this.headerHeight + 20;
            }
            int xRightEdge = visibleStartX + this.gutterWidth;
            PageInfo pageInfo = this.pageArray[pageIndex];
            EditorPageable.setNumber(this.digitArray, pageInfo.firstLine);
            int numLines = pageInfo.printedLines;
            int[] numberArray = pageInfo.lineNumberArray;
            int digitArraySize = this.digitArray.length;
            for (int i = 0; i < numLines; ++i) {
                if (numberArray[i] == -1) {
                    if (i == 0) {
                        EditorPageable.incrementNumber(this.digitArray);
                    }
                } else {
                    int width = this.fontMetrics.charsWidth(this.digitArray, 0, digitArraySize);
                    graphics.drawChars(this.digitArray, 0, digitArraySize, xRightEdge - width, yPos);
                    EditorPageable.incrementNumber(this.digitArray);
                }
                yPos += this.fontHeight;
            }
        }
    }

    protected void printWrappedSymbols(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (this.wrapSymbolWidth > 0) {
            int visibleStartX = (int)pageFormat.getImageableX();
            int visibleStartY = (int)pageFormat.getImageableY();
            int visibleWidth = (int)pageFormat.getImageableWidth();
            Font font = this.fontHelper.getBaseFont();
            graphics.setFont(font);
            graphics.setColor(Color.black);
            int yPos = visibleStartY + this.fontAscent;
            if (this.headerHeight > 0) {
                yPos += this.headerHeight + 20;
            }
            int xPos = visibleStartX + visibleWidth - this.wrapSymbolWidth;
            PageInfo pageInfo = this.pageArray[pageIndex];
            int numLines = pageInfo.printedLines;
            boolean[] wrappedArray = pageInfo.wrappedArray;
            for (int i = 0; i < numLines; ++i) {
                if (wrappedArray[i]) {
                    graphics.drawString(this.wrapSymbol, xPos, yPos);
                }
                yPos += this.fontHeight;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printText(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        int fragmentIndex;
        int visibleStartX = (int)pageFormat.getImageableX();
        int visibleStartY = (int)pageFormat.getImageableY();
        int visibleWidth = (int)pageFormat.getImageableWidth();
        int xStart = visibleStartX;
        if (this.gutterWidth > 0) {
            xStart += this.gutterWidth + 20;
        }
        int xPos = xStart;
        int yPos = visibleStartY + this.fontAscent;
        if (this.headerHeight > 0) {
            yPos += this.headerHeight + 20;
        }
        PageInfo pageInfo = this.pageArray[pageIndex];
        int numLines = pageInfo.printedLines;
        int[] startOffsetArray = pageInfo.startOffsetArray;
        int[] endOffsetArray = pageInfo.endOffsetArray;
        if (numLines == 0) {
            return;
        }
        LineMap lineMap = this.document.getLineMap();
        TextBuffer textBuffer = this.document.getTextBuffer();
        DocumentRenderer renderer = this.document.getDocumentRenderer();
        EditorProperties properties = EditorProperties.getProperties();
        StyleRegistry styleRegistry = properties.getStyleRegistry();
        StyledFragmentsList fragmentsList = null;
        StyledFragment fragment = null;
        BaseStyle fragmentStyle = null;
        int numFragments = 0;
        FontMetrics styleMetrics = this.fontMetrics;
        boolean printColors = this.printOptions.getPrintColors();
        boolean printStyles = this.printOptions.getPrintFontStyles();
        if (printColors || printStyles) {
            int firstOffset = startOffsetArray[0];
            int lastOffset = endOffsetArray[numLines - 1];
            int firstLine = lineMap.getLineFromOffset(firstOffset);
            int lastLine = lineMap.getLineFromOffset(lastOffset);
            this.document.readLock();
            try {
                fragmentsList = renderer.renderLines(firstLine, lastLine);
            }
            finally {
                this.document.readUnlock();
            }
            if (fragmentsList == null) {
                throw new IllegalStateException("empty fragments list");
            }
            numFragments = fragmentsList.size();
            for (fragmentIndex = 0; fragmentIndex < numFragments; ++fragmentIndex) {
                fragment = fragmentsList.get(fragmentIndex);
                if (fragment.endOffset > firstOffset) break;
            }
            fragmentStyle = this.lookupStyle(styleRegistry, fragment.styleName);
        }
        if (printStyles) {
            int fontStyle = fragmentStyle.getFontStyle();
            Font font = this.fontHelper.getFont(fontStyle);
            styleMetrics = this.fontHelper.getFontMetrics(font, this.randomComponent);
            graphics.setFont(font);
        } else {
            Font baseFont = this.fontHelper.getBaseFont();
            graphics.setFont(baseFont);
        }
        if (printColors) {
            Color color = fragmentStyle.getForegroundColor();
            if (color.equals(Color.white)) {
                color = Color.black;
            }
            graphics.setColor(color);
        } else {
            graphics.setColor(Color.black);
        }
        for (int i = 0; i < numLines; ++i) {
            xPos = xStart;
            int startOffset = startOffsetArray[i];
            int endOffset = endOffsetArray[i];
            textBuffer.getText(startOffset, endOffset - startOffset, this.segment);
            char[] buffer = this.segment.array;
            int bufferStart = this.segment.offset;
            int bufferEnd = this.segment.offset + this.segment.count;
            int lastPaintOffset = bufferStart;
            int adjustRelative = bufferStart - startOffset;
            int charsToPaint = 0;
            int charsWidth = 0;
            block9: for (int currentOffset = bufferStart; currentOffset < bufferEnd; ++currentOffset) {
                if ((printStyles || printColors) && fragment.endOffset <= currentOffset - adjustRelative) {
                    if (charsToPaint > 0) {
                        graphics.drawChars(buffer, lastPaintOffset, charsToPaint, xPos, yPos);
                        xPos += charsWidth;
                        charsToPaint = 0;
                        charsWidth = 0;
                        lastPaintOffset = currentOffset;
                    }
                    fragment = fragmentsList.get(++fragmentIndex);
                    fragmentStyle = this.lookupStyle(styleRegistry, fragment.styleName);
                    if (printColors) {
                        Color color = fragmentStyle.getForegroundColor();
                        if (color.equals(Color.white)) {
                            color = Color.black;
                        }
                        graphics.setColor(color);
                    }
                    if (printStyles) {
                        int fontStyle = fragmentStyle.getFontStyle();
                        Font font = this.fontHelper.getFont(fontStyle);
                        styleMetrics = this.fontHelper.getFontMetrics(font, this.randomComponent);
                        graphics.setFont(font);
                    }
                }
                char c = buffer[currentOffset];
                switch (c) {
                    case '\t': {
                        if (charsToPaint > 0) {
                            graphics.drawChars(buffer, lastPaintOffset, charsToPaint, xPos, yPos);
                            xPos += charsWidth;
                            charsToPaint = 0;
                            charsWidth = 0;
                        }
                        lastPaintOffset = currentOffset + 1;
                        int xAbs = xPos - xStart;
                        xPos = EditorPageable.getNextTabStop(this.fontMetrics, this.tabSize, xAbs) + xStart;
                        continue block9;
                    }
                    case '\n': 
                    case '\r': {
                        break block9;
                    }
                    default: {
                        ++charsToPaint;
                        charsWidth += styleMetrics.charWidth(c);
                    }
                }
            }
            if (charsToPaint > 0) {
                graphics.drawChars(buffer, lastPaintOffset, charsToPaint, xPos, yPos);
            }
            yPos += this.fontHeight;
        }
        if (fragmentsList != null) {
            renderer.recycleFragmentsList(fragmentsList);
        }
    }

    private static int getNextTabStop(FontMetrics metrics, int tabSize, int xPos) {
        int spaceSize = metrics.charWidth(' ');
        int tabPixels = tabSize * spaceSize;
        int numTabs = xPos / tabPixels;
        int nextStop = tabPixels * (numTabs + 1);
        return nextStop;
    }

    private static int digitWidth(FontMetrics metrics) {
        int maxWidth = 0;
        for (char c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
            int width = metrics.charWidth(c);
            maxWidth = Math.max(width, maxWidth);
        }
        return maxWidth;
    }

    static int numDigits(int number) {
        if (number < 10) {
            return 1;
        }
        if (number < 100) {
            return 2;
        }
        if (number < 1000) {
            return 3;
        }
        int digits = 0;
        do {
            ++digits;
        } while ((number /= 10) != 0);
        return digits;
    }

    static void setNumber(char[] numberChars, int number) {
        int numberWidth = numberChars.length;
        for (int i = 0; i < numberWidth; ++i) {
            numberChars[i] = 32;
        }
        String numberStr = Integer.toString(number);
        char[] numberStrChars = numberStr.toCharArray();
        int numberStrLen = numberStrChars.length;
        int startOffset = numberWidth - numberStrLen;
        System.arraycopy(numberStrChars, 0, numberChars, startOffset, numberStrLen);
    }

    static void incrementNumber(char[] number) {
        int numberWidth = number.length;
        int carry = 1;
        for (int i = numberWidth - 1; i >= 0; --i) {
            char c = number[i];
            int digit = c == ' ' ? 0 : c - 48;
            carry = 0;
            if ((digit += carry) > 9) {
                carry = 1;
                digit -= 10;
            }
            number[i] = (char)(digit + 48);
            if (carry == 0) break;
        }
    }
}

