/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.print;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.Utilities;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.DocumentRenderer;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.StyledFragment;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.editor.print.EditorPageable;
import oracle.javatools.editor.print.HTMLGeneratorOptions;

public class DocumentToHTMLGenerator {
    private BasicDocument _document;
    private String _filepath;
    private StyleRegistry _registry = null;
    private int _tabSize = -1;
    private static final int PREFETCH_LINE_COUNT = 100;
    private static final String LINE_TO_SOURCE_PADDING = "  ";
    private static final String SOURCE_TO_WRAP_PADDING = "  ";

    public DocumentToHTMLGenerator(BasicDocument document, String filepath) {
        this._document = document;
        this._filepath = filepath;
    }

    public void setStyleRegistry(StyleRegistry registry) {
        this._registry = registry;
    }

    public void setTabSize(int tabSize) {
        if (tabSize > 0) {
            this._tabSize = tabSize;
        }
    }

    public void generateHTML(OutputStream outputStream, HTMLGeneratorOptions options) throws UnsupportedEncodingException, IOException {
        String charset = options.getCharsetEncoding();
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, charset);
        BufferedWriter bufWriter = new BufferedWriter(writer);
        this.generateHTML(bufWriter, options);
    }

    public void generateHTML(Writer writer, HTMLGeneratorOptions options) throws IOException {
        writer.write("<html>\n");
        Map styleMap = this.generateHead(writer, options);
        this.generateBody(writer, options, styleMap);
        writer.write("</html>\n");
        writer.close();
    }

    private void generateBody(Writer writer, HTMLGeneratorOptions options, Map styleMap) throws IOException {
        writer.write("<body>\n");
        this.generateFileHeader(writer, options, styleMap);
        writer.write("<pre>\n");
        this.generateSource(writer, options, styleMap);
        writer.write("</pre>\n");
        writer.write("</body>\n");
    }

    private void generateSource(Writer writer, HTMLGeneratorOptions options, Map styleMap) throws IOException {
        char[] WRAPPED_LINE_PADDING;
        char[] lineChars;
        TextBuffer textBuffer = this._document.getTextBuffer();
        LineMap lineMap = textBuffer.getLineMap();
        DocumentRenderer renderer = this._document.getDocumentRenderer();
        boolean printAnchors = options.getUseAnchors();
        boolean printLineNumbers = options.getPrintLineNumbers() == 1;
        boolean countLineNumbers = printAnchors || printLineNumbers;
        boolean printStyles = options.getPrintColors() || options.getPrintFontStyles() || options.getUseFontInfo();
        boolean wrapLines = options.getWrapBehavior() == 1;
        int wrapColumn = options.getWrapColumn();
        String wrapSymbol = options.getWrapSymbol();
        int tabSize = this.getTabSize();
        int numLines = lineMap.getLineCount();
        int lineNumberWidth = EditorPageable.numDigits(numLines);
        if (countLineNumbers) {
            lineChars = new char[lineNumberWidth];
            EditorPageable.setNumber(lineChars, 0);
            WRAPPED_LINE_PADDING = new char[lineNumberWidth];
            for (int i = 0; i < lineNumberWidth; ++i) {
                WRAPPED_LINE_PADDING[i] = 32;
            }
        } else {
            lineChars = null;
            WRAPPED_LINE_PADDING = null;
        }
        String DEFAULT_STYLE = "base-plain-style";
        String DEFAULT_HTML_STYLE = printStyles ? (String)styleMap.get("base-plain-style") : null;
        StyledFragment fragment = null;
        StyledFragmentsList fragmentsList = null;
        int nextFragmentIndex = 0;
        int numFragments = 0;
        for (int i = 0; i < numLines; ++i) {
            int realEndOffset;
            int beforeSpaceEndOffset;
            int startOffset;
            if (countLineNumbers) {
                EditorPageable.incrementNumber(lineChars);
            }
            if (printAnchors) {
                int numDigits = EditorPageable.numDigits(i + 1);
                writer.write("<a name=\"");
                writer.write(lineChars, lineNumberWidth - numDigits, numDigits);
                writer.write("\">");
            }
            int endOffset = (startOffset = lineMap.getLineStartOffset(i)) == (beforeSpaceEndOffset = this.getLineEndBeforeTrailing(textBuffer, startOffset, realEndOffset = lineMap.getLineEndOffset(i))) ? Math.min(startOffset + 1, realEndOffset) : beforeSpaceEndOffset;
            int currentOffset = startOffset;
            boolean firstLine = true;
            while (currentOffset < endOffset) {
                boolean isWrapped;
                int stopOffset = this.getGeneratedLineEnd(textBuffer, currentOffset, endOffset, wrapLines, wrapColumn, tabSize);
                if (printLineNumbers) {
                    if (printStyles) {
                        this.generateFontStart(writer, DEFAULT_HTML_STYLE);
                    }
                    if (firstLine) {
                        writer.write(lineChars);
                        firstLine = false;
                    } else {
                        writer.write(WRAPPED_LINE_PADDING);
                    }
                    writer.write("  ");
                    if (printStyles) {
                        this.generateFontEnd(writer);
                    }
                }
                int currentColumn = 0;
                while (currentOffset < stopOffset) {
                    while (fragment == null || currentOffset < fragment.startOffset || fragment.endOffset <= currentOffset) {
                        if (nextFragmentIndex >= numFragments) {
                            int endFetch;
                            int startFetch;
                            if (fragmentsList != null) {
                                renderer.recycleFragmentsList(fragmentsList);
                            }
                            if ((numFragments = this.getFragmentsCount(fragmentsList = renderer.renderLines(startFetch = i, endFetch = Math.min(i + 100, numLines - 1)))) == 0) {
                                throw new IllegalStateException("empty fragment list");
                            }
                            nextFragmentIndex = 0;
                        }
                        fragment = fragmentsList.get(nextFragmentIndex++);
                    }
                    String baseStyleName = fragment.styleName;
                    boolean isDefaultStyle = baseStyleName.equals("base-plain-style");
                    if (printStyles && !isDefaultStyle) {
                        String htmlStyle = (String)styleMap.get(baseStyleName);
                        this.generateFontStart(writer, htmlStyle);
                    }
                    block13: while (currentOffset < fragment.endOffset && currentOffset < stopOffset) {
                        char c = textBuffer.getChar(currentOffset++);
                        switch (c) {
                            case '\t': {
                                int nextStop = Utilities.getNextTabStop(tabSize, currentColumn);
                                int spacesToGenerate = nextStop - currentColumn;
                                if (wrapLines && nextStop >= wrapColumn) {
                                    spacesToGenerate = wrapColumn - nextStop;
                                }
                                for (int s = 0; s < spacesToGenerate; ++s) {
                                    writer.write(32);
                                }
                                currentColumn = nextStop;
                                continue block13;
                            }
                            case '<': {
                                writer.write("&lt;");
                                continue block13;
                            }
                            case '>': {
                                writer.write("&gt;");
                                continue block13;
                            }
                            case '\"': {
                                writer.write("&quot;");
                                continue block13;
                            }
                            case '&': {
                                writer.write("&amp;");
                                continue block13;
                            }
                            case '\n': 
                            case '\r': {
                                continue block13;
                            }
                        }
                        writer.write(c);
                        ++currentColumn;
                    }
                    if (!printStyles || isDefaultStyle) continue;
                    this.generateFontEnd(writer);
                }
                boolean bl = isWrapped = stopOffset != endOffset;
                if (!wrapLines || !isWrapped) continue;
                writer.write("  ");
                writer.write(wrapSymbol);
                writer.write("\n");
            }
            if (printAnchors) {
                writer.write("</a>");
            }
            writer.write("\n");
        }
    }

    private void generateFontStart(Writer writer, String styleClass) throws IOException {
        writer.write("<font class=\"");
        writer.write(styleClass);
        writer.write("\">");
    }

    private void generateFontEnd(Writer writer) throws IOException {
        writer.write("</font>");
    }

    private int getLineEndBeforeTrailing(TextBuffer textBuffer, int startOffset, int endOffset) {
        int currentOffset;
        block3: for (currentOffset = endOffset; currentOffset > startOffset; --currentOffset) {
            char c = textBuffer.getChar(currentOffset - 1);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
            }
            return currentOffset;
        }
        return currentOffset;
    }

    private int getGeneratedLineEnd(TextBuffer textBuffer, int startOffset, int endOffset, boolean wrapLines, int wrapColumn, int tabSize) {
        if (!wrapLines) {
            return endOffset;
        }
        int currentColumn = 0;
        int currentOffset = startOffset;
        block3: while (currentColumn < wrapColumn && currentOffset < endOffset) {
            char c = textBuffer.getChar(currentOffset++);
            switch (c) {
                case '\t': {
                    currentColumn = Utilities.getNextTabStop(tabSize, currentColumn);
                    continue block3;
                }
            }
            ++currentColumn;
        }
        return currentOffset;
    }

    private int getTabSize() {
        if (this._tabSize > 0) {
            return this._tabSize;
        }
        EditorProperties properties = EditorProperties.getProperties();
        return properties.getIntegerProperty("tab-size");
    }

    private int getFragmentsCount(StyledFragmentsList list) {
        return list == null ? 0 : list.size();
    }

    private void generateFileHeader(Writer writer, HTMLGeneratorOptions options, Map styleMap) throws IOException {
        boolean useHeader = options.getPrintFileHeader();
        boolean useTimeStamp = options.getPrintTimeStamp();
        if (useHeader) {
            boolean printStyles = options.getPrintColors() || options.getPrintFontStyles() || options.getUseFontInfo();
            String DEFAULT_STYLE = "base-plain-style";
            String DEFAULT_HTML_STYLE = printStyles ? (String)styleMap.get("base-plain-style") : null;
            writer.write("<pre>\n");
            if (DEFAULT_HTML_STYLE != null) {
                this.generateFontStart(writer, DEFAULT_HTML_STYLE);
            }
            if (this._filepath != null) {
                writer.write(this._filepath);
                writer.write("\n");
            }
            if (DEFAULT_HTML_STYLE != null) {
                this.generateFontEnd(writer);
            }
            if (useTimeStamp) {
                Date date = new Date();
                DateFormat formatter = DateFormat.getDateTimeInstance();
                writer.write(formatter.format(date));
                writer.write("\n");
            }
            writer.write("</pre>\n");
        }
    }

    private Map generateHead(Writer writer, HTMLGeneratorOptions options) throws IOException {
        writer.write("<head>\n");
        String charset = options.getCharsetEncoding();
        writer.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=");
        writer.write(charset);
        writer.write("\">\n");
        writer.write("<title>\n");
        if (this._filepath != null) {
            writer.write(this._filepath);
            writer.write("\n");
        }
        writer.write("</title>\n");
        Map styleMap = this.generateStyles(writer, options);
        writer.write("</head>\n");
        return styleMap;
    }

    private Map generateStyles(Writer writer, HTMLGeneratorOptions options) throws IOException {
        boolean useColors = options.getPrintColors();
        boolean useFontStyles = options.getPrintFontStyles();
        boolean useFileHeader = options.getPrintFileHeader();
        boolean useFontInfo = options.getUseFontInfo();
        String fontFamily = options.getFontFamily();
        int fontSize = options.getFontSize();
        HashMap<String, String> styleMap = new HashMap<String, String>();
        writer.write("<style type=\"text/css\">\n");
        writer.write("<!--\n");
        StyleRegistry registryToUse = this._registry;
        if (registryToUse == null) {
            EditorProperties properties = EditorProperties.getProperties();
            registryToUse = properties.getStyleRegistry();
        }
        Color defaultBgColor = null;
        if (useColors) {
            writer.write("body {");
            BaseStyle defaultStyle = registryToUse.lookupStyle("base-plain-style");
            if (defaultStyle != null) {
                Color bgColor;
                Color fgColor = defaultStyle.getForegroundColor();
                defaultBgColor = bgColor = defaultStyle.getBackgroundColor();
                writer.write("color: ");
                this.generateColor(writer, fgColor);
                writer.write("; background-color: ");
                this.generateColor(writer, bgColor);
            }
            writer.write("}\n");
        }
        if (useColors || useFontInfo || useFontStyles) {
            int index = 0;
            Iterator styleIterator = registryToUse.getStyleIterator();
            while (styleIterator.hasNext()) {
                BaseStyle style = (BaseStyle)styleIterator.next();
                if (style == null) continue;
                String styleName = "s" + index;
                ++index;
                writer.write(".");
                writer.write(styleName);
                writer.write(" {");
                boolean needSemi = false;
                if (useColors) {
                    Color fgColor = style.getForegroundColor();
                    Color bgColor = style.getBackgroundColor();
                    writer.write("color: ");
                    this.generateColor(writer, fgColor);
                    writer.write("; background-color: ");
                    if (bgColor.equals(defaultBgColor)) {
                        writer.write("transparent");
                    } else {
                        this.generateColor(writer, bgColor);
                    }
                    needSemi = true;
                }
                if (useFontInfo) {
                    if (needSemi) {
                        writer.write("; ");
                    }
                    writer.write("font-family: ");
                    writer.write(fontFamily);
                    writer.write("; font-size: ");
                    writer.write(Integer.toString(fontSize));
                    needSemi = true;
                }
                if (useFontStyles) {
                    boolean useItalic;
                    boolean useBold;
                    int fontStyle = style.getFontStyle();
                    boolean bl = useBold = (fontStyle & 1) == 1;
                    if (useBold) {
                        if (needSemi) {
                            writer.write("; ");
                        }
                        writer.write("font-weight: bold");
                        needSemi = true;
                    }
                    boolean bl2 = useItalic = (fontStyle & 2) == 2;
                    if (useItalic) {
                        if (needSemi) {
                            writer.write("; ");
                        }
                        writer.write("font-style: italic");
                        needSemi = true;
                    }
                }
                writer.write("}\n");
                styleMap.put(style.getName(), styleName);
            }
        }
        writer.write("-->\n");
        writer.write("</style>\n");
        return styleMap;
    }

    private void generateColor(Writer writer, Color color) throws IOException {
        int value = color.getRGB() & 0xFFFFFF;
        String hexValue = Integer.toHexString(value);
        writer.write("#");
        int hexLen = hexValue.length();
        int paddingToWrite = 6 - hexLen;
        for (int i = 0; i < paddingToWrite; ++i) {
            writer.write(48);
        }
        writer.write(hexValue);
    }
}

