/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.plugins;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.WriteLockRequestListener;
import oracle.javatools.editor.ActionHookInvoker;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.language.BraceProvider;
import oracle.javatools.editor.language.ExtendedBraceProvider;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.resource.BundleHelper;
import oracle.javatools.util.Executors;

public final class BraceMatchingPlugin
implements ActionHookInvoker,
CaretListener,
DocumentListener,
EditorPlugin {
    public static final int DEFAULT_BRACE_PRIORITY = 80;
    public static final String HIGHLIGHT_BRACE_MATCH1 = "brace-match1-highlight";
    public static final String HIGHLIGHT_BRACE_MATCH2 = "brace-match2-highlight";
    public static final String HIGHLIGHT_BRACE_MISMATCH = "brace-mismatch-highlight";
    public static final String HIGHLIGHT_ENCLOSING_BLOCK = "enclosing-block-highlight";
    public static final String HIGHLIGHT_ENCLOSING_PARENS = "enclosing-parens-highlight";
    private static final HighlightStyle braceMatchStyle1;
    private static final HighlightStyle braceMatchStyle2;
    private static final HighlightStyle nonMatchingStyle;
    private static final HighlightStyle enclosingBlockStyle;
    private static final HighlightStyle enclosingParenStyle;
    private static ScheduledThreadPoolExecutor scheduler;
    private volatile BraceMatchingTask braceMatchingTask;
    private Future braceMatchingFuture;
    private HighlightLayer highlightLayer;
    private BasicEditorPane editor;
    private boolean doHighlighting;
    private boolean doBlocks;
    private boolean doParens;
    private int delay = 300;

    public static void shutdown() {
        Executors.shutdownNow((ExecutorService)scheduler);
    }

    @Override
    public void install(BasicEditorPane editor) {
        this.editor = editor;
        editor.addActionHookInvoker(this);
        editor.addCaretListener(this);
        Document document = editor.getDocument();
        document.addDocumentListener(this);
        this.doHighlighting = false;
        this.updateEnabled();
        this.updateTimerDelay();
        this.scheduleMatch();
    }

    @Override
    public void deinstall(BasicEditorPane editor) {
        editor.removeCaretListener(this);
        editor.removeActionHookInvoker(this);
        Document document = editor.getDocument();
        if (document != null) {
            document.removeDocumentListener(this);
        }
        if (this.braceMatchingFuture != null) {
            this.braceMatchingFuture.cancel(true);
            this.braceMatchingFuture = null;
            this.braceMatchingTask = null;
            scheduler.purge();
        }
        if (this.highlightLayer != null) {
            editor.destroyHighlightLayer(this.highlightLayer);
            this.highlightLayer = null;
        }
        this.editor = null;
        this.doHighlighting = false;
    }

    protected void updateEnabled() {
        this.doHighlighting = this.editor.getBooleanProperty("brace-matching-auto");
        this.doBlocks = this.editor.getBooleanProperty("brace-matching-enclosing-blocks");
        this.doParens = this.editor.getBooleanProperty("brace-matching-enclosing-parens");
    }

    protected void updateTimerDelay() {
        this.delay = this.editor.getIntegerProperty("brace-matching-delay");
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        boolean updateEnabled = false;
        if (propertyName.equals("language-support")) {
            updateEnabled = true;
        } else if (propertyName.equals("brace-matching-auto")) {
            updateEnabled = true;
        } else if (propertyName.equals("brace-matching-enclosing-blocks")) {
            updateEnabled = true;
        } else if (propertyName.equals("brace-matching-enclosing-parens")) {
            updateEnabled = true;
        } else if (propertyName.equals("brace-matching-delay")) {
            this.updateTimerDelay();
        } else if (propertyName.equals("document")) {
            Object newValue;
            Object oldValue = event.getOldValue();
            if (oldValue instanceof Document) {
                Document document = (Document)oldValue;
                document.removeDocumentListener(this);
            }
            if ((newValue = event.getNewValue()) instanceof Document) {
                Document document = (Document)newValue;
                document.addDocumentListener(this);
            }
            updateEnabled = true;
        }
        if (updateEnabled) {
            this.updateEnabled();
            if (this.doHighlighting) {
                this.scheduleMatch();
            } else {
                this.clearHighlighting();
            }
        }
    }

    @Override
    public void caretUpdate(CaretEvent event) {
        this.scheduleMatch();
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.scheduleMatch();
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.scheduleMatch();
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        this.scheduleMatch();
    }

    @Override
    public boolean invokeAction(String actionKey) {
        if (actionKey.equals("show-matching-brace")) {
            this.scheduleBraceMatchingTask(true);
            return true;
        }
        return false;
    }

    private void scheduleMatch() {
        if (this.doHighlighting) {
            if (this.braceMatchingFuture != null) {
                this.braceMatchingFuture.cancel(true);
                this.braceMatchingFuture = null;
                this.braceMatchingTask = null;
                scheduler.purge();
            }
            this.scheduleBraceMatchingTask(false);
        }
    }

    private void scheduleBraceMatchingTask(boolean manual) {
        this.clearHighlighting();
        if (this.doHighlighting || manual) {
            if (this.editor == null) {
                this.doHighlighting = false;
                return;
            }
            Document document = this.editor.getDocument();
            if (!(document instanceof BasicDocument)) {
                this.doHighlighting = false;
                return;
            }
            BasicDocument basicDocument = (BasicDocument)document;
            LanguageSupport languageSupport = basicDocument.getLanguageSupport();
            BraceProvider braceProvider = languageSupport.getBraceProvider();
            if (braceProvider == null) {
                this.doHighlighting = false;
                return;
            }
            int offset = this.editor.getCaretPosition();
            this.braceMatchingTask = new BraceMatchingTask(basicDocument, offset, braceProvider, this.getHighlightLayer(), this.doBlocks, this.doParens);
            this.braceMatchingFuture = manual ? scheduler.submit(this.braceMatchingTask) : scheduler.schedule(this.braceMatchingTask, (long)this.delay, TimeUnit.MILLISECONDS);
        }
    }

    private void clearHighlighting() {
        if (this.highlightLayer != null) {
            this.highlightLayer.removeAllHighlights();
        }
    }

    private HighlightLayer getHighlightLayer() {
        if (this.highlightLayer == null) {
            this.highlightLayer = this.editor.createHighlightLayer();
        }
        return this.highlightLayer;
    }

    static {
        EditorProperties properties = EditorProperties.getProperties();
        HighlightRegistry registry = properties.getHighlightRegistry();
        BundleHelper resources = EditorProperties.getEditorBundle();
        String name = resources.getString("BRACE_MATCH1_HIGHLIGHT");
        braceMatchStyle1 = registry.createStyle(HIGHLIGHT_BRACE_MATCH1, name, 80, Color.black, Color.yellow);
        name = resources.getString("BRACE_MATCH2_HIGHLIGHT");
        braceMatchStyle2 = registry.createStyle(HIGHLIGHT_BRACE_MATCH2, name, 80, Color.black, Color.orange);
        name = resources.getString("BRACE_MISMATCH_HIGHLIGHT");
        nonMatchingStyle = registry.createStyle(HIGHLIGHT_BRACE_MISMATCH, name, 80, Color.black, Color.red);
        name = resources.getString("BRACE_ENCLOSING_PARENS");
        enclosingParenStyle = registry.createStyle(HIGHLIGHT_ENCLOSING_PARENS, name, 79, Color.black, new Color(214, 214, 255));
        name = resources.getString("BRACE_ENCLOSING_BLOCK");
        enclosingBlockStyle = registry.createStyle(HIGHLIGHT_ENCLOSING_BLOCK, name, 79, Color.black, new Color(239, 214, 255));
        scheduler = new ScheduledThreadPoolExecutor(1, Executors.namedThreadFactory((String)"brace-matching"), new ThreadPoolExecutor.DiscardPolicy());
        scheduler.setKeepAliveTime(10L, TimeUnit.SECONDS);
        scheduler.allowCoreThreadTimeOut(true);
    }

    private static final class BraceResult {
        private final HighlightStyle style;
        private final NumberRange braceLocation;
        private final NumberRange matchingLocation;

        BraceResult(HighlightStyle style, NumberRange braceLocation) {
            this(style, braceLocation, null);
        }

        BraceResult(HighlightStyle style, NumberRange braceLocation, NumberRange matchingLocation) {
            this.style = style;
            this.braceLocation = braceLocation == null ? null : new NumberRange(braceLocation);
            this.matchingLocation = matchingLocation == null ? null : new NumberRange(matchingLocation);
        }

        public HighlightStyle getHighlightStyle() {
            return this.style;
        }

        public NumberRange getBraceLocation() {
            return this.braceLocation;
        }

        public NumberRange getMatchingLocation() {
            return this.matchingLocation;
        }
    }

    private final class HighlightTask
    implements Runnable {
        private final BraceMatchingTask braceTask;
        private final Collection<BraceResult> results;
        private final BasicDocument document;
        private final int changeId;
        private final HighlightLayer highlightLayer;

        HighlightTask(BraceMatchingTask braceTask, Collection<BraceResult> results, BasicDocument document, int changeId, HighlightLayer highlightLayer) {
            this.braceTask = braceTask;
            this.results = results;
            this.document = document;
            this.changeId = changeId;
            this.highlightLayer = highlightLayer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TextBuffer buffer = this.document.getTextBuffer();
            buffer.readLock();
            try {
                if (BraceMatchingPlugin.this.braceMatchingTask == this.braceTask && buffer.getChangeId() == this.changeId) {
                    for (BraceResult result : this.results) {
                        this.highlightBraces(result);
                    }
                }
            }
            finally {
                buffer.readUnlock();
            }
        }

        private void highlightBraces(BraceResult result) {
            NumberRange matchingLocation;
            NumberRange braceLocation = result.getBraceLocation();
            if (braceLocation != null) {
                this.highlightLayer.addHighlight(result.getHighlightStyle(), braceLocation.start, braceLocation.end);
            }
            if ((matchingLocation = result.getMatchingLocation()) != null) {
                this.highlightLayer.addHighlight(result.getHighlightStyle(), matchingLocation.start, matchingLocation.end);
            }
        }
    }

    private final class BraceMatchingTask
    implements Runnable,
    WriteLockRequestListener {
        private final BasicDocument document;
        private final int offset;
        private final BraceProvider braceProvider;
        private final HighlightLayer highlightLayer;
        private final boolean doBlocks;
        private final boolean doParens;
        private volatile Thread callingThread;

        BraceMatchingTask(BasicDocument document, int offset, BraceProvider braceProvider, HighlightLayer highlightLayer, boolean doBlocks, boolean doParens) {
            this.document = document;
            this.offset = offset;
            this.braceProvider = braceProvider;
            this.highlightLayer = highlightLayer;
            this.doBlocks = doBlocks;
            this.doParens = doParens;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.callingThread = Thread.currentThread();
            ArrayList<BraceResult> results = new ArrayList<BraceResult>();
            TextBuffer buffer = this.document.getTextBuffer();
            buffer.readLock();
            try {
                if (!buffer.addWriteLockRequestListener((WriteLockRequestListener)this)) {
                    int changeId = buffer.getChangeId();
                    this.getBracesOnOffset(results);
                    if (this.braceProvider instanceof ExtendedBraceProvider) {
                        if (!this.isCancelled() && this.doBlocks) {
                            this.getEnclosingBraces(3, (ExtendedBraceProvider)this.braceProvider, enclosingBlockStyle, results);
                        }
                        if (!this.isCancelled() && this.doParens) {
                            this.getEnclosingBraces(1, (ExtendedBraceProvider)this.braceProvider, enclosingParenStyle, results);
                        }
                    }
                    if (!this.isCancelled()) {
                        results.trimToSize();
                        SwingUtilities.invokeLater(new HighlightTask(this, results, this.document, changeId, this.highlightLayer));
                    }
                }
            }
            finally {
                buffer.removeWriteLockRequestListener((WriteLockRequestListener)this);
                buffer.readUnlock();
            }
        }

        public void writeRequested(ReadWriteLock lock) {
            this.callingThread.interrupt();
        }

        private boolean isCancelled() {
            return Thread.interrupted();
        }

        private void getBracesOnOffset(Collection<BraceResult> results) {
            int matchResult;
            int braceToken;
            NumberRange braceLocation = new NumberRange(0, 0);
            NumberRange matchingLocation = new NumberRange(0, 0);
            HighlightStyle style = braceMatchStyle1;
            int lastBraceStart = -1;
            int lastMatchingStart = -1;
            if (this.offset > 0 && (braceToken = this.braceProvider.isPartOfBrace(this.offset - 1, braceLocation)) != -1) {
                lastBraceStart = braceLocation.start;
                matchResult = this.braceProvider.findMatchingBrace(braceToken, braceLocation, matchingLocation);
                if (matchResult == 1 || matchResult == 2) {
                    results.add(new BraceResult(style, braceLocation, matchingLocation));
                    style = braceMatchStyle2;
                    lastMatchingStart = matchingLocation.start;
                } else {
                    results.add(new BraceResult(nonMatchingStyle, braceLocation, null));
                }
            }
            if (this.isCancelled()) {
                return;
            }
            if (this.offset < this.document.getLength() && (braceToken = this.braceProvider.isPartOfBrace(this.offset, braceLocation)) != -1 && braceLocation.start != lastBraceStart && braceLocation.start != lastMatchingStart) {
                matchResult = this.braceProvider.findMatchingBrace(braceToken, braceLocation, matchingLocation);
                if (matchResult == 1 || matchResult == 2) {
                    results.add(new BraceResult(style, braceLocation, matchingLocation));
                } else {
                    results.add(new BraceResult(nonMatchingStyle, braceLocation, null));
                }
            }
        }

        private void getEnclosingBraces(int braceType, ExtendedBraceProvider provider, HighlightStyle styleToUse, Collection<BraceResult> results) {
            NumberRange braceLocation = new NumberRange(0, 0);
            NumberRange matchingLocation = new NumberRange(0, 0);
            int checkOffset = this.offset;
            while (checkOffset > 0 && !this.isCancelled()) {
                int braceToken = provider.findClosestBrace(checkOffset, braceLocation);
                if (braceToken == -1) {
                    return;
                }
                int matchResult = provider.findMatchingBrace(braceToken, braceLocation, matchingLocation);
                if (provider.isOpenBraceType(braceToken)) {
                    int checkType;
                    if (braceType != -1 && braceType != (checkType = provider.getBraceType(braceToken, braceLocation))) {
                        checkOffset = braceLocation.start;
                        continue;
                    }
                    if (matchResult == 1 || matchResult == 2) {
                        if (matchingLocation.start > this.offset) {
                            results.add(new BraceResult(styleToUse, braceLocation, matchingLocation));
                        }
                    } else {
                        results.add(new BraceResult(nonMatchingStyle, braceLocation, null));
                    }
                    return;
                }
                if (provider.isCloseBraceType(braceToken)) {
                    if (matchResult == 1 || matchResult == 2) {
                        checkOffset = matchingLocation.start;
                        continue;
                    }
                    return;
                }
                throw new IllegalStateException("Unrecognized brace type: " + braceToken);
            }
        }
    }
}

