/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.css;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.editor.language.css.CSSAtRuleRenderer;
import oracle.javatools.editor.language.css.CSSBaseRenderer;
import oracle.javatools.editor.language.css.CSSFontFaceRuleRenderer;
import oracle.javatools.editor.language.css.CSSImportRuleRenderer;
import oracle.javatools.editor.language.css.CSSMediaRuleRenderer;
import oracle.javatools.editor.language.css.CSSNamespaceRuleRenderer;
import oracle.javatools.editor.language.css.CSSPageRuleRenderer;
import oracle.javatools.editor.language.css.CSSRuleSetRenderer;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.css.CSSLexer;
import oracle.javatools.parser.css.CSSTokens;

public class CSSBlockRenderer
extends CSSBaseRenderer
implements CSSTokens {
    protected CSSNamespaceRuleRenderer _mNamespaceRuleRenderer;
    protected CSSImportRuleRenderer _mImportRuleRenderer;
    protected CSSMediaRuleRenderer _mMediaRuleRenderer;
    protected CSSPageRuleRenderer _mPageRuleRenderer;
    protected CSSFontFaceRuleRenderer _mFontFaceRenderer;
    protected CSSRuleSetRenderer _mRuleSetRenderer;
    protected CSSAtRuleRenderer _mAtRuleRenderer;
    private List<int[]> _mCommentOffsetList = new ArrayList<int[]>();
    private int _mTextBufferId;

    public CSSBlockRenderer(TextBuffer textBuffer) {
        super(textBuffer);
        this._mTextBufferId = textBuffer.getChangeId();
    }

    @Override
    protected Lexer createLexer() {
        return new CSSLexer();
    }

    @Override
    public void renderBlock(StyledFragmentsList fragmentsList, int blockStartOffset, int blockEndOffset, int clipStartOffset, int clipEndOffset) {
        if (this._mTextBufferId != this.getTextBuffer().getChangeId()) {
            this._mCommentOffsetList.clear();
            this._mTextBufferId = this.getTextBuffer().getChangeId();
        }
        super.renderBlock(fragmentsList, blockStartOffset, blockEndOffset, clipStartOffset, clipEndOffset);
    }

    @Override
    protected void renderToken(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        int newClipStart = Math.max(tokenStart, clipStart);
        int newClipEnd = Math.min(tokenEnd, clipEnd);
        switch (token) {
            case 55: {
                this.renderCSSNamespaceRule(fragmentsList, token, tokenStart, tokenEnd, newClipStart, newClipEnd);
                break;
            }
            case 28: {
                this.renderCSSImportRule(fragmentsList, token, tokenStart, tokenEnd, newClipStart, newClipEnd);
                break;
            }
            case 33: {
                this.renderCSSPageRule(fragmentsList, token, tokenStart, tokenEnd, newClipStart, newClipEnd);
                break;
            }
            case 32: {
                this.renderCSSMediaRule(fragmentsList, token, tokenStart, tokenEnd, newClipStart, newClipEnd);
                break;
            }
            case 31: {
                this.renderCSSFontFaceRule(fragmentsList, token, tokenStart, tokenEnd, newClipStart, newClipEnd);
                break;
            }
            case 100: {
                this.renderCSSRuleSet(fragmentsList, token, tokenStart, tokenEnd, newClipStart, newClipEnd);
                break;
            }
            case 29: 
            case 30: {
                this.renderCSSAtRuleRule(fragmentsList, token, tokenStart, tokenEnd, newClipStart, newClipEnd);
                break;
            }
            default: {
                super.renderToken(fragmentsList, token, tokenStart, tokenEnd, clipStart, clipEnd);
            }
        }
    }

    @Override
    protected String mapTokenToStyleName(int token) {
        switch (token) {
            case 18: {
                return "css-comment-style";
            }
            case -1: {
                return "css-error-style";
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 55: 
            case 100: {
                throw new IllegalStateException("Should be sub-rendering style rules");
            }
        }
        return this.getDefaultStyleName();
    }

    protected void renderCSSRuleSet(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        if (this._mRuleSetRenderer == null) {
            this._mRuleSetRenderer = new CSSRuleSetRenderer(this.getTextBuffer());
        }
        this._mRuleSetRenderer.setCommentOffsetList(this._mCommentOffsetList);
        this._mRuleSetRenderer.renderBlock(fragmentsList, tokenStart, tokenEnd, clipStart, clipEnd);
    }

    protected void renderCSSNamespaceRule(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        if (this._mNamespaceRuleRenderer == null) {
            this._mNamespaceRuleRenderer = new CSSNamespaceRuleRenderer(this.getTextBuffer());
        }
        this._mNamespaceRuleRenderer.setCommentOffsetList(this._mCommentOffsetList);
        this._mNamespaceRuleRenderer.renderBlock(fragmentsList, tokenStart, tokenEnd, clipStart, clipEnd);
    }

    protected void renderCSSImportRule(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        if (this._mImportRuleRenderer == null) {
            this._mImportRuleRenderer = new CSSImportRuleRenderer(this.getTextBuffer());
        }
        this._mImportRuleRenderer.setCommentOffsetList(this._mCommentOffsetList);
        this._mImportRuleRenderer.renderBlock(fragmentsList, tokenStart, tokenEnd, clipStart, clipEnd);
    }

    protected void renderCSSMediaRule(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        if (this._mMediaRuleRenderer == null) {
            this._mMediaRuleRenderer = new CSSMediaRuleRenderer(this.getTextBuffer());
        }
        this._mMediaRuleRenderer.setCommentOffsetList(this._mCommentOffsetList);
        this._mMediaRuleRenderer.renderBlock(fragmentsList, tokenStart, tokenEnd, clipStart, clipEnd);
    }

    protected void renderCSSFontFaceRule(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        if (this._mFontFaceRenderer == null) {
            this._mFontFaceRenderer = new CSSFontFaceRuleRenderer(this.getTextBuffer());
        }
        this._mFontFaceRenderer.setCommentOffsetList(this._mCommentOffsetList);
        this._mFontFaceRenderer.renderBlock(fragmentsList, tokenStart, tokenEnd, clipStart, clipEnd);
    }

    protected void renderCSSPageRule(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        if (this._mPageRuleRenderer == null) {
            this._mPageRuleRenderer = new CSSPageRuleRenderer(this.getTextBuffer());
        }
        this._mPageRuleRenderer.setCommentOffsetList(this._mCommentOffsetList);
        this._mPageRuleRenderer.renderBlock(fragmentsList, tokenStart, tokenEnd, clipStart, clipEnd);
    }

    protected void renderCSSAtRuleRule(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        if (this._mAtRuleRenderer == null) {
            this._mAtRuleRenderer = new CSSAtRuleRenderer(this.getTextBuffer());
        }
        this._mAtRuleRenderer.setCommentOffsetList(this._mCommentOffsetList);
        this._mAtRuleRenderer.renderBlock(fragmentsList, tokenStart, tokenEnd, clipStart, clipEnd);
    }
}

