/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.highlight;

import java.awt.Color;
import java.awt.Graphics;
import oracle.javatools.editor.highlight.UnderlinePainter;

public class SimpleLinePainter
implements UnderlinePainter {
    public static final int MAX_THICKNESS = 4;
    protected final int _thickness;
    protected final int _underlineType;

    public SimpleLinePainter(int thickness, int underlineType) {
        this._thickness = Math.min(Math.max(thickness, 1), 4);
        this._underlineType = underlineType;
        if (this._underlineType != 2 && this._underlineType != 1 && this._underlineType != 0) {
            throw new IllegalArgumentException("invalid type: " + underlineType);
        }
    }

    protected int getYPos(int yTop, int yBaseline, int descent) {
        switch (this._underlineType) {
            case 0: {
                int ascent = yBaseline - yTop;
                return yTop + ascent * 3 / 4;
            }
            case 2: {
                return yBaseline + descent - this._thickness;
            }
        }
        return yBaseline + 1;
    }

    @Override
    public void paintUnderline(Graphics graphics, Color color, int xPos, int width, int yTop, int yBaseline, int descent) {
        int yPos = this.getYPos(yTop, yBaseline, descent);
        graphics.setColor(color);
        graphics.fillRect(xPos, yPos, width, this._thickness);
    }

    @Override
    public int getUnderlineType() {
        return this._underlineType;
    }
}

