/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.folding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.folding.CodeFoldingModel;
import oracle.javatools.editor.folding.CodeFoldingModelEvent;
import oracle.javatools.editor.folding.CodeFoldingModelListener;
import oracle.javatools.editor.folding.DefaultFoldingBlock;
import oracle.javatools.editor.folding.FoldingBlock;

public class DefaultCodeFoldingModel
implements CodeFoldingModel {
    protected static final int MAX_TOOLTIP_LENGTH = 4096;
    protected static final Object[] NO_BLOCKS = new Object[0];
    protected DefaultFoldingBlock root;
    protected BasicDocument document;
    protected EventListenerList listenerList;
    protected ReadWriteLock lock;

    public DefaultCodeFoldingModel(BasicDocument document) {
        this.document = document;
        this.listenerList = new EventListenerList();
        this.lock = new ReadWriteLock();
    }

    public BasicDocument getDocument() {
        return this.document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        FoldingBlock root;
        this.readLock();
        try {
            root = (FoldingBlock)this.getRoot();
        }
        finally {
            this.readUnlock();
        }
        this.fireStructureChanged(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRoot(Object root) {
        DefaultFoldingBlock oldRoot;
        this.writeLock();
        try {
            oldRoot = this.root;
            this.root = (DefaultFoldingBlock)root;
        }
        finally {
            this.writeUnlock();
        }
        if (root != oldRoot) {
            this.fireStructureChanged(this.root);
        }
    }

    public CodeFoldingModelListener[] getCodeFoldingModelListeners() {
        return (CodeFoldingModelListener[])this.listenerList.getListeners(CodeFoldingModelListener.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertUpdate(int offset, int length) {
        this.writeLock();
        try {
            DefaultFoldingBlock root = (DefaultFoldingBlock)this.getRoot();
            if (root != null) {
                this.insertUpdateChildren(root, offset, length);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUpdate(int offset, int length) {
        this.writeLock();
        try {
            DefaultFoldingBlock root = (DefaultFoldingBlock)this.getRoot();
            if (root != null) {
                this.removeUpdateChildren(root, offset, length);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    protected void insertUpdateChildren(DefaultFoldingBlock block, int offset, int length) {
        Iterator it = block.getChildren();
        while (it.hasNext()) {
            DefaultFoldingBlock child = (DefaultFoldingBlock)it.next();
            int startOffset = child.getStartOffset();
            int endOffset = child.getEndOffset();
            if (offset <= startOffset) {
                child.setStartOffset(startOffset + length);
                child.setEndOffset(endOffset + length);
                this.insertUpdateChildren(child, offset, length);
                continue;
            }
            if (offset >= endOffset) continue;
            child.setEndOffset(endOffset + length);
            this.insertUpdateChildren(child, offset, length);
        }
    }

    protected void removeUpdateChildren(DefaultFoldingBlock block, int offset, int length) {
        Iterator it = block.getChildren();
        while (it.hasNext()) {
            DefaultFoldingBlock child = (DefaultFoldingBlock)it.next();
            int startOffset = child.getStartOffset();
            int endOffset = child.getEndOffset();
            if (offset <= startOffset) {
                if (offset + length > startOffset) {
                    it.remove();
                    continue;
                }
                child.setStartOffset(startOffset - length);
                child.setEndOffset(endOffset - length);
                this.removeUpdateChildren(child, offset, length);
                continue;
            }
            if (offset >= endOffset) continue;
            if (offset + length >= endOffset) {
                child.setEndOffset(offset);
            } else {
                child.setEndOffset(endOffset - length);
            }
            this.removeUpdateChildren(child, offset, length);
        }
    }

    @Override
    public void readLock() {
        BasicDocument document = this.getDocument();
        document.readLock();
        this.lock.readLock();
    }

    @Override
    public void readUnlock() {
        BasicDocument document = this.getDocument();
        this.lock.readUnlock();
        document.readUnlock();
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getSmallestEnclosingBlock(int offset) {
        FoldingBlock root = (FoldingBlock)this.getRoot();
        if (root != null) {
            return this.getEnclosingDescendant(root, offset);
        }
        return null;
    }

    @Override
    public Object getFirstBlockAtLine(int line) {
        FoldingBlock root = (FoldingBlock)this.getRoot();
        if (root != null) {
            return this.getFirstDescendantAtLine(root, line);
        }
        return null;
    }

    @Override
    public Object[] getCollapsedBlocks() {
        FoldingBlock root = (FoldingBlock)this.getRoot();
        if (root != null) {
            ArrayList collapsed = new ArrayList();
            this.getCollapsedDescendants(root, collapsed);
            return collapsed.toArray(new Object[collapsed.size()]);
        }
        return NO_BLOCKS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getToolTipText(Object block) {
        String text;
        BasicDocument document = this.getDocument();
        FoldingBlock fb = (FoldingBlock)block;
        int startOffset = fb.getStartOffset();
        int endOffset = fb.getEndOffset();
        int startLine = this.getLineFromOffset(startOffset);
        int offset = this.getLineStartOffset(startLine);
        document.readLock();
        try {
            int length = endOffset - offset;
            length = Math.min(length, 4096);
            text = document.getText(offset, length);
        }
        catch (BadLocationException ex) {
            text = null;
        }
        finally {
            document.readUnlock();
        }
        return text;
    }

    @Override
    public Iterator getChildren(Object parent) {
        FoldingBlock block = (FoldingBlock)parent;
        return block.getChildren();
    }

    @Override
    public Object getParent(Object child) {
        FoldingBlock block = (FoldingBlock)child;
        return block.getParent();
    }

    @Override
    public int[] getTextOffsets(Object block, int[] offsets) {
        if (offsets == null) {
            offsets = new int[2];
        }
        FoldingBlock fb = (FoldingBlock)block;
        offsets[0] = fb.getStartOffset();
        offsets[1] = fb.getEndOffset();
        return offsets;
    }

    @Override
    public String getAbbreviatedText(Object block) {
        FoldingBlock fb = (FoldingBlock)block;
        return fb.getReplacementText();
    }

    @Override
    public boolean isExpanded(Object block) {
        FoldingBlock fb = (FoldingBlock)block;
        return fb.isExpanded();
    }

    @Override
    public void setExpanded(Object block, boolean isExpanded) {
        FoldingBlock fb = (FoldingBlock)block;
        fb.setExpanded(isExpanded);
    }

    @Override
    public void addCodeFoldingModelListener(CodeFoldingModelListener listener) {
        this.listenerList.add(CodeFoldingModelListener.class, listener);
    }

    @Override
    public void removeCodeFoldingModelListener(CodeFoldingModelListener listener) {
        this.listenerList.remove(CodeFoldingModelListener.class, listener);
    }

    protected void writeLock() {
        this.lock.writeLock();
    }

    protected void writeUnlock() {
        this.lock.writeUnlock();
    }

    protected int getLineFromOffset(int offset) {
        BasicDocument document = this.getDocument();
        return document.getLineFromOffset(offset);
    }

    protected int getLineCount() {
        BasicDocument document = this.getDocument();
        return document.getLineCount();
    }

    protected int getLineStartOffset(int line) {
        BasicDocument document = this.getDocument();
        return document.getLineStartOffset(line);
    }

    protected int getLineEndOffset(int line) {
        BasicDocument document = this.getDocument();
        return document.getLineEndOffset(line);
    }

    protected FoldingBlock getFirstDescendantAtLine(FoldingBlock block, int line) {
        FoldingBlock child;
        FoldingBlock ret = null;
        Iterator it = block.getChildren();
        while (it.hasNext()) {
            child = (FoldingBlock)it.next();
            int startOffset = child.getStartOffset();
            int startLine = this.getLineFromOffset(startOffset);
            if (startLine != line) continue;
            if (ret == null) {
                ret = child;
                continue;
            }
            int oldStartOffset = ret.getStartOffset();
            if (startOffset >= oldStartOffset) continue;
            ret = child;
        }
        if (ret == null) {
            it = block.getChildren();
            while (it.hasNext()) {
                child = (FoldingBlock)it.next();
                ret = this.getFirstDescendantAtLine(child, line);
                if (ret == null) continue;
                return ret;
            }
        }
        return ret;
    }

    protected FoldingBlock getEnclosingDescendant(FoldingBlock block, int offset) {
        Iterator it = block.getChildren();
        while (it.hasNext()) {
            FoldingBlock child = (FoldingBlock)it.next();
            if (!child.bounds(offset)) continue;
            FoldingBlock descendant = this.getEnclosingDescendant(child, offset);
            return descendant != null ? descendant : child;
        }
        return null;
    }

    protected void getCollapsedDescendants(FoldingBlock block, Collection collapsed) {
        Iterator it = block.getChildren();
        while (it.hasNext()) {
            FoldingBlock child = (FoldingBlock)it.next();
            boolean expanded = child.isExpanded();
            if (!expanded) {
                collapsed.add(child);
                continue;
            }
            this.getCollapsedDescendants(child, collapsed);
        }
    }

    protected void fireStructureChanged(FoldingBlock block) {
        CodeFoldingModelEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CodeFoldingModelListener.class) continue;
            if (event == null) {
                event = new CodeFoldingModelEvent(this, block);
            }
            CodeFoldingModelListener listener = (CodeFoldingModelListener)listeners[i + 1];
            listener.structureChanged(event);
        }
    }
}

