/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.folding;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.folding.CodeExpansionEvent;
import oracle.javatools.editor.folding.CodeExpansionListener;
import oracle.javatools.editor.folding.CodeExpansionVetoException;
import oracle.javatools.editor.folding.CodeFoldingModel;
import oracle.javatools.editor.folding.CodeFoldingModelEvent;
import oracle.javatools.editor.folding.CodeFoldingModelListener;
import oracle.javatools.editor.folding.CodeFoldingProvider;
import oracle.javatools.editor.folding.CodeWillExpandListener;
import oracle.javatools.editor.folding.FoldingFader;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;

public class CodeFoldingMargin
extends JComponent {
    protected BasicEditorPane editorPane;
    protected CodeFoldingProvider provider;
    protected CodeFoldingModel model;
    protected final int[] TEMP_OFFSETS = new int[2];
    private static final Composite BLOCK_HIGHLIGHT_COMPOSITE = AlphaComposite.getInstance(3, 0.15f);
    private EventHandler eventHandler;
    private PopupCodeWindow popupWindow;
    private Icon expandedIcon;
    private Icon collapsedIcon;
    private Point lastMousePosition;
    private int lastCaretPosition;
    private MouseAutoExpandListener _mouseAutoExpandListener;

    public CodeFoldingMargin(CodeFoldingProvider provider) {
        this.provider = provider;
        this.setOpaque(true);
        Border border = this.createBorder();
        this.setBorder(border);
    }

    public CodeFoldingModel getModel() {
        return this.model;
    }

    public CodeFoldingProvider getProvider() {
        return this.provider;
    }

    public void setModel(CodeFoldingModel model) {
        CodeFoldingModel oldModel = this.getModel();
        if (model != oldModel) {
            if (oldModel != null) {
                oldModel.removeCodeFoldingModelListener(this.eventHandler);
            }
            this.model = model;
            this.editorPane.putProperty("code-folding-model", model);
            if (model != null) {
                model.addCodeFoldingModelListener(this.eventHandler);
            }
        }
    }

    public void setExpansionState(Object block, boolean expand) {
        this.setExpansionState(block, expand, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setExpansionState(Object block, boolean expand, boolean fadeBlock) {
        CodeFoldingModel model = this.getModel();
        if (expand == model.isExpanded(block)) {
            return;
        }
        if (expand) {
            Object parent;
            model.readLock();
            try {
                parent = model.getParent(block);
            }
            finally {
                model.readUnlock();
            }
            if (parent != null && !model.isExpanded(parent)) {
                this.setExpansionState(parent, expand);
            }
            try {
                this.fireCodeWillExpand(block);
            }
            catch (CodeExpansionVetoException ex) {
                return;
            }
            if (fadeBlock) {
                this._fadeBlock(block);
            }
            model.setExpanded(block, expand);
            this.fireCodeExpanded(block);
        } else {
            try {
                this.fireCodeWillCollapse(block);
            }
            catch (CodeExpansionVetoException ex) {
                return;
            }
            model.readLock();
            try {
                int caretPosition = this.getCaretPosition();
                if (this.blockContainsOffset(model, block, caretPosition)) {
                    int[] nArray = this.TEMP_OFFSETS;
                    // MONITORENTER : this.TEMP_OFFSETS
                    model.getTextOffsets(block, this.TEMP_OFFSETS);
                    int blockEnd = this.TEMP_OFFSETS[1];
                    // MONITOREXIT : nArray
                    this.editorPane.setCaretPosition(blockEnd);
                }
            }
            finally {
                model.readUnlock();
            }
            if (fadeBlock) {
                this._fadeBlock(block);
            }
            model.setExpanded(block, expand);
            this.fireCodeCollapsed(block);
        }
        this.repaint();
    }

    private void _fadeBlock(Object block) {
        int[] offsets = new int[2];
        this.getModel().getTextOffsets(block, offsets);
        FoldingFader.fadeBlock(this.model, block, offsets, this.editorPane);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean expandEnclosingBlocks(int position) {
        CodeFoldingModel model = this.getModel();
        if (model == null) {
            return false;
        }
        model.readLock();
        try {
            Object root = model.getRoot();
            boolean bl = this.expandEnclosingChild(model, root, position);
            return bl;
        }
        finally {
            model.readUnlock();
        }
    }

    public void addCodeWillExpandListener(CodeWillExpandListener listener) {
        this.listenerList.add(CodeWillExpandListener.class, listener);
    }

    public void removeCodeWillExpandListener(CodeWillExpandListener listener) {
        this.listenerList.remove(CodeWillExpandListener.class, listener);
    }

    public CodeWillExpandListener[] getCodeWillExpandListeners() {
        return (CodeWillExpandListener[])this.listenerList.getListeners(CodeWillExpandListener.class);
    }

    public void addCodeExpansionListener(CodeExpansionListener listener) {
        this.listenerList.add(CodeExpansionListener.class, listener);
    }

    public void removeCodeExpansionListener(CodeExpansionListener listener) {
        this.listenerList.remove(CodeExpansionListener.class, listener);
    }

    public CodeExpansionListener[] getCodeExpansionListeners() {
        return (CodeExpansionListener[])this.listenerList.getListeners(CodeExpansionListener.class);
    }

    protected void attach(BasicEditorPane editorPane) {
        this.editorPane = editorPane;
        this.eventHandler = new EventHandler(this);
        CodeFoldingModel model = this.createCodeFoldingModel(editorPane);
        this.setModel(model);
        this.addMouseListener(this.eventHandler);
        this.addMouseMotionListener(this.eventHandler);
        editorPane.addCaretListener(this.eventHandler);
        editorPane.addPropertyChangeListener(this.eventHandler);
        editorPane.addComponentListener(this.eventHandler);
        editorPane.addAncestorListener(this.eventHandler);
        editorPane.putProperty("code-folding-margin", this);
        this._mouseAutoExpandListener = new MouseAutoExpandListener();
        editorPane.addMouseListener(this._mouseAutoExpandListener);
        Color fg = (Color)editorPane.getProperty("right-margin-color");
        this.setForeground(fg);
        this.setBackground(editorPane.getBackground());
    }

    protected void detach(BasicEditorPane editorPane) {
        assert (GraphicsEnvironment.isHeadless() || SwingUtilities.isEventDispatchThread());
        editorPane.putProperty("code-folding-margin", null);
        this.disposePopupWindow();
        this.removeMouseListener(this.eventHandler);
        this.removeMouseMotionListener(this.eventHandler);
        editorPane.removeCaretListener(this.eventHandler);
        editorPane.addPropertyChangeListener(this.eventHandler);
        editorPane.removeComponentListener(this.eventHandler);
        editorPane.removeMouseListener(this._mouseAutoExpandListener);
        editorPane.removeAncestorListener(this.eventHandler);
        this.setModel(null);
        this.eventHandler = null;
        this.editorPane = null;
    }

    protected CodeFoldingModel createCodeFoldingModel(BasicEditorPane editorPane) {
        CodeFoldingProvider provider = this.getProvider();
        return provider.createModel(editorPane);
    }

    protected Border createBorder() {
        Border insideBorder = BorderFactory.createEmptyBorder(0, 1, 0, 1);
        DottedRightBorder outsideBorder = new DottedRightBorder();
        return BorderFactory.createCompoundBorder(outsideBorder, insideBorder);
    }

    protected int getPreferredWidth() {
        Icon collapsedIcon;
        int width = 0;
        Icon expandedIcon = this.getExpandedIcon();
        if (expandedIcon != null) {
            width = Math.max(width, expandedIcon.getIconWidth());
        }
        if ((collapsedIcon = this.getCollapsedIcon()) != null) {
            width = Math.max(width, collapsedIcon.getIconWidth());
        }
        Insets insets = this.getInsets();
        return width += insets.left + insets.right;
    }

    protected int getPreferredHeight() {
        BasicEditorPane editor = this.getEditorPane();
        if (editor != null) {
            return editor.getHeight();
        }
        return 0;
    }

    protected BasicEditorPane getEditorPane() {
        return this.editorPane;
    }

    protected BasicDocument getDocument() {
        BasicEditorPane editorPane = this.getEditorPane();
        return (BasicDocument)editorPane.getDocument();
    }

    protected CodeFoldingProvider getFoldingProvider() {
        return this.provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean blockContainsOffset(CodeFoldingModel model, Object block, int offset) {
        int[] nArray = this.TEMP_OFFSETS;
        synchronized (this.TEMP_OFFSETS) {
            model.getTextOffsets(block, this.TEMP_OFFSETS);
            int blockStart = this.TEMP_OFFSETS[0];
            int blockEnd = this.TEMP_OFFSETS[1];
            // ** MonitorExit[var6_4] (shouldn't be in output)
            return offset > blockStart && offset < blockEnd;
        }
    }

    protected boolean expandEnclosingChild(CodeFoldingModel model, Object block, int offset) {
        Iterator it = model.getChildren(block);
        while (it.hasNext()) {
            Object child = it.next();
            if (!this.blockContainsOffset(model, child, offset)) continue;
            boolean expanded = model.isExpanded(child);
            if (!expanded) {
                this.setExpansionState(child, true);
            }
            return this.expandEnclosingChild(model, child, offset) || !expanded;
        }
        return false;
    }

    public Object getLargestCollapsedBlock(CodeFoldingModel model, Object block, int offset) {
        Iterator it = model.getChildren(block);
        while (it.hasNext()) {
            Object child = it.next();
            if (!this.blockContainsOffset(model, child, offset)) continue;
            if (!model.isExpanded(child)) {
                return child;
            }
            Object retBlock = this.getLargestCollapsedBlock(model, child, offset);
            if (retBlock == null) continue;
            return retBlock;
        }
        return null;
    }

    protected Object getSmallestEnclosingBlock(int offset) {
        CodeFoldingModel model = this.getModel();
        return model != null ? model.getSmallestEnclosingBlock(offset) : null;
    }

    protected Object getFirstBlockAtLine(int line) {
        CodeFoldingModel model = this.getModel();
        return model.getFirstBlockAtLine(line);
    }

    protected Icon getExpandedIcon() {
        if (this.expandedIcon == null) {
            this.expandedIcon = this.createExpandedIcon();
        }
        return this.expandedIcon;
    }

    protected Icon getCollapsedIcon() {
        if (this.collapsedIcon == null) {
            this.collapsedIcon = this.createCollapsedIcon();
        }
        return this.collapsedIcon;
    }

    protected Icon createExpandedIcon() {
        Icon icon = UIManager.getIcon("Tree.expandedIcon");
        if (icon == null) {
            icon = UIManager.getIcon("Tree.openIcon");
        }
        return icon;
    }

    protected Icon createCollapsedIcon() {
        Icon icon = UIManager.getIcon("Tree.collapsedIcon");
        if (icon == null) {
            icon = UIManager.getIcon("Tree.closedIcon");
        }
        return icon;
    }

    protected int getYCoordinateFromOffset(int offset) {
        BasicEditorPane editor = this.getEditorPane();
        BasicDocument document = this.getDocument();
        LineMap lineMap = document.getLineMap();
        int line = lineMap.getLineFromOffset(offset);
        offset = lineMap.getLineStartOffset(line);
        try {
            Rectangle offsetRect = editor.modelToView(offset);
            return offsetRect.y;
        }
        catch (BadLocationException e) {
            return 0;
        }
    }

    protected int getLineFromRow(int row) {
        BasicEditorPane editor = this.getEditorPane();
        int fontHeight = this.getFontHeight();
        int adjustedRow = row;
        Insets insets = editor.getInsets();
        int y = adjustedRow * fontHeight + insets.top;
        int rowStart = editor.viewToModel(new Point(0, y));
        BasicDocument document = this.getDocument();
        LineMap lineMap = document.getLineMap();
        return lineMap.getLineFromOffset(rowStart);
    }

    protected int getRowCount() {
        BasicEditorPane editor = this.getEditorPane();
        int fontHeight = this.getFontHeight();
        Insets insets = editor.getInsets();
        int insetHeight = insets.top + insets.bottom;
        int editorHeight = editor.getHeight();
        int numberRows = (editorHeight - insetHeight) / fontHeight;
        int blankLines = editor.getIntegerProperty("trailing-blank-rows");
        return numberRows - blankLines;
    }

    protected int getClosestLineFromCoordinate(int y) {
        int topPadding = this.getTopPadding();
        int adjustedY = y - topPadding;
        if (adjustedY < 0) {
            adjustedY = 0;
        }
        int fontHeight = this.getFontHeight();
        int rowCount = this.getRowCount();
        int row = Math.min(adjustedY / fontHeight, rowCount);
        return this.getLineFromRow(row);
    }

    protected int getLineFromOffset(int offset) {
        BasicEditorPane editorPane = this.getEditorPane();
        return editorPane.getLineFromOffset(offset);
    }

    protected int getLineStartOffset(int line) {
        BasicEditorPane editorPane = this.getEditorPane();
        return editorPane.getLineStartOffset(line);
    }

    protected int getTopPadding() {
        BasicEditorPane editorPane = this.getEditorPane();
        Insets editorInsets = editorPane.getInsets();
        Insets insets = this.getInsets();
        return editorInsets.top - insets.top;
    }

    protected int getFontHeight() {
        BasicEditorPane editorPane = this.getEditorPane();
        Font font = editorPane.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        return fontMetrics.getHeight();
    }

    protected int getLineCount() {
        BasicDocument document = this.getDocument();
        LineMap lineMap = document.getLineMap();
        return lineMap.getLineCount();
    }

    protected int getCaretPosition() {
        BasicEditorPane editorPane = this.getEditorPane();
        return editorPane != null ? editorPane.getCaretPosition() : 0;
    }

    protected void ensurePositionVisible(int position) {
        BasicEditorPane editorPane = this.getEditorPane();
        editorPane.ensurePositionVisible(position);
    }

    protected int getBlankLines() {
        BasicEditorPane editorPane = this.getEditorPane();
        return editorPane.getIntegerProperty("trailing-blank-rows");
    }

    protected boolean isCodeFoldingHighlight() {
        BasicEditorPane editorPane = this.getEditorPane();
        return editorPane.getBooleanProperty("code-folding-highlight");
    }

    protected boolean isCodeFoldingEnabled() {
        CodeFoldingModel model = this.getModel();
        BasicEditorPane editorPane = this.getEditorPane();
        return model != null && editorPane.getBooleanProperty("code-folding-enabled");
    }

    protected void fireCodeWillExpand(Object block) throws CodeExpansionVetoException {
        CodeExpansionEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CodeWillExpandListener.class) continue;
            if (event == null) {
                BasicEditorPane editorPane = this.getEditorPane();
                event = new CodeExpansionEvent(editorPane, block);
            }
            CodeWillExpandListener listener = (CodeWillExpandListener)listeners[i + 1];
            listener.codeWillExpand(event);
        }
    }

    protected void fireCodeExpanded(Object block) {
        CodeExpansionEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CodeExpansionListener.class) continue;
            if (event == null) {
                BasicEditorPane editorPane = this.getEditorPane();
                event = new CodeExpansionEvent(editorPane, block);
            }
            CodeExpansionListener listener = (CodeExpansionListener)listeners[i + 1];
            listener.codeExpanded(event);
        }
    }

    protected void fireCodeWillCollapse(Object block) throws CodeExpansionVetoException {
        CodeExpansionEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CodeWillExpandListener.class) continue;
            if (event == null) {
                BasicEditorPane editorPane = this.getEditorPane();
                event = new CodeExpansionEvent(editorPane, block);
            }
            CodeWillExpandListener listener = (CodeWillExpandListener)listeners[i + 1];
            listener.codeWillCollapse(event);
        }
    }

    protected void fireCodeCollapsed(Object block) {
        CodeExpansionEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CodeExpansionListener.class) continue;
            if (event == null) {
                BasicEditorPane editorPane = this.getEditorPane();
                event = new CodeExpansionEvent(editorPane, block);
            }
            CodeExpansionListener listener = (CodeExpansionListener)listeners[i + 1];
            listener.codeCollapsed(event);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int width = this.getPreferredWidth();
        int height = this.getPreferredHeight();
        return new Dimension(width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Rectangle clipBounds = g.getClipBounds();
        int width = this.getWidth();
        SwingUtilities.computeIntersection(0, 0, width, this.getHeight(), clipBounds);
        if (this.isOpaque()) {
            g2.setColor(this.getBackground());
            g2.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
        }
        Color selectionColor = UIManager.getColor("textHighlight");
        int yClip = clipBounds.y + clipBounds.height;
        int fontHeight = this.getFontHeight();
        CodeFoldingModel model = this.getModel();
        if (model == null) {
            return;
        }
        model.readLock();
        try {
            Object root;
            int caretPosition;
            Object block;
            if (this.isCodeFoldingHighlight() && (block = this.getSmallestEnclosingBlock(caretPosition = this.getLastCaretPosition())) != null) {
                int[] nArray = this.TEMP_OFFSETS;
                // MONITORENTER : this.TEMP_OFFSETS
                model.getTextOffsets(block, this.TEMP_OFFSETS);
                int blockStart = this.TEMP_OFFSETS[0];
                int blockEnd = this.TEMP_OFFSETS[1];
                // MONITOREXIT : nArray
                int yStart = this.getYCoordinateFromOffset(blockStart);
                yStart = Math.max(yStart, clipBounds.y);
                int yEnd = this.getYCoordinateFromOffset(blockEnd) + fontHeight;
                yEnd = Math.min(yEnd, yClip);
                if (yEnd > yStart) {
                    Composite oldComposite = g2.getComposite();
                    g2.setColor(selectionColor);
                    g2.setComposite(BLOCK_HIGHLIGHT_COMPOSITE);
                    g2.fillRect(0, yStart, width, yEnd - yStart);
                    g2.setComposite(oldComposite);
                }
            }
            if (!this.isCodeFoldingEnabled()) return;
            Point mousePosition = this.getLastMousePosition();
            if (mousePosition != null) {
                int mouseLine = this.getClosestLineFromCoordinate(mousePosition.y);
                Object block2 = this.getFirstBlockAtLine(mouseLine);
                if (block2 == null) {
                    int mouseStartOffset = this.getLineStartOffset(mouseLine);
                    block2 = this.getSmallestEnclosingBlock(mouseStartOffset);
                }
                if (block2 != null && model.isExpanded(block2)) {
                    int[] yEnd = this.TEMP_OFFSETS;
                    // MONITORENTER : this.TEMP_OFFSETS
                    model.getTextOffsets(block2, this.TEMP_OFFSETS);
                    int blockStart = this.TEMP_OFFSETS[0];
                    int blockEnd = this.TEMP_OFFSETS[1];
                    // MONITOREXIT : yEnd
                    int yStart = this.getYCoordinateFromOffset(blockStart) + fontHeight / 2;
                    yStart = Math.max(yStart, clipBounds.y);
                    int yEnd2 = this.getYCoordinateFromOffset(blockEnd) + fontHeight - 1;
                    yEnd2 = Math.min(yEnd2, yClip);
                    if (yEnd2 >= yStart) {
                        Insets insets = this.getInsets();
                        int x = (width + insets.left - insets.right) / 2;
                        g2.setColor(selectionColor);
                        g2.drawLine(x, yStart, x, yEnd2);
                        if (yEnd2 <= yClip) {
                            g2.drawLine(x, yEnd2, x + 2, yEnd2);
                        }
                    }
                }
            }
            if ((root = model.getRoot()) == null) return;
            this.paintChildTurners(g2, clipBounds, model, root);
            return;
        }
        catch (ExpiredTextBufferException e) {
            return;
        }
        finally {
            model.readUnlock();
        }
    }

    protected void paintChildTurners(Graphics g, Rectangle clipBounds, CodeFoldingModel model, Object block) {
        Iterator it = model.getChildren(block);
        while (it.hasNext()) {
            Object child = it.next();
            if (this.isTurnerDamaged(clipBounds, model, child)) {
                this.paintTurner(g, model, child);
            }
            if (!model.isExpanded(child)) continue;
            this.paintChildTurners(g, clipBounds, model, child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintTurner(Graphics g, CodeFoldingModel model, Object block) {
        boolean isExpanded = model.isExpanded(block);
        Icon expandedIcon = this.getExpandedIcon();
        Icon collapsedIcon = this.getCollapsedIcon();
        Icon icon = isExpanded ? expandedIcon : collapsedIcon;
        int[] nArray = this.TEMP_OFFSETS;
        synchronized (this.TEMP_OFFSETS) {
            model.getTextOffsets(block, this.TEMP_OFFSETS);
            int blockStart = this.TEMP_OFFSETS[0];
            // ** MonitorExit[var9_8] (shouldn't be in output)
            int yStart = this.getYCoordinateFromOffset(blockStart);
            int iconHeight = icon.getIconHeight();
            int iconWidth = icon.getIconWidth();
            int fontHeight = this.getFontHeight();
            int width = this.getWidth();
            int x = (width - iconWidth) / 2;
            int y = yStart + (fontHeight - iconHeight) / 2;
            icon.paintIcon(this, g, x, y);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isTurnerDamaged(Rectangle clipBounds, CodeFoldingModel model, Object block) {
        int[] nArray = this.TEMP_OFFSETS;
        synchronized (this.TEMP_OFFSETS) {
            model.getTextOffsets(block, this.TEMP_OFFSETS);
            int blockStart = this.TEMP_OFFSETS[0];
            // ** MonitorExit[var5_4] (shouldn't be in output)
            int fontHeight = this.getFontHeight();
            int yStart = this.getYCoordinateFromOffset(blockStart);
            int yEnd = yStart + fontHeight;
            return yStart <= clipBounds.y + clipBounds.height && yEnd >= clipBounds.y;
        }
    }

    private Point getLastMousePosition() {
        return this.lastMousePosition;
    }

    private void setLastMousePosition(Point lastMousePosition) {
        this.lastMousePosition = lastMousePosition;
        this.repaint();
    }

    private int getLastCaretPosition() {
        return this.lastCaretPosition;
    }

    private void setLastCaretPosition(int lastCaretPosition) {
        this.lastCaretPosition = lastCaretPosition;
    }

    private PopupCodeWindow getPopupWindow() {
        if (this.popupWindow == null) {
            BasicEditorPane editorPane = this.getEditorPane();
            this.popupWindow = new PopupCodeWindow(editorPane);
        }
        return this.popupWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showPopupWindow(Point mousePos, Point lastPos) {
        if (this.isCodeFoldingEnabled()) {
            BasicDocument document = this.getDocument();
            document.readLock();
            try {
                int lastLine;
                int y = mousePos.y;
                int line = this.getClosestLineFromCoordinate(y);
                if (lastPos != null && line == (lastLine = this.getClosestLineFromCoordinate(lastPos.y))) {
                    return;
                }
                this.hidePopupWindow();
                CodeFoldingModel model = this.getModel();
                model.readLock();
                try {
                    Object block = this.getFirstBlockAtLine(line);
                    if (block != null && !model.isExpanded(block)) {
                        this.popupWindow = this.getPopupWindow();
                        String documentText = model.getToolTipText(block);
                        this.popupWindow.setText(documentText);
                        Point marginPos = this.getLocationOnScreen();
                        Insets popupInsets = this.popupWindow.getPopupInsets();
                        int lineOffset = this.getLineStartOffset(line);
                        int xPos = marginPos.x + this.getWidth() - popupInsets.left;
                        int yPos = marginPos.y + this.getYCoordinateFromOffset(lineOffset) - popupInsets.top;
                        this.popupWindow.setLocation(xPos, yPos);
                        Dimension contentSize = this.popupWindow.getContentPane().getPreferredSize();
                        this.popupWindow.setSize(contentSize.width, contentSize.height);
                        this.popupWindow.validate();
                        this.popupWindow.setVisible(true);
                    }
                }
                finally {
                    model.readUnlock();
                }
            }
            finally {
                document.readUnlock();
            }
        }
    }

    private void hidePopupWindow() {
        if (this.isCodeFoldingEnabled() && this.popupWindow != null) {
            this.popupWindow.setVisible(false);
        }
    }

    private void disposePopupWindow() {
        if (this.isCodeFoldingEnabled() && this.popupWindow != null) {
            this.popupWindow.dispose();
            this.popupWindow = null;
        }
    }

    private class MouseAutoExpandListener
    extends MouseAdapter {
        private MouseAutoExpandListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                int offset = CodeFoldingMargin.this.getEditorPane().viewToModel(e.getPoint()) - 1;
                CodeFoldingModel model = CodeFoldingMargin.this.getModel();
                if (model == null) {
                    return;
                }
                Object block = null;
                model.readLock();
                try {
                    block = CodeFoldingMargin.this.getLargestCollapsedBlock(model, model.getRoot(), offset);
                }
                finally {
                    model.readUnlock();
                }
                if (block != null) {
                    CodeFoldingMargin.this.setExpansionState(block, true, true);
                }
            }
        }
    }

    private static final class PopupCodeWindow
    extends JWindow {
        private JScrollPane popupScrollPane;
        private BasicEditorPane popupEditorPane;

        public PopupCodeWindow(BasicEditorPane editorPane) {
            super(SwingUtilities.getWindowAncestor(editorPane));
            this.initializeFrom(editorPane);
        }

        public void setText(String text) {
            this.popupEditorPane.setText(text);
        }

        public String getText() {
            return this.popupEditorPane.getText();
        }

        public Insets getPopupInsets() {
            Insets ret = super.getInsets();
            for (Container c = this.popupEditorPane; c != this; c = c.getParent()) {
                Insets insets = ((Container)c).getInsets();
                ret.top += insets.top;
                ret.left += insets.left;
                ret.bottom += insets.bottom;
                ret.right += insets.right;
            }
            return ret;
        }

        private void initializeFrom(BasicEditorPane editorPane) {
            BasicDocument document = (BasicDocument)editorPane.getDocument();
            LanguageSupport support = document.getLanguageSupport();
            LanguageSupport popupSupport = LanguageModule.createSupportForFileType(support.getClass());
            BasicDocument popupDocument = new BasicDocument();
            popupDocument.setLanguageSupport(popupSupport);
            this.popupEditorPane = new BasicEditorPane();
            this.popupEditorPane.setDocument(popupDocument);
            this.popupEditorPane.setBorder(BorderFactory.createEmptyBorder());
            this.popupEditorPane.setOpaque(false);
            Border outerBorder = UIManager.getBorder("ToolTip.border");
            this.popupScrollPane = new JScrollPane(this.popupEditorPane);
            this.popupScrollPane.setBorder(outerBorder);
            this.popupScrollPane.setBackground(UIManager.getColor("ToolTip.background"));
            Insets editorInsets = editorPane.getInsets();
            Border innerBorder = BorderFactory.createEmptyBorder(0, editorInsets.left, 0, editorInsets.right);
            this.popupScrollPane.setViewportBorder(innerBorder);
            this.popupScrollPane.getViewport().setOpaque(false);
            this.getContentPane().add(this.popupScrollPane);
            this.setFocusableWindowState(false);
        }
    }

    private static final class EventHandler
    implements ActionListener,
    CaretListener,
    ComponentListener,
    MouseListener,
    MouseMotionListener,
    PropertyChangeListener,
    CodeFoldingModelListener,
    AncestorListener {
        private static final int CARET_UPDATE_DELAY_MSEC = 150;
        private CodeFoldingMargin margin;
        private Timer caretUpdateTimer;

        public EventHandler(CodeFoldingMargin margin) {
            this.margin = margin;
            this.caretUpdateTimer = new Timer(150, this);
            this.caretUpdateTimer.setRepeats(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.caretUpdateTimer) {
                this.updateMargin();
            }
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            this.caretUpdateTimer.restart();
            int caretPosition = e.getDot();
            if (this.margin.expandEnclosingBlocks(caretPosition)) {
                this.margin.ensurePositionVisible(caretPosition);
            }
        }

        private void updateMargin() {
            int caretPosition = this.margin.getCaretPosition();
            this.margin.setLastCaretPosition(caretPosition);
            this.margin.repaint();
        }

        @Override
        public void componentResized(ComponentEvent event) {
            this.margin.invalidate();
        }

        @Override
        public void componentMoved(ComponentEvent event) {
        }

        @Override
        public void componentShown(ComponentEvent event) {
        }

        @Override
        public void componentHidden(ComponentEvent event) {
        }

        private boolean isValidXCoordinate(MouseEvent e) {
            Component c = e.getComponent();
            int x = e.getX();
            return x > 0 && x < c.getWidth() - 1;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (this.isValidXCoordinate(e)) {
                Point mousePos = e.getPoint();
                Point lastPos = this.margin.getLastMousePosition();
                this.margin.showPopupWindow(mousePos, lastPos);
                this.margin.setLastMousePosition(mousePos);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.margin.hidePopupWindow();
            this.margin.setLastMousePosition(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mousePressed(MouseEvent e) {
            this.margin.hidePopupWindow();
            BasicEditorPane editorPane = this.getEditorPane();
            if (!editorPane.hasFocus()) {
                editorPane.requestFocus();
            }
            if (e.isPopupTrigger()) {
                this.showContextMenu(e);
            } else if (this.margin.isCodeFoldingEnabled() && e.getButton() == 1) {
                CodeFoldingModel model = this.getModel();
                model.readLock();
                try {
                    int line = this.margin.getClosestLineFromCoordinate(e.getY());
                    Object block = this.margin.getFirstBlockAtLine(line);
                    if (block != null) {
                        boolean isExpanded = model.isExpanded(block);
                        this.margin.setExpansionState(block, !isExpanded, true);
                    }
                }
                finally {
                    model.readUnlock();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showContextMenu(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        private void showContextMenu(MouseEvent e) {
            CodeFoldingProvider provider;
            JPopupMenu popup;
            if (this.margin.isCodeFoldingEnabled() && (popup = (provider = this.getProvider()).getPopupMenu()) != null && popup.getComponentCount() > 0) {
                popup.show(this.margin, e.getX(), e.getY());
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.mouseEntered(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String property;
            BasicEditorPane editorPane;
            Object source = e.getSource();
            if (source == (editorPane = this.getEditorPane()) && (property = e.getPropertyName()).equals("background")) {
                this.margin.setBackground(editorPane.getBackground());
            }
        }

        @Override
        public void structureChanged(CodeFoldingModelEvent e) {
            this.margin.repaint();
        }

        private CodeFoldingProvider getProvider() {
            return this.margin.getProvider();
        }

        private CodeFoldingModel getModel() {
            return this.margin.getModel();
        }

        private BasicEditorPane getEditorPane() {
            return this.margin.getEditorPane();
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            this.margin.hidePopupWindow();
            this.margin.setLastMousePosition(null);
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    }

    private static final class DottedRightBorder
    extends AbstractBorder {
        private static int DASH_LENGTH = 3;
        private static int DASH_GAP = 3;
        private static int DASH_CYCLE = DASH_LENGTH + DASH_GAP;
        private static final BasicStroke DASHED_STROKE = new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{DASH_LENGTH, DASH_GAP}, 0.0f);
        public static final int WIDTH = 1;

        private DottedRightBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(c.getForeground());
            g2.setStroke(DASHED_STROKE);
            Rectangle clipRect = g2.getClipBounds();
            int y1 = Math.max(y, clipRect.y) / DASH_CYCLE * DASH_CYCLE;
            int y2 = Math.min(y + height - 1, clipRect.y + clipRect.height);
            g2.drawLine(x + width - 1, y1, x + width - 1, y2);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            Insets insets = new Insets(0, 0, 0, 0);
            return this.getBorderInsets(c, insets);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.bottom = 0;
            insets.top = 0;
            insets.left = 0;
            insets.right = 1;
            return insets;
        }
    }
}

