/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.WordLocator;

public final class Utilities {
    public static int getTextWidth(TextBuffer textBuffer, int startOffset, int endOffset, int tabSize, int startColumn) {
        int bufferEnd = textBuffer.getLength();
        startOffset = Math.min(Math.max(0, startOffset), bufferEnd);
        endOffset = Math.min(Math.max(0, endOffset), bufferEnd);
        int currentOffset = startOffset;
        int currentColumn = startColumn;
        block4: while (currentOffset < endOffset) {
            char c = textBuffer.getChar(currentOffset++);
            switch (c) {
                case '\t': {
                    currentColumn = Utilities.getNextTabStop(tabSize, currentColumn);
                }
                case '\n': 
                case '\r': {
                    continue block4;
                }
            }
            ++currentColumn;
        }
        return currentColumn - startColumn;
    }

    public static int getNextTabStop(int tabSize, int startColumn) {
        if (tabSize <= 0 || startColumn < 0) {
            throw new IllegalArgumentException("bad tab size or column");
        }
        switch (tabSize) {
            case 1: {
                return startColumn + 1;
            }
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                return (startColumn & ~(tabSize - 1)) + tabSize;
            }
        }
        int tabColumn = startColumn - startColumn % tabSize + tabSize;
        return tabColumn;
    }

    public static int getColumnFromOffset(TextBuffer textBuffer, int offset, int tabSize) {
        LineMap lineMap = textBuffer.getLineMap();
        int line = lineMap.getLineFromOffset(offset);
        return Utilities.getColumnFromOffset(textBuffer, line, offset, tabSize);
    }

    public static int getColumnFromOffset(TextBuffer textBuffer, int line, int offset, int tabSize) {
        LineMap lineMap = textBuffer.getLineMap();
        int lineStart = lineMap.getLineStartOffset(line);
        if (lineStart == offset) {
            return 0;
        }
        return Utilities.getTextWidth(textBuffer, lineStart, offset, tabSize, 0);
    }

    public static int getOffsetFromColumn(TextBuffer textBuffer, int line, int column, int tabSize) {
        LineMap lineMap = textBuffer.getLineMap();
        int lineStart = lineMap.getLineStartOffset(line);
        int lineEnd = lineMap.getLineEndOffset(line);
        if (column == 0) {
            return lineStart;
        }
        int currentOffset = lineStart;
        int currentColumn = 0;
        boolean done = false;
        while (!done && currentOffset < lineEnd) {
            char c = textBuffer.getChar(currentOffset);
            switch (c) {
                case '\t': {
                    ++currentOffset;
                    currentColumn = Utilities.getNextTabStop(tabSize, currentColumn);
                    break;
                }
                case '\n': 
                case '\r': {
                    return currentOffset;
                }
                default: {
                    ++currentOffset;
                    ++currentColumn;
                }
            }
            if (currentColumn < column) continue;
            if (currentColumn <= column) break;
            --currentOffset;
            break;
        }
        return currentOffset;
    }

    public static int getRowStart(BasicDocument document, int offset) {
        offset = Math.max(offset, 0);
        offset = Math.min(offset, document.getLength());
        LineMap lineMap = document.getLineMap();
        int currentLine = lineMap.getLineFromOffset(offset);
        int lineStart = lineMap.getLineStartOffset(currentLine);
        return lineStart;
    }

    public static int getRowEnd(BasicDocument document, int offset) {
        offset = Math.max(offset, 0);
        offset = Math.min(offset, document.getLength());
        LineMap lineMap = document.getLineMap();
        int currentLine = lineMap.getLineFromOffset(offset);
        int lineEnd = lineMap.getLineEndOffset(currentLine);
        int lineCount = lineMap.getLineCount();
        if (lineCount - 1 != currentLine) {
            --lineEnd;
        }
        return lineEnd;
    }

    private static WordLocator getWordLocator(BasicDocument document) {
        LanguageSupport support = document.getLanguageSupport();
        return support.getWordLocator();
    }

    public static int getWordStart(BasicDocument document, int offset) {
        WordLocator locator = Utilities.getWordLocator(document);
        return locator.getWordStart(offset);
    }

    public static int getWordEnd(BasicDocument document, int offset) {
        WordLocator locator = Utilities.getWordLocator(document);
        return locator.getWordEnd(offset);
    }

    public static int getNextWordStart(BasicDocument document, int offset) {
        WordLocator locator = Utilities.getWordLocator(document);
        int wordStart = locator.getNextWordStart(offset);
        return wordStart;
    }

    public static int getNextWordEnd(BasicDocument document, int offset) {
        WordLocator locator = Utilities.getWordLocator(document);
        int wordEnd = locator.getNextWordEnd(offset);
        return wordEnd;
    }

    public static int getPreviousWordStart(BasicDocument document, int offset) {
        WordLocator locator = Utilities.getWordLocator(document);
        int wordStart = locator.getPreviousWordStart(offset);
        return wordStart;
    }

    public static int getPreviousWordEnd(BasicDocument document, int offset) {
        WordLocator locator = Utilities.getWordLocator(document);
        int wordEnd = locator.getPreviousWordEnd(offset);
        return wordEnd;
    }

    public static boolean testBit(int value, int flag) {
        return (value & flag) != 0;
    }

    public static int setBit(int value, int flag) {
        return value | flag;
    }

    public static int clearBit(int value, int flag) {
        return value & ~flag;
    }
}

