/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Component;
import java.awt.FontMetrics;
import javax.swing.event.DocumentEvent;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicView;
import oracle.javatools.editor.LineRenderFragmentGenerator;
import oracle.javatools.editor.RowMap;
import oracle.javatools.editor.highlight.HighlightFragmentsList;
import oracle.javatools.editor.language.DocumentRenderer;
import oracle.javatools.editor.language.StyledFragmentsList;

class LineRowMap
implements RowMap {
    protected boolean _sameWidthFaces = true;
    protected int _rowCount = -1;
    protected int _lineCount = -1;
    protected int[] _rowWidths = null;
    protected int _maxWidth = -1;
    protected int _maxWidthRow = -1;
    protected BasicView _view;
    protected static final int MINIMUM_INCREMENT = 25;
    protected static final int MAXIMUM_INCREMENT = 500;
    protected static final float INCREMENT_RATE = 0.1f;

    protected LineRowMap(BasicView basicView) {
        this._view = basicView;
        this.rebuildRowMap();
    }

    protected BasicView.RenderFragmentGenerator createRenderFragmentGenerator(StyledFragmentsList styledList, HighlightFragmentsList highlightList) {
        return new LineRenderFragmentGenerator(styledList, highlightList, this._view);
    }

    protected void rebuildRowMap() {
        this.checkFontFaces();
        this._maxWidthRow = -1;
        this._maxWidth = -1;
        this._rowCount = 1;
        this._lineCount = 1;
        this.handleInsert(0);
    }

    protected void revalidateRowMap() {
        this.revalidateRows(0, this._rowCount);
    }

    protected void handleInsert(int offset) {
        int oldLineCount = this._lineCount;
        int newLineCount = this._view.getLineMap().getLineCount();
        int linesAdded = newLineCount - oldLineCount;
        int startRow = this._view.getLineMap().getLineFromOffset(offset);
        int numRows = 1;
        int startLine = startRow;
        int numLines = linesAdded + 1;
        this.recalculateRows(startRow, numRows, startLine, numLines);
        this._lineCount = newLineCount;
    }

    protected void handleRemove(int offset) {
        int oldLineCount = this._lineCount;
        int newLineCount = this._view.getLineMap().getLineCount();
        int linesRemoved = newLineCount - oldLineCount;
        int startRow = this._view.getLineMap().getLineFromOffset(offset);
        int numRows = 1 - linesRemoved;
        int startLine = startRow;
        int numLines = 1;
        this.recalculateRows(startRow, numRows, startLine, numLines);
        this._lineCount = newLineCount;
    }

    protected void invalidateMaxWidthRow(int startRow, int numRows) {
        if (this._maxWidthRow != -1) {
            int endRow = startRow + numRows;
            if (startRow <= this._maxWidthRow && this._maxWidthRow < endRow) {
                this._maxWidthRow = -1;
                this._maxWidth = -1;
            }
        }
    }

    protected void recalculateRows(int startRow, int numRows, int startLine, int numLines) {
        try {
            if (startRow != startLine) {
                throw new IllegalStateException("non-matching row/line");
            }
            this.invalidateMaxWidthRow(startRow, numRows);
            int oldRowCount = this._rowCount;
            int linesChanged = numLines - numRows;
            int rowsToShift = 0;
            int rowSrc = 0;
            int rowDest = 0;
            if (this._rowWidths == null) {
                this._rowWidths = new int[20];
            }
            int[] rowWidthsSrc = this._rowWidths;
            int[] rowWidthsDest = this._rowWidths;
            if (linesChanged < 0) {
                int linesRemoved = -linesChanged;
                rowDest = startRow + 1;
                rowSrc = rowDest + linesRemoved;
                rowsToShift = oldRowCount - rowSrc;
            } else if (linesChanged > 0) {
                int requestedSize;
                int linesAdded = linesChanged;
                rowSrc = startRow + 1;
                rowDest = rowSrc + linesAdded;
                rowsToShift = oldRowCount - rowSrc;
                int currentSize = this._rowWidths != null ? this._rowWidths.length : 0;
                if (currentSize < (requestedSize = this._view.getLineMap().getLineCount())) {
                    int increment = (int)((float)requestedSize * 0.1f);
                    increment = Math.min(500, increment);
                    increment = Math.max(25, increment);
                    rowWidthsDest = this._rowWidths = new int[requestedSize += increment];
                    if (rowWidthsSrc != null && startRow > 0) {
                        System.arraycopy(rowWidthsSrc, 0, rowWidthsDest, 0, startRow);
                    }
                }
            }
            if (rowsToShift > 0) {
                System.arraycopy(rowWidthsSrc, rowSrc, rowWidthsDest, rowDest, rowsToShift);
            }
            this._rowCount = this._view.getLineMap().getLineCount();
            this.recalculateLineWidths(startRow, numLines);
            this.updateMaxRowWidth();
        }
        catch (RuntimeException e) {
            System.out.println("Exception occurred updating RowMap: " + e.getMessage());
            System.out.println("  startRow: " + startRow);
            System.out.println("  numRows: " + numRows);
            System.out.println("  startLine: " + startLine);
            System.out.println("  numLines: " + numLines);
            System.out.println("  _rowCount: " + this._rowCount);
            System.out.println("  lineCount: " + this._view.getLineMap().getLineCount());
            System.out.println();
            System.out.println("Stack trace follows");
            e.printStackTrace(System.out);
            System.out.println();
            System.out.println("Forcing RowMap rebuild");
        }
    }

    protected void recalculateLineWidths(int startRow, int numRowsChanged) {
        if (this._sameWidthFaces) {
            FontMetrics biMetrics = this._view.getFontHelper().getFontMetrics(3, (Component)this._view.getEditor());
            int rowCount = this._rowWidths.length;
            int endRow = startRow + numRowsChanged;
            if (rowCount < endRow) {
                new RuntimeException(endRow + " > " + rowCount).printStackTrace();
                endRow = rowCount;
            }
            for (int i = startRow; i < endRow; ++i) {
                int width = this._rowWidths[i] = this.calculateLineWidth(biMetrics, i);
                if (this._maxWidth == -1 || width <= this._maxWidth) continue;
                this._maxWidth = width;
                this._maxWidthRow = i;
            }
        } else {
            int LINE_CHUNK = 200;
            int recalcStartLine = startRow;
            int recalcEndLine = startRow + numRowsChanged;
            int recalcStartOffset = this._view.getLineMap().getLineStartOffset(recalcStartLine);
            int recalcEndOffset = this._view.getLineMap().getLineEndOffset(recalcEndLine - 1);
            HighlightFragmentsList fontHighlightList = this._view.renderFontHighlights(recalcStartOffset, recalcEndOffset);
            int linesRemaining = numRowsChanged;
            int currentLine = startRow;
            DocumentRenderer documentRenderer = this._view.getDocumentRenderer();
            while (linesRemaining > 0) {
                int chunkSize = Math.min(linesRemaining, 200);
                int chunkStartLine = currentLine;
                int chunkEndLine = chunkStartLine + chunkSize - 1;
                StyledFragmentsList fragmentsList = documentRenderer.renderLines(chunkStartLine, chunkEndLine);
                LineRenderFragmentGenerator generator = new LineRenderFragmentGenerator(fragmentsList, fontHighlightList, this._view);
                for (int i = chunkStartLine; i <= chunkEndLine; ++i) {
                    int width = this._rowWidths[i] = this.calculateLineWidth(generator, i);
                    if (this._maxWidth == -1 || width <= this._maxWidth) continue;
                    this._maxWidth = width;
                    this._maxWidthRow = i;
                }
                if (fragmentsList != null) {
                    fragmentsList.clear();
                    documentRenderer.recycleFragmentsList(fragmentsList);
                }
                linesRemaining -= chunkSize;
                currentLine += chunkSize;
            }
            BasicView.freeHighlightFragmentsList(fontHighlightList);
        }
    }

    protected int calculateLineWidth(BasicView.RenderFragmentGenerator generator, int line) {
        int lineStart = this._view.getLineMap().getLineStartOffset(line);
        int lineEnd = this._view.getLineMap().getLineEndOffset(line);
        int xEnd = this._view.getXCoordinateForOffset(generator, lineStart, lineEnd);
        return xEnd;
    }

    protected int calculateLineWidth(FontMetrics metrics, int line) {
        int lineStart = this._view.getLineMap().getLineStartOffset(line);
        int lineEnd = this._view.getLineMap().getLineEndOffset(line);
        int width = this._view.getTabbedTextWidth(metrics, lineStart, lineEnd, 0);
        return width;
    }

    protected void revalidateRows(int startRow, int numRows) {
        if (this._sameWidthFaces) {
            return;
        }
        this.invalidateMaxWidthRow(startRow, numRows);
        this.recalculateLineWidths(startRow, numRows);
        this.updateMaxRowWidth();
    }

    protected void updateMaxRowWidth() {
        if (this._maxWidth == -1) {
            int maxRow = -1;
            int maxWidth = -1;
            for (int i = 0; i < this._rowCount; ++i) {
                int checkWidth = this._rowWidths[i];
                if (checkWidth <= maxWidth) continue;
                maxWidth = checkWidth;
                maxRow = i;
            }
            this._maxWidth = maxWidth;
            this._maxWidthRow = maxRow;
        }
    }

    protected int getMaxRowWidth() {
        return this._maxWidth;
    }

    protected void checkFontFaces() {
        boolean checkFaces = this._view.getEditor().getBooleanProperty("check-same-width-faces");
        if (checkFaces) {
            FontMetrics plainMetrics = this._view.getFontHelper().getFontMetrics(0, (Component)this._view.getEditor());
            FontMetrics biMetrics = this._view.getFontHelper().getFontMetrics(3, (Component)this._view.getEditor());
            this._sameWidthFaces = plainMetrics.charWidth('i') == biMetrics.charWidth('i') && plainMetrics.charWidth('m') == biMetrics.charWidth('m') && plainMetrics.charWidth('w') == biMetrics.charWidth('w');
        } else {
            this._sameWidthFaces = false;
        }
    }

    private void notYetImplemented() {
        throw new IllegalStateException("implement me");
    }

    protected void documentChanged(DocumentEvent event) {
        int offset = event.getOffset();
        if (event.getType() == DocumentEvent.EventType.INSERT) {
            this.handleInsert(offset);
        } else if (event.getType() == DocumentEvent.EventType.REMOVE) {
            this.handleRemove(offset);
        }
    }

    protected boolean rowEndIsLineEnd(int row) {
        int lastRow = this.getRowCount() - 1;
        if (row == lastRow) {
            return true;
        }
        int rowEndOffset = this.getRowEndOffset(row);
        int lineForNextRow = this.getRowStartLine(row + 1);
        return rowEndOffset == this._view.getLineMap().getLineStartOffset(lineForNextRow);
    }

    @Override
    public BasicEditorPane getEditorPane() {
        return this._view.getEditor();
    }

    @Override
    public int getRowCount() {
        return this._view.getLineMap().getLineCount();
    }

    @Override
    public int getRowFromOffset(int offset) {
        return this._view.getLineMap().getLineFromOffset(offset);
    }

    @Override
    public int getRowStartOffset(int row) {
        return this._view.getLineMap().getLineStartOffset(row);
    }

    @Override
    public int getRowEndOffset(int row) {
        return this._view.getLineMap().getLineEndOffset(row);
    }

    @Override
    public int getRowStartLine(int row) {
        return row;
    }
}

