/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import oracle.javatools.editor.BasicView;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.FoldedCollapsedBlocks;
import oracle.javatools.editor.LineRenderFragmentGenerator;
import oracle.javatools.editor.folding.FoldingFader;
import oracle.javatools.editor.highlight.HighlightFragmentsList;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.resource.BundleHelper;

class FoldedRenderFragmentGenerator
implements BasicView.RenderFragmentGenerator {
    public static final String FOLDED_BLOCK_HIGHLIGHT = "folded-block-highlight";
    public static final int DEFAULT_FOLDED_BLOCK_PRIORITY = 99;
    private BasicView _view;
    private BasicView.RenderFragmentGenerator _generator;
    private FoldedCollapsedBlocks _blocks;
    private int _lastOffset;
    private int _currentBlock;
    private HighlightStyle _foldedStyle;
    protected BasicView.RenderFragment _currentFragment = new BasicView.RenderFragment();

    protected FoldedRenderFragmentGenerator(StyledFragmentsList styledList, HighlightFragmentsList highlightList, FoldedCollapsedBlocks collapsedBlocks, BasicView view) {
        this._view = view;
        this._generator = new LineRenderFragmentGenerator(styledList, highlightList, view);
        this._blocks = collapsedBlocks;
        this._foldedStyle = this.lookupHighlight(FOLDED_BLOCK_HIGHLIGHT);
        BasicView.RenderFragment unfoldedFragment = this._generator.current();
        if (unfoldedFragment == null) {
            this._currentFragment = null;
            return;
        }
        this._lastOffset = unfoldedFragment.startOffset;
        this._currentBlock = 0;
        this.next();
    }

    private HighlightStyle lookupHighlight(String highlightName) {
        EditorProperties properties = EditorProperties.getProperties();
        HighlightRegistry registry = properties.getHighlightRegistry();
        HighlightStyle style = registry.lookupStyle(highlightName);
        if (style == null) {
            throw new IllegalStateException("highlight not found: " + highlightName);
        }
        return style;
    }

    @Override
    public BasicView.RenderFragment current() {
        return this._currentFragment;
    }

    @Override
    public BasicView.RenderFragment next() {
        if (this._currentFragment == null) {
            return null;
        }
        try {
            return this.nextImpl();
        }
        catch (IndexOutOfBoundsException e) {
            this._currentFragment = null;
            return this._currentFragment;
        }
    }

    protected BasicView.RenderFragment nextImpl() {
        int blockStart = -1;
        int blockEnd = -1;
        String blockText = null;
        while (this._currentBlock < this._blocks._numBlocks) {
            blockStart = this._blocks._blockStarts[this._currentBlock];
            blockEnd = this._blocks._blockEnds[this._currentBlock];
            blockText = this._blocks._blockTexts[this._currentBlock];
            if (blockText == null) {
                blockText = "<**ERROR in CodeFoldingModel: No replacement text for block**>";
            }
            if (blockEnd > this._lastOffset) break;
            ++this._currentBlock;
            blockEnd = -1;
            blockStart = -1;
            blockText = null;
        }
        BasicView.RenderFragment unfoldedFragment = this._generator.current();
        while (unfoldedFragment != null && unfoldedFragment.endOffset <= this._lastOffset) {
            unfoldedFragment = this._generator.next();
        }
        if (unfoldedFragment == null) {
            this._currentFragment = null;
            return null;
        }
        int processStart = unfoldedFragment.startOffset;
        processStart = Math.max(processStart, this._lastOffset);
        int processEnd = unfoldedFragment.endOffset;
        if (blockStart == processStart) {
            BaseStyle style;
            this._currentFragment.syntaxStyle = style = this._view.lookupStyle("base-plain-style");
            this._currentFragment.startOffset = blockStart;
            this._currentFragment.endOffset = blockEnd;
            this._currentFragment.textToUse = blockText;
            this._currentFragment.backgroundHighlight = null;
            this._currentFragment.foregroundHighlight = null;
            this._currentFragment.fontHighlight = null;
            HighlightStyle backgroundToUse = unfoldedFragment.backgroundHighlight;
            HighlightStyle foregroundToUse = unfoldedFragment.foregroundHighlight;
            HighlightStyle fontHighlightToUse = unfoldedFragment.fontHighlight;
            while (unfoldedFragment.endOffset < blockEnd && (unfoldedFragment = this._generator.next()) != null) {
                if (blockEnd <= unfoldedFragment.startOffset) continue;
                if (unfoldedFragment.backgroundHighlight != backgroundToUse) {
                    backgroundToUse = null;
                }
                if (unfoldedFragment.foregroundHighlight != foregroundToUse) {
                    foregroundToUse = null;
                }
                if (unfoldedFragment.fontHighlight == fontHighlightToUse) continue;
                fontHighlightToUse = null;
            }
            if (this._foldedStyle != null && this._foldedStyle.getEnabled()) {
                if (this._foldedStyle.getUseBackgroundColor() && (backgroundToUse == null || backgroundToUse.getPriority() < this._foldedStyle.getPriority())) {
                    backgroundToUse = this._foldedStyle;
                }
                if (this._foldedStyle.getUseForegroundColor() && (foregroundToUse == null || foregroundToUse.getPriority() < this._foldedStyle.getPriority())) {
                    foregroundToUse = this._foldedStyle;
                }
                if (this._foldedStyle.getUseFontStyle() && (fontHighlightToUse == null || fontHighlightToUse.getPriority() < this._foldedStyle.getPriority())) {
                    fontHighlightToUse = this._foldedStyle;
                }
            }
            this._currentFragment.backgroundHighlight = backgroundToUse;
            this._currentFragment.foregroundHighlight = foregroundToUse;
            this._currentFragment.fontHighlight = fontHighlightToUse;
            ++this._currentBlock;
            this._lastOffset = blockEnd;
            return this._currentFragment;
        }
        if (blockStart != -1 && this._lastOffset < blockStart) {
            processEnd = Math.min(processEnd, blockStart);
        }
        this._currentFragment.syntaxStyle = unfoldedFragment.syntaxStyle;
        this._currentFragment.startOffset = processStart;
        this._currentFragment.endOffset = processEnd;
        this._currentFragment.textToUse = null;
        this._currentFragment.backgroundHighlight = unfoldedFragment.backgroundHighlight;
        this._currentFragment.foregroundHighlight = unfoldedFragment.foregroundHighlight;
        this._currentFragment.fontHighlight = unfoldedFragment.fontHighlight;
        this._lastOffset = processEnd;
        return this._currentFragment;
    }

    static {
        EditorProperties properties = EditorProperties.getProperties();
        HighlightRegistry registry = properties.getHighlightRegistry();
        BundleHelper resources = EditorProperties.getEditorBundle();
        registry.createStyle(FOLDED_BLOCK_HIGHLIGHT, resources.getString("FOLDED_BLOCK_HIGHLIGHT"), true, 99, null, null);
        registry.modifyStyleFont(FOLDED_BLOCK_HIGHLIGHT, 2);
        FoldingFader.registerHighlights();
    }
}

