/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import oracle.bali.ewt.text.MultiLineToolTip;
import oracle.javatools.controls.EditorPeekPopup;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.FileOverviewMark;
import oracle.javatools.editor.folding.CodeExpansionEvent;
import oracle.javatools.editor.folding.CodeExpansionListener;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.editor.folding.CodeFoldingModel;
import oracle.javatools.editor.folding.CodeFoldingModelEvent;
import oracle.javatools.editor.folding.CodeFoldingModelListener;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.ui.MouseHoverListener;
import oracle.javatools.ui.MouseHoverSupport;
import oracle.javatools.util.Pair;

public class FileOverviewMargin
extends JComponent
implements EditorPlugin {
    public static final int PRIORITY_LOW = 3;
    public static final int PRIORITY_MEDIUM = 2;
    public static final int PRIORITY_HIGH = 1;
    private BasicEditorPane editor;
    private DocumentListener documentListener;
    private ComponentListener componentListener;
    private CodeFoldingModel codeFoldingModel;
    private CodeFoldingMargin codeFoldingMargin;
    private CodeFoldingListener codeFoldingListener;
    private Map collapsedBlocks;
    private int collapsedLines;
    private int lineCount;
    private int height;
    private double yMultiplier;
    private final Map mapLineToMarks;
    private final Map mapAnalysisIdToTooltip;
    private boolean analysisCompleted;
    private int maximumSeverity;
    private String summaryCategory;
    private static final Map mapCategoryToColor = new HashMap();
    private static final Map mapCategoryToPriority = new HashMap();
    private static final Map mapEditorToFileOverviewMargin = new HashMap();
    private static final PropertyChangeListener editorPropertyChangeListener;
    private static final Comparator categoryComparator;
    private PeekListener _peekListener;
    private MouseHoverSupport hoverSupport;
    private static final int COLUMN_WIDTH = 12;
    private static final int MARK_HEIGHT = 6;
    private static final int GET_INFO_LINE = 0;
    private static final int GET_INFO_LOCATION = 1;
    private static final int GET_INFO_MARKS = 2;
    private static final int GET_INFO_MARKS_COLOR_PAIR = 3;

    public static void setMarkColor(String category, Color color) {
        FileOverviewMargin.setMarkColor(category, 3, color);
    }

    public static void setMarkColor(String category, HighlightStyle highlightStyle) {
        FileOverviewMargin.setMarkColor(category, 3, highlightStyle);
    }

    public static void setMarkColor(String category, int priority, Color color) {
        mapCategoryToColor.put(category, color);
        mapCategoryToPriority.put(category, priority);
    }

    public static void setMarkColor(String category, int priority, HighlightStyle highlightStyle) {
        mapCategoryToColor.put(category, highlightStyle);
        mapCategoryToPriority.put(category, priority);
    }

    public static Object getMarkColor(String category) {
        return mapCategoryToColor.get(category);
    }

    public static void removeMarkColor(String category) {
        mapCategoryToColor.remove(category);
        mapCategoryToPriority.remove(category);
    }

    public static FileOverviewMargin getFileOverviewMargin(BasicEditorPane editor) {
        return (FileOverviewMargin)mapEditorToFileOverviewMargin.get(editor);
    }

    public FileOverviewMargin() {
        this.setBackground(UIManager.getColor("window"));
        this.collapsedBlocks = new TreeMap();
        this.collapsedLines = 0;
        this.codeFoldingListener = new CodeFoldingListener();
        this.lineCount = 1;
        this.height = 1;
        this.yMultiplier = 1.0;
        this.mapLineToMarks = new TreeMap();
        this.mapAnalysisIdToTooltip = new HashMap();
        MouseInputAdapter mouseInputListener = new MouseInputAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (FileOverviewMargin.this.editor != null) {
                    Point pt = e.getPoint();
                    Integer line = FileOverviewMargin.this.getMarkLineAtY(pt.y);
                    if (line != null) {
                        FileOverviewMargin.this.setCursor(Cursor.getPredefinedCursor(12));
                        return;
                    }
                }
                FileOverviewMargin.this.setCursor(null);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (FileOverviewMargin.this.editor != null && (e.getModifiers() & 0x10) != 0 && e.getClickCount() == 1) {
                        Point pt = e.getPoint();
                        Object[] location = FileOverviewMargin.this.getMarkLocationAtY(pt.y);
                        if (location != null) {
                            int line = (Integer)location[0];
                            FileOverviewMark mark = (FileOverviewMark)location[1];
                            FileOverviewMargin.this.navigate(line, mark);
                        } else if (EditorPeekPopup.editorPeek) {
                            int row = FileOverviewMargin.this.getRowAtY(pt.y);
                            int line = FileOverviewMargin.this.editor.getLineFromRow(row);
                            line = Math.max(0, line);
                            line = Math.min(FileOverviewMargin.this.editor.getLineCount(), line);
                            int offset = FileOverviewMargin.this.editor.getLineStartOffset(line);
                            FileOverviewMargin.this.editor.setCaretPositionCenter(offset);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.addMouseListener(mouseInputListener);
        this.addMouseMotionListener(mouseInputListener);
        this.hoverSupport = new MouseHoverSupport((Component)this, 500, false);
    }

    protected void navigate(int line, FileOverviewMark mark) {
        int selectionStart = mark.getSelectionStart();
        if (selectionStart >= 0) {
            int selectionLength = mark.getSelectionLength();
            this.editor.select(selectionStart, selectionStart + selectionLength);
        } else {
            int offset = this.editor.getLineStartOffset(line - 1);
            this.editor.setCaretPositionCenter(offset);
        }
    }

    public void clearAnalysis() {
        this.analysisCompleted = false;
        this.repaintSummaryBlock();
    }

    public void startAnalysis(Object id, String tooltip) {
        this.mapAnalysisIdToTooltip.put(id, tooltip);
        this.repaintSummaryBlock();
    }

    public void stopAnalysis(Object id) {
        this.mapAnalysisIdToTooltip.remove(id);
        int maximumSeverity = 0;
        String summaryCategory = null;
        for (Object o : this.mapLineToMarks.values()) {
            Map mapCategoryToMarks = (Map)o;
            for (Map.Entry entry : mapCategoryToMarks.entrySet()) {
                String category = (String)entry.getKey();
                if (mapCategoryToColor.get(category) == null) continue;
                Object markOrMarks = entry.getValue();
                if (markOrMarks instanceof FileOverviewMark[]) {
                    FileOverviewMark[] marks = (FileOverviewMark[])markOrMarks;
                    for (int i = marks.length - 1; i >= 0; --i) {
                        int severity = marks[i].getSeverity();
                        if (severity <= maximumSeverity) continue;
                        maximumSeverity = severity;
                        summaryCategory = category;
                    }
                    continue;
                }
                FileOverviewMark mark = (FileOverviewMark)markOrMarks;
                int severity = mark.getSeverity();
                if (severity <= maximumSeverity) continue;
                maximumSeverity = severity;
                summaryCategory = category;
            }
        }
        this.maximumSeverity = maximumSeverity;
        this.summaryCategory = summaryCategory;
        this.analysisCompleted = true;
        this.repaintSummaryBlock();
    }

    public final void clearMarks(String category) {
        if (!this.mapLineToMarks.isEmpty()) {
            ArrayList<String> remove = new ArrayList<String>();
            for (Object oLine : this.mapLineToMarks.keySet()) {
                Map mapCategoryToMarks = (Map)this.mapLineToMarks.get(oLine);
                if (mapCategoryToMarks.isEmpty()) continue;
                Iterator itCategory = mapCategoryToMarks.keySet().iterator();
                while (itCategory.hasNext()) {
                    if (!itCategory.next().equals(category)) continue;
                    remove.add(category);
                }
                while (!remove.isEmpty()) {
                    mapCategoryToMarks.remove(remove.remove(0));
                }
            }
            this.repaint();
        }
    }

    public final void addMark(String category, int line, FileOverviewMark mark) {
        Object previousMarkOrMarks;
        Integer oLine;
        TreeMap<String, Object> mapCategoryToMarks;
        if (line < 1) {
            return;
        }
        if (this.codeFoldingMargin == null || this.codeFoldingModel == null) {
            this.updateCodeFolding();
        }
        if ((mapCategoryToMarks = (TreeMap<String, Object>)this.mapLineToMarks.get(oLine = Integer.valueOf(line))) == null) {
            mapCategoryToMarks = new TreeMap<String, Object>(categoryComparator);
            this.mapLineToMarks.put(oLine, mapCategoryToMarks);
        }
        if ((previousMarkOrMarks = mapCategoryToMarks.get(category)) != null) {
            FileOverviewMark[] newArray;
            if (previousMarkOrMarks instanceof FileOverviewMark[]) {
                FileOverviewMark[] oldArray = (FileOverviewMark[])previousMarkOrMarks;
                int oldMarksLength = oldArray.length;
                newArray = new FileOverviewMark[oldMarksLength + 1];
                System.arraycopy(oldArray, 0, newArray, 0, oldMarksLength);
                newArray[oldMarksLength] = mark;
            } else {
                newArray = new FileOverviewMark[]{(FileOverviewMark)previousMarkOrMarks, mark};
            }
            mapCategoryToMarks.put(category, newArray);
        } else {
            mapCategoryToMarks.put(category, mark);
        }
        if (mapCategoryToColor.containsKey(category) && line <= this.lineCount) {
            this.repaintLine(line);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void removeMark(String category, int line, FileOverviewMark mark) {
        if (line < 1) {
            return;
        }
        Integer oLine = line;
        Map mapCategoryToMarks = (Map)this.mapLineToMarks.get(oLine);
        if (mapCategoryToMarks == null) {
            return;
        }
        Object previousMarkOrMarks = mapCategoryToMarks.get(category);
        if (previousMarkOrMarks == null) return;
        if (previousMarkOrMarks instanceof FileOverviewMark[]) {
            FileOverviewMark[] oldArray = (FileOverviewMark[])previousMarkOrMarks;
            int oldMarksLength = oldArray.length;
            int index = -1;
            for (int i = 0; i < oldArray.length; ++i) {
                if (!oldArray[i].equals(mark)) continue;
                index = i;
                break;
            }
            if (index == -1) return;
            if (oldMarksLength == 2) {
                mapCategoryToMarks.put(category, oldArray[1 - index]);
            } else {
                FileOverviewMark[] newArray = new FileOverviewMark[oldMarksLength - 1];
                System.arraycopy(oldArray, 0, newArray, 0, index);
                System.arraycopy(oldArray, index + 1, newArray, index, oldMarksLength - index - 1);
                mapCategoryToMarks.put(category, newArray);
            }
        } else {
            mapCategoryToMarks.remove(category);
        }
        if (!mapCategoryToColor.containsKey(category) || line > this.lineCount) return;
        this.repaintLine(line);
    }

    private static void stylesChanged() {
        EditorProperties editorProperties = EditorProperties.getProperties();
        HighlightRegistry highlightRegistry = editorProperties.getHighlightRegistry();
        for (Object category : mapCategoryToColor.keySet()) {
            Object o = mapCategoryToColor.get(category);
            if (!(o instanceof HighlightStyle)) continue;
            HighlightStyle highlightStyle = (HighlightStyle)o;
            highlightStyle = highlightRegistry.lookupStyle(highlightStyle.getName());
            mapCategoryToColor.put(category, highlightStyle);
        }
    }

    private static Color getColorForCategory(String category) {
        Object o = mapCategoryToColor.get(category);
        if (o instanceof Color) {
            return (Color)o;
        }
        if (o instanceof HighlightStyle) {
            HighlightStyle style = (HighlightStyle)o;
            if (style.getUseUnderline()) {
                return style.getUnderlineColor();
            }
            if (style.getUseBackgroundColor()) {
                return style.getBackgroundColor();
            }
            if (style.getUseForegroundColor()) {
                return style.getForegroundColor();
            }
        }
        return null;
    }

    private void checkLineCount() {
        if (this.editor != null) {
            int lineCount = this.editor.getLineCount() + this.editor.getIntegerProperty("trailing-blank-rows");
            if (lineCount <= 0) {
                lineCount = 1;
            }
            if (this.lineCount != lineCount) {
                this.lineCount = lineCount;
                this.updateYMultiplier();
            }
        }
    }

    private void checkHeight() {
        if (this.editor != null) {
            Rectangle wholeRect = this.getWholeRectangle();
            if (this.height != wholeRect.height) {
                this.height = wholeRect.height;
                this.updateYMultiplier();
            }
        }
    }

    private void updateYMultiplier() {
        this.yMultiplier = (double)this.height / (double)(this.lineCount - this.collapsedLines);
        if (this.yMultiplier < 0.001) {
            this.yMultiplier = 0.001;
        } else if (this.editor != null) {
            try {
                FontMetrics fontMetrics = this.editor.getFontMetrics(this.editor.getFont());
                int rowHeight = fontMetrics.getHeight();
                if (this.yMultiplier > (double)rowHeight) {
                    this.yMultiplier = rowHeight;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.repaint();
    }

    private void repaintSummaryBlock() {
        Rectangle summaryRect = this.getSummaryRectangle();
        this.repaint(summaryRect.x, summaryRect.y, summaryRect.width, summaryRect.height);
    }

    private void repaintLine(int line) {
        Rectangle lineRect = this.getLineRectangle(null, line);
        this.repaint(lineRect.x, lineRect.y, lineRect.width, lineRect.height);
    }

    protected int getTopOffset() {
        return 0;
    }

    protected int getBottomOffset() {
        return 0;
    }

    private Rectangle getWholeRectangle() {
        Dimension d = this.getSize();
        Insets insets = this.getInsets();
        Rectangle r = new Rectangle(insets.left, insets.top, d.width - (insets.left + insets.right), d.height - (insets.top + insets.bottom));
        int topOffset = this.getTopOffset();
        int bottomOffset = this.getBottomOffset();
        r.y += topOffset;
        r.height -= topOffset + bottomOffset;
        if (r.height < 1) {
            r.height = 1;
        }
        return r;
    }

    private Rectangle getSummaryRectangle() {
        Dimension d = this.getSize();
        Insets insets = this.getInsets();
        Rectangle r = new Rectangle(insets.left, insets.top, d.width - (insets.left + insets.right), d.height - (insets.top + insets.bottom));
        ++r.x;
        r.width -= 2;
        r.y += 2;
        r.height = r.width;
        return r;
    }

    private Rectangle getLineRectangle(Rectangle wholeRect, int line) {
        if (wholeRect == null) {
            wholeRect = this.getWholeRectangle();
        }
        int yOffset = (int)Math.round((double)(line - 1) * this.yMultiplier);
        if (this.collapsedLines > 0) {
            for (Object key : this.collapsedBlocks.keySet()) {
                int startLine = (Integer)key;
                int endLine = (Integer)this.collapsedBlocks.get(key);
                if (line <= startLine) break;
                if (startLine < line && line <= endLine) {
                    yOffset -= (int)Math.round((double)(line - startLine) * this.yMultiplier);
                    break;
                }
                if (endLine >= line) continue;
                yOffset -= (int)Math.round((double)(endLine - startLine) * this.yMultiplier);
            }
        }
        return new Rectangle(wholeRect.x + 1, wholeRect.y + yOffset, wholeRect.width - 2, 6);
    }

    private Map makeMapRectToColor(Rectangle clipRect) {
        if (this.lineCount > 0 && !this.mapLineToMarks.isEmpty() && !mapCategoryToColor.isEmpty()) {
            Rectangle wholeRect = this.getWholeRectangle();
            final HashMap<Rectangle, String> mapRectToCategory = new HashMap<Rectangle, String>();
            TreeMap<Rectangle, Color> mapRectToColor = new TreeMap<Rectangle, Color>(new Comparator(){

                public int compare(Object o1, Object o2) {
                    Rectangle rect1 = (Rectangle)o1;
                    Rectangle rect2 = (Rectangle)o2;
                    String category1 = (String)mapRectToCategory.get(rect1);
                    String category2 = (String)mapRectToCategory.get(rect2);
                    int result = categoryComparator.compare(category2, category1);
                    if (result != 0) {
                        return result;
                    }
                    return rect1.y - rect2.y;
                }
            });
            for (Integer oLine : this.mapLineToMarks.keySet()) {
                Object previousCategory;
                String category;
                Color color;
                Iterator itCategory;
                Map mapCategoryToMarks;
                int line = oLine;
                Rectangle lineRect = this.getLineRectangle(wholeRect, line);
                if (!clipRect.intersects(lineRect) || (mapCategoryToMarks = (Map)this.mapLineToMarks.get(oLine)).isEmpty() || !(itCategory = mapCategoryToMarks.keySet().iterator()).hasNext() || (color = FileOverviewMargin.getColorForCategory(category = (String)itCategory.next())) == null || (previousCategory = mapRectToCategory.get(lineRect)) != null && categoryComparator.compare(previousCategory, category) < 0) continue;
                mapRectToCategory.put(lineRect, category);
                mapRectToColor.put(lineRect, color);
            }
            return mapRectToColor;
        }
        return null;
    }

    private Object getMarkInfoAtY(int y, int what) {
        ArrayList<Object> marksToReturn;
        ArrayList<Object> arrayList = marksToReturn = what == 2 || what == 3 ? new ArrayList<Object>() : null;
        if (this.lineCount > 0 && !this.mapLineToMarks.isEmpty() && !mapCategoryToColor.isEmpty()) {
            Rectangle wholeRect = this.getWholeRectangle();
            int x = wholeRect.x + 1;
            for (Integer oLine : this.mapLineToMarks.keySet()) {
                Map mapCategoryToMarks;
                int line = oLine;
                Rectangle lineRect = this.getLineRectangle(wholeRect, line);
                if (!lineRect.contains(x, y) || (mapCategoryToMarks = (Map)this.mapLineToMarks.get(oLine)).isEmpty()) continue;
                for (Map.Entry entry : mapCategoryToMarks.entrySet()) {
                    FileOverviewMark[] array;
                    Object markOrMarks;
                    Object category = entry.getKey();
                    if (mapCategoryToColor.get(category) == null) continue;
                    if (what == 0) {
                        return oLine;
                    }
                    if (what == 1) {
                        markOrMarks = entry.getValue();
                        if (markOrMarks == null) continue;
                        FileOverviewMark mark = null;
                        if (markOrMarks instanceof FileOverviewMark[]) {
                            FileOverviewMark[] array2 = (FileOverviewMark[])markOrMarks;
                            if (array2.length > 0) {
                                mark = array2[0];
                            }
                        } else {
                            mark = (FileOverviewMark)markOrMarks;
                        }
                        if (mark == null) continue;
                        Object[] location = new Object[]{oLine, mark};
                        return location;
                    }
                    if (what == 2) {
                        markOrMarks = mapCategoryToMarks.get(category);
                        if (markOrMarks == null) continue;
                        if (markOrMarks instanceof FileOverviewMark[]) {
                            array = (FileOverviewMark[])markOrMarks;
                            for (int i = 0; i < array.length; ++i) {
                                marksToReturn.add(array[i]);
                            }
                            continue;
                        }
                        marksToReturn.add(markOrMarks);
                        continue;
                    }
                    if (what != 3 || (markOrMarks = mapCategoryToMarks.get(category)) == null) continue;
                    if (markOrMarks instanceof FileOverviewMark[]) {
                        array = (FileOverviewMark[])markOrMarks;
                        for (int i = 0; i < array.length; ++i) {
                            Pair<FileOverviewMark, Color> pair = new Pair<FileOverviewMark, Color>(array[i], FileOverviewMargin.getColorForCategory((String)category));
                            marksToReturn.add(pair);
                        }
                        continue;
                    }
                    if (!(markOrMarks instanceof FileOverviewMark)) continue;
                    Pair pair = new Pair(markOrMarks, FileOverviewMargin.getColorForCategory((String)category));
                    marksToReturn.add(pair);
                }
            }
        }
        switch (what) {
            case 0: 
            case 1: {
                return null;
            }
            case 2: 
            case 3: {
                return marksToReturn;
            }
        }
        return null;
    }

    private Integer getMarkLineAtY(int y) {
        return (Integer)this.getMarkInfoAtY(y, 0);
    }

    private Object[] getMarkLocationAtY(int y) {
        return (Object[])this.getMarkInfoAtY(y, 1);
    }

    private String getToolTipAtPt(Point pt, MouseEvent event) {
        return this.getToolTipAtPt(pt, event, true);
    }

    private String getToolTipAtPt(Point pt, MouseEvent event, boolean suppressDuplicates) {
        StringBuffer sb;
        block8: {
            block6: {
                block9: {
                    block7: {
                        sb = new StringBuffer();
                        Rectangle summaryRect = this.getSummaryRectangle();
                        if (!summaryRect.contains(pt)) break block6;
                        if (this.mapAnalysisIdToTooltip.isEmpty()) {
                            String resId = this.analysisCompleted ? "FILE_OVERVIEW_MARGIN_ANALYSIS_COMPLETED" : "FILE_OVERVIEW_MARGIN_NO_ANALYSIS_PERFORMED";
                            sb.append(EditorProperties.getEditorBundle().getString(resId));
                            sb.append("\n");
                        } else {
                            for (String tooltip : this.mapAnalysisIdToTooltip.values()) {
                                sb.append(tooltip);
                                sb.append("\n");
                            }
                        }
                        if (this.maximumSeverity != 2) break block7;
                        sb.append(EditorProperties.getEditorBundle().getString("FILE_OVERVIEW_MARGIN_SUMMARY_ERRORS"));
                        sb.append("\n");
                        break block8;
                    }
                    if (this.maximumSeverity != 1) break block9;
                    sb.append(EditorProperties.getEditorBundle().getString("FILE_OVERVIEW_MARGIN_SUMMARY_WARNINGS"));
                    sb.append("\n");
                    break block8;
                }
                if (!this.analysisCompleted) break block8;
                sb.append(EditorProperties.getEditorBundle().getString("FILE_OVERVIEW_MARGIN_SUMMARY_GOOD"));
                sb.append("\n");
                break block8;
            }
            List listOfMarks = (List)this.getMarkInfoAtY(pt.y, 2);
            if (listOfMarks != null && !listOfMarks.isEmpty()) {
                AbstractCollection messages = suppressDuplicates ? new HashSet() : new ArrayList();
                int size = listOfMarks.size();
                for (int i = 0; i < size; ++i) {
                    FileOverviewMark mark = (FileOverviewMark)listOfMarks.get(i);
                    String toolTipText = mark.getToolTipText(event);
                    if (toolTipText == null || toolTipText.length() <= 0 || !messages.add(toolTipText)) continue;
                    sb.append(toolTipText);
                    sb.append("\n");
                }
            }
        }
        int length = sb.length();
        if (length > 0) {
            sb.delete(length - 1, length);
            return sb.toString();
        }
        return null;
    }

    @Override
    public final JToolTip createToolTip() {
        MultiLineToolTip mltt = new MultiLineToolTip();
        mltt.setTextWrapper(null);
        return mltt;
    }

    @Override
    public final Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.width = 12;
        return d;
    }

    @Override
    public final Dimension getMinimumSize() {
        Dimension d = super.getMinimumSize();
        d.width = 12;
        return d;
    }

    @Override
    public final Dimension getMaximumSize() {
        Dimension d = super.getMaximumSize();
        d.width = 12;
        return d;
    }

    @Override
    public final boolean isFocusTraversable() {
        return false;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Map mapRectToColor;
        Rectangle clipBounds = g.getClipBounds();
        g.setColor(this.getBackground());
        g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
        Color color = this.analysisCompleted ? (this.maximumSeverity == 2 || this.maximumSeverity == 1 ? FileOverviewMargin.getColorForCategory(this.summaryCategory) : Color.GREEN) : this.getBackground();
        Rectangle rect = this.getSummaryRectangle();
        this.drawBox(g, rect, color);
        if (this.lineCount > 0 && !mapCategoryToColor.isEmpty() && !this.mapLineToMarks.isEmpty() && (mapRectToColor = this.makeMapRectToColor(clipBounds)) != null) {
            for (Map.Entry entry : mapRectToColor.entrySet()) {
                rect = (Rectangle)entry.getKey();
                color = (Color)entry.getValue();
                this.drawBox(g, rect, color);
            }
        }
    }

    protected void drawBox(Graphics g, Rectangle rect, Color color) {
        if (color == null) {
            color = this.getBackground();
        }
        g.setColor(color);
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
        g.setColor(color.darker());
        g.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
    }

    @Override
    public final String getToolTipText() {
        return null;
    }

    @Override
    public final String getToolTipText(MouseEvent event) {
        Point pt;
        String tooltip;
        if (EditorPeekPopup.editorPeek) {
            if (EditorPeekPopup.isShowing()) {
                return null;
            }
            return EditorProperties.getEditorBundle().getString("FILE_OVERVIEW_MARGIN_PEEK_TOOLTIP");
        }
        if (event != null && (tooltip = this.getToolTipAtPt(pt = event.getPoint(), event)) != null) {
            return tooltip;
        }
        return null;
    }

    @Override
    public final void install(BasicEditorPane basicEditorPane) {
        this.editor = basicEditorPane;
        mapEditorToFileOverviewMargin.put(this.editor, this);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.checkLineCount();
        this.documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FileOverviewMargin.this.checkLineCount();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FileOverviewMargin.this.checkLineCount();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FileOverviewMargin.this.checkLineCount();
            }
        };
        this.editor.getDocument().addDocumentListener(this.documentListener);
        this.componentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                FileOverviewMargin.this.checkHeight();
            }
        };
        this.addComponentListener(this.componentListener);
        if (EditorPeekPopup.editorPeek) {
            this._peekListener = new PeekListener();
            this.addMouseListener(this._peekListener);
            this.addMouseMotionListener(this._peekListener);
            this.hoverSupport.addMouseHoverListener((MouseHoverListener)this._peekListener);
            Toolkit.getDefaultToolkit().addAWTEventListener(this._peekListener, 8L);
        }
    }

    @Override
    public final void deinstall(BasicEditorPane editor) {
        this.removeComponentListener(this.componentListener);
        this.componentListener = null;
        editor.getDocument().removeDocumentListener(this.documentListener);
        this.documentListener = null;
        ToolTipManager.sharedInstance().unregisterComponent(this);
        mapEditorToFileOverviewMargin.remove(editor);
        this.removeMouseListener(this._peekListener);
        this.removeMouseMotionListener(this._peekListener);
        this.hoverSupport.removeMouseHoverListener((MouseHoverListener)this._peekListener);
        Toolkit.getDefaultToolkit().removeAWTEventListener(this._peekListener);
        this._peekListener = null;
        this.editor = null;
        this.updateCodeFolding();
    }

    @Override
    public final void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (propertyName.equals("trailing-blank-rows")) {
            this.checkLineCount();
        } else if (propertyName.equals("code-folding-margin-visible")) {
            this.updateCodeFolding();
        } else if (propertyName.equals("code-folding-model")) {
            this.updateCodeFolding();
        }
    }

    private void updateCodeFolding() {
        if (this.codeFoldingMargin != null) {
            this.codeFoldingMargin.removeCodeExpansionListener(this.codeFoldingListener);
        }
        if (this.codeFoldingModel != null) {
            this.codeFoldingModel.removeCodeFoldingModelListener(this.codeFoldingListener);
        }
        this.collapsedBlocks.clear();
        this.collapsedLines = 0;
        if (this.editor != null) {
            this.codeFoldingMargin = (CodeFoldingMargin)this.editor.getProperty("code-folding-margin");
            this.codeFoldingModel = (CodeFoldingModel)this.editor.getProperty("code-folding-model");
        } else {
            this.codeFoldingMargin = null;
            this.codeFoldingModel = null;
        }
        if (this.codeFoldingMargin != null) {
            this.codeFoldingMargin.addCodeExpansionListener(this.codeFoldingListener);
        }
        if (this.codeFoldingModel != null) {
            this.codeFoldingModel.addCodeFoldingModelListener(this.codeFoldingListener);
        }
        this.rebuildFoldingFromScratch();
        this.updateYMultiplier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildFoldingFromScratch() {
        this.collapsedBlocks.clear();
        this.collapsedLines = 0;
        if (this.codeFoldingModel != null) {
            this.codeFoldingModel.readLock();
            try {
                this.addCollapsedChildren(this.codeFoldingModel.getRoot());
            }
            finally {
                this.codeFoldingModel.readUnlock();
            }
        }
    }

    private void addCollapsedChildren(Object parent) {
        Iterator it = this.codeFoldingModel.getChildren(parent);
        while (it.hasNext()) {
            Object child = it.next();
            if (this.codeFoldingModel.isExpanded(child)) {
                this.addCollapsedChildren(child);
                continue;
            }
            this.addCollapsedBlock(child);
        }
    }

    private void removeCollapsedChildren(Object parent) {
        Iterator it = this.codeFoldingModel.getChildren(parent);
        while (it.hasNext()) {
            Object child = it.next();
            if (this.codeFoldingModel.isExpanded(child)) {
                this.removeCollapsedChildren(child);
                continue;
            }
            this.removeCollapsedBlock(child);
        }
    }

    private void addCollapsedBlock(Object block) {
        int[] offsets = this.codeFoldingModel.getTextOffsets(block, null);
        int startLine = this.editor.getLineFromOffset(offsets[0]) + 1;
        int endLine = this.editor.getLineFromOffset(offsets[1]) + 1;
        Integer key = startLine;
        Integer value = endLine;
        this.collapsedBlocks.put(key, value);
        this.collapsedLines += endLine - startLine;
    }

    private void removeCollapsedBlock(Object block) {
        int[] offsets = this.codeFoldingModel.getTextOffsets(block, null);
        int startLine = this.editor.getLineFromOffset(offsets[0]) + 1;
        int endLine = this.editor.getLineFromOffset(offsets[1]) + 1;
        Integer key = startLine;
        this.collapsedBlocks.remove(key);
        this.collapsedLines -= endLine - startLine;
    }

    private int _lookupOffset(FileOverviewMark mark) {
        int offset = -1;
        for (Integer aLine : this.mapLineToMarks.keySet()) {
            Map mapCategoryToMarks = (Map)this.mapLineToMarks.get(aLine);
            for (String cat : mapCategoryToMarks.keySet()) {
                Object aMark = mapCategoryToMarks.get(cat);
                if (!aMark.equals(mark)) continue;
                offset = this.editor.getLineStartOffset(aLine - 1);
                return offset;
            }
        }
        return offset;
    }

    private Pair<Color, Rectangle> _getColorAndRectForMark(FileOverviewMark mark) {
        int offset = mark.getSelectionStart();
        if (offset < 0) {
            offset = this._lookupOffset(mark);
        }
        int startLine = this.editor.getLineFromOffset(offset);
        Rectangle markRect = this.getLineRectangle(null, startLine + 1);
        Map mapRectToColor = this.makeMapRectToColor(this.getWholeRectangle());
        Color color = Color.WHITE;
        Rectangle rect = new Rectangle();
        if (mapRectToColor != null) {
            for (Map.Entry entry : mapRectToColor.entrySet()) {
                rect = (Rectangle)entry.getKey();
                if (!rect.contains(markRect)) continue;
                color = (Color)entry.getValue();
            }
        }
        return new Pair<Color, Rectangle>(color, rect);
    }

    private int getRowAtY(int y) {
        int row = (int)((double)(y - this.getWholeRectangle().y) / this.yMultiplier);
        return row;
    }

    private void _showOrHideGutterPeek(MouseEvent event) {
        List listOfMarks = (List)this.getMarkInfoAtY(event.getY(), 3);
        if (event.getY() < this.getWholeRectangle().y) {
            EditorPeekPopup.hidePopup(false);
        } else if ((event.getModifiersEx() & 0x80) > 0) {
            int row = this.getRowAtY(event.getY());
            row = Math.max(-1, row - 4);
            int startLine = this.editor.getLineFromRow(row);
            int endRow = row + 10;
            int endLine = this.editor.getLineFromRow(endRow);
            endLine = Math.min(this.editor.getLineCount() - 1, endLine);
            if (endLine - startLine >= 10) {
                int lineHeight = this.editor.getFontMetrics(this.editor.getFont()).getHeight();
                Point sp = event.getPoint();
                sp.x = 0;
                SwingUtilities.convertPointToScreen(sp, this);
                Rectangle sourceRect = new Rectangle(sp.x, sp.y, 12, 6);
                EditorPeekPopup.showPopup((Object)startLine, this.editor, null, sourceRect, Math.max(-1, startLine), Math.min(endLine, this.editor.getLineCount() - 1), lineHeight, Color.LIGHT_GRAY, (int)((float)lineHeight * 0.2f), 500);
            }
        } else if (listOfMarks != null && listOfMarks.size() > 0) {
            FileOverviewMark firstMark = (FileOverviewMark)((Pair)listOfMarks.get((int)0)).first;
            int offset = firstMark.getSelectionStart();
            if (offset < 0) {
                offset = this._lookupOffset(firstMark);
            }
            int startLine = this.editor.getLineFromOffset(offset);
            int endLine = this.editor.getLineFromOffset(offset + firstMark.getSelectionLength());
            Rectangle markRect = this.getLineRectangle(null, startLine + 1);
            Point gutterMarkTopPoint = markRect.getLocation();
            Point gutterMarkBottomPoint = (Point)gutterMarkTopPoint.clone();
            ArrayList<Pair<String, Color>> stringColorList = new ArrayList<Pair<String, Color>>();
            for (Pair markColorPair : listOfMarks) {
                int markEndLine;
                int markStartLine;
                FileOverviewMark mark = (FileOverviewMark)markColorPair.first;
                Color color = (Color)markColorPair.second;
                if (color == null) {
                    color = Color.WHITE;
                }
                if ((offset = mark.getSelectionStart()) < 0) {
                    offset = this._lookupOffset(mark);
                }
                if ((markStartLine = this.editor.getLineFromOffset(offset)) < startLine) {
                    startLine = markStartLine;
                }
                if ((markEndLine = this.editor.getLineFromOffset(offset + mark.getSelectionLength())) > endLine) {
                    endLine = markEndLine;
                }
                markRect = this.getLineRectangle(null, startLine + 1);
                if (gutterMarkTopPoint.y > markRect.y) {
                    gutterMarkTopPoint = markRect.getLocation();
                }
                if (gutterMarkBottomPoint.y < markRect.y + markRect.height) {
                    gutterMarkBottomPoint = markRect.getLocation();
                }
                gutterMarkBottomPoint.y = markRect.y + markRect.height;
                String message = mark.getToolTipText(event);
                Pair<String, Color> messageColorPair = new Pair<String, Color>(message, color);
                if (stringColorList.contains(messageColorPair)) continue;
                stringColorList.add(messageColorPair);
            }
            String[] messages = new String[stringColorList.size()];
            Color[] colors = new Color[stringColorList.size()];
            for (int i = 0; i < messages.length; ++i) {
                messages[i] = (String)((Pair)stringColorList.get((int)i)).first;
                colors[i] = (Color)((Pair)stringColorList.get((int)i)).second;
            }
            Font f = this.editor.getFont();
            int lineHeight = this.editor.getFontMetrics(f).getHeight();
            SwingUtilities.convertPointToScreen(gutterMarkTopPoint, this);
            Rectangle sourceRect = new Rectangle(gutterMarkTopPoint.x, gutterMarkTopPoint.y, 12, 6);
            EditorPeekPopup.showPopup((Object)messages.hashCode(), this.editor, messages, sourceRect, Math.max(-1, startLine - 2), Math.min(endLine + 1, this.editor.getLineCount() - 1), lineHeight, colors, (int)((float)lineHeight * 0.2f), 500);
        } else {
            EditorPeekPopup.hidePopup(false);
        }
    }

    static {
        categoryComparator = new Comparator(){

            public int compare(Object category1, Object category2) {
                int priority2;
                Integer p1 = (Integer)mapCategoryToPriority.get(category1);
                int priority1 = p1 != null ? p1 : 3;
                Integer p2 = (Integer)mapCategoryToPriority.get(category2);
                int n = priority2 = p2 != null ? p2 : 3;
                if (priority1 != priority2) {
                    return priority1 - priority2;
                }
                return ((String)category1).compareTo((String)category2);
            }
        };
        editorPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if (propertyName.equals("highlight-registry")) {
                    FileOverviewMargin.stylesChanged();
                }
            }
        };
        EditorProperties.getProperties().addPropertyChangeListener(editorPropertyChangeListener);
    }

    private class PeekListener
    extends MouseInputAdapter
    implements MouseHoverListener,
    AWTEventListener {
        private PeekListener() {
        }

        public void mouseHovered(MouseEvent event) {
            if (!EditorPeekPopup.isShowing()) {
                FileOverviewMargin.this._showOrHideGutterPeek(event);
            }
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            if (EditorPeekPopup.isShowing()) {
                FileOverviewMargin.this._showOrHideGutterPeek(event);
            }
        }

        @Override
        public void mouseExited(MouseEvent event) {
            EditorPeekPopup.hidePopup(false);
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            EditorPeekPopup.hidePopup(true);
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            KeyEvent ke;
            if (!FileOverviewMargin.this.isShowing()) {
                return;
            }
            if (event instanceof KeyEvent && (ke = (KeyEvent)event).getKeyCode() == 17) {
                if (ke.isControlDown()) {
                    if (EditorPeekPopup.isShowing()) {
                        return;
                    }
                    if (MouseInfo.getPointerInfo() == null) {
                        return;
                    }
                    Point p = MouseInfo.getPointerInfo().getLocation();
                    SwingUtilities.convertPointFromScreen(p, FileOverviewMargin.this);
                    if (!FileOverviewMargin.this.getVisibleRect().contains(p)) {
                        return;
                    }
                    int row = FileOverviewMargin.this.getRowAtY(p.y);
                    row = Math.max(-1, row - 4);
                    int startLine = FileOverviewMargin.this.editor.getLineFromRow(row);
                    int endRow = row + 10;
                    int endLine = FileOverviewMargin.this.editor.getLineFromRow(endRow);
                    endLine = Math.min(FileOverviewMargin.this.editor.getLineCount() - 1, endLine);
                    if (endLine - startLine >= 10) {
                        int lineHeight = FileOverviewMargin.this.editor.getFontMetrics(FileOverviewMargin.this.editor.getFont()).getHeight();
                        Point sp = p;
                        sp.x = 0;
                        SwingUtilities.convertPointToScreen(sp, FileOverviewMargin.this);
                        Rectangle sourceRect = new Rectangle(sp.x, sp.y, 12, 6);
                        EditorPeekPopup.showPopup((Object)startLine, FileOverviewMargin.this.editor, null, sourceRect, Math.max(-1, startLine), Math.min(endLine, FileOverviewMargin.this.editor.getLineCount() - 1), lineHeight, Color.LIGHT_GRAY, (int)((float)lineHeight * 0.2f), 500);
                    }
                } else {
                    if (!EditorPeekPopup.isShowing()) {
                        return;
                    }
                    EditorPeekPopup.hidePopup(false);
                }
            }
        }
    }

    private class CodeFoldingListener
    implements CodeExpansionListener,
    CodeFoldingModelListener {
        private CodeFoldingListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void codeExpanded(CodeExpansionEvent event) {
            if (FileOverviewMargin.this.codeFoldingModel != null) {
                FileOverviewMargin.this.codeFoldingModel.readLock();
                try {
                    Object block = event.getBlock();
                    FileOverviewMargin.this.removeCollapsedBlock(block);
                    FileOverviewMargin.this.addCollapsedChildren(block);
                    FileOverviewMargin.this.updateYMultiplier();
                }
                finally {
                    FileOverviewMargin.this.codeFoldingModel.readUnlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void codeCollapsed(CodeExpansionEvent event) {
            if (FileOverviewMargin.this.codeFoldingModel != null) {
                FileOverviewMargin.this.codeFoldingModel.readLock();
                try {
                    Object block = event.getBlock();
                    FileOverviewMargin.this.removeCollapsedChildren(block);
                    FileOverviewMargin.this.addCollapsedBlock(block);
                    FileOverviewMargin.this.updateYMultiplier();
                }
                finally {
                    FileOverviewMargin.this.codeFoldingModel.readUnlock();
                }
            }
        }

        @Override
        public void structureChanged(CodeFoldingModelEvent event) {
            FileOverviewMargin.this.rebuildFoldingFromScratch();
            FileOverviewMargin.this.updateYMultiplier();
        }
    }
}

