/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.editor.BasicAction;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.util.Log;

public abstract class EmacsAction
extends BasicAction {
    private static ArrayList killRingList = new ArrayList();
    private static int lastYankIndex = -1;
    private static final int MAX_KILL_RING_SIZE = 20;
    private static final String MARK_PROPERTY = "*emacs-mark*";
    private static final Log LOG = new Log("expiration");
    private static final String MARK_SET_MESSAGE = "Mark set";
    private static final String MARK_NOT_SET_MESSAGE = "The mark has not been set";
    private static final String END_BUFFER_MESSAGE = "End of buffer";
    private static final String READ_ONLY_MESSAGE = "Buffer is read-only";
    private static final String NEXT_KILL_APPEND = "If next command is a kill, it will append";
    private static final String PREVIOUS_NOT_YANK = "Previous command was not a yank";

    public EmacsAction(String actionName) {
        super(actionName);
    }

    @Override
    public abstract void actionPerformed(ActionEvent var1, BasicEditorPane var2, BasicDocument var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addKillRing(String text) {
        if (text == null || text.length() == 0) {
            return;
        }
        ArrayList arrayList = killRingList;
        synchronized (arrayList) {
            killRingList.add(text);
            EmacsAction.checkKillRingSize();
            EmacsAction.setClipboardText(text);
            lastYankIndex = killRingList.size() - 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void appendKillRing(String text) {
        if (text == null || text.length() == 0) {
            return;
        }
        ArrayList arrayList = killRingList;
        synchronized (arrayList) {
            int lastIndex;
            Object lastEntry;
            int listSize = killRingList.size();
            String lastText = "";
            if (listSize > 0 && (lastEntry = killRingList.remove(lastIndex = listSize - 1)) != null) {
                lastText = lastEntry.toString();
            }
            lastText = lastText + text;
            EmacsAction.addKillRing(lastText);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void prependKillRing(String text) {
        if (text == null || text.length() == 0) {
            return;
        }
        ArrayList arrayList = killRingList;
        synchronized (arrayList) {
            int lastIndex;
            Object lastEntry;
            int listSize = killRingList.size();
            String lastText = "";
            if (listSize > 0 && (lastEntry = killRingList.remove(lastIndex = listSize - 1)) != null) {
                lastText = lastEntry.toString();
            }
            lastText = text + lastText;
            EmacsAction.addKillRing(lastText);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String yankKillRing() {
        String yankText = "";
        ArrayList arrayList = killRingList;
        synchronized (arrayList) {
            boolean clipboardChanged = false;
            String clipboardText = EmacsAction.getClipboardText();
            if (lastYankIndex == -1) {
                clipboardChanged = true;
            } else {
                int listSize = killRingList.size();
                String topYankText = killRingList.get(listSize - 1).toString();
                if (!topYankText.equals(clipboardText)) {
                    clipboardChanged = true;
                }
            }
            if (clipboardChanged) {
                EmacsAction.addKillRing(clipboardText);
            }
            if (lastYankIndex != -1) {
                yankText = killRingList.get(lastYankIndex).toString();
            }
        }
        return yankText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String popKillRing() {
        String popText = "";
        ArrayList arrayList = killRingList;
        synchronized (arrayList) {
            int listSize = killRingList.size();
            if (listSize > 0) {
                if (--lastYankIndex < 0) {
                    lastYankIndex = listSize - 1;
                }
                popText = killRingList.get(lastYankIndex).toString();
            }
        }
        return popText;
    }

    private static void checkKillRingSize() {
        int listSize = killRingList.size();
        if (listSize > 20) {
            killRingList.remove(0);
        }
    }

    protected static String getClipboardText() {
        Clipboard clipboard = EmacsAction.getSystemClipboard();
        Transferable content = clipboard.getContents(null);
        String stringData = "";
        if (content != null) {
            try {
                Object data = content.getTransferData(DataFlavor.stringFlavor);
                stringData = (String)data;
            }
            catch (IOException e) {
                stringData = "";
            }
            catch (UnsupportedFlavorException e) {
                stringData = "";
            }
        }
        return stringData;
    }

    protected static void setClipboardText(String text) {
        if (text == null || text.length() == 0) {
            return;
        }
        StringSelection content = new StringSelection(text);
        Clipboard clipboard = EmacsAction.getSystemClipboard();
        ClipboardStack.pushCurrentClipboard();
        clipboard.setContents(content, null);
    }

    protected static Clipboard getSystemClipboard() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
        return clipboard;
    }

    protected static int getMark(BasicEditorPane editor) {
        Object mark = editor.getProperty(MARK_PROPERTY);
        if (mark != null) {
            OffsetMark offsetMark = (OffsetMark)mark;
            return offsetMark.getOffset();
        }
        return -1;
    }

    protected static void setMark(BasicEditorPane editor, int offset) {
        Object mark = editor.getProperty(MARK_PROPERTY);
        if (mark != null) {
            OffsetMark offsetMark = (OffsetMark)mark;
            offsetMark.setOffset(offset);
        } else {
            BasicDocument document = (BasicDocument)editor.getDocument();
            TextBuffer textBuffer = document.getTextBuffer();
            OffsetMark newMark = textBuffer.addOffsetMark(offset);
            editor.putProperty(MARK_PROPERTY, newMark);
        }
    }

    protected static void removeMark(BasicEditorPane editor) {
        OffsetMark mark = (OffsetMark)editor.getProperty(MARK_PROPERTY);
        BasicDocument document = (BasicDocument)editor.getDocument();
        if (mark != null && document != null) {
            TextBuffer textBuffer = document.getTextBuffer();
            try {
                textBuffer.removeOffsetMark(mark);
            }
            catch (ExpiredTextBufferException e) {
                LOG.trace("handled expiration in EmacsAction.removeMark: {0}", (Object)e);
            }
        }
        editor.putProperty(MARK_PROPERTY, null);
    }

    protected static void showMarkSetMessage(BasicEditorPane editor) {
        EmacsAction.showMessage(editor, MARK_SET_MESSAGE);
    }

    protected static void showMarkNotSetMessage(BasicEditorPane editor) {
        EmacsAction.showMessage(editor, MARK_NOT_SET_MESSAGE);
    }

    protected static void showEndBufferMessage(BasicEditorPane editor) {
        EmacsAction.showMessage(editor, END_BUFFER_MESSAGE);
    }

    protected static void showReadOnlyMessage(BasicEditorPane editor) {
        EmacsAction.showMessage(editor, READ_ONLY_MESSAGE);
    }

    protected static void showNextKillAppendMessage(BasicEditorPane editor) {
        EmacsAction.showMessage(editor, NEXT_KILL_APPEND);
    }

    protected static void showPreviousNotYankMessage(BasicEditorPane editor) {
        EmacsAction.showMessage(editor, PREVIOUS_NOT_YANK);
    }

    protected static final class Tracker
    implements CaretListener,
    EditorPlugin,
    FocusListener {
        private int lastKillOffset = -1;
        private BasicEditorPane lastEditor = null;

        protected Tracker() {
        }

        protected boolean matchesEditor(BasicEditorPane editor, int offset) {
            return editor == this.lastEditor && offset == this.lastKillOffset;
        }

        protected void trackEditor(BasicEditorPane editor) {
            if (this.lastEditor != null) {
                this.lastEditor.deinstallPlugin(this);
            }
            editor.installPlugin(this);
        }

        @Override
        public void install(BasicEditorPane editor) {
            this.lastEditor = editor;
            this.lastKillOffset = editor.getCaretPosition();
            editor.addFocusListener(this);
            editor.addCaretListener(this);
        }

        @Override
        public void deinstall(BasicEditorPane editor) {
            editor.removeFocusListener(this);
            editor.removeCaretListener(this);
            this.lastKillOffset = -1;
            this.lastEditor = null;
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
        }

        @Override
        public void caretUpdate(CaretEvent event) {
            this.lastEditor.deinstallPlugin(this);
        }

        @Override
        public void focusGained(FocusEvent event) {
            this.lastEditor.deinstallPlugin(this);
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.lastEditor.deinstallPlugin(this);
        }
    }
}

