/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.editor.ActionInvoker;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.EditorSelection;
import oracle.javatools.editor.EditorSelectionColumns;
import oracle.javatools.editor.EditorSelectionWrap;
import oracle.javatools.editor.EmacsAction;
import oracle.javatools.editor.FontHelper;
import oracle.javatools.editor.PopupManager;
import oracle.javatools.editor.Utilities;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.DocumentRenderer;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.StyledFragment;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.resource.BundleHelper;

public class BasicCaret
extends DefaultCaret
implements PropertyChangeListener,
TextBufferListener {
    public static final int CARET_VERTICAL_BAR = 1;
    public static final int CARET_DOUBLE_VERTICAL_BAR = 2;
    public static final int CARET_TRIPLE_VERTICAL_BAR = 7;
    public static final int CARET_QUAD_VERTICAL_BAR = 8;
    public static final int CARET_UNDER_BAR = 3;
    public static final int CARET_DOUBLE_UNDER_BAR = 4;
    public static final int CARET_TRIPLE_UNDER_BAR = 9;
    public static final int CARET_QUAD_UNDER_BAR = 10;
    public static final int CARET_OUTLINE_BOX = 5;
    public static final int CARET_SOLID_BOX = 6;
    public static final String CARET_SHAPE_INSERT = "caret-shape-insert";
    public static final String CARET_SHAPE_OVERWRITE = "caret-shape-overwrite";
    public static final String CARET_ENABLE_BLINK = "caret-enable-blink";
    public static final String CARET_BLINK_RATE = "caret-blink-rate";
    public static final String CARET_COLOR = "caret-color";
    public static final String CARET_XOR_PAINTING = "caret-xor-painting";
    public static final String CARET_RIGHT_CLICK_SELECTION = "caret-right-click-selection";
    public static final String CARET_EDITOR_SELECTION_TYPE = "caret-editor-selection-type";
    public static final int CARET_EDITOR_SELECTION_WRAP = 20;
    public static final int CARET_EDITOR_SELECTION_COLUMNS = 21;
    protected int lastClickCount = 0;
    protected int lastClickOffset = 0;
    private boolean inInsertMode = true;
    private int fontHeight;
    private int fontWidth = -1;
    private Scroller scroller = new Scroller();
    private HighlightLayer selectionLayer;
    private static HighlightStyle caretStyle;
    private EditorSelection editorSelection;
    public static final String HIGHLIGHT_SELECTION_NAME = "highlight-selection";
    private int savedDot;
    private Rectangle savedRect;

    @Override
    public void install(JTextComponent component) {
        super.install(component);
        BasicEditorPane editor = (BasicEditorPane)component;
        editor.addPropertyChangeListener(this);
        BasicDocument document = (BasicDocument)editor.getDocument();
        if (document != null) {
            TextBuffer buffer = document.getTextBuffer();
            buffer.addTextBufferListener((TextBufferListener)this);
        }
        int selType = (Integer)editor.getProperty(CARET_EDITOR_SELECTION_TYPE);
        switch (selType) {
            case 20: {
                this.editorSelection = new EditorSelectionWrap();
                break;
            }
            case 21: {
                this.editorSelection = new EditorSelectionColumns();
            }
        }
        this.editorSelection.install(editor);
    }

    @Override
    public void deinstall(JTextComponent component) {
        BasicEditorPane editor = (BasicEditorPane)component;
        editor.removePropertyChangeListener(this);
        BasicDocument document = (BasicDocument)editor.getDocument();
        if (document != null) {
            TextBuffer buffer = document.getTextBuffer();
            buffer.removeTextBufferListener((TextBufferListener)this);
        }
        if (this.selectionLayer != null) {
            editor.destroyHighlightLayer(this.selectionLayer);
            this.selectionLayer = null;
        }
        if (this.editorSelection != null) {
            this.editorSelection.deinstall();
        }
        this.editorSelection = null;
        super.deinstall(component);
    }

    @Override
    protected void adjustVisibility(Rectangle newRect) {
        if (this.getEditorPane().hasFocus()) {
            this.scroller.adjustVisibility(newRect);
        }
    }

    @Override
    public void setDot(int dot) {
        int oldDot = this.getDot();
        int oldMark = this.getMark();
        int validStart = this.getEditorPane().getValidOffsetStart();
        int validEnd = this.getEditorPane().getValidOffsetEnd();
        if (dot < validStart) {
            dot = validStart;
        }
        if (validEnd != -1 && dot > validEnd) {
            dot = validEnd;
        }
        this.setMagicCaretPosition(null);
        super.setDot(dot);
        if (this.editorSelection != null) {
            try {
                Rectangle caretRect = this.getEditorPane().modelToView(dot);
                if (caretRect != null) {
                    this.editorSelection.setStartSelectionPoint(caretRect.getLocation());
                    this.editorSelection.setEndSelectionPoint(caretRect.getLocation());
                } else {
                    this.editorSelection.setStartSelectionPoint(new Point(0, 0));
                    this.editorSelection.setEndSelectionPoint(new Point(0, 0));
                }
            }
            catch (BadLocationException e) {
                this.editorSelection.setStartSelectionPoint(new Point(0, 0));
                this.editorSelection.setEndSelectionPoint(new Point(0, 0));
            }
        }
        if (oldDot == dot && oldDot != oldMark) {
            this.fireStateChanged();
        }
    }

    @Override
    public void moveDot(int dot) {
        int validStart = this.getEditorPane().getValidOffsetStart();
        int validEnd = this.getEditorPane().getValidOffsetEnd();
        if (dot < validStart) {
            dot = validStart;
        }
        if (validEnd != -1 && dot > validEnd) {
            dot = validEnd;
        }
        this.setMagicCaretPosition(null);
        if (this.editorSelection != null) {
            try {
                Rectangle caretRect = this.getEditorPane().modelToView(dot);
                if (caretRect != null) {
                    this.editorSelection.setEndSelectionPoint(caretRect.getLocation());
                } else {
                    this.editorSelection.setEndSelectionPoint(new Point(0, 0));
                }
            }
            catch (BadLocationException e) {
                this.editorSelection.setEndSelectionPoint(new Point(0, 0));
            }
        }
        super.moveDot(dot);
        BasicEditorPane editor = this.getEditorPane();
        int mark = this.getMark();
        EmacsAction.setMark(editor, mark);
    }

    @Override
    protected void fireStateChanged() {
        this.updateHighlight();
        super.fireStateChanged();
    }

    public void updateHighlight() {
        if (this.editorSelection != null) {
            this.editorSelection.updateSelectionHighlight(this.getHighlightLayer(), caretStyle);
        }
    }

    public ActionInvoker getActionInvoker() {
        BasicEditorPane editor = this.getEditorPane();
        return editor.getActionInvoker();
    }

    @Override
    protected void moveCaret(MouseEvent event) {
        int offset = this.getOffsetForMouseEvent(event);
        if (this.editorSelection != null) {
            this.editorSelection.setEndSelectionPoint(event.getPoint());
        }
        if (offset >= 0) {
            BasicEditorPane editor = this.getEditorPane();
            editor.beginNavigation();
            this.moveDot(offset);
            editor.endNavigation();
            int mark = this.getMark();
            EmacsAction.setMark(editor, mark);
        }
        this.updateHighlight();
    }

    @Override
    protected void positionCaret(MouseEvent event) {
        int offset = this.getOffsetForMouseEvent(event);
        if (this.editorSelection != null) {
            this.editorSelection.setStartSelectionPoint(event.getPoint());
        }
        if (offset >= 0) {
            BasicEditorPane editor = this.getEditorPane();
            editor.beginNavigation();
            this.setDot(offset);
            editor.endNavigation();
        }
    }

    protected void adjustCaretPosition(MouseEvent event) {
        if ((event.getModifiers() & 1) != 0 && this.getDot() != -1) {
            this.moveCaret(event);
        } else {
            this.positionCaret(event);
        }
    }

    protected int getOffsetForMouseEvent(MouseEvent event) {
        boolean inInsert;
        Point point = new Point(event.getX(), event.getY());
        Position.Bias[] biasRet = new Position.Bias[1];
        JTextComponent component = this.getComponent();
        int offset = component.getUI().viewToModel(component, point, biasRet);
        if (biasRet[0] == null) {
            biasRet[0] = Position.Bias.Forward;
        }
        if (offset >= 0 && (inInsert = this.getInsertMode())) {
            offset = this.adjustInsertOffset(offset, point, biasRet[0]);
        }
        return offset;
    }

    protected boolean isPressInSelection(MouseEvent event) {
        Point clickPoint;
        int dot = this.getDot();
        int mark = this.getMark();
        int start = Math.min(dot, mark);
        int end = Math.max(dot, mark);
        int threshold = 5;
        BasicEditorPane editor = this.getEditorPane();
        int clickOffset = editor.viewToModel(clickPoint = event.getPoint());
        if (start <= clickOffset && clickOffset < end) {
            return true;
        }
        Point[] pointsToCheck = null;
        if (clickOffset < start) {
            pointsToCheck = new Point[]{new Point(clickPoint.x + threshold, clickPoint.y), new Point(clickPoint.x + threshold, clickPoint.y + threshold), new Point(clickPoint.x, clickPoint.y + threshold), new Point(clickPoint.x - threshold, clickPoint.y + threshold)};
        } else if (clickOffset >= end) {
            pointsToCheck = new Point[]{new Point(clickPoint.x - threshold, clickPoint.y), new Point(clickPoint.x - threshold, clickPoint.y - threshold), new Point(clickPoint.x, clickPoint.y - threshold), new Point(clickPoint.x + threshold, clickPoint.y - threshold)};
        }
        int numPoints = pointsToCheck != null ? pointsToCheck.length : 0;
        for (int i = 0; i < numPoints; ++i) {
            int pointOffset = editor.viewToModel((Point)pointsToCheck[i]);
            if (start > pointOffset || pointOffset >= end) continue;
            return true;
        }
        return false;
    }

    private boolean isPointInPaddedRect(Point point, Rectangle rect, int horizontalPad, int verticalPad) {
        rect.x -= horizontalPad;
        rect.width += horizontalPad * 2;
        rect.y -= verticalPad;
        rect.height += verticalPad * 2;
        if (rect.x < 0) {
            rect.width += rect.x;
            rect.x = 0;
        }
        if (rect.y < 0) {
            rect.height += rect.y;
            rect.y = 0;
        }
        return rect.contains(point);
    }

    private int adjustInsertOffset(int offset, Point point, Position.Bias bias) {
        if (offset < 0) {
            return offset;
        }
        JTextComponent component = this.getComponent();
        Document document = component.getDocument();
        int length = document.getLength();
        if (offset < length - 1) {
            try {
                int rightDistance;
                int pointX;
                int leftDistance;
                Rectangle currentRect = component.getUI().modelToView(component, offset, bias);
                Rectangle nextRect = component.getUI().modelToView(component, offset + 1, bias);
                if (currentRect.y == nextRect.y && (leftDistance = (pointX = (int)point.getX()) - currentRect.x) > (rightDistance = nextRect.x - pointX)) {
                    ++offset;
                }
            }
            catch (BadLocationException e) {
                System.out.println("Exception: " + e.toString());
            }
        }
        return offset;
    }

    @Override
    public void focusGained(FocusEvent event) {
        if (this.getComponent().isEnabled()) {
            this.setVisible(true);
            this.setSelectionVisible(true);
        }
    }

    @Override
    protected synchronized void damage(Rectangle r) {
        this.updateMetrics();
        if (r != null) {
            this.x = r.x - 4;
            this.y = r.y;
            this.updateCaretSize();
            this.repaint();
        }
    }

    private void updateCaretSize() {
        this.width = this.fontWidth * 2 + 8;
        this.height = this.fontHeight;
    }

    @Override
    public void paint(Graphics g) {
        this.updateMetrics();
        if (!this.isVisible()) {
            return;
        }
        BasicEditorPane editor = this.getEditorPane();
        boolean useInsertCaret = this.getInsertMode();
        String caretProperty = useInsertCaret ? CARET_SHAPE_INSERT : CARET_SHAPE_OVERWRITE;
        int caretShape = editor.getIntegerProperty(caretProperty);
        try {
            TextUI mapper = editor.getUI();
            int caretDot = this.getDot();
            Rectangle caretRect = mapper.modelToView(editor, caretDot);
            Color caretColor = (Color)editor.getProperty(CARET_COLOR);
            if (caretColor == null) {
                caretColor = editor.getCaretColor();
            }
            FontMetrics metricsToUse = null;
            Font fontToUse = null;
            Color backgroundToUse = null;
            FontHelper fontHelper = editor.getFontHelper();
            BasicDocument document = (BasicDocument)editor.getDocument();
            DocumentRenderer renderer = document.getDocumentRenderer();
            int line = editor.getLineFromOffset(caretDot);
            StyledFragmentsList fragmentsList = renderer.renderLines(line, line);
            int numFragments = fragmentsList.size();
            for (int i = 0; i < numFragments; ++i) {
                StyledFragment fragment = fragmentsList.get(i);
                if (fragment.startOffset > caretDot || caretDot >= fragment.endOffset) continue;
                StyleRegistry registry = editor.getStyleRegistry();
                BaseStyle style = registry.lookupStyle(fragment.styleName);
                int fontStyle = style.getFontStyle();
                fontToUse = fontHelper.getFont(fontStyle);
                metricsToUse = fontHelper.getFontMetrics(fontStyle, (Component)editor);
                backgroundToUse = style.getBackgroundColor();
                break;
            }
            if (metricsToUse == null || fontToUse == null) {
                fontToUse = fontHelper.getFont(0);
                metricsToUse = fontHelper.getFontMetrics(0, (Component)editor);
            }
            if (backgroundToUse == null) {
                backgroundToUse = editor.getBackground();
            }
            fragmentsList.clear();
            renderer.recycleFragmentsList(fragmentsList);
            TextBuffer buffer = document.getTextBuffer();
            char c = caretDot < buffer.getLength() ? (char)buffer.getChar(caretDot) : (char)'\n';
            int charWidth = metricsToUse.charWidth(c);
            if (charWidth == 0) {
                charWidth = this.fontWidth;
            }
            int fontAscent = metricsToUse.getAscent();
            int fontDescent = metricsToUse.getDescent();
            int underlinePos = caretRect.y + fontAscent + fontDescent - 1;
            g.setColor(caretColor);
            boolean useXOR = editor.getBooleanProperty(CARET_XOR_PAINTING);
            if (useXOR) {
                g.setXORMode(backgroundToUse);
            }
            boolean useAA = editor.getBooleanProperty("editor-antialiasing");
            switch (caretShape) {
                case 1: {
                    g.drawLine(caretRect.x, caretRect.y, caretRect.x, caretRect.y + this.fontHeight - 1);
                    break;
                }
                case 2: {
                    g.fillRect(caretRect.x, caretRect.y, 2, this.fontHeight - 1);
                    break;
                }
                case 7: {
                    g.fillRect(caretRect.x, caretRect.y, 3, this.fontHeight - 1);
                    break;
                }
                case 8: {
                    g.fillRect(caretRect.x, caretRect.y, 4, this.fontHeight - 1);
                    break;
                }
                case 3: {
                    g.drawLine(caretRect.x, underlinePos, caretRect.x + charWidth, underlinePos);
                    break;
                }
                case 4: {
                    g.fillRect(caretRect.x, underlinePos - 1, charWidth, 2);
                    break;
                }
                case 9: {
                    g.fillRect(caretRect.x, underlinePos - 2, charWidth, 3);
                    break;
                }
                case 10: {
                    g.fillRect(caretRect.x, underlinePos - 3, charWidth, 4);
                    break;
                }
                case 5: {
                    g.drawRect(caretRect.x, caretRect.y, charWidth, this.fontHeight - 1);
                    break;
                }
                case 6: {
                    g.fillRect(caretRect.x, caretRect.y, charWidth, this.fontHeight - 1);
                    if (useXOR || Character.isWhitespace(c)) break;
                    g.setColor(backgroundToUse);
                    g.setFont(fontToUse);
                    Object oldAAValue = null;
                    if (useAA) {
                        Graphics2D graphics2d = (Graphics2D)g;
                        oldAAValue = graphics2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                        graphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    }
                    g.drawString("" + c, caretRect.x, caretRect.y + fontAscent);
                    if (!useAA) break;
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAAValue);
                }
            }
            if (useXOR) {
                g.setPaintMode();
            }
        }
        catch (BadLocationException e) {
            return;
        }
    }

    public boolean getInsertMode() {
        return this.inInsertMode;
    }

    public void setInsertMode(boolean insertMode) {
        boolean doRepaint = insertMode != this.inInsertMode;
        this.inInsertMode = insertMode;
        if (doRepaint) {
            this.updateCaretSize();
            this.repaint();
            this.fireStateChanged();
        }
    }

    public void toggleInsertMode() {
        this.setInsertMode(!this.inInsertMode);
    }

    public EditorSelection getEditorSelection() {
        return this.editorSelection;
    }

    public void setEditorSelection(EditorSelection newEditorSelection) {
        if (newEditorSelection == null) {
            throw new IllegalArgumentException("null editorSelection");
        }
        if (!newEditorSelection.canSupportEditor(this.getEditorPane())) {
            return;
        }
        if (this.editorSelection == null) {
            this.editorSelection = newEditorSelection;
            this.getEditorSelection().install(this.getEditorPane());
        } else {
            this.editorSelection.clearSelectionHighlights(this.getHighlightLayer());
            this.editorSelection.deinstall();
            this.editorSelection = newEditorSelection;
            this.getEditorSelection().install(this.getEditorPane());
            if (this.getEditorPane().hasSelection()) {
                this.setDot(this.getDot());
            }
        }
    }

    private void updateMetrics() {
        JTextComponent component;
        Font font;
        if (this.fontWidth == -1 && (font = (component = this.getComponent()).getFont()) != null) {
            FontMetrics metrics = component.getFontMetrics(font);
            this.fontWidth = metrics.charWidth('m');
            this.fontHeight = metrics.getHeight();
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        try {
            Toolkit toolkit;
            Clipboard clipboard;
            BasicEditorPane editor;
            if (SwingUtilities.isMiddleMouseButton(event) && event.getClickCount() == 1 && (editor = this.getEditorPane()) != null && (clipboard = (toolkit = editor.getToolkit()).getSystemSelection()) != null) {
                this.adjustCaretPosition(event);
                editor.pasteFromClipboard(toolkit, clipboard);
            }
        }
        catch (ExpiredTextBufferException expiredTextBufferException) {
            // empty catch block
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        block6: {
            try {
                if (!SwingUtilities.isLeftMouseButton(event)) break block6;
                if (this.lastClickCount == 2) {
                    int offset = this.getOffsetForMouseEvent(event);
                    BasicEditorPane editor = this.getEditorPane();
                    BasicDocument document = (BasicDocument)editor.getDocument();
                    offset = Math.max(0, offset);
                    offset = Math.min(offset, document.getLength());
                    int leftBoundary = Math.min(offset, this.lastClickOffset);
                    int rightBoundary = Math.max(offset, this.lastClickOffset);
                    int leftOffset = Utilities.getWordStart(document, leftBoundary);
                    int rightOffset = Utilities.getWordEnd(document, rightBoundary);
                    boolean draggingForward = offset > this.lastClickOffset;
                    int dragStart = draggingForward ? leftOffset : rightOffset;
                    int dragEnd = draggingForward ? rightOffset : leftOffset;
                    this.setDot(dragStart);
                    this.moveDot(dragEnd);
                    break block6;
                }
                if (this.lastClickCount == 3) {
                    int rightOffset;
                    int leftOffset;
                    int offset = this.getOffsetForMouseEvent(event);
                    BasicEditorPane editor = this.getEditorPane();
                    BasicDocument document = (BasicDocument)editor.getDocument();
                    offset = Math.max(0, offset);
                    offset = Math.min(offset, document.getLength());
                    int leftBoundary = Math.min(offset, this.lastClickOffset);
                    int rightBoundary = Math.max(offset, this.lastClickOffset);
                    try {
                        Rectangle leftRect = editor.modelToView(leftBoundary);
                        Point leftPoint = new Point(0, leftRect.y);
                        leftOffset = editor.viewToModel(leftPoint);
                        Rectangle rightRect = editor.modelToView(rightBoundary);
                        Point rightPoint = new Point(0, rightRect.y + this.fontHeight);
                        rightOffset = editor.viewToModel(rightPoint);
                    }
                    catch (BadLocationException e) {
                        leftOffset = leftBoundary;
                        rightOffset = rightBoundary;
                    }
                    boolean draggingForward = offset > this.lastClickOffset;
                    int dragStart = draggingForward ? leftOffset : rightOffset;
                    int dragEnd = draggingForward ? rightOffset : leftOffset;
                    this.setDot(dragStart);
                    this.moveDot(dragEnd);
                    break block6;
                }
                int offset = this.getOffsetForMouseEvent(event);
                this.moveDot(offset);
                this.editorSelection.setEndSelectionPoint(event.getPoint());
                this.updateHighlight();
            }
            catch (ExpiredTextBufferException expiredTextBufferException) {
                // empty catch block
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        try {
            if (SwingUtilities.isLeftMouseButton(event)) {
                this.lastClickCount = (event.getClickCount() - 1) % 3 + 1;
                if (this.lastClickCount == 1) {
                    this.adjustCaretPosition(event);
                    JTextComponent component = this.getComponent();
                    if (component != null && !component.hasFocus() && component.isEnabled()) {
                        MenuSelectionManager.defaultManager().clearSelectedPath();
                        component.requestFocus();
                    }
                    this.lastClickOffset = this.getDot();
                } else if (this.lastClickCount == 2) {
                    this.getActionInvoker().invokeAction("select-word");
                } else if (this.lastClickCount == 3) {
                    this.getActionInvoker().invokeAction("select-line");
                }
            }
            if (SwingUtilities.isRightMouseButton(event)) {
                int mark;
                BasicEditorPane editor = this.getEditorPane();
                int dot = this.getDot();
                if (dot == (mark = this.getMark())) {
                    this.positionCaret(event);
                } else if (editor.getBooleanProperty(CARET_RIGHT_CLICK_SELECTION) && !this.isPressInSelection(event)) {
                    this.positionCaret(event);
                }
                if (editor != null && editor.isEnabled()) {
                    editor.requestFocus();
                }
            }
            this.checkIsPopupTrigger(event);
        }
        catch (ExpiredTextBufferException expiredTextBufferException) {
            // empty catch block
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        super.mouseReleased(event);
        this.checkIsPopupTrigger(event);
        if (SwingUtilities.isLeftMouseButton(event)) {
            this.lastClickCount = 0;
        }
    }

    private void checkIsPopupTrigger(MouseEvent event) {
        BasicEditorPane editor;
        PopupManager popupManager;
        if (event.isPopupTrigger() && (popupManager = (editor = this.getEditorPane()).getPopupManager()) != null) {
            popupManager.showPopup(editor, event);
        }
    }

    private HighlightLayer getHighlightLayer() {
        if (this.selectionLayer == null) {
            BasicEditorPane editor = this.getEditorPane();
            this.selectionLayer = editor.createHighlightLayer();
        }
        return this.selectionLayer;
    }

    private BasicEditorPane getEditorPane() {
        return (BasicEditorPane)this.getComponent();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("editor-font")) {
            this.fontWidth = -1;
            this.updateMetrics();
            this.repaint();
        } else if (propertyName.equals(CARET_ENABLE_BLINK) || propertyName.equals(CARET_BLINK_RATE)) {
            BasicEditorPane editor = this.getEditorPane();
            boolean enableBlink = editor.getBooleanProperty(CARET_ENABLE_BLINK);
            int blinkRate = enableBlink ? editor.getIntegerProperty(CARET_BLINK_RATE) : 0;
            this.setBlinkRate(blinkRate);
        } else if (propertyName.equals(CARET_SHAPE_INSERT) || propertyName.equals(CARET_SHAPE_OVERWRITE) || propertyName.equals(CARET_COLOR)) {
            this.repaint();
        } else if (propertyName.equals("document")) {
            Object newValue;
            Object oldValue = event.getOldValue();
            if (oldValue instanceof BasicDocument) {
                BasicDocument doc = (BasicDocument)oldValue;
                TextBuffer buffer = doc.getTextBuffer();
                buffer.removeTextBufferListener((TextBufferListener)this);
            }
            if ((newValue = event.getNewValue()) instanceof BasicDocument) {
                BasicDocument doc = (BasicDocument)newValue;
                TextBuffer buffer = doc.getTextBuffer();
                buffer.addTextBufferListener((TextBufferListener)this);
            }
        }
    }

    public void insertUpdate(TextBuffer buffer, int offset, int count, char[] insertedData) {
    }

    public void removeUpdate(TextBuffer buffer, int offset, int count, char[] removedData) {
    }

    public void attributeUpdate(TextBuffer buffer, int attribute) {
        BasicEditorPane editor = this.getEditorPane();
        switch (attribute) {
            case 3: {
                this.savedDot = this.getDot();
                if (!SwingUtilities.isEventDispatchThread()) break;
                try {
                    this.savedRect = new Rectangle();
                    editor.computeVisibleRect(this.savedRect);
                }
                catch (Exception e) {
                    this.savedRect = null;
                }
                break;
            }
            case 4: {
                if (SwingUtilities.isEventDispatchThread()) {
                    if (this.savedRect != null) {
                        editor.scrollRectToVisible(this.savedRect);
                    }
                    this.savedRect = null;
                }
                BasicDocument document = (BasicDocument)editor.getDocument();
                int length = document.getLength();
                this.savedDot = Math.min(this.savedDot, length);
                this.setDot(this.savedDot);
                break;
            }
        }
    }

    protected Rectangle getCaretInsets(Rectangle caretRect) {
        if (this.useJumpScrolling()) {
            return caretRect;
        }
        this.updateMetrics();
        Rectangle newRect = new Rectangle(caretRect);
        int widthPerColumn = this.fontWidth > 0 ? this.fontWidth : 10;
        int heightPerRow = this.fontHeight > 0 ? this.fontHeight : 15;
        int adjustX = widthPerColumn * this.getColumnInsets();
        int adjustY = heightPerRow * this.getRowInsets();
        newRect.x -= adjustX;
        newRect.y -= adjustY;
        newRect.width += adjustX * 2;
        newRect.height += adjustY * 2;
        BasicEditorPane editor = this.getEditorPane();
        int height = editor.getHeight();
        int width = editor.getWidth();
        newRect.x = Math.max(newRect.x, 0);
        newRect.y = Math.max(newRect.y, 0);
        newRect.width = Math.min(newRect.width, width - newRect.x);
        newRect.height = Math.min(newRect.height, height - newRect.y);
        return newRect;
    }

    private boolean useJumpScrolling() {
        BasicEditorPane editor = this.getEditorPane();
        return editor.getBooleanProperty("use-jump-scroll");
    }

    private int getRowInsets() {
        if (this.useJumpScrolling()) {
            return 0;
        }
        BasicEditorPane editor = this.getEditorPane();
        return editor.getIntegerProperty("caret-inset-rows");
    }

    private int getColumnInsets() {
        if (this.useJumpScrolling()) {
            return 0;
        }
        BasicEditorPane editor = this.getEditorPane();
        return editor.getIntegerProperty("caret-inset-columns");
    }

    static {
        EditorProperties properties = EditorProperties.getProperties();
        HighlightRegistry registry = properties.getHighlightRegistry();
        BundleHelper resources = EditorProperties.getEditorBundle();
        String name = resources.getString("ACTIVE_SELECTION_HIGHLIGHT");
        caretStyle = registry.createStyle(HIGHLIGHT_SELECTION_NAME, name, 100, Color.white, Color.blue);
    }

    private class Scroller
    implements Runnable {
        private Rectangle rect = null;
        private boolean isScheduled = false;

        private Scroller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void adjustVisibility(Rectangle newRect) {
            Scroller scroller = this;
            synchronized (scroller) {
                this.rect = newRect;
                if (!this.isScheduled) {
                    if (SwingUtilities.isEventDispatchThread()) {
                        this.run();
                    } else {
                        this.isScheduled = true;
                        SwingUtilities.invokeLater(this);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Scroller scroller = this;
            synchronized (scroller) {
                this.isScheduled = false;
                BasicEditorPane editor = BasicCaret.this.getEditorPane();
                if (editor != null) {
                    if (BasicCaret.this.useJumpScrolling()) {
                        editor.ensureVisibleAndCentered(this.rect);
                    } else {
                        Rectangle insetRect = BasicCaret.this.getCaretInsets(this.rect);
                        editor.scrollRectToVisible(insetRect);
                    }
                }
            }
        }
    }
}

