/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.dialogs.progress;

import java.awt.Component;
import javax.swing.JProgressBar;
import oracle.javatools.dialogs.progress.AbstractProgressMonitor;

public class IndeterminateProgressMonitor
extends AbstractProgressMonitor {
    private boolean _started;
    private DelayThread _delayThread;

    public IndeterminateProgressMonitor(Component parent, String title) {
        this(parent, title, null, null);
    }

    public IndeterminateProgressMonitor(Component parent, String title, Object message, String note) {
        super(parent, title, message, note);
    }

    @Override
    public synchronized void start() {
        if (this._started) {
            return;
        }
        this._started = true;
        int millisToPopup = this.getMillisToPopup();
        if (millisToPopup <= 0) {
            this.display();
            return;
        }
        this._delayThread = new DelayThread(millisToPopup){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected final void runDelayed() {
                IndeterminateProgressMonitor indeterminateProgressMonitor = IndeterminateProgressMonitor.this;
                synchronized (indeterminateProgressMonitor) {
                    if (IndeterminateProgressMonitor.this.getPanel() != null) {
                        IndeterminateProgressMonitor.this.display();
                    }
                }
            }
        };
        this._delayThread.start();
    }

    @Override
    protected JProgressBar createProgressBar() {
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        return progressBar;
    }

    @Override
    protected void displayImpl() {
        super.displayImpl();
        this.stop();
    }

    @Override
    protected void finishImpl(JProgressBar progressBar) {
        super.finishImpl(progressBar);
        this.stop();
        if (progressBar == null) {
            return;
        }
        progressBar.setIndeterminate(false);
        progressBar.setValue(progressBar.getMaximum());
    }

    @Override
    protected void closeImpl() {
        super.closeImpl();
        this.stop();
    }

    private synchronized void stop() {
        if (this._delayThread == null) {
            return;
        }
        this._delayThread.exit();
        this._delayThread = null;
    }

    private static abstract class DelayThread
    extends Thread {
        private final int _millisToPopup;
        private boolean _exit;

        DelayThread(int millisToPopup) {
            this._millisToPopup = millisToPopup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                DelayThread delayThread = this;
                synchronized (delayThread) {
                    this.wait(this._millisToPopup);
                }
                Thread.yield();
                delayThread = this;
                synchronized (delayThread) {
                    if (this._exit) {
                        return;
                    }
                }
                this.runDelayed();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void exit() {
            DelayThread delayThread = this;
            synchronized (delayThread) {
                this._exit = true;
                this.notify();
            }
        }

        protected abstract void runDelayed();
    }
}

