/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.dialogs.progress;

import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.JProgressBar;
import oracle.javatools.dialogs.progress.AbstractProgressMonitor;

public class DeterminateProgressMonitor
extends AbstractProgressMonitor {
    private int _min;
    private int _max;
    private int _v;
    private int _millisToDecideToPopup;
    private int _reportDelta;
    private int _lastDisp;
    private long _T0;

    public DeterminateProgressMonitor(Component parent, String title) {
        this(parent, title, null, null, 0, 0);
    }

    public DeterminateProgressMonitor(Component parent, String title, int min, int max) {
        this(parent, title, null, null, min, max);
    }

    public DeterminateProgressMonitor(Component parent, String title, Object message, String note) {
        this(parent, title, message, note, 0, 0);
    }

    public DeterminateProgressMonitor(Component parent, String title, Object message, String note, int min, int max) {
        super(parent, title, message, note);
        this._min = min;
        this._max = max;
        this._v = this._min;
        this.recalculateReportDelta();
        this._T0 = System.currentTimeMillis();
    }

    public int getProgress() {
        return this._v;
    }

    public void incProgress() {
        this.incProgress(1);
    }

    public void incProgress(int increment) {
        this.setProgress(this._v + increment);
    }

    @Override
    public synchronized void start() {
        this.setProgress(this._min);
        this.display();
    }

    public void setProgress(int nv) {
        if (EventQueue.isDispatchThread()) {
            new IllegalStateException("Cannot update progress monitor from the AWT event thread.").printStackTrace();
        }
        if (this._max <= this._min) {
            this.display();
            return;
        }
        this._v = nv;
        if (nv >= this._max) {
            this.finish();
            return;
        }
        if (nv >= this._lastDisp + this._reportDelta) {
            this._lastDisp = nv;
            JProgressBar progressBar = this.getPanel().getProgressBar();
            if (progressBar != null) {
                progressBar.setValue(nv);
            } else {
                int millisToPopup;
                int predictedCompletionTime;
                long T = System.currentTimeMillis();
                long dT = (int)(T - this._T0);
                if (dT >= (long)this._millisToDecideToPopup && (predictedCompletionTime = nv > this._min ? (int)(dT * (long)(this._max - this._min) / (long)(nv - this._min)) : millisToPopup) >= (millisToPopup = this.getMillisToPopup())) {
                    this.display();
                }
            }
        }
    }

    public int getMinimum() {
        return this._min;
    }

    public void setMinimum(int m) {
        this._min = m;
        JProgressBar progressBar = this.getPanel().getProgressBar();
        if (progressBar != null) {
            progressBar.setMinimum(m);
        }
        this.recalculateReportDelta();
    }

    public int getMaximum() {
        return this._max;
    }

    public void setMaximum(int m) {
        this._max = m;
        JProgressBar progressBar = this.getPanel().getProgressBar();
        if (progressBar != null) {
            progressBar.setMaximum(m);
        }
        this.recalculateReportDelta();
    }

    public void setMillisToDecideToPopup(int millisToDecideToPopup) {
        this._millisToDecideToPopup = millisToDecideToPopup;
    }

    public int getMillisToDecideToPopup() {
        return this._millisToDecideToPopup;
    }

    @Override
    protected JProgressBar createProgressBar() {
        JProgressBar progressBar = super.createProgressBar();
        progressBar.setIndeterminate(false);
        progressBar.setMinimum(this._min);
        progressBar.setMaximum(this._max);
        progressBar.setValue(this._v);
        return progressBar;
    }

    @Override
    protected void finishImpl(JProgressBar progressBar) {
        super.finishImpl(progressBar);
        if (progressBar == null) {
            return;
        }
        progressBar.setValue(progressBar.getMaximum());
    }

    private void recalculateReportDelta() {
        this._reportDelta = (this._max - this._min) / 100;
        if (this._reportDelta < 1) {
            this._reportDelta = 1;
        }
    }
}

