/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import oracle.javatools.datatransfer.AugmentableTransferable;
import oracle.javatools.datatransfer.ExtendedTransferable;
import oracle.javatools.datatransfer.TransferDataInfo;
import oracle.javatools.datatransfer.TransferUtils;
import oracle.javatools.datatransfer.TransferableBackedTransferDataInfo;

final class SimpleAugmentableTransferable
extends AugmentableTransferable {
    private int _modCount = 0;
    private String _shortDesc = null;
    private String _mediumDesc = null;
    private final HashMap _map = new HashMap(17);
    private final ArrayList _sortedFlavorList = new ArrayList();
    private final Comparator _comparator = new FlavorByHighestRankComparator();
    private static final float _RANK_DELTA_WHEN_ADDING_TRANSFERABLE = 1.0E-4f;
    private static final float _DEFAULT_INITIAL_RANK_WHEN_ADDING_TRANSFERABLE = 0.5f;

    public SimpleAugmentableTransferable() {
    }

    public SimpleAugmentableTransferable(Transferable base) {
        if (base instanceof AugmentableTransferable) {
            throw new IllegalStateException("tried to create proxying transferable from already augmentable one: " + base);
        }
        this._augmentWithTransferable(base, false);
    }

    public static AugmentableTransferable createPrefetchedCopy(Transferable original) {
        SimpleAugmentableTransferable ret = new SimpleAugmentableTransferable();
        ret._augmentWithTransferable(original, true);
        return ret;
    }

    @Override
    public AugmentableTransferable getCopy() {
        return new SimpleAugmentableTransferable(this);
    }

    @Override
    public List getDataInfos(DataFlavor flavor) {
        List ret = (List)this._map.get(flavor);
        if (ret != null) {
            return ret;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public String getShortDescription() {
        return this._shortDesc;
    }

    @Override
    public String getMediumDescription() {
        return this._mediumDesc;
    }

    @Override
    public void augment(TransferDataInfo info) {
        this._augmentHelper(info);
        this._sortFlavorList();
        ++this._modCount;
    }

    @Override
    public int getModificationCount() {
        return this._modCount;
    }

    @Override
    public Iterator getOrderedFlavorIterator() {
        return this._sortedFlavorList.iterator();
    }

    @Override
    protected int getFlavorCount() {
        return this._map.size();
    }

    @Override
    protected boolean isFlavorSupported(DataFlavor flavor) {
        return this._map.containsKey(flavor);
    }

    private List _findOrCreateList(DataFlavor flavor) {
        LinkedList ret = this._findList(flavor);
        if (ret == null) {
            ret = new LinkedList();
            this._map.put(flavor, ret);
            this._sortedFlavorList.add(flavor);
        }
        return ret;
    }

    private void _sortFlavorList() {
        Collections.sort(this._sortedFlavorList, this._comparator);
    }

    private void _augmentHelper(TransferDataInfo info) {
        Object md;
        List list = this._findOrCreateList(info.getDataFlavor());
        if (list.isEmpty()) {
            list.add(info);
        } else {
            ListIterator<TransferDataInfo> itor = list.listIterator();
            while (itor.hasNext()) {
                TransferDataInfo other = (TransferDataInfo)itor.next();
                if (other.compareTo(info) <= 0) continue;
                itor.previous();
                break;
            }
            itor.add(info);
        }
        if (this._shortDesc == null && (md = info.getMetadata(TransferDataInfo.METADATA_SHORT_DESCRIPTION)) != null) {
            this._shortDesc = md.toString();
        }
        if (this._mediumDesc == null && (md = info.getMetadata(TransferDataInfo.METADATA_MEDIUM_DESCRIPTION)) != null) {
            this._mediumDesc = md.toString();
        }
    }

    private void _augmentWithTransferable(Transferable base, boolean eager) {
        if (!eager && base instanceof ExtendedTransferable) {
            this._augmentWithExtendedTransferable((ExtendedTransferable)base);
        } else {
            this._augmentWithRegularTransferable(base, eager);
        }
        this._sortFlavorList();
        ++this._modCount;
    }

    private void _augmentWithRegularTransferable(Transferable trans, boolean eager) {
        DataFlavor[] flavors = trans.getTransferDataFlavors();
        boolean allowEarlyFetch = trans.isDataFlavorSupported(TransferUtils.FLAVOR_SAFE_TO_FETCH_CONTENTS_EARLY_MARKER);
        float rank = 0.5f;
        for (int i = 0; i < flavors.length; ++i) {
            DataFlavor flavor = flavors[i];
            if (flavor == TransferUtils.FLAVOR_SAFE_TO_FETCH_CONTENTS_EARLY_MARKER) continue;
            TransferDataInfo info = eager ? TransferUtils.createDataInfo(flavor, TransferUtils.getDataIfAvailable(trans, flavor), rank, null) : new TransferableBackedTransferDataInfo(trans, flavor, rank, allowEarlyFetch);
            this._augmentHelper(info);
            rank -= 1.0E-4f;
        }
    }

    private void _augmentWithExtendedTransferable(ExtendedTransferable base) {
        Iterator flavorItor = base.getOrderedFlavorIterator();
        while (flavorItor.hasNext()) {
            List infos = base.getDataInfos((DataFlavor)flavorItor.next());
            Iterator infoItor = infos.iterator();
            while (infoItor.hasNext()) {
                this._augmentHelper((TransferDataInfo)infoItor.next());
            }
        }
    }

    private List _findList(DataFlavor flavor) {
        return (List)this._map.get(flavor);
    }

    private SimpleAugmentableTransferable(SimpleAugmentableTransferable source) {
        this._modCount = source._modCount;
        this._shortDesc = source._shortDesc;
        this._mediumDesc = source._mediumDesc;
        this._map.putAll(source._map);
        this._sortedFlavorList.addAll(source._sortedFlavorList);
    }

    private class FlavorByHighestRankComparator
    implements Comparator {
        private FlavorByHighestRankComparator() {
        }

        public int compare(Object o1, Object o2) {
            DataFlavor f1 = (DataFlavor)o1;
            DataFlavor f2 = (DataFlavor)o2;
            List list1 = SimpleAugmentableTransferable.this._findList(f1);
            List list2 = SimpleAugmentableTransferable.this._findList(f2);
            assert (list1 != null);
            assert (list2 != null);
            assert (!list1.isEmpty());
            assert (!list2.isEmpty());
            Comparable first1 = (Comparable)list1.get(0);
            Comparable first2 = (Comparable)list2.get(0);
            return first1.compareTo(first2);
        }
    }
}

