/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls.nicetable;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.controls.nicetable.NiceTableModel;
import oracle.javatools.ui.table.TableHelper;

public class NiceTableHeaderRenderer
extends DefaultTableCellRenderer {
    private final DefaultTableCellRenderer _defaultRenderer = (DefaultTableCellRenderer)new JTable().getTableHeader().getDefaultRenderer();
    static final Dimension SORT_ICON_SIZE = new Dimension(9, 5);

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this._defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (table != null) {
            JTableHeader header = table.getTableHeader();
            if (header != null) {
                this._defaultRenderer.setBackground(header.getBackground());
                this._defaultRenderer.setFont(header.getFont());
                if (table.isEnabled()) {
                    this._defaultRenderer.setForeground(header.getForeground());
                } else {
                    this._defaultRenderer.setForeground(UIManager.getColor("textInactiveText"));
                }
            }
            if (table instanceof NiceTable && ((NiceTable)table).getBaseModel() instanceof NiceTableModel) {
                int modelColumn = table.convertColumnIndexToModel(column);
                NiceTableModel niceModel = (NiceTableModel)((NiceTable)table).getBaseModel();
                this._defaultRenderer.setHorizontalAlignment(niceModel.getColumnAlignment(modelColumn));
                if (table instanceof NiceTable && ((NiceTable)table).isSorted() && ((NiceTable)table).getSortColumn() == modelColumn) {
                    this._defaultRenderer.setHorizontalTextPosition(2);
                    boolean ascending = ((NiceTable)table).isSortAscending();
                    Icon i = ascending ? TableHelper.getSortIconUp() : TableHelper.getSortIconDown();
                    this._defaultRenderer.setIcon(i);
                } else {
                    this._defaultRenderer.setIcon(null);
                }
            }
        }
        this._defaultRenderer.setBorder(BorderFactory.createCompoundBorder(this._defaultRenderer.getBorder(), BorderFactory.createEmptyBorder(0, 4, 0, 4)));
        return this._defaultRenderer;
    }
}

