/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.SwingUtilities;
import oracle.javatools.util.ClosureException;
import oracle.javatools.util.GraphicsUtils;
import oracle.javatools.util.SwingClosure;
import oracle.javatools.util.SwingUtils;

public class SplashScreen {
    private static SplashWindow splash;
    protected static Image splashImage;
    private static final int progressOffsetStart = 20;
    private static int progressOffset;
    private static int msgCounter;
    private static int lastPos;
    private static final int defaultTotalMsgs = 461;
    private static int totalSqares;
    private static int totalMsgs;
    private static boolean dismissed;
    private static boolean keepHidden;

    protected SplashScreen() {
    }

    public static void create(String filename) {
        if (splashImage != null || !SplashScreen._fileExists(filename)) {
            return;
        }
        splashImage = Toolkit.getDefaultToolkit().createImage(filename);
        SplashScreen._create();
    }

    public static void create(String filename, int nsteps) {
        SplashScreen.create(filename);
        totalMsgs = nsteps;
    }

    public static int getCurrentMsgCounter() {
        return msgCounter;
    }

    public static void setVisible(boolean visible) {
        if (splash != null) {
            splash.setVisible(visible);
        }
    }

    public static boolean isDismissed() {
        return dismissed;
    }

    public static void dismiss() {
        if (splash != null) {
            try {
                new SwingClosure(true){

                    @Override
                    public void runImpl() {
                        SplashScreen._dismiss();
                    }
                }.run();
            }
            catch (ClosureException closureException) {
                // empty catch block
            }
        }
    }

    public static boolean isKeepHidden() {
        return keepHidden;
    }

    public static void setKeepHidden(boolean keepHidden) {
        SplashScreen.keepHidden = keepHidden;
    }

    public static void log(String msg) {
        int pos;
        if (splash == null) {
            return;
        }
        final Graphics g = splash.getGraphics();
        if (g != null && lastPos != (pos = ++msgCounter * totalSqares / totalMsgs) && progressOffset - 20 < 360) {
            lastPos = pos;
            final int offset = progressOffset;
            progressOffset += 10;
            if (SwingUtilities.isEventDispatchThread()) {
                if (splash != null) {
                    g.setColor(Color.lightGray);
                    g.drawRect(19, 173, 360, 9);
                    g.setColor(Color.red);
                    for (int i = 20; i <= offset; i += 10) {
                        g.fillRect(i, 174, 9, 8);
                    }
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (splash != null) {
                            g.setColor(Color.lightGray);
                            g.drawRect(19, 173, 360, 9);
                            g.setColor(Color.red);
                            for (int i = 20; i <= offset; i += 10) {
                                g.fillRect(i, 174, 9, 8);
                            }
                        }
                    }
                });
            }
        }
    }

    protected static void _create() {
        if (splashImage == null || splash != null) {
            return;
        }
        try {
            splash = new SplashWindow(SwingUtils.getStartupWindow());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            SplashScreen.dismiss();
        }
    }

    private static synchronized void _dismiss() {
        if (splash != null) {
            splash.dispose();
            splash = null;
            dismissed = true;
        }
        if (splashImage != null) {
            splashImage.flush();
            splashImage = null;
        }
    }

    private static boolean _fileExists(String filename) {
        return new File(filename).exists();
    }

    static {
        progressOffset = 20;
        msgCounter = 0;
        lastPos = 0;
        totalSqares = 36;
        totalMsgs = 461;
    }

    private static final class SplashWindow
    extends Window
    implements MouseListener,
    AWTEventListener,
    Runnable {
        boolean waitForImage = true;

        @Override
        public void run() {
            this.setVisible(true);
            this.waitForImage = false;
            Graphics g = this.getGraphics();
            this.paint(g);
        }

        public SplashWindow(Frame frame) {
            super(frame);
            Toolkit.getDefaultToolkit().prepareImage(splashImage, -1, -1, this);
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 64L);
            this.addMouseListener(this);
            while (this.waitForImage) {
                try {
                    Thread.sleep(1L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        @Override
        public void paint(Graphics g) {
            g.drawImage(splashImage, 0, 0, this);
        }

        @Override
        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            if ((infoflags & 0x20) != 0) {
                this.setSize(width, height);
                GraphicsUtils.centerWindowOnScreen((Window)this);
                this.toFront();
                try {
                    SwingUtilities.invokeAndWait(this);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return super.imageUpdate(img, infoflags, x, y, width, height);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.removeMouseListener(this);
            SplashScreen.dismiss();
            msgCounter = totalMsgs;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (event.getSource() != this) {
                switch (event.getID()) {
                    case 200: {
                        if (SplashScreen.isDismissed()) break;
                        this.setVisible(false);
                        break;
                    }
                    case 202: {
                        if (SplashScreen.isDismissed() || SplashScreen.isKeepHidden()) break;
                        this.setVisible(true);
                    }
                }
            }
        }

        @Override
        public void dispose() {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            super.dispose();
        }
    }
}

