/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;

public class SimpleListModel<T>
extends AbstractListModel
implements Iterable<T> {
    private final List<T> m_delegate;
    private final List<T> m_facade = new AbstractList<T>(){

        @Override
        public T get(int index) {
            return SimpleListModel.this.m_delegate.get(index);
        }

        @Override
        public int size() {
            return SimpleListModel.this.m_delegate.size();
        }

        @Override
        public T set(int index, T element) {
            Object ret = SimpleListModel.this.m_delegate.set(index, element);
            SimpleListModel.this.fireContentsChanged(SimpleListModel.this, index, index);
            return ret;
        }

        @Override
        public void add(int index, T element) {
            SimpleListModel.this.m_delegate.add(index, element);
            SimpleListModel.this.fireIntervalAdded(SimpleListModel.this, index, index);
        }

        @Override
        public T remove(int index) {
            Object ret = SimpleListModel.this.m_delegate.remove(index);
            SimpleListModel.this.fireIntervalRemoved(SimpleListModel.this, index, index);
            return ret;
        }

        @Override
        public boolean addAll(Collection<? extends T> items) {
            if (items.isEmpty()) {
                return false;
            }
            int lastIndex = this.size();
            boolean ret = SimpleListModel.this.m_delegate.addAll(items);
            SimpleListModel.this.fireIntervalAdded(SimpleListModel.this, lastIndex, this.size() - 1);
            return ret;
        }

        @Override
        public void clear() {
            int size = this.size();
            if (size == 0) {
                return;
            }
            super.clear();
            SimpleListModel.this.fireIntervalRemoved(SimpleListModel.this, 0, size - 1);
        }
    };

    public SimpleListModel() {
        this(new ArrayList());
    }

    public SimpleListModel(List<T> list) {
        if (list == null) {
            throw new NullPointerException("list is null");
        }
        this.m_delegate = list;
    }

    public List<T> asList() {
        return this.m_facade;
    }

    @Override
    public int getSize() {
        return this.m_delegate.size();
    }

    @Override
    public T getElementAt(int i) {
        return this.m_delegate.get(i);
    }

    @Override
    public Iterator<T> iterator() {
        return Collections.unmodifiableList(this.m_delegate).iterator();
    }

    public void addElements(Iterator<T> i) {
        int firstIndex = this.m_delegate.size();
        while (i.hasNext()) {
            this.m_delegate.add(i.next());
        }
        if (this.getSize() != 0) {
            super.fireIntervalAdded(this, firstIndex, this.getSize() - 1);
        }
    }

    public void addElement(T o) {
        this.asList().add(o);
    }

    private void removeIndicesSlow(int[] indices) {
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            T element = this.getElementAt(index - i);
            this.removeElement(element);
        }
    }

    public void removeIndices(int[] indices) {
        this.removeIndicesFast(indices);
    }

    private void removeIndicesFast(int[] indices) {
        if (indices.length == 0) {
            return;
        }
        int startRangeIndex = -1;
        int endRangeIndex = -1;
        int endOfLastRange = -1;
        for (int i = 0; i < indices.length; ++i) {
            int thisIndex = indices[i];
            if (i == 0) {
                startRangeIndex = thisIndex;
            }
            this.m_delegate.remove(thisIndex - i);
            if (endRangeIndex != -1 && thisIndex - endRangeIndex > 1) {
                int delta = endOfLastRange + 1;
                this.fireIntervalRemoved(this, startRangeIndex - delta, endRangeIndex - delta);
                endOfLastRange = endRangeIndex;
                startRangeIndex = thisIndex;
            }
            endRangeIndex = thisIndex;
        }
        int delta = endOfLastRange + 1;
        this.fireIntervalRemoved(this, startRangeIndex - delta, endRangeIndex - delta);
    }

    public void removeElement(T o) {
        this.asList().remove(o);
    }

    public void removeAll() {
        this.asList().clear();
    }

    public void changed(int index) {
        this.checkBounds(index);
        super.fireContentsChanged(this, index, index);
    }

    private void checkBounds(int index) {
        if (index < 0 || index > this.getSize() - 1) {
            throw new IndexOutOfBoundsException("Index " + index + " must be between 0 and " + (this.getSize() - 1));
        }
    }

    public void changed() {
        if (this.getSize() == 0) {
            return;
        }
        super.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    public void moveUp(int index) {
        this.checkBounds(index);
        if (index <= 0) {
            return;
        }
        T o = this.m_delegate.remove(index);
        super.fireIntervalRemoved(this, index, index);
        this.m_delegate.add(index - 1, o);
        super.fireIntervalAdded(this, index - 1, index - 1);
    }

    public void moveDown(int index) {
        this.checkBounds(index);
        if (index == this.getSize() - 1) {
            return;
        }
        T o = this.m_delegate.remove(index);
        super.fireIntervalRemoved(this, index, index);
        this.m_delegate.add(index + 1, o);
        super.fireIntervalAdded(this, index + 1, index + 1);
    }

    public void insertAt(int index, T o) {
        this.m_delegate.add(index, o);
        super.fireIntervalAdded(this, index, index);
    }
}

