/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;
import oracle.javatools.compare.view.SplitPanelLayout;
import oracle.javatools.resource.CompareResource;
import oracle.javatools.util.BundleLoader;

public final class SplitPanel
extends JPanel {
    private final JComponent _leftSplitter;
    private final JComponent _centerSplitter;
    private final SplitPanelLayout _layout = new SplitPanelLayout();
    public static final int SPLITTER_WIDTH = 50;
    private static final int SPLITTER_HEIGHT = 20;

    public SplitPanel() {
        this.setLayout(this._layout);
        this._leftSplitter = this.createSplitter();
        this._centerSplitter = this.createSplitter();
        this.add((Component)this._leftSplitter, "leftSplitTop");
        this.add((Component)this._centerSplitter, "centerSplitTop");
        this.registerMouseHandler(this._leftSplitter, false);
        this.registerMouseHandler(this._centerSplitter, true);
        this.updateSplitterToolTips();
    }

    public final void removeAllExceptSplitters() {
        this.removeAll();
        this.add((Component)this._leftSplitter, "leftSplitTop");
        this.add((Component)this._centerSplitter, "centerSplitTop");
    }

    private JComponent createSplitter() {
        JLabel splitter = new JLabel(new ImageIcon(CompareResource.class.getResource("/oracle/javatools/icons/images/splitter.gif")));
        splitter.setPreferredSize(new Dimension(50, 20));
        splitter.setCursor(Cursor.getPredefinedCursor(11));
        MatteBorder splitterBorder = BorderFactory.createMatteBorder(0, 1, 0, 1, UIManager.getColor("controlShadow"));
        splitter.setBorder(splitterBorder);
        return splitter;
    }

    private ImageIcon getIcon(String name) {
        return new ImageIcon(CompareResource.class.getResource(name));
    }

    private static ResourceBundle getBundle() {
        return BundleLoader.getBundle((String)"oracle.javatools.resource.CompareResource");
    }

    private void registerMouseHandler(Component splitter, boolean isCenter) {
        SplitterMouseHandler handler = new SplitterMouseHandler(splitter, isCenter);
        splitter.addMouseListener(handler);
        splitter.addMouseMotionListener(handler);
    }

    private void updateSplitterToolTips() {
        String tooltip = null;
        tooltip = this._layout.isEven() ? SplitPanel.getBundle().getString("WEDGE_SPLITTER_CENTERED_TOOLTIP") : SplitPanel.getBundle().getString("WEDGE_SPLITTER_OFFCENTER_TOOLTIP");
        this._leftSplitter.setToolTipText(tooltip);
        this._centerSplitter.setToolTipText(tooltip);
    }

    public void setThreePaneMode(boolean threePaneMode) {
        this._layout.setThreePaneMode(threePaneMode);
    }

    public boolean isThreePaneMode() {
        return this._layout.isThreePaneMode();
    }

    public void moveSplitter(Component splitter, int location, boolean center) {
        this.moveSplitter(splitter, location, center, null);
    }

    public void moveSplitter(Component splitter, int location, boolean center, Component parent) {
        this._layout.moveSplitter(splitter, location, center, parent);
        this.revalidate();
        this.updateSplitterToolTips();
    }

    public static void main(String[] args) {
        SplitPanel p = new SplitPanel();
        SplitPanel.addLabel(p, "leftOverview", Color.MAGENTA);
        SplitPanel.addLabel(p, "leftGutter", Color.RED);
        SplitPanel.addLabel(p, "leftTitle", Color.GREEN);
        SplitPanel.addLabel(p, "leftEditor", Color.BLUE);
        SplitPanel.addLabel(p, "leftSplit", Color.MAGENTA);
        SplitPanel.addLabel(p, "centerTitle", Color.YELLOW);
        SplitPanel.addLabel(p, "centerEditor", Color.GRAY);
        SplitPanel.addLabel(p, "centerSplit", Color.PINK);
        SplitPanel.addLabel(p, "rightTitle", Color.RED);
        SplitPanel.addLabel(p, "rightEditor", Color.GREEN);
        SplitPanel.addLabel(p, "rightGutter", Color.BLUE);
        SplitPanel.addLabel(p, "rightScrollbar", Color.CYAN);
        SplitPanel.addLabel(p, "rightOverview", Color.MAGENTA);
        p.setThreePaneMode(false);
        JFrame f = new JFrame();
        f.setContentPane(p);
        f.pack();
        f.setVisible(true);
    }

    private static void addLabel(Container c, String constraint, Color color) {
        JLabel l = new JLabel();
        l.setOpaque(true);
        l.setBackground(color);
        l.setText(constraint);
        c.add((Component)l, constraint);
    }

    private class SplitterMouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private final Component _splitter;
        private final boolean _isCenter;

        public SplitterMouseHandler(Component splitterComponent, boolean center) {
            this._splitter = splitterComponent;
            this._isCenter = center;
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            if (me.getClickCount() == 2 && me.getButton() == 1) {
                SplitPanel.this._layout.resetSplitters();
                SplitPanel.this.invalidate();
                SplitPanel.this.validate();
                SplitPanel.this.updateSplitterToolTips();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            SplitPanel.this._layout.moveSplitter(this._splitter, e.getPoint(), this._isCenter);
            SplitPanel.this.revalidate();
            SplitPanel.this.updateSplitterToolTips();
        }

        @Override
        public void mouseMoved(MouseEvent me) {
        }
    }
}

