/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.clipboard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.clipboard.StackedTransferable;
import oracle.javatools.resource.DialogsBundle;
import oracle.javatools.util.Pair;
import oracle.javatools.util.SwingUtils;

public class ClipboardStackDialog
implements ListSelectionListener,
MouseListener {
    private JList _bufferList;
    private JTextArea _contentTextArea;
    private JScrollPane _contentScrollPane;
    private DefaultListModel _model;
    private DismissableJEWTDialog _dialog;

    public Object runDialog() {
        int selectedIndex;
        boolean b;
        Object ret = null;
        JLabel headerLabel = new JLabel();
        this.createModel();
        this._bufferList = new JList(this._model);
        this._bufferList.getSelectionModel().setSelectionMode(0);
        ClipboardStackDialog.resLabel(headerLabel, this._bufferList, DialogsBundle.getBundle().getString("CS_BUFFERS"));
        this._bufferList.addListSelectionListener(this);
        this._bufferList.addMouseListener(this);
        this._bufferList.setCellRenderer(new BufferListRenderer());
        JLabel detailLabel = new JLabel();
        this._contentTextArea = new JTextArea();
        this._contentTextArea.setEditable(false);
        this._contentScrollPane = new JScrollPane(this._contentTextArea);
        ClipboardStackDialog.resLabel(detailLabel, this._contentTextArea, DialogsBundle.getBundle().getString("CS_CONTENT"));
        JPanel panel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(2, 2, 2, 2);
        panel.add((Component)headerLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        panel.add((Component)new JScrollPane(this._bufferList), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
        panel.add((Component)detailLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        panel.add((Component)this._contentScrollPane, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
        panel.setPreferredSize(new Dimension(400, 300));
        HelpUtils.setHelpID((JComponent)panel, (String)"f1_extended_paste_html");
        this._dialog = new DismissableJEWTDialog();
        this._dialog.setContent(panel);
        this._dialog.setResizable(true);
        if (this._model.size() > 0) {
            this._bufferList.setSelectedIndex(0);
        }
        if ((b = this.doInvoke(new JEWTDialogInvoker(){

            @Override
            public boolean doIt() {
                return ClipboardStackDialog.this._dialog.runDialog();
            }
        })) && (selectedIndex = this._bufferList.getSelectedIndex()) != -1) {
            Pair selectedElement = (Pair)this._model.getElementAt(selectedIndex);
            ret = selectedElement.getSecond();
        }
        return ret;
    }

    public static void resLabel(JLabel label, Component labelFor, String labelText) {
        label.setText(StringUtils.stripMnemonic((String)labelText));
        label.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)labelText));
        label.setLabelFor(labelFor);
    }

    private boolean doInvoke(JEWTDialogInvoker invoker) {
        if (EventQueue.isDispatchThread()) {
            invoker.run();
        } else {
            try {
                EventQueue.invokeAndWait(invoker);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return invoker.getResponse();
    }

    private void createModel() {
        this._model = new DefaultListModel();
        Object[] elems = ClipboardStack.getContent();
        for (int i = 0; i < elems.length; ++i) {
            this._model.addElement(elems[i]);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        boolean okEnabled = false;
        int selectedIndex = this._bufferList.getSelectedIndex();
        if (selectedIndex != -1) {
            Pair selectedElement = (Pair)this._model.getElementAt(selectedIndex);
            Transferable tt = (Transferable)selectedElement.getSecond();
            String value = "";
            try {
                value = tt.isDataFlavorSupported(StackedTransferable.BUFFER_DESCRIPTION_FLAVOR) ? (String)tt.getTransferData(StackedTransferable.BUFFER_DESCRIPTION_FLAVOR) : (String)tt.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception ex) {
                // empty catch block
            }
            this._contentTextArea.setText(value);
            this._contentTextArea.setCaretPosition(0);
            okEnabled = true;
        }
        this._dialog.setOKButtonEnabled(okEnabled);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1) {
            this._dialog.dismiss();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private class BufferListRenderer
    extends DefaultListCellRenderer {
        private Font _italicFont;
        private Font _normalFont;

        private BufferListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (this._normalFont == null) {
                this._normalFont = label.getFont();
                this._italicFont = this._normalFont.deriveFont(2);
            }
            if (value instanceof Pair && ((String)((Pair)value).getFirst()).trim().length() == 0) {
                label.setFont(this._italicFont);
                label.setText(DialogsBundle.getBundle().getString("CS_WHITESPACE"));
            } else {
                label.setFont(this._normalFont);
            }
            return label;
        }
    }

    private static final class DismissableJEWTDialog
    extends JEWTDialog {
        public DismissableJEWTDialog() {
            super(SwingUtils.getMainWindow(), DialogsBundle.getBundle().getString("CS_PASTE"), 7);
        }

        private void dismiss() {
            this.dismissDialog(false);
        }
    }

    private abstract class JEWTDialogInvoker
    implements Runnable {
        private boolean m_response;

        private JEWTDialogInvoker() {
        }

        @Override
        public void run() {
            this.m_response = this.doIt();
        }

        public boolean getResponse() {
            return this.m_response;
        }

        public abstract boolean doIt();
    }
}

