/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.assembly;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.AssemblyFactory;
import oracle.javatools.assembly.ObjectArrayFactory;
import oracle.javatools.assembly.ObjectFactory;

public class MapFactory
extends ObjectFactory {
    private AssemblyFactory _keysFactory;
    private AssemblyFactory _valuesFactory;
    private static final byte MAP_CODE = 58;

    public MapFactory(AssemblyFactory keyFactory, AssemblyFactory valueFactory) {
        this._keysFactory = new ObjectArrayFactory(keyFactory);
        this._valuesFactory = new ObjectArrayFactory(valueFactory);
    }

    @Override
    public byte getObjectCode() {
        return 58;
    }

    @Override
    public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
        Object[] keys = (Object[])this._keysFactory.assemble(input);
        Object[] values = (Object[])this._valuesFactory.assemble(input);
        int numKeys = keys.length;
        HashMap<Object, Object> map = new HashMap<Object, Object>(numKeys);
        for (int i = 0; i < numKeys; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    @Override
    public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
        Map map = (Map)object;
        Object[] keys = map.keySet().toArray();
        int numKeys = keys.length;
        Object[] values = new Object[numKeys];
        for (int i = 0; i < numKeys; ++i) {
            values[i] = map.get(keys[i]);
        }
        this._keysFactory.disassemble(keys, output);
        this._valuesFactory.disassemble(values, output);
    }
}

