/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.worker;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.bali.ewt.model.ObjectModel;
import oracle.bali.ewt.worker.InvocationContext;
import oracle.bali.ewt.worker.Worker;
import oracle.bali.ewt.worker.WorkerQueue;
import oracle.bali.ewt.worker.WorkerUtils;
import oracle.bali.share.util.BooleanUtils;

public abstract class AbstractWorker
implements Worker {
    private PropertyChangeSupport _changeSupport = null;
    private boolean _enabled = true;
    private Hashtable _keyTable = null;
    private Hashtable _defaultsTable = null;

    protected AbstractWorker() {
    }

    public Object putValue(Object key, Object newValue) {
        if (key == null) {
            return null;
        }
        Object oldValue = this.getValue(key);
        Dictionary keyTable = this._getValueDictionary();
        if (newValue != null) {
            keyTable.put(key, newValue);
        } else {
            keyTable.remove(key);
        }
        this.firePropertyChange(key, oldValue, newValue);
        return oldValue;
    }

    public Object getValue(Object key) {
        if (this._keyTable == null) {
            return null;
        }
        return this._getValueDictionary().get(key);
    }

    public Enumeration getValueKeys() {
        return this._getValueDictionary().keys();
    }

    public synchronized void setEnabled(boolean newEnabled) {
        boolean oldEnabled = this.isEnabled();
        this._enabled = newEnabled;
        this.fireEnabledPropertyChange(oldEnabled);
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void putDefaultParameterValue(Object key, Object value) {
        if (value == null) {
            value = WorkerUtils.PARAMETER_NULL;
        } else if (value == InvocationContext.UNDEFINED) {
            value = null;
        }
        this._getDefaultsDictionary().put(key, value);
    }

    public Object getDefaultParameterValue(Object key) {
        Object value = InvocationContext.UNDEFINED;
        if (this._defaultsTable != null) {
            value = this._getDefaultsDictionary().get(key);
            if (value == null) {
                value = InvocationContext.UNDEFINED;
            } else if (value == WorkerUtils.PARAMETER_NULL) {
                value = null;
            } else if (value instanceof ObjectModel) {
                value = ((ObjectModel)value).getObject();
            }
        }
        return value;
    }

    public final Object run(InvocationContext invokeContext) throws Throwable {
        if (this.isEnabled()) {
            return this.runWorker(invokeContext);
        }
        throw this.getDisabledWorkerException(invokeContext);
    }

    protected abstract Object runWorker(InvocationContext var1) throws Throwable;

    public Object clone() {
        AbstractWorker newWorker = null;
        try {
            newWorker = (AbstractWorker)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
        return newWorker;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this._changeSupport == null) {
            this._changeSupport = new PropertyChangeSupport(this);
        }
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this._changeSupport != null) {
            this._changeSupport.removePropertyChangeListener(listener);
        }
    }

    public static void setWorkerQueue(Worker worker, WorkerQueue newWorkerQueue) {
        worker.putValue(WORKER_QUEUE, newWorkerQueue);
    }

    public static WorkerQueue getWorkerQueue(Worker worker) {
        return (WorkerQueue)worker.getValue(WORKER_QUEUE);
    }

    public static void setName(Worker worker, String newName) {
        worker.putValue(WORKER_NAME, newName);
    }

    public static String getName(Worker worker) {
        return (String)worker.getValue(WORKER_NAME);
    }

    public static void setCommand(Worker worker, String newCommand) {
        worker.putValue(WORKER_COMMAND, newCommand);
    }

    public static String getCommand(Worker worker) {
        return (String)worker.getValue(WORKER_COMMAND);
    }

    public final void setName(String newName) {
        AbstractWorker.setName(this, newName);
    }

    public final String getName() {
        return AbstractWorker.getName(this);
    }

    public final void setCommand(String newCommand) {
        AbstractWorker.setCommand(this, newCommand);
    }

    public final String getCommand() {
        return AbstractWorker.getCommand(this);
    }

    public final void setWorkerQueue(WorkerQueue newWorkerQueue) {
        AbstractWorker.setWorkerQueue(this, newWorkerQueue);
    }

    public final WorkerQueue getWorkerQueue() {
        return AbstractWorker.getWorkerQueue(this);
    }

    protected Throwable getDisabledWorkerException(InvocationContext invokeContext) {
        return new IllegalStateException("Attempt to run disabled Worker:" + this);
    }

    protected void firePropertyChange(Object key, Object oldValue, Object newValue) {
        if (this._changeSupport != null && (oldValue != null || newValue != null)) {
            this._changeSupport.firePropertyChange(key.toString(), oldValue, newValue);
        }
    }

    protected final void fireEnabledPropertyChange(boolean wasEnabled) {
        boolean isEnabled = this.isEnabled();
        if (wasEnabled != isEnabled) {
            this.firePropertyChange("enabled", BooleanUtils.getBoolean((boolean)wasEnabled), BooleanUtils.getBoolean((boolean)isEnabled));
        }
    }

    private Dictionary _getValueDictionary() {
        if (this._keyTable == null) {
            this._keyTable = new Hashtable(11);
        }
        return this._keyTable;
    }

    private Dictionary _getDefaultsDictionary() {
        if (this._defaultsTable == null) {
            this._defaultsTable = new Hashtable(7);
        }
        return this._defaultsTable;
    }
}

