/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.validate;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.ValidationManager;
import oracle.bali.share.collection.StringKey;

public class JTextValidationHandler {
    private static final JTextValidationHandler[] _HANDLER = new JTextValidationHandler[4];
    private static final Object _SOURCE_COMP_KEY = new StringKey("_EWTValidationTextComp");
    private Listener _listener = new Listener();
    private ArrayList _compList = new ArrayList();
    private ValidationManager _manager = new ValidationManager();
    private boolean _focusLostValidate;
    private boolean _textChangeValidate = true;

    public void registerComponent(ValidationComponent vComp) {
        if (vComp == null) {
            return;
        }
        Component comp = vComp.getComponent();
        if (!(comp instanceof JTextComponent)) {
            throw new IllegalArgumentException();
        }
        JTextComponent textComp = (JTextComponent)comp;
        this._compList.add(textComp);
        this._putValidationComponent(textComp, vComp);
        Document doc = textComp.getDocument();
        if (doc != null) {
            doc.putProperty(_SOURCE_COMP_KEY, textComp);
        }
        textComp.addPropertyChangeListener(this._listener);
        doc.addDocumentListener(this._listener);
        textComp.addFocusListener(this._listener);
    }

    public void unregisterComponent(ValidationComponent vComp) {
        if (vComp == null) {
            return;
        }
        Component comp = vComp.getComponent();
        if (!(comp instanceof JTextComponent)) {
            throw new IllegalArgumentException();
        }
        JTextComponent textComp = (JTextComponent)comp;
        if (this._compList.remove(textComp)) {
            this._putValidationComponent(textComp, null);
            Document doc = textComp.getDocument();
            if (doc != null) {
                doc.putProperty(_SOURCE_COMP_KEY, null);
            }
            textComp.removePropertyChangeListener(this._listener);
            doc.removeDocumentListener(this._listener);
            textComp.removeFocusListener(this._listener);
        }
    }

    private void _putValidationComponent(Component comp, ValidationComponent vComp) {
        this._manager.putValidationComponent(comp, vComp);
    }

    private ValidationComponent _getValidationComponent(Component comp) {
        return this._manager.getValidationComponent(comp);
    }

    private class Listener
    implements PropertyChangeListener,
    FocusListener,
    DocumentListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if ("document".equals(event.getPropertyName())) {
                Document newDoc;
                Document oldDoc = (Document)event.getOldValue();
                JTextComponent textComp = null;
                if (oldDoc != null) {
                    textComp = (JTextComponent)oldDoc.getProperty(_SOURCE_COMP_KEY);
                    oldDoc.putProperty(_SOURCE_COMP_KEY, null);
                    oldDoc.removeDocumentListener(this);
                }
                if ((newDoc = (Document)event.getNewValue()) != null) {
                    newDoc.putProperty(_SOURCE_COMP_KEY, textComp);
                    newDoc.addDocumentListener(this);
                }
            }
        }

        public void focusGained(FocusEvent fe) {
        }

        public void focusLost(FocusEvent fe) {
            ValidationComponent vComp = JTextValidationHandler.this._getValidationComponent(fe.getComponent());
            if (vComp != null) {
                vComp.validateComponent(ValidationComponent.DEFAULT_VALIDATOR);
                vComp.validateComponent(ValidationComponent.FOCUS_CHANGE_VALIDATOR);
            }
        }

        public void changedUpdate(DocumentEvent event) {
            this._textChanged(event);
        }

        public void insertUpdate(DocumentEvent event) {
            this._textChanged(event);
        }

        public void removeUpdate(DocumentEvent event) {
            this._textChanged(event);
        }

        private void _textChanged(DocumentEvent event) {
            Component comp = (Component)event.getDocument().getProperty(_SOURCE_COMP_KEY);
            ValidationComponent vComp = JTextValidationHandler.this._getValidationComponent(comp);
            if (vComp != null) {
                vComp.validateComponent(ValidationComponent.DEFAULT_VALIDATOR);
                vComp.validateComponent(ValidationComponent.MODEL_CHANGE_VALIDATOR);
            }
        }
    }
}

