/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.validate;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import oracle.bali.ewt.validate.ValidationMessage;
import oracle.bali.ewt.validate.ValidationMessageModel;
import oracle.bali.ewt.validate.ValidationMessageModelEvent;
import oracle.bali.ewt.validate.ValidationMessageModelListener;
import oracle.bali.share.event.ListenerManager;

public class DefaultValidationMessageModel
implements ValidationMessageModel {
    private ArrayList _errorList = new ArrayList();
    private ArrayList _warningList = new ArrayList();
    private ArrayList _successList = new ArrayList();
    private ArrayList _inProgressList = new ArrayList();
    private ArrayList _pendingList = new ArrayList();
    private ArrayList _informationList = new ArrayList();
    private ListenerManager _listenerManager;

    public void addValidationMessage(ValidationMessage message) {
        if (message == null) {
            return;
        }
        switch (message.getSeverity()) {
            case 1: {
                this._errorList.add(message);
                break;
            }
            case 2: {
                this._warningList.add(message);
                break;
            }
            case 3: {
                this._successList.add(message);
                break;
            }
            case 4: {
                this._inProgressList.add(message);
                break;
            }
            case 5: {
                this._pendingList.add(message);
                break;
            }
            case 6: {
                this._informationList.add(message);
            }
        }
        this.fireValidationMessageEvent(2001, message);
    }

    public void addValidationMessages(ValidationMessage[] messages) {
        if (messages == null) {
            return;
        }
        for (int i = 0; i < messages.length; ++i) {
            this.addValidationMessage(messages[i]);
        }
    }

    public void removeValidationMessage(ValidationMessage message) {
        if (message == null) {
            return;
        }
        boolean removed = false;
        switch (message.getSeverity()) {
            case 1: {
                removed = this._errorList.remove(message);
                break;
            }
            case 2: {
                removed = this._warningList.remove(message);
                break;
            }
            case 3: {
                removed = this._successList.remove(message);
                break;
            }
            case 4: {
                removed = this._inProgressList.remove(message);
                break;
            }
            case 5: {
                removed = this._pendingList.remove(message);
                break;
            }
            case 6: {
                removed = this._informationList.remove(message);
            }
        }
        if (removed) {
            this.fireValidationMessageEvent(2002, message);
        }
    }

    public void removeValidationMessages(ValidationMessage[] messages) {
        if (messages == null) {
            return;
        }
        for (int i = 0; i < messages.length; ++i) {
            this.removeValidationMessage(messages[i]);
        }
    }

    public void clear() {
        ValidationMessage[] messages = this.getValidationMessages();
        this.removeValidationMessages(messages);
    }

    public boolean isEmpty() {
        return this._errorList.isEmpty() && this._warningList.isEmpty() && this._successList.isEmpty() && this._inProgressList.isEmpty() && this._pendingList.isEmpty() && this._informationList.isEmpty();
    }

    public int getMessageCount() {
        return this._errorList.size() + this._warningList.size() + this._successList.size() + this._inProgressList.size() + this._pendingList.size() + this._informationList.size();
    }

    public int getMessageCount(int severity) {
        switch (severity) {
            case 1: {
                return this._errorList.size();
            }
            case 2: {
                return this._warningList.size();
            }
            case 3: {
                return this._successList.size();
            }
            case 4: {
                return this._inProgressList.size();
            }
            case 5: {
                return this._pendingList.size();
            }
            case 6: {
                return this._informationList.size();
            }
        }
        throw new IllegalArgumentException();
    }

    public ValidationMessage[] getValidationMessages() {
        ArrayList list = new ArrayList();
        list.addAll(this._errorList);
        list.addAll(this._warningList);
        list.addAll(this._successList);
        list.addAll(this._inProgressList);
        list.addAll(this._pendingList);
        list.addAll(this._informationList);
        return list.toArray(new ValidationMessage[0]);
    }

    public ValidationMessage[] getValidationMessages(int severity) {
        switch (severity) {
            case 1: {
                return this._errorList.toArray(new ValidationMessage[0]);
            }
            case 2: {
                return this._warningList.toArray(new ValidationMessage[0]);
            }
            case 3: {
                return this._successList.toArray(new ValidationMessage[0]);
            }
            case 4: {
                return this._inProgressList.toArray(new ValidationMessage[0]);
            }
            case 5: {
                return this._pendingList.toArray(new ValidationMessage[0]);
            }
            case 6: {
                return this._informationList.toArray(new ValidationMessage[0]);
            }
        }
        throw new IllegalArgumentException();
    }

    public void addValidationMessageListener(ValidationMessageModelListener listener) {
        if (this._listenerManager == null) {
            this._listenerManager = new ListenerManager();
        }
        this._listenerManager.addListener((EventListener)listener);
    }

    public void removeValidationMessageListener(ValidationMessageModelListener listener) {
        if (this._listenerManager != null) {
            this._listenerManager.removeListener((EventListener)listener);
        }
    }

    protected void fireValidationMessageEvent(int eventID, ValidationMessage message) {
        if (this._listenerManager != null) {
            Enumeration listeners = this._listenerManager.getListeners();
            if (listeners == null || !listeners.hasMoreElements()) {
                return;
            }
            ValidationMessageModelEvent event = new ValidationMessageModelEvent(this, eventID, message);
            switch (eventID) {
                case 2001: {
                    while (listeners.hasMoreElements()) {
                        ((ValidationMessageModelListener)listeners.nextElement()).messageAdded(event);
                    }
                    break;
                }
                case 2002: {
                    while (listeners.hasMoreElements()) {
                        ((ValidationMessageModelListener)listeners.nextElement()).messageRemoved(event);
                    }
                    break;
                }
            }
        }
    }
}

