/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.statusBar;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.access.OracleAccessibleRole;
import oracle.bali.ewt.elaf.EWTStatusBarUI;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

public class StatusBar
extends LWComponent
implements Accessible {
    private int _lastWidth = -1;
    private int _lastHeight = -1;
    private int _lastFillWidth;
    private int _itemSplitWidth;
    private int _leftCandidate;
    private int _rightCandidate;
    private int _resizeLeft;
    private int _resizeRight;
    private int _resizer;
    private int _dragX;
    private boolean _direction;
    private boolean _canResize;
    private boolean _firstLayout = true;
    private Cursor _savedCursor;
    private boolean _foregroundDefaulted = true;
    private int _ITEM_SPACING;
    private static final int _MINIMUM_WIDTH = 10;
    private static final Object _MIN_WIDTH_KEY = new Object();
    private static final Object _EXPANDING_KEY = new Object();

    public StatusBar() {
        this(4);
    }

    public StatusBar(int initItems) {
        this.updateUI();
        long mask = 48L;
        this.enableEvents(mask);
        this._canResize = true;
        this.setLayout(new StatusBarLayout());
    }

    public final JLabel add(String label) {
        return (JLabel)this.add(new JLabel(label));
    }

    public final JLabel add(String label, int index) {
        return (JLabel)this.add((Component)new JLabel(label), index);
    }

    public final JLabel add(Icon icon) {
        return (JLabel)this.add(new JLabel(icon));
    }

    public final JLabel add(Icon icon, int index) {
        return (JLabel)this.add((Component)new JLabel(icon), index);
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        Component beforeComp;
        this._installBorder(comp);
        if (constraints != null && constraints instanceof Component && (beforeComp = (Component)constraints).getParent() == this) {
            index = this.getComponentIndex(beforeComp);
        }
        super.addImpl(comp, constraints, index);
        this._lastHeight = -1;
        this._lastWidth = -1;
        this._firstLayout = true;
        if (comp.isVisible()) {
            this.revalidate();
        }
    }

    public int getComponentIndex(Component comp) {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comp != comps[i]) continue;
            return i;
        }
        throw new IndexOutOfBoundsException();
    }

    public void remove(int index) {
        this._uninstallBorder(this.getComponent(index));
        super.remove(index);
        this._lastHeight = -1;
        this._lastWidth = -1;
        this._firstLayout = true;
        this.revalidate();
    }

    public String getUIClassID() {
        return "EWTStatusBarUI";
    }

    public void setItemResizeAllowed(boolean resize) {
        if (resize != this._canResize) {
            this._itemSplitWidth = resize ? this._getSplitterWidth() : 0;
            this._canResize = resize;
            this._lastHeight = -1;
            this._lastWidth = -1;
            this.revalidate();
        }
    }

    public boolean isItemResizeAllowed() {
        return this._canResize;
    }

    public boolean isExpandable(Component comp) {
        if (comp == null) {
            throw new IllegalArgumentException();
        }
        if (comp instanceof JComponent) {
            Object expanding = ((JComponent)comp).getClientProperty(_EXPANDING_KEY);
            return expanding != null;
        }
        return false;
    }

    public void setExpandable(JComponent comp, boolean expandable) {
        if (comp == null) {
            throw new IllegalArgumentException();
        }
        if (expandable) {
            comp.putClientProperty(_EXPANDING_KEY, _EXPANDING_KEY);
        } else {
            comp.putClientProperty(_EXPANDING_KEY, null);
        }
        if (comp.getParent() == this) {
            this._lastHeight = -1;
            this._lastWidth = -1;
            this.revalidate();
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            Component[] comps = this.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                comps[i].setEnabled(enabled);
            }
            super.setEnabled(enabled);
            this.repaint();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleStatusBar();
        }
        return this.accessibleContext;
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        if (e.isConsumed() || !this.isEnabled() || this.getComponentCount() == 0) {
            return;
        }
        if (!this.isItemResizeAllowed()) {
            return;
        }
        switch (e.getID()) {
            case 506: {
                this._handleMouseDragged(e);
                break;
            }
            case 503: {
                this._handleMouseMoved(e);
            }
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (e.isConsumed() || !this.isEnabled() || this.getComponentCount() == 0) {
            return;
        }
        if (!this.isItemResizeAllowed()) {
            return;
        }
        switch (e.getID()) {
            case 501: {
                this._handleMousePressed(e);
                break;
            }
            case 502: {
                this._handleMouseReleased(e);
            }
            case 505: {
                this._handleMouseExited(e);
            }
        }
    }

    public void updateUI() {
        int i;
        Component[] comps = this.getComponents();
        for (i = 0; i < comps.length; ++i) {
            this._uninstallBorder(comps[i]);
        }
        this.setUI(UIManager.getUI(this));
        for (i = 0; i < comps.length; ++i) {
            this._installBorder(comps[i]);
        }
        this._itemSplitWidth = this._getSplitterWidth();
        this._ITEM_SPACING = this.getEWTStatusBarUI().getItemSpacing(this);
    }

    protected Object getPaintData(Object key) {
        Object data = null;
        if (key == EWTStatusBarUI.RESIZABLE_SPLITTERS_KEY) {
            data = this._getSplitters(true);
        } else if (key == EWTStatusBarUI.NONRESIZABLE_SPLITTERS_KEY) {
            data = this._getSplitters(false);
        }
        if (data == null) {
            data = super.getPaintData(key);
        }
        return data;
    }

    public boolean isValidateRoot() {
        return true;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int numItems = this.getComponentCount();
        if (numItems == 0) {
            return;
        }
        Component[] items = this.getComponents();
        if (this._firstLayout) {
            this.doLayout();
        }
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        int direction = this.getActualReadingDirection();
        Rectangle clipRect = g.getClipBounds();
        boolean isItemResizeAllowed = this.isItemResizeAllowed();
        int splitterOffset = direction == 2 ? -this._ITEM_SPACING - this._itemSplitWidth : this._ITEM_SPACING;
        Component nextItem = items[0];
        boolean nextItemExpanding = isItemResizeAllowed && this.isExpandable(nextItem) && numItems > 1;
        int itemIndex = 0;
        PaintContext context = this.getPaintContext();
        while (nextItem != null) {
            Rectangle itemRect;
            Component item = nextItem;
            boolean itemIsExpanding = nextItemExpanding;
            if (++itemIndex < numItems) {
                nextItem = items[itemIndex];
                nextItemExpanding = isItemResizeAllowed && this.isExpandable(nextItem);
            } else {
                nextItem = null;
                nextItemExpanding = false;
            }
            if (!(itemRect = item.getBounds()).intersects(clipRect)) continue;
            EWTStatusBarUI ui = this.getEWTStatusBarUI();
            Painter splitter = nextItem == null ? null : (itemIsExpanding ? (nextItemExpanding ? ui.getCenterSplitterPainter(this) : (direction != 2 ? ui.getLeftSplitterPainter(this) : ui.getRightSplitterPainter(this))) : ui.getStaticSplitterPainter(this));
            if (splitter == null) continue;
            int xCoord = itemRect.x + splitterOffset;
            if (direction != 2) {
                xCoord += itemRect.width;
            }
            if (this.isOpaque()) {
                g.setColor(context.getPaintBackground());
                g.fillRect(xCoord - splitterOffset, insets.top, this._itemSplitWidth + splitterOffset * 2, size.height - (insets.top + insets.bottom));
            }
            splitter.paint(context, g, xCoord, 0, this._itemSplitWidth, size.height);
        }
    }

    protected final EWTStatusBarUI getEWTStatusBarUI() {
        return (EWTStatusBarUI)this.ui;
    }

    private void _recalculateSlides(int pushLeft, int pushRight) {
        int pad;
        Component curr;
        int i;
        int direction = this.getActualReadingDirection();
        Component[] items = this.getComponents();
        int numItems = items.length;
        if (pushLeft > -1) {
            this._resizeLeft = 0;
            this._leftCandidate = -1;
            for (i = pushLeft; i >= 0; --i) {
                curr = items[i];
                if (!this.isExpandable(curr) || (pad = curr.getSize().width - curr.getMinimumSize().width) <= 0) continue;
                this._resizeLeft = pad;
                this._leftCandidate = i;
                break;
            }
            if (this._leftCandidate < 0) {
                this._leftCandidate = this._resizer;
            }
        }
        if (pushRight > -1) {
            this._resizeRight = 0;
            this._rightCandidate = -1;
            for (i = pushRight + 1; i < numItems; ++i) {
                curr = items[i];
                if (!this.isExpandable(curr) || (pad = curr.getSize().width - curr.getMinimumSize().width) <= 0) continue;
                this._resizeRight = pad;
                this._rightCandidate = i;
                break;
            }
            if (this._rightCandidate == -1) {
                Component rightmost = items[numItems - 1];
                int rightmostMinWidth = rightmost.getMinimumSize().width;
                this._resizeRight = direction == 2 ? rightmost.getSize().width - rightmostMinWidth : this.getSize().width - this.getInsets().right - (rightmost.getLocation().x + rightmostMinWidth);
                this._rightCandidate = numItems - 1;
            }
        }
    }

    private void _handleMousePressed(MouseEvent e) {
        Insets insets = this.getInsets();
        int innerX = e.getX();
        this._resizer = this._getResizeCandidate(innerX);
        this._recalculateSlides(this._resizer, this._resizer);
        this._dragX = innerX;
        this._direction = true;
    }

    private void _handleMouseReleased(MouseEvent e) {
        this._rightCandidate = -1;
        this._leftCandidate = -1;
        this._resizer = -1;
        this._dragX = 0;
        this._resizeRight = 0;
        this._resizeLeft = 0;
    }

    private void _handleMouseExited(MouseEvent e) {
        this._restoreCursor();
    }

    private void _handleMouseDragged(MouseEvent e) {
        Point loc;
        int dx;
        if (this._leftCandidate < 0 && this._rightCandidate < 0 || this._resizer < 0) {
            return;
        }
        int readDir = this.getActualReadingDirection();
        int leftCan = this._leftCandidate;
        int rightCan = this._rightCandidate;
        Component[] items = this.getComponents();
        int numItems = items.length;
        int innerX = e.getX();
        Component left = leftCan >= 0 ? items[leftCan] : null;
        Component right = rightCan >= 0 ? items[rightCan] : null;
        Component resize = items[this._resizer];
        int pushLeft = -1;
        int pushRight = -1;
        int actualDx = dx = readDir == 2 ? this._dragX - innerX : innerX - this._dragX;
        if (dx <= 0) {
            if (this._direction) {
                int newRight = numItems - 1;
                for (int i = this._resizer + 1; i < numItems - 1; ++i) {
                    if (!this.isExpandable(items[i])) continue;
                    newRight = i;
                    break;
                }
                rightCan = newRight;
                Component rightItem = items[newRight];
                this._resizeRight = rightItem.getSize().width - rightItem.getMinimumSize().width;
                right = rightItem;
                rightCan = this._rightCandidate = newRight;
            }
            if (this._resizeLeft < -dx) {
                actualDx = -this._resizeLeft;
                pushLeft = leftCan - 1;
            }
            if (actualDx != 0) {
                int i;
                Dimension leftsize = left.getSize();
                left.setSize(leftsize.width + actualDx, leftsize.height);
                if (readDir == 2) {
                    for (i = leftCan; i < rightCan; ++i) {
                        loc = items[i].getLocation();
                        items[i].setLocation(loc.x - actualDx, loc.y);
                    }
                } else {
                    for (i = rightCan; i > leftCan; --i) {
                        loc = items[i].getLocation();
                        items[i].setLocation(loc.x + actualDx, loc.y);
                    }
                }
            }
        } else if (dx > 0) {
            if (!this._direction) {
                pushLeft = this._resizer;
            }
            if (this._resizeRight < dx) {
                actualDx = this._resizeRight;
                pushRight = rightCan + 1;
            }
            Dimension resSize = resize.getSize();
            resize.setSize(resSize.width + actualDx, resSize.height);
            if (readDir == 2) {
                for (int i = rightCan - 1; i >= this._resizer; --i) {
                    loc = items[i].getLocation();
                    items[i].setLocation(loc.x - actualDx, loc.y);
                }
            } else {
                for (int i = this._resizer + 1; i <= rightCan; ++i) {
                    loc = items[i].getLocation();
                    items[i].setLocation(loc.x + actualDx, loc.y);
                }
            }
        }
        Dimension rightsize = right.getSize();
        right.setSize(rightsize.width - actualDx, rightsize.height);
        this._resizeLeft += actualDx;
        this._resizeRight -= actualDx;
        int leftPaintX = 0;
        int rightPaintX = 0;
        if (readDir == 2) {
            leftPaintX = items[rightCan].getLocation().x;
            rightPaintX = items[leftCan].getLocation().x + items[leftCan].getSize().width;
        } else {
            leftPaintX = items[leftCan].getLocation().x;
            rightPaintX = items[rightCan].getLocation().x + items[rightCan].getSize().width;
        }
        int height = this.getSize().height;
        int insetLeft = this.getInsets().left;
        this.paintImmediately(leftPaintX + insetLeft, 0, rightPaintX + insetLeft, height);
        if (pushLeft > -1 || pushRight > -1) {
            this._recalculateSlides(pushLeft, pushRight);
        }
        if (actualDx != 0) {
            this._dragX += readDir == 2 ? -actualDx : actualDx;
        }
        this._direction = dx > 0;
    }

    private void _handleMouseMoved(MouseEvent e) {
        Insets insets = this.getInsets();
        int innerX = e.getX();
        int innerY = e.getY();
        if (this._getResizeCandidate(innerX) < 0) {
            this._restoreCursor();
        } else {
            int direction = this.getActualReadingDirection();
            Rectangle innerBounds = this.getBounds();
            innerBounds.x = 0;
            innerBounds.y = 0;
            Component[] items = this.getComponents();
            int numItems = items.length;
            if (direction == 2) {
                int leftX = items[numItems - 1].getLocation().x;
                if (!innerBounds.contains(innerX, innerY) || innerX < leftX) {
                    return;
                }
            } else {
                int rightX = items[numItems - 1].getLocation().x + items[numItems - 1].getSize().width;
                if (!innerBounds.contains(innerX, innerY) || innerX >= rightX) {
                    return;
                }
            }
            this._showResizeCursor();
        }
    }

    private int _getResizeCandidate(int x) {
        int check = 0;
        int numItems = this.getComponentCount();
        if (numItems < 2) {
            return -1;
        }
        Component[] items = this.getComponents();
        int direction = this.getActualReadingDirection();
        if (direction == 2) {
            for (int i = 1; i < numItems; ++i) {
                Rectangle bounds = items[i].getBounds();
                check = bounds.x + bounds.width;
                if (check >= x) continue;
                Component candidate = items[i - 1];
                bounds = items[i - 1].getBounds();
                if (x >= bounds.x && x < bounds.width + bounds.x || !this.isExpandable(candidate)) {
                    return -1;
                }
                return i - 1;
            }
        } else {
            for (int i = 1; i < numItems; ++i) {
                Rectangle bounds = items[i].getBounds();
                check = bounds.x;
                if (check <= x) continue;
                Component candidate = items[i - 1];
                bounds = items[i - 1].getBounds();
                if (x < bounds.width + bounds.x || !this.isExpandable(candidate)) {
                    return -1;
                }
                return i - 1;
            }
        }
        return -1;
    }

    private void _showResizeCursor() {
        this.setCursor(Cursor.getPredefinedCursor(10));
    }

    private void _restoreCursor() {
        this.setCursor(Cursor.getDefaultCursor());
    }

    private int _getSplitterWidth() {
        Painter splitter = this.getEWTStatusBarUI().getCenterSplitterPainter(this);
        return splitter == null ? 0 : splitter.getMinimumSize((PaintContext)this.getPaintContext()).width;
    }

    private int[] _getSplitters(boolean resizable) {
        if (!this.isItemResizeAllowed()) {
            return new int[0];
        }
        int direction = this.getActualReadingDirection();
        int splitterOffset = direction == 2 ? -this._ITEM_SPACING - this._itemSplitWidth : this._ITEM_SPACING;
        int inset = this.getBorderInsets().left;
        int currIndex = 0;
        Component[] items = this.getComponents();
        int numItems = items.length;
        int[] locations = new int[numItems];
        for (int i = 0; i < numItems - 1; ++i) {
            Component item = items[i];
            if (resizable != this.isExpandable(item)) continue;
            Rectangle itemRect = item.getBounds();
            int xCoord = itemRect.x + splitterOffset;
            if (direction != 2) {
                xCoord += itemRect.width;
            }
            locations[currIndex] = xCoord;
            ++currIndex;
        }
        int[] result = new int[currIndex];
        System.arraycopy(locations, 0, result, 0, currIndex);
        return result;
    }

    private void _installBorder(Component comp) {
        Border itemBorder = this.getEWTStatusBarUI().getItemBorder(this);
        if (itemBorder != null && comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            Border currBorder = jcomp.getBorder();
            if (currBorder != null) {
                CompoundBorder compBorder = new CompoundBorder(itemBorder, currBorder);
                itemBorder = compBorder;
            }
            jcomp.setBorder(itemBorder);
        }
    }

    private void _uninstallBorder(Component comp) {
        if (comp instanceof JComponent) {
            Border uiBorder = this.getEWTStatusBarUI().getItemBorder(this);
            if (uiBorder == null) {
                return;
            }
            JComponent jcomp = (JComponent)comp;
            Border currBorder = jcomp.getBorder();
            if (currBorder != null) {
                CompoundBorder compBorder;
                Border outerBorder;
                if (currBorder == uiBorder) {
                    jcomp.setBorder(null);
                } else if (currBorder instanceof CompoundBorder && (outerBorder = (compBorder = (CompoundBorder)currBorder).getOutsideBorder()) == uiBorder) {
                    jcomp.setBorder(compBorder.getInsideBorder());
                }
            }
        }
    }

    private Dimension _getMinimumSize() {
        int minWidth = 20;
        int minHeight = 15;
        Insets insets = this.getInsets();
        int fillCount = 0;
        EWTStatusBarUI sbui = this.getEWTStatusBarUI();
        boolean paintStaticSplits = this.getEWTStatusBarUI().getStaticSplitterPainter(this) != null;
        Component[] items = this.getComponents();
        int numItems = items.length;
        for (int i = 0; i < numItems; ++i) {
            Component currItem = items[i];
            if (!currItem.isVisible()) continue;
            Dimension currMinSize = currItem.getMinimumSize();
            minWidth += currMinSize.width;
            if (currMinSize.height > minHeight) {
                minHeight = currMinSize.height;
            }
            if (!this.isExpandable(currItem) && !paintStaticSplits) continue;
            ++fillCount;
        }
        if (numItems > 0) {
            if (fillCount > 0 && this.isItemResizeAllowed()) {
                if (this.isExpandable(items[numItems - 1]) || paintStaticSplits) {
                    --fillCount;
                }
                minWidth += fillCount * (this._itemSplitWidth + this._ITEM_SPACING);
            }
            minWidth += (numItems - 1) * this._ITEM_SPACING;
        }
        return new Dimension(minWidth + insets.left + insets.right, minHeight + insets.top + insets.bottom);
    }

    private Dimension _getPreferredSize() {
        Dimension size = this.getMinimumSize();
        Dimension maxSize = this.getMaximumSize();
        if (maxSize != null) {
            if (size.width > maxSize.width) {
                size.width = maxSize.width;
            }
            if (size.height > maxSize.height) {
                size.height = maxSize.height;
            }
        }
        return size;
    }

    protected boolean isChildInvalidationIgnored() {
        return true;
    }

    private void _doLayout() {
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.isChildInvalidationIgnored() && width == this._lastWidth && height == this._lastHeight) {
            return;
        }
        this._lastWidth = width;
        this._lastHeight = height;
        int numItems = this.getComponentCount();
        if (numItems < 1) {
            return;
        }
        Component[] items = this.getComponents();
        Insets insets = this.getInsets();
        height -= insets.top + insets.bottom;
        boolean paintStaticSplits = this.getEWTStatusBarUI().getStaticSplitterPainter(this) != null;
        int direction = this.getActualReadingDirection();
        int x = direction == 1 ? insets.left : (width -= insets.left + insets.right);
        int minWidth = 0;
        int maxHeight = 0;
        int fillCount = 0;
        int resizeCount = 0;
        for (int i = 0; i < numItems; ++i) {
            Component currItem = items[i];
            if (!currItem.isVisible()) continue;
            Dimension currMinSize = currItem.getMinimumSize();
            minWidth += currMinSize.width;
            if (currMinSize.height > maxHeight) {
                maxHeight = currMinSize.height;
            }
            if (i < numItems - 1 && (this.isExpandable(currItem) || paintStaticSplits)) {
                ++resizeCount;
            }
            if (!this.isExpandable(currItem)) continue;
            ++fillCount;
        }
        int fillWidth = width - (minWidth += resizeCount * (this._itemSplitWidth + this._ITEM_SPACING) + (numItems - 1) * this._ITEM_SPACING);
        if (fillWidth < 0) {
            fillWidth = 0;
        }
        int fillLeft = fillWidth;
        int fillCountConstant = fillCount;
        if (this.isExpandable(items[numItems - 1])) {
            --fillCountConstant;
        }
        for (int i = 0; i < numItems; ++i) {
            Component currItem = items[i];
            if (!currItem.isVisible()) continue;
            Dimension currItemSize = currItem.getSize();
            if (this._firstLayout || currItemSize.width <= 0 || currItemSize.height <= 0) {
                currItemSize = new Dimension(currItem.getMinimumSize());
            }
            if (this.isExpandable(currItem) || i == numItems - 1) {
                float lastPercent;
                int fillAlloc = 0;
                int currMinWidth = currItem.getMinimumSize().width;
                if (--fillCount <= 0) {
                    fillAlloc = fillLeft;
                } else if (this._firstLayout || this._lastFillWidth == 0) {
                    fillAlloc = fillWidth / fillCountConstant;
                } else if (this._lastFillWidth > 0 && (fillAlloc = (int)((lastPercent = (float)(currItemSize.width - currMinWidth) / (float)this._lastFillWidth) * (float)fillWidth)) > fillLeft) {
                    fillAlloc = fillLeft;
                }
                currItemSize.width = currMinWidth + fillAlloc;
                fillLeft -= fillAlloc;
            }
            currItem.setSize(currItemSize.width, height);
            if (direction == 2) {
                currItem.setLocation(x -= currItemSize.width, insets.top);
                if (!paintStaticSplits && !this.isExpandable(currItem) || i >= numItems - 1) continue;
                x -= this._itemSplitWidth + 2 * this._ITEM_SPACING;
                continue;
            }
            currItem.setLocation(x, insets.top);
            x += currItemSize.width + this._ITEM_SPACING;
            if (!paintStaticSplits && !this.isExpandable(currItem) || i >= numItems - 1) continue;
            x += this._itemSplitWidth + this._ITEM_SPACING;
        }
        this._lastFillWidth = fillWidth;
        this._firstLayout = false;
    }

    protected class AccessibleStatusBar
    extends JComponent.AccessibleJComponent {
        protected AccessibleStatusBar() {
            super(StatusBar.this);
        }

        public AccessibleRole getAccessibleRole() {
            return OracleAccessibleRole.STATUS_BAR;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            states.add(AccessibleState.HORIZONTAL);
            return states;
        }
    }

    private class StatusBarLayout
    implements LayoutManager {
        private StatusBarLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return StatusBar.this._getPreferredSize();
        }

        public Dimension minimumLayoutSize(Container parent) {
            return StatusBar.this._getMinimumSize();
        }

        public void layoutContainer(Container parent) {
            StatusBar.this._doLayout();
        }
    }
}

